/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.booterclient.AbstractClasspathForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.Platform;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.OutputStreamFlushableCommandline;
import org.apache.maven.plugin.surefire.booterclient.output.InPluginProcessDumpSingleton;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.shade.common.org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.maven.surefire.shade.common.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.maven.surefire.shade.common.org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.maven.surefire.util.internal.StringUtils;

public final class JarManifestForkConfiguration
extends AbstractClasspathForkConfiguration {
    public JarManifestForkConfiguration(@Nonnull Classpath bootClasspath, @Nonnull File tempDirectory, @Nullable String debugLine, @Nonnull File workingDirectory, @Nonnull Properties modelProperties, @Nullable String argLine, @Nonnull Map<String, String> environmentVariables, @Nonnull String[] excludedEnvironmentVariables, boolean debug, int forkCount, boolean reuseForks, @Nonnull Platform pluginPlatform, @Nonnull ConsoleLogger log) {
        super(bootClasspath, tempDirectory, debugLine, workingDirectory, modelProperties, argLine, environmentVariables, excludedEnvironmentVariables, debug, forkCount, reuseForks, pluginPlatform, log);
    }

    @Override
    protected void resolveClasspath(@Nonnull OutputStreamFlushableCommandline cli, @Nonnull String booterThatHasMainMethod, @Nonnull StartupConfiguration config, @Nonnull File dumpLogDirectory) throws SurefireBooterForkException {
        try {
            File jar = this.createJar(this.toCompleteClasspath(config), booterThatHasMainMethod, dumpLogDirectory);
            cli.createArg().setValue("-jar");
            cli.createArg().setValue(SurefireHelper.escapeToPlatformPath(jar.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new SurefireBooterForkException("Error creating archive file", (Throwable)e);
        }
    }

    @Nonnull
    private File createJar(@Nonnull List<String> classPath, @Nonnull String startClassName, @Nonnull File dumpLogDirectory) throws IOException {
        File file = File.createTempFile("surefirebooter", ".jar", this.getTempDirectory());
        if (!this.isDebug()) {
            file.deleteOnExit();
        }
        Path parent = file.getParentFile().toPath();
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file), 65536);
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(fos);){
            zos.setUseZip64(Zip64Mode.Never);
            zos.setLevel(0);
            ZipArchiveEntry ze = new ZipArchiveEntry("META-INF/MANIFEST.MF");
            zos.putArchiveEntry(ze);
            Manifest man = new Manifest();
            boolean dumpError = true;
            StringBuilder cp = new StringBuilder();
            Iterator<String> it = classPath.iterator();
            while (it.hasNext()) {
                Path classPathElement = Paths.get(it.next(), new String[0]);
                ClasspathElementUri classpathElementUri = JarManifestForkConfiguration.toClasspathElementUri(parent, classPathElement, dumpLogDirectory, dumpError);
                dumpError &= !classpathElementUri.absolute;
                cp.append(classpathElementUri.uri);
                if (Files.isDirectory(classPathElement, new LinkOption[0]) && !classpathElementUri.uri.endsWith("/")) {
                    cp.append('/');
                }
                if (!it.hasNext()) continue;
                cp.append(' ');
            }
            man.getMainAttributes().putValue("Manifest-Version", "1.0");
            man.getMainAttributes().putValue("Class-Path", cp.toString().trim());
            man.getMainAttributes().putValue("Main-Class", startClassName);
            man.write(zos);
            zos.closeArchiveEntry();
            File file2 = file;
            return file2;
        }
    }

    static String relativize(@Nonnull Path parent, @Nonnull Path child) throws IllegalArgumentException {
        return parent.relativize(child).toString();
    }

    static String toAbsoluteUri(@Nonnull Path absolutePath) {
        return absolutePath.toUri().toASCIIString();
    }

    static ClasspathElementUri toClasspathElementUri(@Nonnull Path parent, @Nonnull Path classPathElement, @Nonnull File dumpLogDirectory, boolean dumpError) {
        try {
            String relativePath = JarManifestForkConfiguration.relativize(parent, classPathElement);
            return ClasspathElementUri.relative(JarManifestForkConfiguration.escapeUri(relativePath, StandardCharsets.UTF_8));
        }
        catch (IllegalArgumentException e) {
            if (dumpError) {
                String error = "Boot Manifest-JAR contains absolute paths in classpath '" + classPathElement + "'" + StringUtils.NL + "Hint: <argLine>-Djdk.net.URLClassPath.disableClassPathURLCheck=true</argLine>";
                InPluginProcessDumpSingleton.getSingleton().dumpStreamText(error, dumpLogDirectory);
            }
            return ClasspathElementUri.absolute(JarManifestForkConfiguration.toAbsoluteUri(classPathElement));
        }
    }

    static String escapeUri(String input, Charset encoding) {
        try {
            String uriFormEncoded = URLEncoder.encode(input, encoding.name());
            String uriPathEncoded = uriFormEncoded.replaceAll("\\+", "%20");
            uriPathEncoded = uriPathEncoded.replaceAll("%2F|%5C", "/");
            return uriPathEncoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("avoided by using Charset");
        }
    }

    static final class ClasspathElementUri {
        final String uri;
        final boolean absolute;

        private ClasspathElementUri(String uri, boolean absolute) {
            this.uri = uri;
            this.absolute = absolute;
        }

        static ClasspathElementUri absolute(String uri) {
            return new ClasspathElementUri(uri, true);
        }

        static ClasspathElementUri relative(String uri) {
            return new ClasspathElementUri(uri, false);
        }
    }
}

