/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.nfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.RegexRootNode;
import com.oracle.truffle.regex.charset.CP16BitMatchers;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.nfa.PureNFA;
import com.oracle.truffle.regex.tregex.nfa.PureNFAMap;
import com.oracle.truffle.regex.tregex.nfa.PureNFAState;
import com.oracle.truffle.regex.tregex.nfa.PureNFATransition;
import com.oracle.truffle.regex.tregex.nfa.QuantifierGuard;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecRootNode;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfStringNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputRegionMatchesNode;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexBacktrackingNFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexLiteralLookAroundExecutorNode;
import com.oracle.truffle.regex.tregex.parser.CaseFoldTable;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.InnerLiteral;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;

public class TRegexBacktrackingNFAExecutorNode
extends TRegexExecutorNode {
    public static final TRegexExecutorNode[] NO_LOOK_AROUND_EXECUTORS = new TRegexExecutorNode[0];
    private final PureNFA nfa;
    private final int nQuantifiers;
    private final int nZeroWidthQuantifiers;
    private final int maxNTransitions;
    private final boolean writesCaptureGroups;
    private final boolean forward;
    private final boolean ignoreCase;
    private final boolean unicode;
    private final boolean loneSurrogates;
    private final boolean loopbackInitialState;
    private final InnerLiteral innerLiteral;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final TRegexExecutorNode[] lookAroundExecutors;
    @Node.Children
    private CharMatcher[] matchers;
    @Node.Child
    InputRegionMatchesNode regionMatchesNode;
    @Node.Child
    InputIndexOfStringNode indexOfNode;
    @Node.Child
    CharMatcher loopbackInitialStateMatcher;
    private static final int IP_BEGIN = -1;
    private static final int IP_BACKTRACK = -2;
    private static final int IP_END = -3;

    public TRegexBacktrackingNFAExecutorNode(PureNFAMap nfaMap, PureNFA nfa, TRegexExecutorNode[] lookAroundExecutors, CompilationBuffer compilationBuffer) {
        RegexASTSubtreeRootNode subtree = nfaMap.getASTSubtree(nfa);
        this.nfa = nfa;
        this.writesCaptureGroups = subtree.hasCaptureGroups();
        this.forward = !(subtree instanceof LookBehindAssertion);
        this.ignoreCase = nfaMap.getAst().getFlags().isIgnoreCase();
        this.unicode = nfaMap.getAst().getFlags().isUnicode();
        this.loneSurrogates = nfaMap.getAst().getProperties().hasLoneSurrogates();
        this.nQuantifiers = nfaMap.getAst().getQuantifierCount().getCount();
        this.nZeroWidthQuantifiers = nfaMap.getAst().getZeroWidthQuantifierCount().getCount();
        this.lookAroundExecutors = lookAroundExecutors;
        this.loopbackInitialState = nfa == nfaMap.getRoot() && !nfaMap.getAst().getFlags().isSticky() && !nfaMap.getAst().getRoot().startsWithCaret();
        this.innerLiteral = nfa == nfaMap.getRoot() && nfaMap.getAst().getProperties().hasInnerLiteral() ? nfaMap.getAst().extractInnerLiteral(compilationBuffer) : null;
        if (this.loopbackInitialState && this.innerLiteral == null) {
            CodePointSet initialCharSet = nfaMap.getMergedInitialStateCharSet(compilationBuffer);
            this.loopbackInitialStateMatcher = initialCharSet == null ? null : CP16BitMatchers.createMatcher(initialCharSet, compilationBuffer);
        }
        nfa.materializeGroupBoundaries();
        this.matchers = new CharMatcher[nfa.getNumberOfStates()];
        int maxTransitions = 0;
        for (int i = 0; i < this.matchers.length; ++i) {
            PureNFAState s = nfa.getState(i);
            if (s.isCharacterClass()) {
                this.matchers[i] = (CharMatcher)this.insert(CP16BitMatchers.createMatcher(s.getCharSet(), compilationBuffer));
            }
            maxTransitions = Math.max(maxTransitions, ((PureNFATransition[])s.getSuccessors(this.forward)).length);
            s.initIsDeterministic(this.forward, compilationBuffer);
        }
        this.maxNTransitions = maxTransitions;
    }

    public void initialize(TRegexExecRootNode rootNode) {
        for (TRegexExecutorNode executor : this.lookAroundExecutors) {
            executor.setRoot(rootNode);
            this.insert(executor);
        }
    }

    @Override
    public boolean writesCaptureGroups() {
        return this.writesCaptureGroups;
    }

    public boolean isForward() {
        return this.forward;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public TRegexExecutorLocals createLocals(Object input, int fromIndex, int index, int maxIndex) {
        return new TRegexBacktrackingNFAExecutorLocals(input, fromIndex, index, maxIndex, this.getNumberOfCaptureGroups(), this.nQuantifiers, this.nZeroWidthQuantifiers, this.maxNTransitions);
    }

    @Override
    public Object execute(TRegexExecutorLocals abstractLocals, boolean compactString) {
        TRegexBacktrackingNFAExecutorLocals locals = (TRegexBacktrackingNFAExecutorLocals)abstractLocals;
        CompilerDirectives.ensureVirtualized((Object)locals);
        if (this.innerLiteral != null) {
            int indexOfInnerLiteral = this.findInnerLiteral(locals, locals.getFromIndex());
            if (indexOfInnerLiteral < 0) {
                return null;
            }
            locals.setLastInnerLiteralIndex(indexOfInnerLiteral);
            locals.setIndex(Math.max(locals.getFromIndex(), indexOfInnerLiteral - this.innerLiteral.getMaxPrefixSize()));
        }
        if (this.loopbackInitialState) {
            locals.setLastInitialStateIndex(locals.getIndex());
        }
        this.runMergeExplode(locals, compactString);
        return locals.popResult();
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    protected void runMergeExplode(TRegexBacktrackingNFAExecutorLocals locals, boolean compactString) {
        block20: {
            int nextIp;
            int ip = -1;
            block0: while (true) {
                if (CompilerDirectives.inInterpreter()) {
                    RegexRootNode.checkThreadInterrupted();
                }
                CompilerAsserts.partialEvaluationConstant((int)ip);
                if (ip == -1) {
                    if (this.nfa.getAnchoredInitialState(this.isForward()) != this.nfa.getUnAnchoredInitialState(this.isForward()) && this.inputAtBegin(locals)) {
                        ip = this.nfa.getAnchoredInitialState(this.isForward()).getId();
                        continue;
                    }
                    ip = this.nfa.getUnAnchoredInitialState(this.isForward()).getId();
                    continue;
                }
                if (ip == -2) {
                    if (!locals.canPopResult()) {
                        if (!locals.canPop()) {
                            if (this.loopbackInitialState) {
                                assert (this.isForward());
                                int nextIndex = locals.getLastInitialStateIndex() + 1;
                                if (nextIndex <= locals.getMaxIndex()) {
                                    if (this.innerLiteral != null) {
                                        if (locals.getLastInitialStateIndex() == locals.getLastInnerLiteralIndex()) {
                                            if ((nextIndex = this.findInnerLiteral(locals, nextIndex)) < 0) {
                                                nextIndex = locals.getMaxIndex();
                                                locals.setLastInnerLiteralIndex(locals.getMaxIndex());
                                            } else {
                                                locals.setLastInnerLiteralIndex(nextIndex);
                                                nextIndex = Math.max(locals.getFromIndex(), nextIndex - this.innerLiteral.getMaxPrefixSize());
                                            }
                                        }
                                    } else if (this.loopbackInitialStateMatcher != null && (nextIndex = this.findFirstLoopbackMatch(locals, compactString, nextIndex)) < 0) {
                                        nextIndex = locals.getMaxIndex();
                                    }
                                    locals.setLastInitialStateIndex(nextIndex);
                                    locals.resetToInitialState(nextIndex);
                                    ip = this.nfa.getUnAnchoredInitialState(this.isForward()).getId();
                                    continue;
                                }
                            }
                        } else {
                            int nextIp2 = locals.pop();
                            for (int i = 0; i < this.nfa.getNumberOfStates(); ++i) {
                                int stateId = this.nfa.getState(i).getId();
                                CompilerAsserts.partialEvaluationConstant((int)stateId);
                                if (stateId != nextIp2) continue;
                                ip = stateId;
                                continue block0;
                            }
                        }
                    }
                    break block20;
                }
                if (ip == -3) break block20;
                PureNFAState curState = this.nfa.getState(ip);
                CompilerAsserts.partialEvaluationConstant((Object)curState);
                PureNFATransition[] successors = (PureNFATransition[])curState.getSuccessors(this.isForward());
                CompilerAsserts.partialEvaluationConstant((Object)successors);
                CompilerAsserts.partialEvaluationConstant((int)successors.length);
                nextIp = this.runState(locals, compactString, curState);
                for (int i = 0; i < successors.length; ++i) {
                    int targetIp = ((PureNFAState)successors[i].getTarget(this.isForward())).getId();
                    if (targetIp != nextIp) continue;
                    CompilerAsserts.partialEvaluationConstant((int)targetIp);
                    ip = targetIp;
                    continue block0;
                }
                if (nextIp != -2) break;
                ip = -2;
            }
            assert (nextIp == -3);
        }
    }

    @ExplodeLoop
    private int runState(TRegexBacktrackingNFAExecutorLocals locals, boolean compactString, PureNFAState curState) {
        long bs;
        int iBS;
        char c;
        CompilerDirectives.isPartialEvaluationConstant((Object)curState);
        if (curState.isFinalState(this.isForward())) {
            locals.setResult();
            locals.pushResult();
            return -3;
        }
        if (curState.isLookAround() && !this.canInlineLookAroundIntoTransition(curState)) {
            int[] subMatchResult = this.runSubMatcher(locals.createSubNFALocals(), compactString, curState);
            if (this.subMatchFailed(curState, subMatchResult)) {
                return -2;
            }
            if (!curState.isLookAroundNegated() && this.getLookAroundExecutor(curState).writesCaptureGroups()) {
                locals.overwriteCaptureGroups(subMatchResult);
            }
        }
        if (curState.isBackReference() && !this.canInlineBackReferenceIntoTransition()) {
            int backrefResult = this.matchBackReferenceGeneric(locals, locals.getCaptureGroupStart(curState.getBackRefNumber()), locals.getCaptureGroupEnd(curState.getBackRefNumber()));
            if (backrefResult < 0) {
                return -2;
            }
            locals.setIndex(backrefResult);
        }
        PureNFATransition[] successors = (PureNFATransition[])curState.getSuccessors(this.isForward());
        CompilerDirectives.isPartialEvaluationConstant((Object)successors);
        CompilerDirectives.isPartialEvaluationConstant((Object)successors.length);
        int index = locals.getIndex();
        boolean atEnd = this.isForward() ? index >= locals.getMaxIndex() : index == 0;
        char c2 = c = atEnd ? (char)'\u0000' : this.inputGetChar(locals, index);
        if (curState.isDeterministic()) {
            for (int i = 0; i < successors.length; ++i) {
                PureNFATransition transition = successors[i];
                CompilerDirectives.isPartialEvaluationConstant((Object)transition);
                if (!this.transitionMatches(locals, compactString, transition, index, atEnd, c)) continue;
                this.updateState(locals, transition, index);
                return ((PureNFAState)transition.getTarget(this.isForward())).getId();
            }
            return -2;
        }
        long[] transitionBitSet = locals.getTransitionBitSet();
        CompilerDirectives.isPartialEvaluationConstant((Object)transitionBitSet);
        CompilerDirectives.ensureVirtualized((Object)transitionBitSet);
        int bitSetWords = (successors.length - 1 >> 6) + 1;
        CompilerDirectives.isPartialEvaluationConstant((Object)bitSetWords);
        int lastMatch = 0;
        int nMatched = -1;
        for (iBS = 0; iBS < bitSetWords; ++iBS) {
            CompilerDirectives.isPartialEvaluationConstant((Object)iBS);
            bs = 0L;
            long bit = 1L;
            int iStart = successors.length - (iBS << 6) - 1;
            CompilerDirectives.isPartialEvaluationConstant((Object)iStart);
            for (int i = iStart; i >= 0; --i) {
                PureNFATransition transition = successors[i];
                CompilerDirectives.isPartialEvaluationConstant((Object)transition);
                if (this.transitionMatches(locals, compactString, transition, index, atEnd, c)) {
                    bs |= bit;
                    lastMatch = i;
                    if (((PureNFAState)transition.getTarget(this.isForward())).isFinalState(this.isForward())) {
                        locals.setResult();
                        --nMatched;
                    }
                }
                bit <<= 1;
            }
            transitionBitSet[iBS] = bs;
        }
        for (iBS = 0; iBS < bitSetWords; ++iBS) {
            nMatched += Long.bitCount(transitionBitSet[iBS]);
        }
        if (nMatched > 0) {
            locals.dupFrame(nMatched);
        }
        for (iBS = 0; iBS < bitSetWords; ++iBS) {
            CompilerDirectives.isPartialEvaluationConstant((Object)iBS);
            bs = transitionBitSet[iBS];
            int iStart = successors.length - (iBS << 6) - 1;
            CompilerDirectives.isPartialEvaluationConstant((Object)iStart);
            for (int i = iStart; i >= 0; --i) {
                PureNFATransition transition = successors[i];
                CompilerDirectives.isPartialEvaluationConstant((Object)transition);
                PureNFAState target = (PureNFAState)transition.getTarget(this.isForward());
                CompilerDirectives.isPartialEvaluationConstant((Object)target);
                if ((bs & 1L) != 0L) {
                    if (target.isFinalState(this.isForward())) {
                        locals.pushResult(transition, index);
                        if (i == lastMatch) {
                            return -3;
                        }
                    } else {
                        this.updateState(locals, transition, index);
                        if (i == lastMatch) {
                            return target.getId();
                        }
                        locals.setPc(target.getId());
                        locals.push();
                    }
                }
                bs >>>= 1;
            }
        }
        return -2;
    }

    private TRegexExecutorNode getLookAroundExecutor(PureNFAState lookAroundState) {
        return this.lookAroundExecutors[lookAroundState.getLookAroundId()];
    }

    protected boolean lookAroundExecutorIsLiteral(PureNFAState s) {
        return this.getLookAroundExecutor(s) instanceof TRegexLiteralLookAroundExecutorNode;
    }

    private boolean canInlineLookAroundIntoTransition(PureNFAState s) {
        return !(((PureNFATransition[])s.getPredecessors()).length != 1 && !this.lookAroundExecutorIsLiteral(s) || !s.isLookAroundNegated() && this.getLookAroundExecutor(s).writesCaptureGroups());
    }

    private boolean checkSubMatcherInline(TRegexBacktrackingNFAExecutorLocals locals, boolean compactString, PureNFATransition transition, PureNFAState target) {
        if (this.lookAroundExecutorIsLiteral(target)) {
            TRegexLiteralLookAroundExecutorNode literal = (TRegexLiteralLookAroundExecutorNode)this.getLookAroundExecutor(target);
            return (Boolean)literal.execute(locals, compactString);
        }
        return !this.subMatchFailed(target, this.runSubMatcher(locals.createSubNFALocals(transition), compactString, target));
    }

    protected int[] runSubMatcher(TRegexBacktrackingNFAExecutorLocals subLocals, boolean compactString, PureNFAState lookAroundState) {
        return (int[])this.getLookAroundExecutor(lookAroundState).execute(subLocals, compactString);
    }

    protected boolean subMatchFailed(PureNFAState curState, int[] subMatchResult) {
        return subMatchResult == null != curState.isLookAroundNegated();
    }

    @ExplodeLoop
    protected boolean transitionMatches(TRegexBacktrackingNFAExecutorLocals locals, boolean compactString, PureNFATransition transition, int index, boolean atEnd, char c) {
        int i;
        PureNFAState target = (PureNFAState)transition.getTarget(this.isForward());
        CompilerDirectives.isPartialEvaluationConstant((Object)target);
        if (transition.hasCaretGuard() && index != 0) {
            return false;
        }
        if (transition.hasDollarGuard() && index < locals.getMaxIndex()) {
            return false;
        }
        int nGuards = transition.getQuantifierGuards().length;
        int n = i = this.isForward() ? 0 : nGuards - 1;
        while (this.isForward() ? i < nGuards : i >= 0) {
            QuantifierGuard guard = transition.getQuantifierGuards()[i];
            CompilerDirectives.isPartialEvaluationConstant((Object)guard);
            Token.Quantifier q = guard.getQuantifier();
            CompilerDirectives.isPartialEvaluationConstant((Object)q);
            switch (this.isForward() ? guard.getKind() : guard.getKindReverse()) {
                case loop: {
                    if (locals.getQuantifierCount(q) != q.getMax()) break;
                    return false;
                }
                case exit: {
                    if (locals.getQuantifierCount(q) >= q.getMin()) break;
                    return false;
                }
                case exitZeroWidth: {
                    if (locals.getZeroWidthQuantifierGuardIndex(q) != index || q.hasIndex() && locals.getQuantifierCount(q) <= q.getMin()) break;
                    return false;
                }
                case enterEmptyMatch: {
                    if (locals.getQuantifierCount(q) < q.getMin()) break;
                    return false;
                }
            }
            i = this.inputIncIndex(i);
        }
        switch (target.getKind()) {
            case 0: {
                assert (!target.isInitialState(this.isForward()));
                return target.isAnchoredFinalState(this.isForward()) ? atEnd : true;
            }
            case 1: {
                return !atEnd && this.matchers[target.getId()].execute(c, compactString);
            }
            case 2: {
                if (this.canInlineLookAroundIntoTransition(target)) {
                    return this.checkSubMatcherInline(locals, compactString, transition, target);
                }
                return true;
            }
            case 3: {
                if (this.canInlineBackReferenceIntoTransition()) {
                    int start = this.getBackRefBoundary(locals, transition, target.getBackRefNumber() * 2, index);
                    int end = this.getBackRefBoundary(locals, transition, target.getBackRefNumber() * 2 + 1, index);
                    if (start < 0 || end < 0) {
                        return true;
                    }
                    return this.matchBackReferenceSimple(locals, start, end, index);
                }
                return true;
            }
            case 4: {
                return true;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalStateException();
    }

    protected int getBackRefBoundary(TRegexBacktrackingNFAExecutorLocals locals, PureNFATransition transition, int cgIndex, int index) {
        return transition.getGroupBoundaries().getUpdateIndices().get(cgIndex) ? index : (transition.getGroupBoundaries().getClearIndices().get(cgIndex) ? -1 : locals.getCaptureGroupBoundary(cgIndex));
    }

    @ExplodeLoop
    protected void updateState(TRegexBacktrackingNFAExecutorLocals locals, PureNFATransition transition, int index) {
        int i;
        CompilerDirectives.isPartialEvaluationConstant((Object)transition);
        locals.apply(transition, index);
        int nGuards = transition.getQuantifierGuards().length;
        int n = i = this.isForward() ? 0 : nGuards - 1;
        while (this.isForward() ? i < nGuards : i >= 0) {
            QuantifierGuard guard = transition.getQuantifierGuards()[i];
            CompilerDirectives.isPartialEvaluationConstant((Object)guard);
            Token.Quantifier q = guard.getQuantifier();
            CompilerDirectives.isPartialEvaluationConstant((Object)q);
            switch (this.isForward() ? guard.getKind() : guard.getKindReverse()) {
                case loop: 
                case enter: 
                case loopInc: {
                    locals.incQuantifierCount(q);
                    break;
                }
                case exit: 
                case exitReset: {
                    locals.resetQuantifierCount(q);
                    break;
                }
                case enterZeroWidth: {
                    locals.setZeroWidthQuantifierGuardIndex(q);
                    break;
                }
                case enterEmptyMatch: {
                    if (!transition.hasCaretGuard() && !transition.hasDollarGuard()) {
                        locals.setQuantifierCount(q, q.getMin());
                        break;
                    }
                    locals.incQuantifierCount(q);
                    break;
                }
            }
            i += this.isForward() ? 1 : -1;
        }
        locals.setIndex(this.getNewIndex(locals, (PureNFAState)transition.getTarget(this.isForward()), index));
    }

    private int getNewIndex(TRegexBacktrackingNFAExecutorLocals locals, PureNFAState target, int index) {
        CompilerDirectives.isPartialEvaluationConstant((Object)target.getKind());
        switch (target.getKind()) {
            case 0: {
                return this.inputIncIndex(index);
            }
            case 1: {
                return this.inputIncIndex(index);
            }
            case 2: {
                return index;
            }
            case 3: {
                if (this.canInlineBackReferenceIntoTransition()) {
                    int end = locals.getCaptureGroupEnd(target.getBackRefNumber());
                    int start = locals.getCaptureGroupStart(target.getBackRefNumber());
                    if (start < 0 || end < 0) {
                        return index;
                    }
                    int length = end - start;
                    return this.isForward() ? index + length : index - length;
                }
                return index;
            }
            case 4: {
                return index;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalStateException();
    }

    private boolean canInlineBackReferenceIntoTransition() {
        return !this.ignoreCase && !this.loneSurrogates;
    }

    private boolean matchBackReferenceSimple(TRegexBacktrackingNFAExecutorLocals locals, int backrefStart, int backrefEnd, int index) {
        assert (!this.ignoreCase && !this.loneSurrogates);
        if (this.regionMatchesNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.regionMatchesNode = InputRegionMatchesNode.create();
        }
        int inputLength = locals.getMaxIndex();
        int backrefLength = backrefEnd - backrefStart;
        if (backrefLength == 0) {
            return true;
        }
        if (this.isForward() ? index + backrefLength > inputLength : index - backrefLength < 0) {
            return false;
        }
        return this.regionMatchesNode.execute(locals.getInput(), backrefStart, locals.getInput(), this.isForward() ? index : index - backrefLength, backrefLength, null);
    }

    private int matchBackReferenceGeneric(TRegexBacktrackingNFAExecutorLocals locals, int backrefStart, int backrefEnd) {
        assert (this.ignoreCase || this.loneSurrogates);
        int index = locals.getIndex();
        int inputLength = locals.getMaxIndex();
        int iBR = this.isForward() ? backrefStart : backrefEnd;
        int i = index;
        while (this.inputBoundsCheck(iBR, backrefStart, backrefEnd)) {
            char lowSurrogate;
            char lowSurrogate2;
            if (!this.inputBoundsCheck(i, 0, inputLength)) {
                return -1;
            }
            int codePointBR = this.inputGetChar(locals, iBR);
            if (this.unicode && this.inputIsHighSurrogate((char)codePointBR) && this.inputBoundsCheck(this.inputIncIndex(iBR), backrefStart, backrefEnd) && this.inputIsLowSurrogate(lowSurrogate2 = this.inputGetChar(locals, this.inputIncIndex(iBR)))) {
                codePointBR = this.inputToCodePoint((char)codePointBR, lowSurrogate2);
                iBR = this.inputIncIndex(iBR);
            }
            int codePointI = this.inputGetChar(locals, i);
            if (this.unicode && this.inputIsHighSurrogate((char)codePointI) && this.inputBoundsCheck(this.inputIncIndex(i), 0, inputLength) && this.inputIsLowSurrogate(lowSurrogate = this.inputGetChar(locals, this.inputIncIndex(i)))) {
                codePointI = this.inputToCodePoint((char)codePointI, lowSurrogate);
                i = this.inputIncIndex(i);
            }
            if (!(!this.isIgnoreCase() ? codePointBR == codePointI : this.equalsIgnoreCase(codePointBR, codePointI))) {
                return -1;
            }
            iBR = this.inputIncIndex(iBR);
            i = this.inputIncIndex(i);
        }
        return i;
    }

    private int findInnerLiteral(TRegexBacktrackingNFAExecutorLocals locals, int fromIndex) {
        if (this.indexOfNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.indexOfNode = InputIndexOfStringNode.create();
        }
        return this.indexOfNode.execute(locals.getInput(), fromIndex, locals.getMaxIndex(), this.innerLiteral.getLiteral(), this.innerLiteral.getMask());
    }

    private int findFirstLoopbackMatch(TRegexBacktrackingNFAExecutorLocals locals, boolean compactString, int fromIndex) {
        assert (this.isForward());
        for (int i = fromIndex; i < locals.getMaxIndex(); ++i) {
            if (!this.loopbackInitialStateMatcher.execute(this.inputGetChar(locals, i), compactString)) continue;
            return i;
        }
        return -1;
    }

    protected boolean inputAtBegin(TRegexBacktrackingNFAExecutorLocals locals) {
        return locals.getIndex() == (this.isForward() ? 0 : locals.getMaxIndex());
    }

    private char inputGetChar(TRegexBacktrackingNFAExecutorLocals locals, int index) {
        return this.forward ? this.getCharAt(locals, index) : this.getCharAt(locals, index - 1);
    }

    private int inputIncIndex(int i) {
        return this.forward ? i + 1 : i - 1;
    }

    private boolean inputBoundsCheck(int i, int min, int max) {
        return this.forward ? i < max : i > min;
    }

    protected boolean inputIsLowSurrogate(char c) {
        return this.forward ? Character.isLowSurrogate(c) : Character.isHighSurrogate(c);
    }

    protected boolean inputIsHighSurrogate(char c) {
        return this.forward ? Character.isHighSurrogate(c) : Character.isLowSurrogate(c);
    }

    protected int inputToCodePoint(char highSurrogate, char lowSurrogate) {
        return this.forward ? Character.toCodePoint(highSurrogate, lowSurrogate) : Character.toCodePoint(lowSurrogate, highSurrogate);
    }

    private boolean equalsIgnoreCase(int a, int b) {
        return CaseFoldTable.equalsIgnoreCase(a, b, this.unicode ? CaseFoldTable.CaseFoldingAlgorithm.ECMAScriptUnicode : CaseFoldTable.CaseFoldingAlgorithm.ECMAScriptNonUnicode);
    }
}

