/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.tregex.automaton.StateSet;
import com.oracle.truffle.regex.tregex.buffer.CharArrayBuffer;
import com.oracle.truffle.regex.tregex.parser.ast.LookAroundIndex;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.QuantifiableTerm;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonObject;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public class CharacterClass
extends QuantifiableTerm {
    private CodePointSet charSet;
    private StateSet<LookAroundIndex, LookBehindAssertion> lookBehindEntries;

    CharacterClass(CodePointSet charSet) {
        this.charSet = charSet;
    }

    private CharacterClass(CharacterClass copy) {
        super(copy);
        this.charSet = copy.charSet;
    }

    @Override
    public CharacterClass copy(RegexAST ast, boolean recursive) {
        return ast.register(new CharacterClass(this));
    }

    @Override
    public Sequence getParent() {
        return (Sequence)super.getParent();
    }

    public CodePointSet getCharSet() {
        return this.charSet;
    }

    public void setCharSet(CodePointSet charSet) {
        this.charSet = charSet;
    }

    public boolean wasSingleChar() {
        return this.isFlagSet(262144);
    }

    public void setWasSingleChar() {
        this.setWasSingleChar(true);
    }

    public void setWasSingleChar(boolean value) {
        this.setFlag(262144, value);
    }

    @Override
    public boolean isUnrollingCandidate() {
        return this.hasQuantifier() && this.getQuantifier().isWithinThreshold(20);
    }

    public void addLookBehindEntry(RegexAST ast, LookBehindAssertion lookBehindEntry) {
        if (this.lookBehindEntries == null) {
            this.lookBehindEntries = StateSet.create(ast.getLookArounds());
        }
        this.lookBehindEntries.add(lookBehindEntry);
    }

    public boolean hasLookBehindEntries() {
        return this.lookBehindEntries != null;
    }

    public Set<LookBehindAssertion> getLookBehindEntries() {
        if (this.lookBehindEntries == null) {
            return Collections.emptySet();
        }
        return this.lookBehindEntries;
    }

    public void extractSingleChar(CharArrayBuffer literal, CharArrayBuffer mask) {
        if (this.charSet.matchesSingleChar()) {
            int first = this.charSet.getMin();
            assert (first <= 65535);
            literal.add((char)first);
            mask.add('\u0000');
        } else {
            assert (this.charSet.matches2CharsWith1BitDifference());
            int c1 = this.charSet.getMin();
            int c2 = this.charSet.getMax();
            assert (c2 <= 65535);
            literal.add((char)(c1 | c2));
            mask.add((char)(c1 ^ c2));
        }
    }

    public void extractSingleChar(char[] literal, char[] mask, int i) {
        if (this.charSet.matchesSingleChar()) {
            int first = this.charSet.getMin();
            assert (first <= 65535);
            literal[i] = (char)first;
            mask[i] = '\u0000';
        } else {
            assert (this.charSet.matches2CharsWith1BitDifference());
            int c1 = this.charSet.getMin();
            int c2 = this.charSet.getMax();
            assert (c2 <= 65535);
            literal[i] = (char)(c1 | c2);
            mask[i] = (char)(c1 ^ c2);
        }
    }

    @Override
    public boolean equalsSemantic(RegexASTNode obj, boolean ignoreQuantifier) {
        return obj instanceof CharacterClass && ((CharacterClass)obj).getCharSet().equals(this.charSet) && (ignoreQuantifier || this.quantifierEquals((CharacterClass)obj));
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.charSet.toString() + this.quantifierToString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        JsonObject json = this.toJson("CharacterClass").append(Json.prop("charSet", this.charSet));
        if (this.lookBehindEntries != null) {
            json.append(Json.prop("lookBehindEntries", this.lookBehindEntries.stream().map(RegexASTNode::astNodeId).collect(Collectors.toList())));
        }
        return json;
    }
}

