/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.FunctionPrototypeBuiltins;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=FunctionPrototypeBuiltins.class)
public final class FunctionPrototypeBuiltinsFactory {

    @GeneratedBy(value=FunctionPrototypeBuiltins.HasInstanceNode.class)
    public static final class HasInstanceNodeGen
    extends FunctionPrototypeBuiltins.HasInstanceNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private HasInstanceNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.hasInstance(arguments0Value_, arguments1Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.hasInstance(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "hasInstance";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static FunctionPrototypeBuiltins.HasInstanceNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new HasInstanceNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=FunctionPrototypeBuiltins.JSCallNode.class)
    public static final class JSCallNodeGen
    extends FunctionPrototypeBuiltins.JSCallNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSCallNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0 && arguments2Value_ instanceof Object[]) {
                Object[] arguments2Value__ = (Object[])arguments2Value_;
                return this.call(arguments0Value_, arguments1Value_, arguments2Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state = this.state_;
            if (arguments2Value instanceof Object[]) {
                Object[] arguments2Value_ = (Object[])arguments2Value;
                this.state_ = state |= 1;
                return this.call(arguments0Value, arguments1Value, arguments2Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "call";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static FunctionPrototypeBuiltins.JSCallNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSCallNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=FunctionPrototypeBuiltins.JSApplyNode.class)
    public static final class JSApplyNodeGen
    extends FunctionPrototypeBuiltins.JSApplyNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private IsCallableNode isCallable;

        private JSApplyNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0) {
                DynamicObject arguments0Value__;
                if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSFunction(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                    return this.applyFunction(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 6) != 0) {
                    if ((state & 2) != 0 && this.isCallable.executeBoolean(arguments0Value_)) {
                        return this.applyCallable(arguments0Value_, arguments1Value_, arguments2Value_, this.isCallable);
                    }
                    if ((state & 4) != 0 && !this.isCallable.executeBoolean(arguments0Value_)) {
                        return this.error(arguments0Value_, arguments1Value_, arguments2Value_, this.isCallable);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                IsCallableNode error_isCallable__;
                Object applyCallable_isCallable__;
                DynamicObject arguments0Value_;
                if (exclude == 0 && JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSFunction(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.applyFunction(arguments0Value_, arguments1Value, arguments2Value);
                    return object;
                }
                boolean ApplyCallable_duplicateFound_ = false;
                if ((state & 2) != 0 && this.isCallable.executeBoolean(arguments0Value)) {
                    ApplyCallable_duplicateFound_ = true;
                }
                if (!ApplyCallable_duplicateFound_ && (applyCallable_isCallable__ = (IsCallableNode)super.insert((Node)IsCallableNode.create())).executeBoolean(arguments0Value) && (state & 2) == 0) {
                    if (this.isCallable == null) {
                        this.isCallable = (IsCallableNode)super.insert((Node)applyCallable_isCallable__);
                    }
                    this.exclude_ = exclude |= 1;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    ApplyCallable_duplicateFound_ = true;
                }
                if (ApplyCallable_duplicateFound_) {
                    lock.unlock();
                    hasLock = false;
                    applyCallable_isCallable__ = this.applyCallable(arguments0Value, arguments1Value, arguments2Value, this.isCallable);
                    return applyCallable_isCallable__;
                }
                boolean Error_duplicateFound_ = false;
                if ((state & 4) != 0 && !this.isCallable.executeBoolean(arguments0Value)) {
                    Error_duplicateFound_ = true;
                }
                if (!Error_duplicateFound_ && !(error_isCallable__ = (IsCallableNode)super.insert((Node)IsCallableNode.create())).executeBoolean(arguments0Value) && (state & 4) == 0) {
                    if (this.isCallable == null) {
                        this.isCallable = (IsCallableNode)super.insert((Node)error_isCallable__);
                    }
                    this.state_ = state |= 4;
                    Error_duplicateFound_ = true;
                }
                if (Error_duplicateFound_) {
                    lock.unlock();
                    hasLock = false;
                    Object object = this.error(arguments0Value, arguments1Value, arguments2Value, this.isCallable);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<IsCallableNode>> cached;
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "applyFunction";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : (exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s;
            s = new Object[3];
            s[0] = "applyCallable";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<IsCallableNode>>();
                cached.add(Arrays.asList(this.isCallable));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "error";
            if ((state & 4) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.isCallable));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static FunctionPrototypeBuiltins.JSApplyNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSApplyNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=FunctionPrototypeBuiltins.JSFunctionToStringNode.class)
    public static final class JSFunctionToStringNodeGen
    extends FunctionPrototypeBuiltins.JSFunctionToStringNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private IsCallableNode isCallable;

        private JSFunctionToStringNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 7) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && JSGuards.isJSFunction(arguments0Value__) && this.isRootTarget(arguments0Value__) && !this.isBoundTarget(arguments0Value__)) {
                    return this.toStringDefault(arguments0Value__);
                }
                if ((state & 2) != 0 && JSGuards.isJSFunction(arguments0Value__) && this.isRootTarget(arguments0Value__) && this.isBoundTarget(arguments0Value__)) {
                    return this.toStringBound(arguments0Value__);
                }
                if ((state & 4) != 0 && JSGuards.isJSFunction(arguments0Value__) && !this.isRootTarget(arguments0Value__)) {
                    return this.toString(arguments0Value__);
                }
            }
            if ((state & 0x38) != 0) {
                if ((state & 8) != 0) {
                    assert (this.isES2019OrLater());
                    if (!JSGuards.isJSFunction(arguments0Value_) && this.isCallable.executeBoolean(arguments0Value_)) {
                        return this.toStringCallable(arguments0Value_, this.isCallable);
                    }
                }
                if ((state & 0x10) != 0) {
                    assert (this.isES2019OrLater());
                    if (!this.isCallable.executeBoolean(arguments0Value_)) {
                        return this.toStringNotCallable(arguments0Value_, this.isCallable);
                    }
                }
                if ((state & 0x20) != 0) {
                    assert (!this.isES2019OrLater());
                    if (!JSGuards.isJSFunction(arguments0Value_)) {
                        return this.toStringNotFunction(arguments0Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private String executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                String string;
                IsCallableNode toStringNotCallable_isCallable__;
                Object toStringCallable_isCallable__;
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (JSGuards.isJSFunction(arguments0Value_) && this.isRootTarget(arguments0Value_) && !this.isBoundTarget(arguments0Value_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        String string2 = this.toStringDefault(arguments0Value_);
                        return string2;
                    }
                    if (JSGuards.isJSFunction(arguments0Value_) && this.isRootTarget(arguments0Value_) && this.isBoundTarget(arguments0Value_)) {
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        String string3 = this.toStringBound(arguments0Value_);
                        return string3;
                    }
                    if (JSGuards.isJSFunction(arguments0Value_) && !this.isRootTarget(arguments0Value_)) {
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        String string4 = this.toString(arguments0Value_);
                        return string4;
                    }
                }
                boolean ToStringCallable_duplicateFound_ = false;
                if ((state & 8) != 0) {
                    assert (this.isES2019OrLater());
                    if (!JSGuards.isJSFunction(arguments0Value) && this.isCallable.executeBoolean(arguments0Value)) {
                        ToStringCallable_duplicateFound_ = true;
                    }
                }
                if (!ToStringCallable_duplicateFound_ && this.isES2019OrLater() && !JSGuards.isJSFunction(arguments0Value) && (toStringCallable_isCallable__ = (IsCallableNode)super.insert((Node)IsCallableNode.create())).executeBoolean(arguments0Value) && (state & 8) == 0) {
                    if (this.isCallable == null) {
                        this.isCallable = (IsCallableNode)super.insert((Node)toStringCallable_isCallable__);
                    }
                    this.state_ = state |= 8;
                    ToStringCallable_duplicateFound_ = true;
                }
                if (ToStringCallable_duplicateFound_) {
                    lock.unlock();
                    hasLock = false;
                    toStringCallable_isCallable__ = this.toStringCallable(arguments0Value, this.isCallable);
                    return toStringCallable_isCallable__;
                }
                boolean ToStringNotCallable_duplicateFound_ = false;
                if ((state & 0x10) != 0) {
                    assert (this.isES2019OrLater());
                    if (!this.isCallable.executeBoolean(arguments0Value)) {
                        ToStringNotCallable_duplicateFound_ = true;
                    }
                }
                if (!ToStringNotCallable_duplicateFound_ && this.isES2019OrLater() && !(toStringNotCallable_isCallable__ = (IsCallableNode)super.insert((Node)IsCallableNode.create())).executeBoolean(arguments0Value) && (state & 0x10) == 0) {
                    if (this.isCallable == null) {
                        this.isCallable = (IsCallableNode)super.insert((Node)toStringNotCallable_isCallable__);
                    }
                    this.state_ = state |= 0x10;
                    ToStringNotCallable_duplicateFound_ = true;
                }
                if (ToStringNotCallable_duplicateFound_) {
                    lock.unlock();
                    hasLock = false;
                    string = this.toStringNotCallable(arguments0Value, this.isCallable);
                    return string;
                }
                if (!this.isES2019OrLater() && !JSGuards.isJSFunction(arguments0Value)) {
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    string = this.toStringNotFunction(arguments0Value);
                    return string;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<IsCallableNode>> cached;
            Object[] data = new Object[7];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "toStringDefault";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "toStringBound";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "toString";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "toStringCallable";
            if ((state & 8) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<IsCallableNode>>();
                cached.add(Arrays.asList(this.isCallable));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[4] = s;
            s = new Object[3];
            s[0] = "toStringNotCallable";
            if ((state & 0x10) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.isCallable));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[5] = s;
            s = new Object[3];
            s[0] = "toStringNotFunction";
            s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[6] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static FunctionPrototypeBuiltins.JSFunctionToStringNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSFunctionToStringNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=FunctionPrototypeBuiltins.JSBindNode.class)
    public static final class JSBindNodeGen
    extends FunctionPrototypeBuiltins.JSBindNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSBindNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0 && arguments2Value_ instanceof Object[]) {
                Object[] arguments2Value__ = (Object[])arguments2Value_;
                if ((state & 3) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                    DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                    if ((state & 1) != 0 && JSGuards.isJSFunction(arguments0Value__)) {
                        return this.bind(arguments0Value__, arguments1Value_, arguments2Value__);
                    }
                    if ((state & 2) != 0 && JSGuards.isJSProxy(arguments0Value__)) {
                        return this.bindProxy(arguments0Value__, arguments1Value_, arguments2Value__);
                    }
                }
                if ((state & 4) != 0 && !JSGuards.isJSFunction(arguments0Value_) && !JSGuards.isJSProxy(arguments0Value_)) {
                    return this.bind(arguments0Value_, arguments1Value_, arguments2Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state = this.state_;
            if (arguments2Value instanceof Object[]) {
                Object[] arguments2Value_ = (Object[])arguments2Value;
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (JSGuards.isJSFunction(arguments0Value_)) {
                        this.state_ = state |= 1;
                        return this.bind(arguments0Value_, arguments1Value, arguments2Value_);
                    }
                    if (JSGuards.isJSProxy(arguments0Value_)) {
                        this.state_ = state |= 2;
                        return this.bindProxy(arguments0Value_, arguments1Value, arguments2Value_);
                    }
                }
                if (!JSGuards.isJSFunction(arguments0Value) && !JSGuards.isJSProxy(arguments0Value)) {
                    this.state_ = state |= 4;
                    return this.bind(arguments0Value, arguments1Value, arguments2Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "bind";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "bindProxy";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "bind";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static FunctionPrototypeBuiltins.JSBindNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSBindNodeGen(context, builtin, arguments);
        }
    }
}

