/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.control.GeneratorWrapperNode;
import com.oracle.truffle.js.runtime.objects.Undefined;

public interface ResumableNode {
    public Object resume(VirtualFrame var1);

    public static GeneratorWrapperNode parent(ResumableNode node) {
        Node parent = ((Node)node).getParent();
        if (parent instanceof InstrumentableNode.WrapperNode) {
            if (!1.$assertionsDisabled && ((InstrumentableNode.WrapperNode)parent).getDelegateNode() != node) {
                throw new AssertionError();
            }
            parent = parent.getParent();
        }
        return (GeneratorWrapperNode)parent;
    }

    default public void setState(VirtualFrame frame, Object state) {
        ResumableNode.parent(this).setState(frame, state);
    }

    default public Object getState(VirtualFrame frame) {
        return ResumableNode.parent(this).getState(frame);
    }

    default public int getStateAsInt(VirtualFrame frame) {
        return ResumableNode.parent(this).getStateAsInt(frame);
    }

    default public Object getStateAndReset(VirtualFrame frame) {
        try {
            Object object = this.getState(frame);
            return object;
        }
        finally {
            this.resetState(frame);
        }
    }

    default public int getStateAsIntAndReset(VirtualFrame frame) {
        try {
            int n = this.getStateAsInt(frame);
            return n;
        }
        finally {
            this.resetState(frame);
        }
    }

    default public void resetState(VirtualFrame frame) {
        this.setState(frame, Undefined.instance);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

