/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNodeGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.truffleinterop.InteropFunction;

@GenerateUncached
public abstract class JSForeignToJSTypeNode
extends JavaScriptBaseNode {
    public abstract Object executeWithTarget(Object var1);

    public static JSForeignToJSTypeNode create() {
        return JSForeignToJSTypeNodeGen.create();
    }

    @Specialization
    public int fromInt(int value) {
        return value;
    }

    @Specialization
    public String fromString(String value) {
        return value;
    }

    @Specialization
    public boolean fromBoolean(boolean value) {
        return value;
    }

    @Specialization
    public BigInt fromBigInt(BigInt value) {
        return value;
    }

    @Specialization(guards={"isLongRepresentableAsInt32(value)"})
    public int fromLongToInt(long value) {
        return (int)value;
    }

    @Specialization(guards={"!isLongRepresentableAsInt32(value)"})
    public long fromLong(long value) {
        return value;
    }

    @Specialization
    public double fromDouble(double value) {
        return value;
    }

    @Specialization
    public int fromNumber(byte value) {
        return value;
    }

    @Specialization
    public int fromNumber(short value) {
        return value;
    }

    @Specialization
    public double fromNumber(float value) {
        return value;
    }

    @Specialization
    public String fromChar(char value) {
        return String.valueOf(value);
    }

    @Specialization(guards={"isJavaNull(value)"})
    public Object isNull(Object value) {
        return Null.instance;
    }

    @Specialization
    public Object fromTruffleJavaObject(TruffleObject value, @CachedContext(value=JavaScriptLanguage.class) TruffleLanguage.ContextReference<JSRealm> contextRef) {
        Object object;
        if (value instanceof InteropFunction) {
            return ((InteropFunction)value).getFunction();
        }
        TruffleLanguage.Env env = ((JSRealm)contextRef.get()).getEnv();
        if (env.isHostObject((Object)value) && (object = env.asHostObject((Object)value)) == null) {
            return Null.instance;
        }
        return value;
    }

    @Fallback
    public Object fallbackCase(Object value) {
        throw Errors.createTypeErrorUnsupportedInteropType(value);
    }
}

