/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.intl.DefaultNumberOptionNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;

public abstract class DefaultNumberOptionNode
extends JavaScriptBaseNode {
    @Node.Child
    JSToNumberNode toNumberNode;
    int maximum;
    Number fallback;

    protected DefaultNumberOptionNode(int maximum, Number fallback) {
        this.maximum = maximum;
        this.fallback = fallback;
    }

    public abstract Number executeValue(Object var1, int var2);

    public static DefaultNumberOptionNode create(int maximum, Number fallback) {
        return DefaultNumberOptionNodeGen.create(maximum, fallback);
    }

    @Specialization(guards={"!isUndefined(value)"})
    public Number getOption(Object value, int minimum) {
        Number numValue = this.toNumber(value);
        int intValue = numValue.intValue();
        if (minimum > intValue || this.maximum < intValue) {
            this.createRangeError(value, minimum);
        }
        return intValue;
    }

    @CompilerDirectives.TruffleBoundary
    private void createRangeError(Object value, int minimum) throws JSException {
        throw Errors.createRangeError(String.format("invalid value %s found where only values between %d and %d are allowed", JSRuntime.safeToString(value), minimum, this.maximum));
    }

    @Specialization(guards={"isUndefined(value)"})
    public Number getOptionFromUndefined(Object value, int minimum) {
        return this.fallback;
    }

    protected Number toNumber(Object value) {
        if (this.toNumberNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toNumberNode = (JSToNumberNode)this.insert(JSToNumberNode.create());
        }
        return this.toNumberNode.executeNumber(value);
    }
}

