/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.intl.GetNumberOptionNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class GetNumberOptionNode
extends JavaScriptBaseNode {
    private final Number maximum;
    @Node.Child
    PropertyGetNode propertyGetNode;
    @Node.Child
    JSToNumberNode toNumberNode = JSToNumberNode.create();

    protected GetNumberOptionNode(JSContext context, String property, Number maximum) {
        this.maximum = maximum;
        this.propertyGetNode = PropertyGetNode.create(property, false, context);
    }

    public abstract Number executeValue(Object var1, Number var2, Number var3);

    public static GetNumberOptionNode create(JSContext context, String property, Number maximum) {
        return GetNumberOptionNodeGen.create(context, property, maximum);
    }

    protected Number makeFinalSelection(Number value, Number minimum) {
        this.ensureSelectedValueIsValid(value, minimum);
        return value.intValue();
    }

    @CompilerDirectives.TruffleBoundary
    private void ensureSelectedValueIsValid(Number value, Number minimum) {
        if (JSRuntime.isNaN(value) || minimum.doubleValue() > value.doubleValue() || this.maximum.doubleValue() < value.doubleValue()) {
            throw Errors.createRangeError(String.format("invalid value %s found where only values between %s and %s are allowed", value, minimum, this.maximum));
        }
    }

    @Specialization(guards={"!isUndefined(options)"})
    public Number getOption(Object options, Number minimum, Number fallback) {
        Object propertyValue = this.propertyGetNode.getValue(options);
        if (propertyValue == Undefined.instance) {
            return fallback;
        }
        return this.makeFinalSelection(this.toOptionType(propertyValue), minimum);
    }

    @Specialization(guards={"isUndefined(options)"})
    public Number getOptionFromUndefined(Object options, Number minimum, Number fallback) {
        return fallback;
    }

    protected Number toOptionType(Object propertyValue) {
        return this.toNumberNode.executeNumber(propertyValue);
    }
}

