/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesIntArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;

public abstract class AbstractIntArray
extends AbstractWritableArray {
    protected AbstractIntArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    AbstractWritableArray sameTypeHolesArray(DynamicObject object, int length, Object array, long indexOffset, int arrayOffset, int usedLength, int holeCount) {
        return HolesIntArray.makeHolesIntArray(object, length, (int[])array, indexOffset, arrayOffset, usedLength, holeCount, this.integrityLevel);
    }

    @Override
    public final ScriptArray setElementImpl(DynamicObject object, long index, Object value, boolean strict, boolean condition) {
        assert (index >= 0L);
        if (CompilerDirectives.injectBranchProbability((double)0.9999, (value instanceof Integer && this.isSupported(object, index, condition) ? 1 : 0) != 0)) {
            int intValue = (Integer)value;
            if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (intValue == Integer.MIN_VALUE ? 1 : 0) != 0)) {
                return this.toObject(object, index, value, condition).setElementImpl(object, index, value, strict, condition);
            }
            this.setSupported(object, (int)index, intValue, condition, ScriptArray.ProfileHolder.empty());
            return this;
        }
        return this.rewrite(object, index, value, condition).setElementImpl(object, index, value, strict, condition);
    }

    private ScriptArray rewrite(DynamicObject object, long index, Object value, boolean condition) {
        if (value instanceof Integer) {
            if (this.isSupportedContiguous(object, index, condition)) {
                return this.toContiguous(object, index, value, condition);
            }
            if (this.isSupportedHoles(object, index, condition)) {
                return this.toHoles(object, index, value, condition);
            }
            return this.toSparse(object, index, value);
        }
        if (value instanceof Double) {
            return this.toDouble(object, index, (Double)value, condition);
        }
        return this.toObject(object, index, value, condition);
    }

    @Override
    public Object getInBoundsFast(DynamicObject object, int index, boolean condition) {
        return this.getInBoundsFastInt(object, index, condition);
    }

    @Override
    int getArrayLength(Object array) {
        return ((int[])array).length;
    }

    protected static int[] getArray(DynamicObject object) {
        return AbstractIntArray.getArray(object, AbstractIntArray.arrayCondition());
    }

    protected static int[] getArray(DynamicObject object, boolean condition) {
        return AbstractIntArray.arrayCast(JSAbstractArray.arrayGetArray(object, condition), int[].class, condition);
    }

    @Override
    public abstract int getInBoundsFastInt(DynamicObject var1, int var2, boolean var3);

    public abstract void setInBoundsFast(DynamicObject var1, int var2, int var3, boolean var4);

    public final void setInBounds(DynamicObject object, int index, int value, boolean condition, ScriptArray.ProfileHolder profile) {
        AbstractIntArray.getArray((DynamicObject)object, (boolean)condition)[this.prepareInBounds((DynamicObject)object, (int)index, (boolean)condition, (ScriptArray.ProfileHolder)profile)] = value;
    }

    public final void setSupported(DynamicObject object, int index, int value, boolean condition, ScriptArray.ProfileHolder profile) {
        int preparedIndex = this.prepareSupported(object, index, condition, profile);
        AbstractIntArray.getArray((DynamicObject)object)[preparedIndex] = value;
    }

    @Override
    void fillWithHoles(Object array, int fromIndex, int toIndex) {
        int[] intArray = (int[])array;
        for (int i = fromIndex; i < toIndex; ++i) {
            intArray[i] = Integer.MIN_VALUE;
        }
    }

    @Override
    protected final void setHoleValue(DynamicObject object, int preparedIndex) {
        AbstractIntArray.getArray((DynamicObject)object)[preparedIndex] = Integer.MIN_VALUE;
    }

    @Override
    protected final boolean isHolePrepared(DynamicObject object, int preparedIndex, boolean condition) {
        return HolesIntArray.isHoleValue(AbstractIntArray.getArray(object, condition)[preparedIndex]);
    }

    @Override
    protected final int getArrayCapacity(DynamicObject object, boolean condition) {
        return AbstractIntArray.getArray(object, condition).length;
    }

    @Override
    protected final void resizeArray(DynamicObject object, int newCapacity, int oldCapacity, int offset, boolean condition) {
        int[] newArray = new int[newCapacity];
        System.arraycopy(AbstractIntArray.getArray(object, condition), 0, newArray, offset, oldCapacity);
        JSAbstractArray.arraySetArray(object, newArray);
    }

    @Override
    public abstract AbstractWritableArray toHoles(DynamicObject var1, long var2, Object var4, boolean var5);

    @Override
    public ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict, boolean condition) {
        return this.toHoles(object, index, Integer.MIN_VALUE, condition).deleteElementImpl(object, index, strict, condition);
    }

    protected abstract HolesObjectArray toObjectHoles(DynamicObject var1, boolean var2);

    protected static Object[] convertToObject(DynamicObject object, boolean condition) {
        int[] array = AbstractIntArray.getArray(object, condition);
        int usedLength = AbstractIntArray.getUsedLength(object, condition);
        Object[] obj = new Object[array.length];
        for (int i = 0; i < usedLength; ++i) {
            obj[i] = array[i];
        }
        return obj;
    }

    protected static boolean containsHoleValue(DynamicObject object, boolean condition) {
        int[] array = AbstractIntArray.getArray(object, condition);
        int usedLength = AbstractIntArray.getUsedLength(object, condition);
        for (int i = 0; i < usedLength; ++i) {
            if (array[i] != Integer.MIN_VALUE) continue;
            return true;
        }
        return false;
    }

    @Override
    protected final void moveRangePrepared(DynamicObject object, int src, int dst, int len) {
        int[] array = AbstractIntArray.getArray(object);
        System.arraycopy(array, src, array, dst, len);
    }

    @Override
    public final Object allocateArray(int length) {
        return new int[length];
    }

    @Override
    protected abstract AbstractIntArray withIntegrityLevel(int var1);
}

