/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.reporting.exec;

import org.apache.maven.model.Plugin;
import org.apache.maven.reporting.MavenReport;

public class MavenReportExecution {
    private MavenReport mavenReport;
    private ClassLoader classLoader;
    private Plugin plugin;
    private final String goal;

    public MavenReportExecution(String goal, Plugin plugin, MavenReport mavenReport, ClassLoader classLoader) {
        this.goal = goal;
        this.setPlugin(plugin);
        this.mavenReport = mavenReport;
        this.classLoader = classLoader;
    }

    public MavenReportExecution(Plugin plugin, MavenReport mavenReport, ClassLoader classLoader) {
        this(null, plugin, mavenReport, classLoader);
    }

    public MavenReportExecution(MavenReport mavenReport) {
        this(null, null, mavenReport, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canGenerateReport() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (this.classLoader != null) {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
            boolean bl = this.mavenReport.canGenerateReport();
            return bl;
        }
        finally {
            if (this.classLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    public MavenReport getMavenReport() {
        return this.mavenReport;
    }

    public void setMavenReport(MavenReport mavenReport) {
        this.mavenReport = mavenReport;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getGoal() {
        return this.goal;
    }
}

