/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.commonjs;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.builtins.GlobalBuiltins;
import com.oracle.truffle.js.builtins.commonjs.CommonJSRequireBuiltin;
import com.oracle.truffle.js.builtins.commonjs.CommonJSResolution;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import java.nio.file.LinkOption;

public abstract class CommonJSDirnameGetterBuiltin
extends GlobalBuiltins.JSFileLoadingOperation {
    CommonJSDirnameGetterBuiltin(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected Object getDirName() {
        return this.getCurrentFolderName();
    }

    @CompilerDirectives.TruffleBoundary
    private String getCurrentFolderName() {
        String filePath = CommonJSResolution.getCurrentFileNameFromStack();
        if (filePath != null) {
            TruffleFile truffleFile = this.getContext().getRealm().getEnv().getPublicTruffleFile(filePath);
            assert (truffleFile.isRegularFile(new LinkOption[0]) && truffleFile.getParent().isDirectory(new LinkOption[0]));
            return truffleFile.getParent().normalize().toString();
        }
        return CommonJSRequireBuiltin.getModuleResolveCurrentWorkingDirectory(this.getContext()).getAbsoluteFile().toString();
    }
}

