/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.BooleanPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;

public final class BooleanPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<BooleanPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new BooleanPrototypeBuiltins();

    protected BooleanPrototypeBuiltins() {
        super("Boolean.prototype", BooleanPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, BooleanPrototype builtinEnum) {
        switch (builtinEnum) {
            case toString: {
                return BooleanPrototypeBuiltinsFactory.JSBooleanToStringNodeGen.create(context, builtin, BooleanPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case valueOf: {
                return BooleanPrototypeBuiltinsFactory.JSBooleanValueOfNodeGen.create(context, builtin, BooleanPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class JSBooleanValueOfNode
    extends JSBuiltinNode {
        public JSBooleanValueOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"!isJSBoolean(thisObj)", "!isBoolean(thisObj)"})
        protected boolean valueOf(Object thisObj) {
            throw JSBoolean.noBooleanError();
        }

        @Specialization(guards={"isJSBoolean(thisObj)"})
        protected boolean valueOf(DynamicObject thisObj) {
            return JSBoolean.valueOf(thisObj);
        }

        @Specialization(guards={"isBoolean(thisObj)"})
        protected boolean valueOfPrimitive(Object thisObj) {
            return (Boolean)thisObj;
        }
    }

    public static abstract class JSBooleanToStringNode
    extends JSBuiltinNode {
        public JSBooleanToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"!isJSBoolean(thisObj)", "!isBoolean(thisObj)"})
        protected String toString(Object thisObj) {
            throw JSBoolean.noBooleanError();
        }

        @Specialization(guards={"isJSBoolean(thisObj)"})
        protected String toString(DynamicObject thisObj) {
            return String.valueOf(JSBoolean.valueOf(thisObj));
        }

        @Specialization(guards={"isBoolean(thisObj)"})
        protected String toStringPrimitive(Object thisObj) {
            return JSRuntime.booleanToString((Boolean)thisObj);
        }
    }

    public static enum BooleanPrototype implements BuiltinEnum<BooleanPrototype>
    {
        toString(0),
        valueOf(0);

        private final int length;

        private BooleanPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

