/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.EnumerateNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.ForInIterator;
import com.oracle.truffle.js.runtime.util.IteratorUtil;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class EnumerateNode
extends JavaScriptNode {
    private final boolean values;
    private final boolean requireIterable;
    protected final JSContext context;
    @Node.Child
    @Executed
    protected JavaScriptNode targetNode;

    protected EnumerateNode(JSContext context, boolean values, boolean requireIterable, JavaScriptNode targetNode) {
        this.context = context;
        this.values = values;
        this.requireIterable = requireIterable;
        this.targetNode = targetNode;
    }

    public static EnumerateNode create(JSContext context, JavaScriptNode target, boolean values) {
        return EnumerateNodeGen.create(context, values, false, target);
    }

    public static EnumerateNode create(JSContext context, boolean values, boolean requireIterable) {
        return EnumerateNodeGen.create(context, values, requireIterable, null);
    }

    EnumerateNode copyRecursive() {
        return EnumerateNode.create(this.context, this.values, this.requireIterable);
    }

    public abstract DynamicObject execute(VirtualFrame var1);

    public abstract DynamicObject execute(Object var1);

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return EnumerateNodeGen.create(this.context, this.values, this.requireIterable, EnumerateNode.cloneUninitialized(this.targetNode, materializedTags));
    }

    @Specialization(guards={"isJSType(iteratedObject)", "!isJSAdapter(iteratedObject)"})
    protected DynamicObject doEnumerateObject(DynamicObject iteratedObject, @Cached(value="createBinaryProfile()") ConditionProfile isObject) {
        if (isObject.profile(JSRuntime.isObject(iteratedObject))) {
            return EnumerateNode.newForInIterator(this.context, iteratedObject, this.values);
        }
        Iterator iterator = Collections.emptyIterator();
        return EnumerateNode.newEnumerateIterator(this.context, iterator);
    }

    @Specialization(guards={"isJSAdapter(iteratedObject)"})
    protected DynamicObject doEnumerateJSAdapter(DynamicObject iteratedObject, @Cached(value="createValues()") EnumerateNode enumerateCallbackResultNode) {
        Object returnValue;
        DynamicObject adaptee = JSAdapter.getAdaptee(iteratedObject);
        assert (JSRuntime.isObject(adaptee));
        Object getIds = JSObject.get(adaptee, (Object)(this.values ? "__getValues__" : "__getIds__"));
        if (JSFunction.isJSFunction(getIds) && JSRuntime.isObject(returnValue = JSFunction.call((DynamicObject)getIds, adaptee, JSArguments.EMPTY_ARGUMENTS_ARRAY))) {
            return enumerateCallbackResultNode.execute(returnValue);
        }
        return EnumerateNode.newEnumerateIterator(this.context, Collections.emptyIterator());
    }

    EnumerateNode createValues() {
        return EnumerateNode.create(this.context, true, false);
    }

    @Specialization(guards={"isForeignObject(iteratedObject)"}, limit="3")
    protected DynamicObject doEnumerateTruffleObject(Object iteratedObject, @CachedLibrary(value="iteratedObject") InteropLibrary interop, @CachedLibrary(limit="3") InteropLibrary keysInterop, @Cached(value="createBinaryProfile()") ConditionProfile isHostObject, @Cached BranchProfile notIterable) {
        Object hostObject;
        Iterator<?> iterator;
        TruffleLanguage.Env env = this.context.getRealm().getEnv();
        if (isHostObject.profile(env.isHostObject(iteratedObject)) && (iterator = EnumerateNode.getHostObjectIterator(hostObject = env.asHostObject(iteratedObject), this.values, env)) != null) {
            return EnumerateNode.newEnumerateIterator(this.context, iterator);
        }
        try {
            if (!interop.isNull(iteratedObject)) {
                if (interop.hasArrayElements(iteratedObject)) {
                    long longSize = interop.getArraySize(iteratedObject);
                    return EnumerateNode.enumerateForeignArrayLike(this.context, iteratedObject, longSize, this.values, interop);
                }
                if (interop.hasMembers(iteratedObject)) {
                    Object keysObj = interop.getMembers(iteratedObject);
                    assert (((InteropLibrary)InteropLibrary.getFactory().getUncached()).hasArrayElements(keysObj));
                    long longSize = keysInterop.getArraySize(keysObj);
                    return EnumerateNode.enumerateForeignNonArray(this.context, iteratedObject, keysObj, longSize, this.values, interop, keysInterop);
                }
                if (interop.isString(iteratedObject)) {
                    String string = interop.asString(iteratedObject);
                    return this.enumerateString(string);
                }
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            // empty catch block
        }
        notIterable.enter();
        if (this.requireIterable) {
            throw Errors.createTypeErrorNotIterable(iteratedObject, this);
        }
        return EnumerateNode.newEnumerateIterator(this.context, Collections.emptyIterator());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CompilerDirectives.TruffleBoundary
    private static Iterator<?> getHostObjectIterator(Object hostObject, boolean values, TruffleLanguage.Env env) {
        void var3_7;
        if (hostObject == null) return null;
        if (hostObject instanceof Map) {
            Map map = (Map)hostObject;
            Iterator<Object> iterator = values ? map.values().iterator() : map.keySet().iterator();
            return IteratorUtil.convertIterator(var3_7, arg_0 -> ((TruffleLanguage.Env)env).asGuestValue(arg_0));
        } else if (hostObject.getClass().isArray()) {
            if (!values) return IteratorUtil.rangeIterator(Array.getLength(hostObject));
            ArrayIterator arrayIterator = new ArrayIterator(hostObject);
            return IteratorUtil.convertIterator(var3_7, arg_0 -> ((TruffleLanguage.Env)env).asGuestValue(arg_0));
        } else {
            if (!values && hostObject instanceof List) {
                return IteratorUtil.rangeIterator(((List)hostObject).size());
            }
            if (!values || !(hostObject instanceof Iterable)) return null;
            Iterator iterator = ((Iterable)hostObject).iterator();
        }
        return IteratorUtil.convertIterator(var3_7, arg_0 -> ((TruffleLanguage.Env)env).asGuestValue(arg_0));
    }

    private static DynamicObject enumerateForeignArrayLike(JSContext context, final Object iteratedObject, final long longSize, final boolean values, final InteropLibrary interop) {
        Iterator<Object> iterator = new Iterator<Object>(){
            private long cursor;

            @Override
            public boolean hasNext() {
                return this.cursor < longSize;
            }

            @Override
            public Object next() {
                if (this.hasNext()) {
                    long index = this.cursor++;
                    if (values) {
                        try {
                            return interop.readArrayElement(iteratedObject, index);
                        }
                        catch (InvalidArrayIndexException | UnsupportedMessageException throwable) {
                        }
                    } else {
                        return index;
                    }
                }
                throw new NoSuchElementException();
            }
        };
        return EnumerateNode.newEnumerateIterator(context, iterator);
    }

    private static DynamicObject enumerateForeignNonArray(JSContext context, final Object iteratedObject, final Object keysObject, final long keysSize, final boolean values, final InteropLibrary objInterop, final InteropLibrary keysInterop) {
        Iterator<Object> iterator = new Iterator<Object>(){
            private long cursor;

            @Override
            public boolean hasNext() {
                return this.cursor < keysSize;
            }

            @Override
            public Object next() {
                block7: {
                    if (this.hasNext()) {
                        long index = this.cursor++;
                        try {
                            Object key = keysInterop.readArrayElement(keysObject, index);
                            if (values) {
                                try {
                                    assert (((InteropLibrary)InteropLibrary.getFactory().getUncached()).isString(key));
                                    String stringKey = key instanceof String ? (String)key : ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asString(key);
                                    return objInterop.readMember(iteratedObject, stringKey);
                                }
                                catch (UnknownIdentifierException | UnsupportedMessageException throwable) {
                                    break block7;
                                }
                            }
                            return key;
                        }
                        catch (InvalidArrayIndexException | UnsupportedMessageException throwable) {
                            // empty catch block
                        }
                    }
                }
                throw new NoSuchElementException();
            }
        };
        return EnumerateNode.newEnumerateIterator(context, iterator);
    }

    private DynamicObject enumerateString(String string) {
        return EnumerateNode.newForInIterator(this.context, JSString.create(this.context, string), this.values);
    }

    private static DynamicObject newEnumerateIterator(JSContext context, Iterator<?> iterator) {
        return JSObject.create(context, context.getEnumerateIteratorFactory(), iterator);
    }

    private static DynamicObject newForInIterator(JSContext context, DynamicObject obj, boolean values) {
        return JSObject.create(context, context.getForInIteratorFactory(), new ForInIterator(obj, values));
    }

    @Specialization(guards={"!isJSObject(iteratedObject)"})
    protected DynamicObject doNonObject(Object iteratedObject, @Cached(value="createToObjectNoCheck(context)") JSToObjectNode toObjectNode, @Cached(value="copyRecursive()") EnumerateNode enumerateNode) {
        return enumerateNode.execute(toObjectNode.execute(iteratedObject));
    }

    private static final class ArrayIterator
    implements Iterator<Object> {
        private final Object array;
        private final int length;
        private int index;

        ArrayIterator(Object array) {
            this.array = array;
            this.length = Array.getLength(array);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public Object next() {
            if (this.hasNext()) {
                return Array.get(this.array, this.index++);
            }
            throw new NoSuchElementException();
        }
    }
}

