/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.JSReadScopeFrameSlotNodeGen;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.Set;

abstract class JSReadScopeFrameSlotNode
extends JSReadFrameSlotNode {
    @Node.Child
    @Executed
    ScopeFrameNode scopeFrameNode;

    JSReadScopeFrameSlotNode(FrameSlot slot, ScopeFrameNode scopeFrameNode) {
        super(slot);
        this.scopeFrameNode = scopeFrameNode;
    }

    @Specialization(guards={"levelFrame.isBoolean(frameSlot)"})
    protected final boolean doBoolean(Frame levelFrame) {
        return super.getBoolean(levelFrame);
    }

    @Specialization(guards={"levelFrame.isInt(frameSlot)"})
    protected final int doInt(Frame levelFrame) {
        return super.getInt(levelFrame);
    }

    @Specialization(guards={"levelFrame.isDouble(frameSlot)"})
    protected final double doDouble(Frame levelFrame) {
        return super.getDouble(levelFrame);
    }

    @Specialization(guards={"levelFrame.isObject(frameSlot)", "!hasTemporalDeadZone()"})
    protected final Object doObject(Frame levelFrame) {
        return super.getObject(levelFrame);
    }

    @Specialization(guards={"levelFrame.isLong(frameSlot)"})
    protected final SafeInteger doSafeInteger(Frame levelFrame) {
        return SafeInteger.valueOf(super.getLong(levelFrame));
    }

    @Override
    public ScopeFrameNode getLevelFrameNode() {
        return this.scopeFrameNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSReadScopeFrameSlotNodeGen.create(this.frameSlot, this.getLevelFrameNode());
    }
}

