/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.function.SpecializedNewObjectNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SpecializedNewObjectNode.class)
public final class SpecializedNewObjectNodeGen
extends SpecializedNewObjectNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private CachedProtoData cachedProto_cache;
    @CompilerDirectives.CompilationFinal
    private BranchProfile uncachedProto_slowBranch_;

    private SpecializedNewObjectNodeGen(JSContext context, boolean isBuiltin, boolean isConstructor, boolean isGenerator, boolean isAsyncGenerator) {
        super(context, isBuiltin, isConstructor, isGenerator, isAsyncGenerator);
    }

    @Override
    @ExplodeLoop
    protected DynamicObject execute(DynamicObject arg0Value, Object arg1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 7) != 0 && JSTypes.isDynamicObject(arg1Value)) {
                DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                if ((state & 1) != 0) {
                    assert (!this.isBuiltin);
                    assert (this.isConstructor);
                    assert (!this.context.isMultiContext());
                    CachedProtoData s1_ = this.cachedProto_cache;
                    while (s1_ != null) {
                        assert (JSGuards.isJSObject(s1_.cachedPrototype_));
                        if (arg1Value_ == s1_.cachedPrototype_) {
                            return this.doCachedProto(arg0Value, arg1Value_, s1_.cachedPrototype_, s1_.shape_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    assert (!this.isBuiltin);
                    assert (this.isConstructor);
                    assert (!this.context.isMultiContext());
                    if (JSGuards.isJSObject(arg1Value_)) {
                        return this.doUncachedProto(arg0Value, arg1Value_, this.uncachedProto_slowBranch_);
                    }
                }
                if ((state & 4) != 0) {
                    assert (!this.isBuiltin);
                    assert (this.isConstructor);
                    assert (this.context.isMultiContext());
                    if (JSGuards.isJSObject(arg1Value_)) {
                        return this.createWithProto(arg0Value, arg1Value_);
                    }
                }
            }
            if ((state & 0x38) != 0) {
                if ((state & 8) != 0) {
                    assert (!this.isBuiltin);
                    assert (this.isConstructor);
                    if (!JSGuards.isJSObject(arg1Value)) {
                        return this.createDefaultProto(arg0Value, arg1Value);
                    }
                }
                if ((state & 0x10) != 0) {
                    assert (this.isBuiltin);
                    assert (this.isConstructor);
                    return SpecializedNewObjectNode.builtinConstructor(arg0Value, arg1Value);
                }
                if ((state & 0x20) != 0) {
                    assert (!this.isConstructor);
                    return this.throwNotConstructorFunctionTypeError(arg0Value, arg1Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private DynamicObject executeAndSpecialize(DynamicObject arg0Value, Object arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        int oldState = state;
        int oldExclude = exclude;
        int oldCacheCount = state == 0 ? 0 : this.countCaches();
        try {
            DynamicObject dynamicObject;
            if (JSTypes.isDynamicObject(arg1Value)) {
                DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                if (exclude == 0 && !this.isBuiltin && this.isConstructor && !this.context.isMultiContext()) {
                    DynamicObject cachedPrototype__;
                    int count1_ = 0;
                    CachedProtoData s1_ = this.cachedProto_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null) {
                            assert (JSGuards.isJSObject(s1_.cachedPrototype_));
                            if (arg1Value_ == s1_.cachedPrototype_) break;
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && JSGuards.isJSObject(cachedPrototype__ = arg1Value_) && count1_ < this.context.getPropertyCacheLimit()) {
                        s1_ = new CachedProtoData(this.cachedProto_cache);
                        s1_.cachedPrototype_ = cachedPrototype__;
                        s1_.shape_ = this.getProtoChildShape(arg1Value_);
                        this.cachedProto_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject2 = this.doCachedProto(arg0Value, arg1Value_, s1_.cachedPrototype_, s1_.shape_);
                        return dynamicObject2;
                    }
                }
                if (!this.isBuiltin && this.isConstructor && !this.context.isMultiContext() && JSGuards.isJSObject(arg1Value_)) {
                    this.uncachedProto_slowBranch_ = BranchProfile.create();
                    this.exclude_ = exclude |= 1;
                    this.cachedProto_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject3 = this.doUncachedProto(arg0Value, arg1Value_, this.uncachedProto_slowBranch_);
                    return dynamicObject3;
                }
                if (!this.isBuiltin && this.isConstructor && this.context.isMultiContext() && JSGuards.isJSObject(arg1Value_)) {
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject4 = this.createWithProto(arg0Value, arg1Value_);
                    return dynamicObject4;
                }
            }
            if (!this.isBuiltin && this.isConstructor && !JSGuards.isJSObject(arg1Value)) {
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                dynamicObject = this.createDefaultProto(arg0Value, arg1Value);
                return dynamicObject;
            }
            if (this.isBuiltin && this.isConstructor) {
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                dynamicObject = SpecializedNewObjectNode.builtinConstructor(arg0Value, arg1Value);
                return dynamicObject;
            }
            if (!this.isConstructor) {
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                dynamicObject = this.throwNotConstructorFunctionTypeError(arg0Value, arg1Value);
                return dynamicObject;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }
        finally {
            if (oldState != 0 || oldExclude != 0) {
                this.checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(int oldState, int oldExclude, int oldCacheCount) {
        int newState = this.state_;
        int newExclude = this.exclude_;
        if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < this.countCaches()) {
            this.reportPolymorphicSpecialize();
        }
    }

    private int countCaches() {
        int cacheCount = 0;
        CachedProtoData s1_ = this.cachedProto_cache;
        while (s1_ != null) {
            ++cacheCount;
            s1_ = s1_.next_;
        }
        return cacheCount;
    }

    public NodeCost getCost() {
        CachedProtoData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cachedProto_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[7];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doCachedProto";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            CachedProtoData s1_ = this.cachedProto_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedPrototype_, s1_.shape_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUncachedProto";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.uncachedProto_slowBranch_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "createWithProto";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "createDefaultProto";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "builtinConstructor";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "throwNotConstructorFunctionTypeError";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static SpecializedNewObjectNode create(JSContext context, boolean isBuiltin, boolean isConstructor, boolean isGenerator, boolean isAsyncGenerator) {
        return new SpecializedNewObjectNodeGen(context, isBuiltin, isConstructor, isGenerator, isAsyncGenerator);
    }

    @GeneratedBy(value=SpecializedNewObjectNode.class)
    private static final class CachedProtoData {
        @CompilerDirectives.CompilationFinal
        CachedProtoData next_;
        @CompilerDirectives.CompilationFinal
        DynamicObject cachedPrototype_;
        @CompilerDirectives.CompilationFinal
        Shape shape_;

        CachedProtoData(CachedProtoData next_) {
            this.next_ = next_;
        }
    }
}

