/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter.collection;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.Invoker;
import org.eclipse.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;

public class ArtifactTransitivityFilter
extends AbstractArtifactsFilter {
    private Set<String> transitiveArtifacts;

    public ArtifactTransitivityFilter(org.apache.maven.artifact.Artifact artifact, ProjectBuildingRequest buildingRequest, ProjectBuilder projectBuilder) throws ProjectBuildingException {
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(buildingRequest);
        request.setResolveDependencies(true);
        ProjectBuildingResult buildingResult = projectBuilder.build(artifact, (ProjectBuildingRequest)request);
        DependencyResolutionResult resolutionResult = buildingResult.getDependencyResolutionResult();
        if (resolutionResult != null) {
            if (ArtifactTransitivityFilter.isMaven31()) {
                try {
                    List dependencies = (List)Invoker.invoke(resolutionResult, "getDependencies");
                    for (org.eclipse.aether.graph.Dependency dependency : dependencies) {
                        org.apache.maven.artifact.Artifact mavenArtifact = (org.apache.maven.artifact.Artifact)Invoker.invoke(RepositoryUtils.class, "toArtifact", Artifact.class, dependency.getArtifact());
                        this.transitiveArtifacts.add(mavenArtifact.getDependencyConflictId());
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            try {
                List dependencies = (List)Invoker.invoke(resolutionResult, "getDependencies");
                for (Dependency dependency : dependencies) {
                    org.apache.maven.artifact.Artifact mavenArtifact = (org.apache.maven.artifact.Artifact)Invoker.invoke(RepositoryUtils.class, "toArtifact", org.sonatype.aether.artifact.Artifact.class, dependency.getArtifact());
                    this.transitiveArtifacts.add(mavenArtifact.getDependencyConflictId());
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    protected static boolean isMaven31() {
        return ArtifactTransitivityFilter.canFindCoreClass("org.eclipse.aether.artifact.Artifact");
    }

    private static boolean canFindCoreClass(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public Set<org.apache.maven.artifact.Artifact> filter(Set<org.apache.maven.artifact.Artifact> artifacts) {
        LinkedHashSet<org.apache.maven.artifact.Artifact> result = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        for (org.apache.maven.artifact.Artifact artifact : artifacts) {
            if (!this.artifactIsATransitiveDependency(artifact)) continue;
            result.add(artifact);
        }
        return result;
    }

    public boolean artifactIsATransitiveDependency(org.apache.maven.artifact.Artifact artifact) {
        return this.transitiveArtifacts.contains(artifact.getDependencyConflictId());
    }
}

