/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util.internal;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class ImmutableMap<K, V>
extends AbstractMap<K, V> {
    private final Node<K, V> first;

    public ImmutableMap(Map<K, V> map) {
        Node<K, V> first = null;
        Node<K, V> previous = null;
        for (Map.Entry<K, V> e : map.entrySet()) {
            Node<K, V> node = new Node<K, V>(e.getKey(), e.getValue());
            if (first == null) {
                first = node;
            } else {
                previous.next = node;
            }
            previous = node;
        }
        this.first = first;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Node<K, V>> entries = new LinkedHashSet<Node<K, V>>();
        Node<K, V> node = this.first;
        while (node != null) {
            entries.add(node);
            node = node.next;
        }
        return Collections.unmodifiableSet(entries);
    }

    static final class Node<K, V>
    implements Map.Entry<K, V> {
        final K key;
        final V value;
        volatile Node<K, V> next;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.getKey() != null ? this.getKey().equals(node.getKey()) : (node.getKey() == null && this.getValue() != null ? this.getValue().equals(node.getValue()) : node.getValue() == null);
        }

        @Override
        public int hashCode() {
            int result = this.getKey() != null ? this.getKey().hashCode() : 0;
            result = 31 * result + (this.getValue() != null ? this.getValue().hashCode() : 0);
            return result;
        }
    }
}

