/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.lazytestprovider;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.AbstractCommandStream;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.MasterProcessCommand;
import org.apache.maven.surefire.booter.Shutdown;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestProvidingInputStream
extends AbstractCommandStream {
    private final Semaphore barrier = new Semaphore(0);
    private final Queue<Command> commands = new ConcurrentLinkedQueue<Command>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Queue<String> testClassNames;

    public TestProvidingInputStream(Queue<String> testClassNames) {
        this.testClassNames = testClassNames;
    }

    void testSetFinished() {
        if (this.canContinue()) {
            this.commands.add(Command.TEST_SET_FINISHED);
            this.barrier.release();
        }
    }

    @Override
    public void skipSinceNextTest() {
        if (this.canContinue()) {
            this.commands.add(Command.SKIP_SINCE_NEXT_TEST);
            this.barrier.release();
        }
    }

    @Override
    public void shutdown(Shutdown shutdownType) {
        if (this.canContinue()) {
            this.commands.add(Command.toShutdown((Shutdown)shutdownType));
            this.barrier.release();
        }
    }

    @Override
    public void noop() {
        if (this.canContinue()) {
            this.commands.add(Command.NOOP);
            this.barrier.release();
        }
    }

    @Override
    protected Command nextCommand() {
        Command cmd = this.commands.poll();
        if (cmd == null) {
            String cmdData = this.testClassNames.poll();
            return cmdData == null ? Command.TEST_SET_FINISHED : Command.toRunClass((String)cmdData);
        }
        return cmd;
    }

    @Override
    protected void beforeNextCommand() throws IOException {
        this.awaitNextTest();
    }

    @Override
    protected boolean isClosed() {
        return this.closed.get();
    }

    @Override
    protected boolean canContinue() {
        return this.getLastCommand() != MasterProcessCommand.TEST_SET_FINISHED && !this.isClosed();
    }

    @Override
    public void provideNewTest() {
        if (this.canContinue()) {
            this.barrier.release();
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.invalidateInternalBuffer();
            this.barrier.drainPermits();
            this.barrier.release();
        }
    }

    private void awaitNextTest() throws IOException {
        try {
            this.barrier.acquire();
        }
        catch (InterruptedException e) {
            this.invalidateInternalBuffer();
            throw new IOException(e.getLocalizedMessage());
        }
    }
}

