/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class TempFileManager {
    private static final Map<File, TempFileManager> INSTANCES = new LinkedHashMap<File, TempFileManager>();
    private static final AtomicInteger FILE_ID = new AtomicInteger(1);
    private static final String SUFFIX_TMP = ".tmp";
    private static Thread shutdownHook;
    private final File tempDir;
    private final String baseName;
    private final List<File> tempFiles;
    private boolean deleteOnExit;

    private TempFileManager(File tempDir) {
        this.tempDir = tempDir;
        this.baseName = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS").format(LocalDateTime.now());
        this.tempFiles = new ArrayList<File>();
    }

    private static File calcTempDir(String subDirName) {
        String tempDirName = subDirName == null ? null : (subDirName.trim().isEmpty() ? null : subDirName.trim());
        File tempDirCandidate = tempDirName == null ? new File(TempFileManager.getJavaIoTmpDir()) : new File(TempFileManager.getJavaIoTmpDir(), tempDirName);
        return tempDirCandidate;
    }

    public static TempFileManager instance() {
        return TempFileManager.instance((File)null);
    }

    public static TempFileManager instance(String subDirName) {
        return TempFileManager.instance(TempFileManager.calcTempDir(subDirName));
    }

    public static synchronized TempFileManager instance(File tempDir) {
        if (shutdownHook == null) {
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            while (tg.getParent() != null) {
                tg = tg.getParent();
            }
            shutdownHook = new Thread(tg, TempFileManager::shutdownAll, TempFileManager.class.getSimpleName() + "-ShutdownHook");
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        return INSTANCES.computeIfAbsent(tempDir == null ? new File(TempFileManager.getJavaIoTmpDir()) : tempDir, TempFileManager::new);
    }

    public synchronized void deleteAll() {
        this.tempFiles.forEach(File::delete);
        this.tempFiles.clear();
        this.tempDir.delete();
    }

    static void shutdownAll() {
        INSTANCES.values().stream().filter(TempFileManager::isDeleteOnExit).forEach(TempFileManager::deleteAll);
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public synchronized File createTempFile(String prefix, String suffix) {
        File tempFile;
        prefix = prefix == null ? "" : new File(prefix).getName();
        suffix = suffix == null ? "" : suffix;
        String name = String.join((CharSequence)"-", prefix, this.baseName + "_" + FILE_ID.getAndIncrement()) + suffix;
        if (!name.equals((tempFile = new File(this.tempDir, name)).getName())) {
            throw new UncheckedIOException(new IOException("Unable to create temporary file " + tempFile));
        }
        if (tempFile.exists() || this.tempFiles.contains(tempFile)) {
            return this.createTempFile(prefix, suffix);
        }
        if (!this.tempDir.exists() && !this.tempDir.mkdirs()) {
            throw new UncheckedIOException(new IOException("Unable to create temporary directory " + this.tempDir.getAbsolutePath()));
        }
        try {
            tempFile.createNewFile();
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Unable to create temporary file " + tempFile.getAbsolutePath(), ex);
        }
        this.tempFiles.add(tempFile);
        return tempFile;
    }

    public File createTempFile(String prefix) {
        return this.createTempFile(prefix, SUFFIX_TMP);
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }

    public void setDeleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    public String toString() {
        return String.format("%s[tempDir=%s, deleteOnExit=%s, baseName=%s, tempFiles=%d]", this.getClass().getSimpleName(), this.tempDir, this.deleteOnExit, this.baseName, this.tempFiles.size());
    }

    public static String getJavaIoTmpDir() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (!tmpDir.endsWith(File.separator)) {
            tmpDir = tmpDir + File.separatorChar;
        }
        return tmpDir;
    }
}

