/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;

public class PomPropertiesUtil {
    private Properties loadPropertiesFile(File file) throws IOException {
        Properties fileProps = new Properties();
        try (InputStream istream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            fileProps.load(istream);
            Properties properties = fileProps;
            return properties;
        }
    }

    private boolean sameContents(Properties props, File file) throws IOException {
        if (!file.isFile()) {
            return false;
        }
        Properties fileProps = this.loadPropertiesFile(file);
        return fileProps.equals(props);
    }

    private void createPropertiesFile(Properties properties, File outputFile, boolean forceCreation) throws IOException {
        File outputDir = outputFile.getParentFile();
        if (outputDir != null && !outputDir.isDirectory() && !outputDir.mkdirs()) {
            throw new IOException("Failed to create directory: " + outputDir);
        }
        if (!forceCreation && this.sameContents(properties, outputFile)) {
            return;
        }
        try (PrintWriter pw = new PrintWriter(outputFile, "ISO-8859-1");
             StringWriter sw = new StringWriter();){
            properties.store(sw, null);
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader r = new BufferedReader(new StringReader(sw.toString()));){
                String line;
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    lines.add(line);
                }
            }
            Collections.sort(lines);
            for (String l : lines) {
                pw.println(l);
            }
        }
    }

    public void createPomProperties(MavenSession session, MavenProject project, Archiver archiver, File customPomPropertiesFile, File pomPropertiesFile, boolean forceCreation) throws IOException {
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        String version = project.getVersion();
        Properties p = customPomPropertiesFile != null ? this.loadPropertiesFile(customPomPropertiesFile) : new Properties();
        p.setProperty("groupId", groupId);
        p.setProperty("artifactId", artifactId);
        p.setProperty("version", version);
        this.createPropertiesFile(p, pomPropertiesFile, forceCreation);
        archiver.addFile(pomPropertiesFile, "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
    }
}

