/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.maven.plugin.surefire.booterclient.output.DeserializedStacktraceWriter;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedChannelDecoderErrorHandler;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessExitErrorListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessPropertyEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessReportEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessStackTraceEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessStandardOutErrEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessStringEventListener;
import org.apache.maven.surefire.booter.ForkedProcessEvent;
import org.apache.maven.surefire.report.CategorizedReportEntry;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunMode;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.util.internal.StringUtils;

public final class ForkedChannelDecoder {
    private static final Base64 BASE64 = new Base64();
    private volatile ForkedProcessPropertyEventListener propertyEventListener;
    private volatile ForkedProcessStackTraceEventListener consoleErrorEventListener;
    private volatile ForkedProcessExitErrorListener exitErrorEventListener;
    private final ConcurrentMap<ForkedProcessEvent, ForkedProcessReportEventListener<?>> reportEventListeners = new ConcurrentHashMap();
    private final ConcurrentMap<ForkedProcessEvent, ForkedProcessStandardOutErrEventListener> stdOutErrEventListeners = new ConcurrentHashMap<ForkedProcessEvent, ForkedProcessStandardOutErrEventListener>();
    private final ConcurrentMap<ForkedProcessEvent, ForkedProcessStringEventListener> consoleEventListeners = new ConcurrentHashMap<ForkedProcessEvent, ForkedProcessStringEventListener>();
    private final ConcurrentMap<ForkedProcessEvent, ForkedProcessEventListener> controlEventListeners = new ConcurrentHashMap<ForkedProcessEvent, ForkedProcessEventListener>();

    public void setSystemPropertiesListener(ForkedProcessPropertyEventListener listener) {
        this.propertyEventListener = Objects.requireNonNull(listener);
    }

    public <T extends ReportEntry> void setTestSetStartingListener(ForkedProcessReportEventListener<T> listener) {
        this.reportEventListeners.put(ForkedProcessEvent.BOOTERCODE_TESTSET_STARTING, Objects.requireNonNull(listener));
    }

    public void setTestSetCompletedListener(ForkedProcessReportEventListener<?> listener) {
        this.reportEventListeners.put(ForkedProcessEvent.BOOTERCODE_TESTSET_COMPLETED, Objects.requireNonNull(listener));
    }

    public void setTestStartingListener(ForkedProcessReportEventListener<?> listener) {
        this.reportEventListeners.put(ForkedProcessEvent.BOOTERCODE_TEST_STARTING, Objects.requireNonNull(listener));
    }

    public void setTestSucceededListener(ForkedProcessReportEventListener<?> listener) {
        this.reportEventListeners.put(ForkedProcessEvent.BOOTERCODE_TEST_SUCCEEDED, Objects.requireNonNull(listener));
    }

    public void setTestFailedListener(ForkedProcessReportEventListener<?> listener) {
        this.reportEventListeners.put(ForkedProcessEvent.BOOTERCODE_TEST_FAILED, Objects.requireNonNull(listener));
    }

    public void setTestSkippedListener(ForkedProcessReportEventListener<?> listener) {
        this.reportEventListeners.put(ForkedProcessEvent.BOOTERCODE_TEST_SKIPPED, Objects.requireNonNull(listener));
    }

    public void setTestErrorListener(ForkedProcessReportEventListener<?> listener) {
        this.reportEventListeners.put(ForkedProcessEvent.BOOTERCODE_TEST_ERROR, Objects.requireNonNull(listener));
    }

    public void setTestAssumptionFailureListener(ForkedProcessReportEventListener<?> listener) {
        this.reportEventListeners.put(ForkedProcessEvent.BOOTERCODE_TEST_ASSUMPTIONFAILURE, Objects.requireNonNull(listener));
    }

    public void setStdOutListener(ForkedProcessStandardOutErrEventListener listener) {
        this.stdOutErrEventListeners.put(ForkedProcessEvent.BOOTERCODE_STDOUT, Objects.requireNonNull(listener));
        this.stdOutErrEventListeners.put(ForkedProcessEvent.BOOTERCODE_STDOUT_NEW_LINE, Objects.requireNonNull(listener));
    }

    public void setStdErrListener(ForkedProcessStandardOutErrEventListener listener) {
        this.stdOutErrEventListeners.put(ForkedProcessEvent.BOOTERCODE_STDERR, Objects.requireNonNull(listener));
        this.stdOutErrEventListeners.put(ForkedProcessEvent.BOOTERCODE_STDERR_NEW_LINE, Objects.requireNonNull(listener));
    }

    public void setConsoleInfoListener(ForkedProcessStringEventListener listener) {
        this.consoleEventListeners.put(ForkedProcessEvent.BOOTERCODE_CONSOLE_INFO, Objects.requireNonNull(listener));
    }

    public void setConsoleErrorListener(ForkedProcessStackTraceEventListener listener) {
        this.consoleErrorEventListener = Objects.requireNonNull(listener);
    }

    public void setConsoleDebugListener(ForkedProcessStringEventListener listener) {
        this.consoleEventListeners.put(ForkedProcessEvent.BOOTERCODE_CONSOLE_DEBUG, Objects.requireNonNull(listener));
    }

    public void setConsoleWarningListener(ForkedProcessStringEventListener listener) {
        this.consoleEventListeners.put(ForkedProcessEvent.BOOTERCODE_CONSOLE_WARNING, Objects.requireNonNull(listener));
    }

    public void setByeListener(ForkedProcessEventListener listener) {
        this.controlEventListeners.put(ForkedProcessEvent.BOOTERCODE_BYE, Objects.requireNonNull(listener));
    }

    public void setStopOnNextTestListener(ForkedProcessEventListener listener) {
        this.controlEventListeners.put(ForkedProcessEvent.BOOTERCODE_STOP_ON_NEXT_TEST, Objects.requireNonNull(listener));
    }

    public void setAcquireNextTestListener(ForkedProcessEventListener listener) {
        this.controlEventListeners.put(ForkedProcessEvent.BOOTERCODE_NEXT_TEST, Objects.requireNonNull(listener));
    }

    public void setExitErrorEventListener(ForkedProcessExitErrorListener listener) {
        this.exitErrorEventListener = Objects.requireNonNull(listener);
    }

    public void handleEvent(String line, ForkedChannelDecoderErrorHandler errorHandler) {
        ForkedProcessEvent event;
        if (line == null || !line.startsWith(":maven:surefire:std:out:")) {
            errorHandler.handledError(line, null);
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(line.substring(":maven:surefire:std:out:".length()), ":");
        String opcode = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
        ForkedProcessEvent forkedProcessEvent = event = opcode == null ? null : (ForkedProcessEvent)ForkedProcessEvent.EVENTS.get(opcode);
        if (event == null) {
            errorHandler.handledError(line, null);
            return;
        }
        try {
            if (event.isControlCategory()) {
                ForkedProcessEventListener listener = (ForkedProcessEventListener)this.controlEventListeners.get(event);
                if (listener != null) {
                    listener.handle();
                }
            } else if (event.isConsoleCategory()) {
                Charset encoding;
                ForkedProcessStringEventListener listener = (ForkedProcessStringEventListener)this.consoleEventListeners.get(event);
                Charset charset = encoding = tokenizer.hasMoreTokens() ? Charset.forName(tokenizer.nextToken()) : null;
                if (listener != null && encoding != null) {
                    String msg = tokenizer.hasMoreTokens() ? ForkedChannelDecoder.decode(tokenizer.nextToken(), encoding) : "";
                    listener.handle(msg);
                }
            } else if (event.isConsoleErrorCategory()) {
                Charset encoding;
                Charset charset = encoding = tokenizer.hasMoreTokens() ? Charset.forName(tokenizer.nextToken()) : null;
                if (this.consoleErrorEventListener != null && encoding != null) {
                    String msg = tokenizer.hasMoreTokens() ? ForkedChannelDecoder.decode(tokenizer.nextToken(), encoding) : null;
                    String smartStackTrace = tokenizer.hasMoreTokens() ? ForkedChannelDecoder.decode(tokenizer.nextToken(), encoding) : null;
                    String stackTrace = tokenizer.hasMoreTokens() ? ForkedChannelDecoder.decode(tokenizer.nextToken(), encoding) : null;
                    this.consoleErrorEventListener.handle(msg, smartStackTrace, stackTrace);
                }
            } else if (event.isStandardStreamCategory()) {
                Charset encoding;
                ForkedProcessStandardOutErrEventListener listener = (ForkedProcessStandardOutErrEventListener)this.stdOutErrEventListeners.get(event);
                RunMode mode = tokenizer.hasMoreTokens() ? (RunMode)RunMode.MODES.get(tokenizer.nextToken()) : null;
                Charset charset = encoding = tokenizer.hasMoreTokens() ? Charset.forName(tokenizer.nextToken()) : null;
                if (listener != null && encoding != null && mode != null) {
                    boolean newLine = event == ForkedProcessEvent.BOOTERCODE_STDOUT_NEW_LINE || event == ForkedProcessEvent.BOOTERCODE_STDERR_NEW_LINE;
                    String output = tokenizer.hasMoreTokens() ? ForkedChannelDecoder.decode(tokenizer.nextToken(), encoding) : "";
                    listener.handle(mode, output, newLine);
                }
            } else if (event.isSysPropCategory()) {
                String key;
                RunMode mode = tokenizer.hasMoreTokens() ? (RunMode)RunMode.MODES.get(tokenizer.nextToken()) : null;
                Charset encoding = tokenizer.hasMoreTokens() ? Charset.forName(tokenizer.nextToken()) : null;
                String string = key = tokenizer.hasMoreTokens() ? ForkedChannelDecoder.decode(tokenizer.nextToken(), encoding) : "";
                if (this.propertyEventListener != null && StringUtils.isNotBlank((String)key)) {
                    String value = tokenizer.hasMoreTokens() ? ForkedChannelDecoder.decode(tokenizer.nextToken(), encoding) : "";
                    this.propertyEventListener.handle(mode, key, value);
                }
            } else if (event.isTestCategory()) {
                Charset encoding;
                ForkedProcessReportEventListener listener = (ForkedProcessReportEventListener)this.reportEventListeners.get(event);
                RunMode mode = tokenizer.hasMoreTokens() ? (RunMode)RunMode.MODES.get(tokenizer.nextToken()) : null;
                Charset charset = encoding = tokenizer.hasMoreTokens() ? Charset.forName(tokenizer.nextToken()) : null;
                if (listener != null && encoding != null && mode != null) {
                    String sourceName = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                    String sourceText = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                    String name = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                    String nameText = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                    String group = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                    String message = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                    String elapsed = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                    String traceMessage = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                    String smartTrimmedStackTrace = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                    String stackTrace = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                    ReportEntry reportEntry = ForkedChannelDecoder.toReportEntry(encoding, sourceName, sourceText, name, nameText, group, message, elapsed, traceMessage, smartTrimmedStackTrace, stackTrace);
                    listener.handle(mode, reportEntry);
                }
            } else if (event.isJvmExitError() && this.exitErrorEventListener != null) {
                Charset encoding = tokenizer.hasMoreTokens() ? Charset.forName(tokenizer.nextToken()) : null;
                String message = tokenizer.hasMoreTokens() ? ForkedChannelDecoder.decode(tokenizer.nextToken(), encoding) : "";
                String smartTrimmedStackTrace = tokenizer.hasMoreTokens() ? ForkedChannelDecoder.decode(tokenizer.nextToken(), encoding) : "";
                String stackTrace = tokenizer.hasMoreTokens() ? ForkedChannelDecoder.decode(tokenizer.nextToken(), encoding) : "";
                this.exitErrorEventListener.handle(message, smartTrimmedStackTrace, stackTrace);
            }
        }
        catch (IllegalArgumentException e) {
            errorHandler.handledError(line, e);
        }
    }

    static ReportEntry toReportEntry(Charset encoding, String encSource, String encSourceText, String encName, String encNameText, String encGroup, String encMessage, String encTimeElapsed, String encTraceMessage, String encSmartTrimmedStackTrace, String encStackTrace) throws NumberFormatException {
        if (encoding == null) {
            return null;
        }
        String source = ForkedChannelDecoder.decode(encSource, encoding);
        String sourceText = ForkedChannelDecoder.decode(encSourceText, encoding);
        String name = ForkedChannelDecoder.decode(encName, encoding);
        String nameText = ForkedChannelDecoder.decode(encNameText, encoding);
        String group = ForkedChannelDecoder.decode(encGroup, encoding);
        StackTraceWriter stackTraceWriter = ForkedChannelDecoder.decodeTrace(encoding, encTraceMessage, encSmartTrimmedStackTrace, encStackTrace);
        Integer elapsed = ForkedChannelDecoder.decodeToInteger(encTimeElapsed);
        String message = ForkedChannelDecoder.decode(encMessage, encoding);
        return CategorizedReportEntry.reportEntry((String)source, (String)sourceText, (String)name, (String)nameText, (String)group, (StackTraceWriter)stackTraceWriter, (Integer)elapsed, (String)message, Collections.emptyMap());
    }

    static String decode(String line, Charset encoding) {
        return line == null || "-".equals(line) ? null : new String(BASE64.decode(line.getBytes(StandardCharsets.US_ASCII)), encoding);
    }

    static Integer decodeToInteger(String line) {
        return line == null || "-".equals(line) ? null : Integer.decode(line);
    }

    private static StackTraceWriter decodeTrace(Charset encoding, String encTraceMessage, String encSmartTrimmedStackTrace, String encStackTrace) {
        if (StringUtils.isBlank((String)encStackTrace) || "-".equals(encStackTrace)) {
            return null;
        }
        String traceMessage = ForkedChannelDecoder.decode(encTraceMessage, encoding);
        String stackTrace = ForkedChannelDecoder.decode(encStackTrace, encoding);
        String smartTrimmedStackTrace = ForkedChannelDecoder.decode(encSmartTrimmedStackTrace, encoding);
        return new DeserializedStacktraceWriter(traceMessage, smartTrimmedStackTrace, stackTrace);
    }
}

