/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.FormatedTextParser;
import org.apache.maven.doxia.module.twiki.parser.GenericListBlockParser;
import org.apache.maven.doxia.module.twiki.parser.ListBlock;
import org.apache.maven.doxia.module.twiki.parser.ListItemBlock;

class TreeListBuilder {
    private final FormatedTextParser textParser;
    private final TreeComponent root;
    private TreeComponent current;

    TreeListBuilder(FormatedTextParser formatTextParser) throws IllegalArgumentException {
        if (formatTextParser == null) {
            throw new IllegalArgumentException("argument is null");
        }
        this.textParser = formatTextParser;
        this.current = this.root = new TreeComponent(null, "root", null);
    }

    void feedEntry(GenericListBlockParser.Type type, int level, String text) {
        int incomingLevel = level - 1;
        int currentDepth = this.current.getDepth();
        if (incomingLevel != currentDepth) {
            if (incomingLevel > currentDepth) {
                TreeComponent[] components = this.current.getChildren();
                if (components.length == 0) {
                    int n = incomingLevel - currentDepth;
                    for (int i = 0; i < n; ++i) {
                        this.current = this.current.addChildren("", type);
                    }
                } else {
                    this.current = components[components.length - 1];
                }
            } else {
                int n = currentDepth - incomingLevel;
                for (int i = 0; i < n; ++i) {
                    this.current = this.current.getFather();
                    if (this.current != null) continue;
                    throw new IllegalStateException();
                }
            }
        }
        this.current.addChildren(text, type);
    }

    ListBlock getBlock() {
        return this.getList(this.root);
    }

    private ListBlock getList(TreeComponent tc) {
        ListItemBlock[] li = this.getListItems(tc).toArray(new ListItemBlock[0]);
        return tc.getChildren()[0].getType().createList(li);
    }

    private List<ListItemBlock> getListItems(TreeComponent tc) {
        ArrayList<ListItemBlock> blocks = new ArrayList<ListItemBlock>();
        for (int i = 0; i < tc.getChildren().length; ++i) {
            TreeComponent child = tc.getChildren()[i];
            Block[] text = new Block[]{};
            if (child.getFather() != null) {
                text = this.textParser.parse(child.getText());
            }
            if (child.getChildren().length != 0) {
                blocks.add(new ListItemBlock(text, this.getList(child)));
                continue;
            }
            blocks.add(new ListItemBlock(text));
        }
        return blocks;
    }

    static class TreeComponent {
        private List<TreeComponent> children = new ArrayList<TreeComponent>();
        private String text;
        private TreeComponent father;
        private GenericListBlockParser.Type type;

        TreeComponent(TreeComponent father, String text, GenericListBlockParser.Type type) {
            this.text = text;
            this.father = father;
            this.type = type;
        }

        TreeComponent[] getChildren() {
            return this.children.toArray(new TreeComponent[0]);
        }

        TreeComponent addChildren(String t, GenericListBlockParser.Type ttype) {
            if (t == null || ttype == null) {
                throw new IllegalArgumentException("argument is null");
            }
            TreeComponent ret = new TreeComponent(this, t, ttype);
            this.children.add(ret);
            return ret;
        }

        TreeComponent getFather() {
            return this.father;
        }

        int getDepth() {
            int ret = 0;
            TreeComponent c = this;
            while ((c = c.getFather()) != null) {
                ++ret;
            }
            return ret;
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String indent) {
            StringBuilder sb = new StringBuilder();
            if (this.father != null) {
                sb.append(indent);
                sb.append("- ");
                sb.append(this.text);
                sb.append(GenericListBlockParser.EOL);
            }
            for (TreeComponent lc : this.children) {
                sb.append(lc.toString(indent + "   "));
            }
            return sb.toString();
        }

        String getText() {
            return this.text;
        }

        GenericListBlockParser.Type getType() {
            return this.type;
        }
    }
}

