/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.scanner;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.StringUtils;

public class DefaultMojoScanner
extends AbstractLogEnabled
implements MojoScanner {
    private Map<String, MojoDescriptorExtractor> mojoDescriptorExtractors;
    private Set<String> activeExtractors;

    public DefaultMojoScanner(Map<String, MojoDescriptorExtractor> extractors) {
        this.mojoDescriptorExtractors = extractors;
        this.enableLogging((Logger)new ConsoleLogger(1, "standalone-scanner-logger"));
    }

    public DefaultMojoScanner() {
    }

    @Override
    public void populatePluginDescriptor(PluginToolsRequest request) throws ExtractionException, InvalidPluginDescriptorException {
        Logger logger = this.getLogger();
        Set<String> activeExtractorsInternal = this.getActiveExtractors();
        logger.debug("Using " + activeExtractorsInternal.size() + " mojo extractors.");
        int numMojoDescriptors = 0;
        for (String extractorId : activeExtractorsInternal) {
            MojoDescriptorExtractor extractor = this.mojoDescriptorExtractors.get(extractorId);
            if (extractor == null) {
                throw new ExtractionException("No mojo extractor with '" + extractorId + "' id.");
            }
            logger.debug("Applying " + extractorId + " mojo extractor");
            List<MojoDescriptor> extractorDescriptors = extractor.execute(request);
            logger.info(extractorId + " mojo extractor found " + extractorDescriptors.size() + " mojo descriptor" + (extractorDescriptors.size() > 1 ? "s" : "") + ".");
            numMojoDescriptors += extractorDescriptors.size();
            for (MojoDescriptor descriptor : extractorDescriptors) {
                logger.debug("Adding mojo: " + descriptor + " to plugin descriptor.");
                descriptor.setPluginDescriptor(request.getPluginDescriptor());
                request.getPluginDescriptor().addMojo(descriptor);
            }
        }
        if (numMojoDescriptors == 0 && !request.isSkipErrorNoDescriptorsFound()) {
            throw new InvalidPluginDescriptorException("No mojo definitions were found for plugin: " + request.getPluginDescriptor().getPluginLookupKey() + ".");
        }
    }

    protected Set<String> getActiveExtractors() {
        Set<String> result = this.activeExtractors;
        if (result == null) {
            result = new HashSet<String>(this.mojoDescriptorExtractors.keySet());
        }
        return result;
    }

    @Override
    public void setActiveExtractors(Set<String> extractors) {
        if (extractors == null) {
            this.activeExtractors = null;
        } else {
            this.activeExtractors = new HashSet<String>();
            for (String extractor : extractors) {
                if (!StringUtils.isNotEmpty((String)extractor)) continue;
                this.activeExtractors.add(extractor);
            }
        }
    }
}

