/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportSet
implements Serializable,
Cloneable,
InputLocationTracker {
    private String id = "default";
    private Object configuration;
    private String inherited;
    private List<String> reports;
    private Map<Object, InputLocation> locations;
    private boolean inheritanceApplied = true;

    public void addReport(String string) {
        this.getReports().add(string);
    }

    public ReportSet clone() {
        try {
            ReportSet copy = (ReportSet)super.clone();
            if (this.configuration != null) {
                copy.configuration = new Xpp3Dom((Xpp3Dom)this.configuration);
            }
            if (this.reports != null) {
                copy.reports = new ArrayList<String>();
                copy.reports.addAll(this.reports);
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public Object getConfiguration() {
        return this.configuration;
    }

    public String getId() {
        return this.id;
    }

    public String getInherited() {
        return this.inherited;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public List<String> getReports() {
        if (this.reports == null) {
            this.reports = new ArrayList<String>();
        }
        return this.reports;
    }

    public void removeReport(String string) {
        this.getReports().remove(string);
    }

    public void setConfiguration(Object configuration) {
        this.configuration = configuration;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setInherited(String inherited) {
        this.inherited = inherited;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    public void setReports(List<String> reports) {
        this.reports = reports;
    }

    public void unsetInheritanceApplied() {
        this.inheritanceApplied = false;
    }

    public boolean isInheritanceApplied() {
        return this.inheritanceApplied;
    }

    public String toString() {
        return this.getId();
    }
}

