/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.CRC32;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipEntry;
import org.codehaus.plexus.archiver.zip.ZipFile;
import org.codehaus.plexus.archiver.zip.ZipOutputStream;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractZipArchiver
extends AbstractArchiver {
    private String comment;
    private String encoding;
    private boolean doCompress = true;
    private boolean doUpdate = false;
    private boolean savedDoUpdate = false;
    protected String archiveType = "zip";
    private boolean doFilesonly = false;
    protected Hashtable entries = new Hashtable();
    protected String duplicate = "add";
    protected Hashtable addedDirs = new Hashtable();
    private Vector addedFiles = new Vector();
    private static final long EMPTY_CRC = new CRC32().getValue();
    protected boolean doubleFilePass = false;
    protected boolean skipWriting = false;
    protected boolean addingNewFiles = false;
    private boolean roundUp = true;
    private File renamedFile = null;
    private File zipFile;
    private boolean success;
    private ZipOutputStream zOut;

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setCompress(boolean compress) {
        this.doCompress = compress;
    }

    public boolean isCompress() {
        return this.doCompress;
    }

    public void setUpdateMode(boolean update) {
        this.savedDoUpdate = this.doUpdate = update;
    }

    public boolean isInUpdateMode() {
        return this.doUpdate;
    }

    public void setFileMode(String octalString) {
        this.setDefaultFileMode(Integer.parseInt(octalString, 8));
    }

    public int getFileMode() {
        return this.getDefaultFileMode();
    }

    public void setDirMode(String octalString) {
        this.setDefaultDirectoryMode(Integer.parseInt(octalString, 8));
    }

    public int getDirMode() {
        return this.getDefaultDirectoryMode();
    }

    public void setFilesonly(boolean f) {
        this.doFilesonly = f;
    }

    public boolean isFilesonly() {
        return this.doFilesonly;
    }

    public void setRoundUp(boolean r) {
        this.roundUp = r;
    }

    public boolean isRoundUp() {
        return this.roundUp;
    }

    protected void execute() throws ArchiverException, IOException {
        if (!this.checkForced()) {
            return;
        }
        if (this.doubleFilePass) {
            this.skipWriting = true;
            this.createArchiveMain();
            this.skipWriting = false;
            this.createArchiveMain();
        } else {
            this.createArchiveMain();
        }
        this.finalizeZipOutputStream(this.zOut);
    }

    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, ArchiverException {
    }

    private void createArchiveMain() throws ArchiverException, IOException {
        Map archiveEntries = this.getFiles();
        if (!(archiveEntries != null && archiveEntries.size() != 0 || this.hasVirtualFiles())) {
            throw new ArchiverException("You must set at least one file.");
        }
        this.zipFile = this.getDestFile();
        if (this.zipFile == null) {
            throw new ArchiverException("You must set the destination " + this.archiveType + "file.");
        }
        if (this.zipFile.exists() && !this.zipFile.isFile()) {
            throw new ArchiverException(this.zipFile + " isn't a file.");
        }
        if (this.zipFile.exists() && !this.zipFile.canWrite()) {
            throw new ArchiverException(this.zipFile + " is read-only.");
        }
        this.addingNewFiles = true;
        if (this.doUpdate && !this.zipFile.exists()) {
            this.doUpdate = false;
            this.getLogger().debug("ignoring update attribute as " + this.archiveType + " doesn't exist.");
        }
        this.success = false;
        if (this.doUpdate) {
            this.renamedFile = FileUtils.createTempFile((String)"zip", (String)".tmp", (File)this.zipFile.getParentFile());
            this.renamedFile.deleteOnExit();
            try {
                FileUtils.rename((File)this.zipFile, (File)this.renamedFile);
            }
            catch (SecurityException e) {
                this.getLogger().debug(e.toString());
                throw new ArchiverException("Not allowed to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file", e);
            }
            catch (IOException e) {
                this.getLogger().debug(e.toString());
                throw new ArchiverException("Unable to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file", e);
            }
        }
        String action = this.doUpdate ? "Updating " : "Building ";
        this.getLogger().info(action + this.archiveType + ": " + this.zipFile.getAbsolutePath());
        if (!this.skipWriting) {
            this.zOut = new ZipOutputStream(this.zipFile);
            this.zOut.setEncoding(this.encoding);
            if (this.doCompress) {
                this.zOut.setMethod(8);
            } else {
                this.zOut.setMethod(0);
            }
        }
        this.initZipOutputStream(this.zOut);
        this.addResources(this.getResourcesToAdd(this.zipFile), this.zOut);
        if (this.doUpdate) {
            this.addResources(this.getResourcesToUpdate(this.zipFile), this.zOut);
        }
        if (this.doUpdate && !this.renamedFile.delete()) {
            this.getLogger().warn("Warning: unable to delete temporary file " + this.renamedFile.getName());
        }
        this.success = true;
    }

    protected Map getResourcesToAdd(File file) throws IOException {
        if (!file.exists() || !this.doUpdate) {
            return this.getFiles();
        }
        ZipFile zipFile = new ZipFile(file);
        HashMap result = new HashMap();
        Iterator iter = this.getFiles().keySet().iterator();
        while (iter.hasNext()) {
            String fileName = (String)iter.next();
            if (zipFile.getEntry(fileName) != null) continue;
            result.put(fileName, this.getFiles().get(fileName));
        }
        return result;
    }

    protected Map getResourcesToUpdate(File file) throws IOException {
        HashMap result = new HashMap();
        if (file.exists() && this.doUpdate) {
            ZipFile zipFile = new ZipFile(file);
            Iterator iter = this.getFiles().keySet().iterator();
            while (iter.hasNext()) {
                String fileName = (String)iter.next();
                ZipEntry zipEntry = zipFile.getEntry(fileName);
                if (zipEntry == null) continue;
                ArchiveEntry currentEntry = (ArchiveEntry)this.getFiles().get(fileName);
                if (zipEntry.getTime() >= currentEntry.getFile().lastModified()) continue;
                result.put(fileName, this.getFiles().get(fileName));
            }
        }
        return result;
    }

    protected final void addResources(Map resources, ZipOutputStream zOut) throws IOException, ArchiverException {
        File base = null;
        Iterator iter = resources.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ArchiveEntry entry = (ArchiveEntry)resources.get(name);
            if ("".equals(name = name.replace(File.separatorChar, '/'))) continue;
            if (entry.getFile().isDirectory() && !name.endsWith("/")) {
                name = name + "/";
            }
            this.addParentDirs(base, name, zOut, "");
            if (entry.getFile().isFile()) {
                this.zipFile(entry, zOut, name);
                continue;
            }
            this.zipDir(entry.getFile(), zOut, name, entry.getMode());
        }
    }

    protected final void addParentDirs(File baseDir, String entry, ZipOutputStream zOut, String prefix) throws IOException {
        if (!this.doFilesonly && this.getIncludeEmptyDirs()) {
            String dir;
            Stack<String> directories = new Stack<String>();
            int slashPos = entry.length() - (entry.endsWith("/") ? 1 : 0);
            while ((slashPos = entry.lastIndexOf(47, slashPos - 1)) != -1) {
                dir = entry.substring(0, slashPos + 1);
                if (this.addedDirs.contains(prefix + dir)) break;
                directories.push(dir);
            }
            while (!directories.isEmpty()) {
                dir = (String)directories.pop();
                File f = baseDir != null ? new File(baseDir, dir) : new File(dir);
                this.zipDir(f, zOut, prefix + dir, this.getDefaultDirectoryMode());
            }
        }
    }

    protected void zipFile(InputStream in, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException, ArchiverException {
        if (this.entries.contains(vPath)) {
            if (this.duplicate.equals("preserve")) {
                this.getLogger().info(vPath + " already added, skipping");
                return;
            }
            if (this.duplicate.equals("fail")) {
                throw new ArchiverException("Duplicate file " + vPath + " was found and the duplicate " + "attribute is 'fail'.");
            }
            this.getLogger().debug("duplicate file " + vPath + " found, adding.");
        } else {
            this.getLogger().debug("adding entry " + vPath);
        }
        this.entries.put(vPath, vPath);
        if (!this.skipWriting) {
            ZipEntry ze = new ZipEntry(vPath);
            ze.setTime(lastModified);
            ze.setMethod(this.doCompress ? 8 : 0);
            if (!zOut.isSeekable() && !this.doCompress) {
                long size = 0L;
                CRC32 cal = new CRC32();
                if (!in.markSupported()) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    int count = 0;
                    do {
                        size += (long)count;
                        cal.update(buffer, 0, count);
                        bos.write(buffer, 0, count);
                    } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                    in = new ByteArrayInputStream(bos.toByteArray());
                } else {
                    in.mark(Integer.MAX_VALUE);
                    byte[] buffer = new byte[8192];
                    int count = 0;
                    do {
                        size += (long)count;
                        cal.update(buffer, 0, count);
                    } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                    in.reset();
                }
                ze.setSize(size);
                ze.setCrc(cal.getValue());
            }
            ze.setUnixMode(0x8000 | mode);
            zOut.putNextEntry(ze);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                if (count == 0) continue;
                zOut.write(buffer, 0, count);
            } while ((count = in.read(buffer, 0, buffer.length)) != -1);
        }
        this.addedFiles.addElement(vPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipFile(ArchiveEntry entry, ZipOutputStream zOut, String vPath) throws IOException, ArchiverException {
        if (entry.equals(this.getDestFile())) {
            throw new ArchiverException("A zip file cannot include itself");
        }
        FileInputStream fIn = new FileInputStream(entry.getFile());
        try {
            this.zipFile(fIn, zOut, vPath, entry.getFile().lastModified() + (long)(this.roundUp ? 1999 : 0), null, entry.getMode());
        }
        finally {
            fIn.close();
        }
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath, int mode) throws IOException {
        if (this.addedDirs.get(vPath) != null) {
            return;
        }
        this.getLogger().debug("adding directory " + vPath);
        this.addedDirs.put(vPath, vPath);
        if (!this.skipWriting) {
            ZipEntry ze = new ZipEntry(vPath);
            if (dir != null && dir.exists()) {
                ze.setTime(dir.lastModified() + (long)(this.roundUp ? 1999 : 0));
            } else {
                ze.setTime(System.currentTimeMillis() + (long)(this.roundUp ? 1999 : 0));
            }
            ze.setSize(0L);
            ze.setMethod(0);
            ze.setCrc(EMPTY_CRC);
            ze.setUnixMode(mode);
            zOut.putNextEntry(ze);
        }
    }

    protected boolean createEmptyZip(File zipFile) throws ArchiverException {
        this.getLogger().info("Note: creating empty " + this.archiveType + " archive " + zipFile);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(zipFile);
            byte[] empty = new byte[22];
            empty[0] = 80;
            empty[1] = 75;
            empty[2] = 5;
            empty[3] = 6;
            ((OutputStream)os).write(empty);
        }
        catch (IOException ioe) {
            throw new ArchiverException("Could not create empty ZIP archive (" + ioe.getMessage() + ")", ioe);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {}
            }
        }
        return true;
    }

    protected void cleanUp() {
        this.addedDirs.clear();
        this.addedFiles.removeAllElements();
        this.entries.clear();
        this.addingNewFiles = false;
        this.doUpdate = this.savedDoUpdate;
        this.success = false;
        this.zOut = null;
        this.renamedFile = null;
        this.zipFile = null;
    }

    public void reset() {
        this.setDestFile(null);
        this.duplicate = "add";
        this.archiveType = "zip";
        this.doCompress = true;
        this.doUpdate = false;
        this.doFilesonly = false;
        this.encoding = null;
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, ArchiverException {
    }

    public boolean isSupportingForced() {
        return true;
    }

    protected boolean revert(StringBuffer messageBuffer) {
        int initLength = messageBuffer.length();
        if (!(this.doUpdate && this.renamedFile == null || this.zipFile.delete())) {
            messageBuffer.append(" (and the archive is probably corrupt but I could not delete it)");
        }
        if (this.doUpdate && this.renamedFile != null) {
            try {
                FileUtils.rename((File)this.renamedFile, (File)this.zipFile);
            }
            catch (IOException e) {
                messageBuffer.append(" (and I couldn't rename the temporary file ");
                messageBuffer.append(this.renamedFile.getName());
                messageBuffer.append(" back)");
            }
        }
        return messageBuffer.length() == initLength;
    }

    protected void close() throws IOException {
        block3: {
            try {
                if (this.zOut != null) {
                    this.zOut.close();
                }
            }
            catch (IOException ex) {
                if (!this.success) break block3;
                throw ex;
            }
        }
    }

    protected String getArchiveType() {
        return this.archiveType;
    }
}

