; generate FSK modulated sinewave on the left channel

	nolist
	include 'leonid'
	list


buflen	equ	32
f	equ	2000
fs	equ	16000

; two integrator sinewave generator
sg	macro	store
	move		    x:store,a
	move		    x:store+1,b

	move	 b,y0
	mac	x0,y0,a
	move	 a,y0
	mac    -x0,y0,b

	move		    a,x:store
	move		    b,x:store+1
	endm


	org	p:user_code

	move		    #buffer+2,r7
	move		    #buflen*4-1,m7

	move		    #buffer,r2
	move		    #4,n2
	move		    #buflen*4-1,m2

	ctrlcd	1,r2,buflen,LINEI,0.0,0.0,LINEO|HEADP,0.0,0.0
	move		    (r2)+
	opencd	fs/1000

; wait for one sample
loop	waitblk r2,buflen,1

; then generate the sinewave
	move		    #6.2832*500.0/fs,x0
	sg	sg1
	move		    #6.2832*f/fs,x0
	add	x0,b
	move	b,x0
	sg	sg2

; and output the generated sample
	move		    b,y:(r2)+n2


	jmp	<loop


	org	x:user_data

sg1	dc	0.04,0.04
sg2	dc	0.2,0.2

buffer	dsm	buflen*4


	org	y:user_data

	dsm	buflen*4


	end
