#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "purgdate.h"
#include "purgwwv.h"

/* This program is intended to purge SYSTEM\BIN\WWV.BIN */

/* PURGEWWV [p=WwvPath] [d=#n_days] [v]

   where : - [p=WwvPath] specifies the directory in where wwv.bin file
	     is located.
	     The default directory is ..\SYSTEM\BIN.

	   - [d=#n_days] sets the number of day (#n_days) after which a
	     wwv spot will be deleted.
	     By default, this value is set to 30.

	   - [v] gets the version number.

   Example : PURGWWV p=C:\DXNET\SYSTEM\BIN d=7
	or : PURGWWV d=15

*/

/*---------------------------------------------------------------------------
  ------ main function ------------------------------------------------------
  -------------------------------------------------------------------------*/
int main(int Argc, char * Argv[])
{
	int	index;
	int	nSpotNum    = 0;
	int	nDelSpotNum = 0;
	int     nDelDays   = 30;
	char	szBinPath[1024];
	char	szBin[256];
	char	szOld[256];
	FILE *	fBinFile;
	FILE *	fOldFile;
	struct WwvSpotStruct tWwvSpot;

#ifdef LINUX
	strcpy (szBinPath,  "../system/bin/");
#else
	strcpy (szBinPath,  "..\\system\\bin\\");
#endif

	/* Get the arguments */
	for(index = 1; index < Argc; index++)
	{
		switch( Argv[index][0] )
		{
			case 'd' :
			case 'D' :
				if( Argv[index][1] == '=' )
				nDelDays = atoi (Argv[index] + 2);
				break;

			case 'p' :
			case 'P' :
				if( Argv[index][1] == '=' )
				strcpy (szBinPath, Argv[index] + 2);
				break;

			case 'v' :
			case 'V' :
				printf("PURGWWV v 1.0\n");
				break;
		}/* End SWITCH */
	}/* End FOR */

	/* Check arguments */
	if( nDelDays <= 0 )
		nDelDays = 1;

	/* Prepare the file name */
#ifdef LINUX
	if( szBin[strlen (szBin)] == '/' )
		sprintf (szBin, "%s%s", szBinPath, "wwv.bin");
	else
		sprintf (szBin, "%s%s", szBinPath, "/wwv.bin");
#else
	if( szBin[strlen (szBin)] == '\\' )
		sprintf (szBin, "%s%s", szBinPath, "wwv.bin");
	else
		sprintf (szBin, "%s%s", szBinPath, "\\wwv.bin");
#endif
	strcpy (szOld, szBin);
	strcpy (szOld + strlen (szOld) - 4, ".old");

	/* Create a bak file */
	/* Open the files */
	fBinFile = fopen (szBin, "rb");
	if( ! fBinFile )	/* Error opening the file */
	{
		perror ("PURGWWV -> fopen in MAIN (fBinFile 1)");
		return (1);
	}

	fOldFile = fopen (szOld, "w+b");
	if( ! fOldFile )	/* Error opening the file */
	{
		perror ("PURGWWV -> fopen in MAIN (fOldFile 1)");
		return (2);
	}

	/* Copy wwv.bin -> wwv.old */
	printf ("Creating wwv.old\n");
	for (;;)
	{
		if( ! fread (&tWwvSpot, sizeof (tWwvSpot), 1, fBinFile) )
			break;	/* EOF */
		fwrite (&tWwvSpot, sizeof (tWwvSpot), 1, fOldFile);
	}/* End FOR */

	fclose (fBinFile);
	fclose (fOldFile);

	fBinFile = fopen (szBin, "wb");
	if( ! fBinFile )	/* Error opening the file */
	{
		perror ("PURGWWV -> fopen in MAIN (fBinOld 2)");
		return (3);
	}

	fOldFile = fopen (szOld, "rb");
	if( ! fOldFile )	/* Error opening the file */
	{
		perror ("PURGWWV -> fopen in MAIN (fOldFile 2)");
		return (2);
	}

	for (;;)
	{
		time_t SpotTime;

		if( ! fread (&tWwvSpot, sizeof (tWwvSpot), 1, fOldFile) )
			break;	/* EOF */

		/* Is this spot to be killed ? */
		SpotTime = DATE_hms (tWwvSpot.sDate);
		if( difftime (time (NULL), SpotTime) < (86400L * (double) nDelDays) )
		{
		  /* No, copy it */
		  fwrite(&tWwvSpot, sizeof (tWwvSpot), 1, fBinFile);
		  nSpotNum++;
		}
		else
		{
		  /* Yes, do not copy it */
		  nDelSpotNum++;
		} /* End IF */
	} /* End FOR  */

	fclose (fOldFile);
	fclose (fBinFile);

	printf ("PURGWWV completed : %d spots left, %d deleted.\n",
		nSpotNum, nDelSpotNum);

	return (0);
}

