
/******************************************************
 *                                                    *
 * FPAC project.            FPAC PAD                  *
 *                                                    *
 * Parts of code from different sources of ax25-utils *
 *                                                    *
 * F6FBB 05-1997                                      *
 *                                                    *
 ******************************************************/

/******************************************************
 * 12/05/97 1.00 F6FBB First draft !
 *
 ******************************************************/
 
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <syslog.h>
#include <ctype.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>

#include <linux/ax25.h>
#include <linux/rose.h>

#include "axutils.h"
#include "axconfig.h"
#include "wp.h"

int cr = 0;
int addsort = 0;
int revsort = 0;
int node = 0;

/*** Prototypes *******************/
static void display_results(wp_t *wp, int limit, int nb);
static int strmatch (char *chaine, char *masque);
static char *my_date(time_t date);
static int wp_cmp(const void *p1, const void *p2);

#define CR() printf( (cr) ? "\r" : "\n"); 

int main(int ac, char **av)
{
	int p;
	int ok;
	int pos;
	int nb;
	int limit = 10;
	int test_call;
	FILE *fptr;
	wp_t *wp;
	wp_header wph;
	char call[20];
	char *full_call;
	char *ptr;
	char *match;

	while ((p = getopt(ac, av, "acl:nr")) != -1) 
	{
		switch (p)
		{
		case 'c' :
			cr = 1;
			break;
		case 'l' :
			limit = atoi(optarg);
			break;
		case 'a' :
			addsort = 1;
			break;
		case 'r' :
			revsort = 1;
			break;
		case 'n' :
			node = 1;
			break;
		case '?' :
			printf("usage: wpserv [-c] [-l n] [-n] [mask]\n");
			return(1);
		}
	}

	if (optind == ac)
	{
		match = strdup("*");
		test_call = 1;
	}
	else
	{
		match = av[optind];
		test_call = 0;

		for (ptr = match ; *ptr ; ptr++)
		{
			if (isalpha(*ptr))
				test_call = 1;
		}
	}
	
	fptr = fopen(FPACWP, "r");
	if (fptr == NULL)
	{
		printf("No WP found"); CR();
		return(0);
	}

	if (fread(&wph, sizeof(wph), 1, fptr) == 0)
	{
		fclose(fptr);
		return(0);
	}

	/* Check the first record for compatibility */
	if (strcmp(wph.signature,FILE_SIGNATURE) != 0)
	{
		printf("WP file is not compatible\n");
		fclose(fptr);
		return(0);
	}

	printf("%d callsigns in database", wph.nb_record);
	CR();

	if ((ptr = strrchr(match, '-')) != NULL)
		*ptr = '\0';

	wp = malloc(sizeof(wp_t) * (limit + 1));
	if (wp == NULL)
	{
		printf("Cannot allocate memory"); CR();
		return(0);
	}

	pos = 0;
	nb = 0;
	
	while (fread(&wp[pos], sizeof(wp_t), 1, fptr))
	{
		char *add;
		
		full_call = ax2asc(&wp[pos].address.srose_call);
		if (*full_call == '\0')
			continue;
			
		if (node && !wp[pos].is_node)
			continue;
			
		if (test_call)
		{
			strcpy(call, full_call);
			if ((ptr = strrchr(call, '-')) != NULL)
				*ptr = '\0';

			if (strmatch(call, match))
			{
				++nb;			
				if (pos < limit)
					++pos;
			}
		}
		else
		{
			add = rose2asc(&wp[pos].address.srose_addr);
			ok = (strmatch(add, match));
			if (!ok)
				ok = (strmatch(add+4, match));
			if (ok)
			{
				++nb;			
				if (pos < limit)
					++pos;
			}
		}
		
	}

	fclose(fptr);
	
	if (nb)
	{
		/* sort the results */
		qsort(wp, (nb < limit) ? nb : limit, sizeof(wp_t), wp_cmp);
	}
	
	display_results(wp, limit, nb);
	
	free(wp);
	return(0);
}

static int wp_cmp(const void *p1, const void *p2)
{
	int ret;
	char *pt1;
	char *pt2;
	wp_t *wp1;
	wp_t *wp2;
	
	if (revsort)
	{
		wp1 = (wp_t *)p2;
		wp2 = (wp_t *)p1;
	}
	else
	{
		wp1 = (wp_t *)p1;
		wp2 = (wp_t *)p2;
	}
	
	if (addsort)
	{
		pt1 = strdup(rose2asc(&wp1->address.srose_addr));
		pt2 = strdup(rose2asc(&wp2->address.srose_addr));
	}
	else
	{
		pt1 = strdup(ax2asc(&wp1->address.srose_call));
		pt2 = strdup(ax2asc(&wp2->address.srose_call));
	}
	
	ret = strcmp(pt1, pt2);
	
	free(pt1);
	free(pt2);
	
	return ret;
}

static void display_results(wp_t *wp, int limit, int nb)
{
	int i, j;
	
	if (nb == 0)
	{
		printf("None found");
		CR();
	}

	else
	{
		if (nb > limit)
		{
			printf("%d entries match your request. Only first %d will be displayed.", nb, limit);
			CR();
			CR();
			nb = limit;
		}

		printf("Callsign  Last update       DNIC address digis"); 
		CR();
			
		for (i = 0 ; i < nb ; i++)
		{
			char dnic[5];
			char *add;
			char *call;	
			
			add = rose2asc(&wp->address.srose_addr);
			call = ax2asc(&wp->address.srose_call);

			strncpy(dnic, add, 4); dnic[4] = '\0';

			printf("%-9s %s => %s %-7s ", 
				call,
				my_date(wp->date),
				dnic, 
				add+4);
			
			if (wp->is_node)
				printf("Node ");

			for (j = wp->address.srose_ndigis-1 ; j >= 0  ; j--)
				printf("%s ", ax2asc(&wp->address.srose_digis[j]));
						
			printf("%s %s", wp->locator, wp->city);
			CR();
			
			++wp;
		}
	}

	printf("-- ");
	CR();

}

static int strmatch (char *chaine, char *masque)
{
	while (1)
	{
		switch (*masque)
		{
		case '\0':
			return (toupper(*masque) == toupper(*chaine));
		case '&':
			if ((*chaine == '\0') || (*chaine == '.'))
				return (1);
			break;
		case '?':
			if (!isalnum (*chaine))
				return (0);
			break;
		case '#':
			if ((*chaine != '#') && (!isdigit (*chaine)))
				return (0);
			break;
		case '@':
			if (!isalpha (*chaine))
				return (0);
			break;
		case '=':
			if (!isgraph (*chaine))
				return (0);
			break;
		case '*':
			while (*++masque == '*')
				;
			if (*masque == '\0')
				return (1);
			while (!strmatch (chaine, masque))
				if (*++chaine == '\0')
					return (0);
			break;
		default:
			if ((toupper (*chaine)) != (toupper (*masque)))
				return (0);
			break;
		}
		++chaine;
		++masque;
	}
}

static char *my_date(time_t date)
{
	static char buf[20];
	struct tm *sdate;

	sdate = localtime (&date);
	sprintf(buf, "%02d/%02d/%02d %02d:%02d", 
		sdate->tm_mday,
		sdate->tm_mon + 1, 
		sdate->tm_year%100,
		sdate->tm_hour,
		sdate->tm_min);
	return(buf);
}
