#include "linux/ax25.h"
#include "linux/rose.h"
#include "linux/netrom.h"

#ifdef OLD_AX25

#include "axutils.h"
#include "config.h"
#include "axconfig.h"
#include "nrconfig.h"
#include "rsconfig.h"
#include "procutils.h"
#include "mheard.h"
#include "daemon.h"

#define ax25_ntoa(a) ax2asc(a)
#define ax25_aton(a, b) convert_call(a, b) 
#define ax25_aton_entry(a, b) convert_call_entry(a, b)
#define ax25_aton_arglist(a, b) convert_call_arglist(a, b)

#define rose_ntoa(a) rose2asc(a)
#define rose_aton(a, b)  convert_rose_address(a, b)
#define rs_ax25_aton(a, b) rs_convert_call(a, b) 

#define nr_ax25_aton(a, b) nr_convert_call(a, b) 

#define ax25_cmp(a, b) ax25cmp(a, b)
#define ax25_validate(a) ax25validate(a)

#else

#include "netax25/axlib.h"
#include "netax25/axconfig.h"
#include "netax25/nrconfig.h"
#include "netax25/rsconfig.h"
#include "netax25/procutils.h"
#include "netax25/mheard.h"
#include "netax25/daemon.h"

#endif
