/* getargs.h
 *
 *	Definitions for getargs()/getallargs()/getfiles()
 *
 *	Copyright (c) 1985 J. Schilling
 *	Heavily modified and cleaned up for use with setpciscc.c by
 *	Jens David, DG1KJD <dg1kjd@afthd.tu-darmstadt.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	_GETARGS_H
#define	_GETARGS_H

#define	NOARGS		  0	/* No more args			*/
#define	NOTAFLAG	  1	/* Not a flag type argument	*/
#define BADFLAG		(-1)	/* Not a valid flag argument	*/
#define BADFMT		(-2)	/* Error in format string	*/
#define	NOTAFILE	(-3)	/* Seems to be a flag type	*/

typedef int BOOL;

#define TRUE 1
#define FALSE 0

extern char *astoi (const char *, int *);
extern char *astol (const char *, long *);

typedef int (*getargfun)(const void *, void *);

#define va_copy(to, from) ((to) = (from))

extern char *astoll(const char *s, long long *ll);
extern long long number(char *arg, int *retp);
extern int getnum(char *arg, long *valp);
extern int getbool(char *arg, int *valp);
extern int getllnum(char *arg, long long *lvalp);

int getargs(int *pac, char *const **pav, const char *fmt, ...);
int getallargs(int *pac, char *const **pav, const char *fmt, ...);
int getfiles(int *pac, char *const *pav[], const char *fmt);

#endif	/* _GETARGS_H */
