// InputCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "fbbW.h"
#include "InputCtrl.h"
#include "ConsoleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define DEFAULT_INPUT_BUFFER_SIZE	5;

/////////////////////////////////////////////////////////////////////////////
// CInputCtrl

CInputCtrl::CInputCtrl()
{
	m_bAnsi = false;
	m_bAutoReturn = true;
	m_bAutoSpace = true;
	m_bEndLine = true;
}

CInputCtrl::~CInputCtrl()
{
}


BEGIN_MESSAGE_MAP(CInputCtrl, CEdit)
	//{{AFX_MSG_MAP(CInputCtrl)
	ON_WM_SETFOCUS()
	ON_WM_KILLFOCUS()
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEWHEEL()
	ON_WM_CHAR()
	ON_WM_MOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInputCtrl message handlers

void CInputCtrl::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (nChar == VK_CANCEL)
	{
		// CtrlC = Copy accelerator
		m_pParentWnd->m_OutputCtrl.GetSelectedText();
	}
	else if (nChar == VK_RETURN)
	{
		char *buffer;
		int pos = LineFromChar();
		int ll = LineLength();
		
		buffer = (char *)malloc(ll+2);
		int nb = GetLine(pos, buffer, ll);
		buffer[nb] = '\0';
		strcat(buffer, "\n");
		if (!m_bAnsi)
			CharToOem(buffer, buffer);
		m_pParentWnd->Send(buffer);
		free(buffer);
		
		if (pos == GetLineCount() - 1)
		{
			// Last line...
			SetSel(100000, 100000);
			int ll = LineLength();
			if (ll)
				CEdit::OnChar(nChar, nRepCnt, nFlags);
		}
		else
		{
			int ll = LineIndex(pos+1);
			if (m_bEndLine)
			{
				// return at end of line
				ll += LineLength(ll);
			}
			SetSel(ll, ll);
		}
		
		// Limite le buffer a 20 lignes
		if (GetLineCount() > 20)
		{
			// Supprimer la 1ere ligne
			int nStart, nEnd;
			GetSel(nStart, nEnd);
			
			SetSel(0, LineLength(0)+2);
			ReplaceSel("");
			
			SetSel(nStart, nEnd);
		}
		
	}
	else
	{
		int ll = LineLength();

		// Automatic return when line > 79 chars
		if (m_bAutoReturn && ll >= 79)
		{
			// truncate the line in the last space if it exists
			if (m_bAutoSpace)
			{
				// Get the current selection
				int nStart, nEnd;
				GetSel(nStart, nEnd);
				
				// Get the position of the last character of the line
				int nFirst = LineIndex();
				int nLast = nFirst+ll;
				
				// Is the cursor at end of line ?
				if (nEnd == nLast)
				{
					if (nChar == ' ')
					{
						// Send a return character instead of space
						SendMessage(WM_CHAR, VK_RETURN, MAKELONG(1, nFlags));
					}
					else
					{
						// Search last space character
						int pos = LineFromChar();
						
						char *buffer = (char *)malloc(ll+1);
						int nb = GetLine(pos, buffer, ll);
						buffer[nb] = '\0';
						
						char *pEnd = strrchr(buffer, ' ');
						if (pEnd == NULL)
						{
							// No space, append a return...
							SendMessage(WM_CHAR, VK_RETURN, MAKELONG(1, nFlags));
						}
						else
						{
							
							SetSel(nFirst, nLast);
							
							// Truncates the buffer
							*pEnd++ = '\0';
							
							// Replace the current line with the new buffer
							ReplaceSel(buffer);
							
							SetSel(nStart, nEnd);
							
							// Send a return character 
							// Selection at the beginning of the next line
							BOOL bSauve = m_bEndLine;
							m_bEndLine = false;
							SendMessage(WM_CHAR, VK_RETURN, MAKELONG(1, nFlags));
							m_bEndLine = bSauve;
							
							// Prepend the end of the line to the next line
							ReplaceSel(pEnd);
						}
						
						// Write the current character
						CEdit::OnChar(nChar, nRepCnt, nFlags);
						
						free(buffer);
					}
				}
				else
				{
					// Do not accept further characters
					MessageBeep(MB_OK);
				}
			}
			else
			{
				SendMessage(WM_CHAR, VK_RETURN, MAKELONG(1, nFlags));
				CEdit::OnChar(nChar, nRepCnt, nFlags);
			}
			
		}
		else
		{
			CEdit::OnChar(nChar, nRepCnt, nFlags);
		}
	}		
	m_pParentWnd->m_OutputCtrl.ClearSelection();
}


BOOL CInputCtrl::Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID)
{
	m_pParentWnd = (CConsoleDlg *) pParentWnd;
	BOOL bRet = CEdit::Create(dwStyle, rect, pParentWnd, nID);

	SetFont(&Font, false);

	return bRet;
}

void CInputCtrl::SetAnsi(BOOL bAnsi)
{
	m_bAnsi = bAnsi;
	int Len = GetWindowTextLength();
	CString string;
	GetWindowText(string);
	if (bAnsi)
		string.OemToAnsi();
	else
		string.AnsiToOem();
	SetWindowText(string);

	Invalidate();
}

void CInputCtrl::OnSetFocus(CWnd* pOldWnd) 
{
	CEdit::OnSetFocus(pOldWnd);
	// Validate the selection
	m_pParentWnd->m_OutputCtrl.m_bViewSel = true;
	m_pParentWnd->m_OutputCtrl.Invalidate(false);
}

void CInputCtrl::OnKillFocus(CWnd* pNewWnd) 
{
	CEdit::OnKillFocus(pNewWnd);
	// Unvalidate the selection
	m_pParentWnd->m_OutputCtrl.m_bViewSel = false;
	m_pParentWnd->m_OutputCtrl.Invalidate(false);
}

void CInputCtrl::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	m_pParentWnd->m_OutputCtrl.ClearSelection();
	CEdit::OnLButtonDown(nFlags, point);
}

BOOL CInputCtrl::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt) 
{
	// TODO: Add your message handler code here and/or call default
	if (pt.y >= m_nYPos)
	{
		return CEdit::OnMouseWheel(nFlags, zDelta, pt);
	}
	else
	{
		m_pParentWnd->m_OutputCtrl.SendMessage(WM_MOUSEWHEEL, MAKELONG(nFlags, zDelta), MAKELONG(pt.x, pt.y));
		return 1;
	} 
}

void CInputCtrl::OnMove(int x, int y) 
{
	CEdit::OnMove(x, y);
	
	// TODO: Add your message handler code here
	RECT Rect;
	GetWindowRect(&Rect);
	m_nXPos = Rect.left;
	m_nYPos = Rect.top;
}
