#!/bin/sh
#
# Shell file to XFBB software
#
# F6FBB 1996
#

#
# Base directory of XFBB software
XFBBDIR=__BASEDIR__

#
# Add local PATH
PATH=$XFBBDIR/bin:$PATH

#
# Export resource file
XAPPLRESDIR=$XFBBDIR/res

export XFBBDIR PATH XAPPLRESDIR

end_session()
{
  echo "Session of XFBB is ended"
  exit 0;
}

maintenance()
{
  echo "Running maintenance"
  sleep 2
  epurmess
  epurwp 40 90
}

rerun()
{
  echo "Re-running XFBB"
  sleep 2
}

stop()
{
  echo "Stop XFBB asked !!"
  sleep 2
}

segv()
{
  echo "Segmentation violation in XFBB"
  sleep 2
}

error_return()
{
  echo "Unknown return value $1"
  sleep 10
}

if [ "_$1" = "_-d" ]
then
  XFBB=xfbbd
  shift
else
  XFBB=xfbb
fi

PARAM=$*

while [ 1 ]
  do

    cd $XFBBDIR

    echo
    echo "Running XFBB ^C to abort"
    sleep 3

    echo "Starting XFBB ..."
    $XFBB $PARAM > /dev/null
    
    ret=$?
    echo
    case $ret in
      1) end_session ;;
      2) rerun;;
      3) maintenance;;
      4) stop;;
      5) segv;;
      *) error_return $ret;;
    esac
    
done

