/*
 *	Simple Mailbox routines for AWZNode
 *	IZ5AWZ Stefano Noferi
 */

/* Moved #defines out to config.h file - Terry Dawson VK2KTJ */
/* Added Rose support - Terry Dawson VK2KTJ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <pwd.h>
#include <time.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <signal.h>
#include <linux/ax25.h>
#include <getopt.h>

#include "config.h"
#include "version.h"
#include "axcalluser.h"
#include "axconfig.h"
#include "node.h"
#include "io.h"

static char Caller[10];
static char delimiter = '\n';
static char DayName[]="Sun\0Mon\0Tue\0Wed\0Thu\0Fri\0Sat";
static char MonName[]="Jan\0Feb\0Mar\0Apr\0May\0Jun\0Jul\0Aug\0Sep\0Oct\0Nov\0Dec";

char *Lowercase(char *x)
{
	char *p=x;
	while(*p)
	{
		if(isupper(*p))
			*p=tolower(*p);
		p++;
	}
	return x;
}

int SendMessage(int argc,char **argv)
{
	char *subj;
	char *msg,*mptr;
	int msgsize;
	int mused;
	char *p;
	char *to=NULL;
	char *from=NULL;
	int len;
	char abuf[64];	/* Will hold last R: line data for Reply-To: line */
	char adate[64];
	int ct=1;
	long tv;
	struct tm *tp;
	char *to_username = NULL;
	
	*abuf=0;
	strcpy(Caller ,User.call);
	if(argc==1)
	{
		tprintf("\nSend to whom ?%c",delimiter);
		return 0;
	}
	to=strdup(strtok(argv[ct++]," @\t\n\r"));
	to_username = getusername(axcalluserid(to));
	if (!to_username)
	{
		free(to);
		tprintf("\nNo third party traffic.%c",delimiter);
		return 0;
	}
	time(&tv);	
	tp=gmtime(&tv);
	sprintf(adate,"%s, %d %s %2d:%2d:00 GMT",
	&DayName[tp->tm_wday*4],
		tp->tm_mday,
		&MonName[tp->tm_mon*4],
		tp->tm_hour,
		tp->tm_min);
		
	/*
	 *	Ok it parses now do the message
	 */
	 
	tprintf("\nEnter the subject for the message.%c",delimiter);
	usflush(User.fd);
	subj=readline(User.fd);
	if(subj==NULL) return 0;
	
	subj=strdup(subj);
	tprintf("Enter your message. End with '/EX' on a line of its own.%c",delimiter);
	msg=malloc(1024);
	msgsize=1024;
	mptr=msg;
	mused=0;
	while(1)
	{
		usflush(User.fd);
		p=readline(User.fd);	
		if(p==NULL) return 0;
		if (strcasecmp(p,"/EX")==0 || strcasecmp(p,"\032")==0)
		{
			*mptr++=0;
			break;
		}
		len=strlen(p);
		if(len+mused>=msgsize-3)
		{
			msgsize+=1024;
			msg=realloc(msg,msgsize);
			mptr=&msg[mused];
		}
		if(strncmp(mptr,"From",4)==0)
		{
			mused++;
			*mptr++='>';
		}
		strcpy(mptr,p);
		mptr+=len;
		mused+=len+1;
		*mptr++=delimiter;
	}
	/* We can now deliver it */
	to_username = getusername(axcalluserid(to));
	if(to_username) 
	{
		char deliver_command[80];
		FILE *mb;
		sprintf(deliver_command,MAIL_DELIVERY_AGENT,to_username);
		mb=popen(deliver_command,"w");
		if(mb==NULL)
		{
			tprintf("\nUnable to deliver.%c",delimiter);
			return 0;
		}
		/*
		 *	Now convert to approximate RFC822 format
		 */
#if defined(MY_GATEWAY)
		fprintf(mb,"From %s@%s %s",from?from:Caller,MY_GATEWAY,ctime(&tv));
#else
		fprintf(mb,"From %s %s",from?from:Caller,ctime(&tv));
#endif 
		fprintf(mb,"To: %s\n",Lowercase(to));
#if defined(MY_GATEWAY)
		fprintf(mb,"From: %s@%s\n",from?from:Caller,MY_GATEWAY);
#else
		fprintf(mb,"From: %s\n",from?from:Caller);
#endif
		fprintf(mb,"Subject: %s\n", subj);
		/*
		 *	Now walk the message headers
		 *	generating RFC822 received lines
		 *	(and figuring the return address)
		 */
		 p=msg;
		if(*abuf)
		{
			fprintf(mb,"Reply-To: <%s@%s>\n",from?from:Caller,abuf);
			fprintf(mb,"Return-Path: <%s@%s>\n",from?from:Caller,abuf);
		}
		fprintf(mb,"Date: %s\n",adate);

		/* Now we are onto the data part (if one exists) */
		fprintf(mb,"\n");	/* End envelope */
		/* Now dump the data part of the message */
		while(p && *p)
		{
			mptr=strchr(p,delimiter);
			if(mptr!=NULL)
				*mptr++=0;
			fprintf(mb,"%s\n",p);
			p=mptr;
		}
		fclose(mb);
	}
	/*
	 *	Else its a news article
	 */
/*	else
	{
		;
	}*/
	free(to);
	free(subj);
	free(msg);
	if(from) free(from);
tprintf("\nMessage sent to %s!\n",to_username);
return 0;
}
