/* ptotals.c - Report tool for use with STATS AX.25 monitor program.
   This module is part of ptotals.exe
                  
   Language = Microsoft C version 4.0


   This source is distributed freely and may be copied and
   redistributed with the following provisos:
   
           You may not sell it, nor may you charge for making 
           copies beyond the actual cost of mailing and media.
                      
   Written by Skip Hansen WB6YMH and Harold Price NK6K.

   Feedback is desired.

   RCP/M (213) 541-2503 300/1200/2400 baud
   or via packet WB6YMH @ WB6YMH-2 or 
		 NK6K @ NK6K

   Modification history:

	8/10/87	 	NK6K: Initial release.	
	ver 1.0		 

   10/18/87     NK6K: First general release.
   ver 1.1
*/




#include <stdio.h>

/* ptotals - prints from total file built by total.exe */
struct TOTALS {
	char call[10];
	unsigned long rx_tbytes;		/* total bytes */
	unsigned long rx_udbytes;		/* unique data bytes */
	unsigned long rx_ndbytes;		/* non-digi data bytes */
	unsigned long rx_tdbytes;		/* total data bytes */
	unsigned long tx_tbytes;		/* total bytes */
	unsigned long tx_udbytes;		/* unique data bytes */
	unsigned long tx_ndbytes;		/* non-digi data bytes */
	unsigned long tx_tdbytes;		/* total data bytes */
} total;

char fbuf[257];
long recnum=0;

int
main()
{
int tmp;
	printf(
"Call       TX      TX      TX   TX    RX      RX      RX   RX\n"   );
	printf(
"           TBytes  Ubytes  %%EFF %%Rtry TBytes  Ubytes  %%EFF %%Rtry \n\n");

	while (gets(fbuf)!=NULL) {

		if ((fbuf[0]=='Z') || (fbuf[0]=='S')) {
			tmp = sscanf(fbuf+2,"%[^,],%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu",
				total.call,
				&total.rx_tbytes,
				&total.rx_udbytes,
				&total.rx_ndbytes,
				&total.rx_tdbytes,
				&total.tx_tbytes,
				&total.tx_udbytes,
				&total.tx_ndbytes,
				&total.tx_tdbytes);


			if (tmp!=9) {
				fprintf(stderr,"*** bad rec, number %lu ***\n",recnum); 
				break;
				}
			recnum++;

			printf("%-11s%-8lu%-8lu",
				total.call,
				total.tx_tbytes,
				total.tx_udbytes);
			if (total.tx_tbytes==0) printf("     ");
			else printf("%-5.0f",
				((float) total.tx_udbytes / (float) total.tx_tbytes) * 100.0);
			if (total.tx_ndbytes==0) printf("      ");
			else printf("%-5.0f ",
				100.0-((float) total.tx_udbytes / (float) total.tx_ndbytes) * 100.0);


			printf("%-8lu%-8lu",
				total.rx_tbytes,
				total.rx_udbytes);
			if (total.rx_tbytes==0) printf("     ");
			else printf("%-5.0f",
				((float) total.rx_udbytes / (float) total.rx_tbytes) * 100.0);
			if (total.rx_ndbytes==0) printf("      ");
			else printf("%-5.0f",
				100.0-((float) total.rx_udbytes / (float) total.rx_ndbytes) * 100.0);
			printf("\n");

			if (fbuf[0]=='Z') {
				printf(
"The following values are only for bytes sent to or received from %s.\n",total.call);
				printf(
"RX means bytes received from %s, TX means bytes sent to %s\n\n\n",total.call,total.call);
				printf(
"Call       TX      TX      TX   TX    RX      RX      RX   RX\n"   );
				printf(
"           TBytes  Ubytes  %%EFF %%Rtry TBytes  Ubytes  %%EFF %%Rtry \n\n");

				}

			}
		}

		return(0);
}

