/*****************************************************************************/

/*
 *      usersmdiag.h  --  Diagnostics interface.
 *
 *      Copyright (C) 1996  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *        Swiss Federal Institute of Technology (ETH), Electronics Lab
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  This is the Linux realtime sound output driver
 */

/*****************************************************************************/
      
#ifndef _USERSMDIAG_H
#define _USERSMDIAG_H

/* --------------------------------------------------------------------- */

/*
 * diagnose modes
 */
#define SOUNDMODEM_DIAGMODE_INPUT          0
#define SOUNDMODEM_DIAGMODE_DEMOD          1
#define SOUNDMODEM_DIAGMODE_CONSTELLATION  2
#define SOUNDMODEM_DIAGMODE_RAWS           8
#define SOUNDMODEM_DIAGMODE_RAWB           9


#define SOUNDMODEM_CMD_REQCHACCESS    0x100
#define SOUNDMODEM_CMD_ACKCHACCESS    0x101

#define SOUNDMODEM_CMD_REQSTAT        0x200
#define SOUNDMODEM_CMD_ACKSTAT        0x201

#define SOUNDMODEM_CMD_DIAGPAR        0x300

#define SOUNDMODEM_CMD_DIAGDATA       0x310

#define SOUNDMODEM_CMD_DIAGINP        (SOUNDMODEM_CMD_DIAGDATA+SOUNDMODEM_DIAGMODE_INPUT)
#define SOUNDMODEM_CMD_DIAGDEMOD      (SOUNDMODEM_CMD_DIAGDATA+SOUNDMODEM_DIAGMODE_DEMOD)
#define SOUNDMODEM_CMD_DIAGCONSTELL   (SOUNDMODEM_CMD_DIAGDATA+SOUNDMODEM_DIAGMODE_CONSTELLATION)

#define SOUNDMODEM_CMD_DIAGRAWS       (SOUNDMODEM_CMD_DIAGDATA+SOUNDMODEM_DIAGMODE_RAWS)
#define SOUNDMODEM_CMD_DIAGRAWB       (SOUNDMODEM_CMD_DIAGDATA+SOUNDMODEM_DIAGMODE_RAWB)

#define SOUNDMODEM_CMD_CALIB          0x400

#define SOUNDMODEM_CMD_DRIVERNAMEREQ  0x500
#define SOUNDMODEM_CMD_DRIVERNAMEACK  0x501
#define SOUNDMODEM_CMD_MODENAMEREQ    0x502
#define SOUNDMODEM_CMD_MODENAMEACK    0x503

#define SOUNDMODEM_SIGNATURE          "\006USM"

/* --------------------------------------------------------------------- */

struct sm_message {
	struct sm_message_hdr {
		u_int8_t signature[4];
		u_int16_t cmd;
		u_int8_t pad[2];  /* pad to 8 bytes */
	} hdr;
	union {
		struct sm_message_cp {
			u_int8_t tx_delay;  /* the transmitter keyup delay in 10ms units */
			u_int8_t tx_tail;   /* the transmitter keyoff delay in 10ms units */
			u_int8_t slottime;  /* the slottime in 10ms; usually 10 = 100ms */
			u_int8_t ppersist;  /* the p-persistence 0..255 */
			u_int8_t fulldup;   /* some driver do not support full duplex, setting */
			                    /* this just makes them send even if DCD is on */
		} cp;

		u_int32_t calib;

		struct sm_message_cs {
			unsigned long ptt_keyed;
			unsigned long tx_packets;
			unsigned long tx_errors;
			unsigned long rx_packets;
			unsigned long rx_errors;
			unsigned long int_rate;
			unsigned long mod_cycles;
			unsigned long demod_cycles;
			unsigned long dma_residue1;
			unsigned long dma_residue2;
			u_int8_t ptt;
			u_int8_t dcd;
		} cs;
		
		struct sm_message_diagpar {
			u_int16_t modes;
		} diagpar;

		struct sm_message_diagraw {
			u_int32_t seq;
			u_int16_t flags;
			u_int8_t data[0];
		} diagraw;

		struct sm_message_diagsamp {
			u_int32_t seq;
			u_int16_t flags;
			u_int16_t sperbit;
			int16_t sample[0];
		} diagsamp;

		char str[0];
	} d;
};

/* --------------------------------------------------------------------- */
#endif /* _USERSMDIAG_H */
