/* Copyright (C) 1999, 2000 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef DIALOGS_H
#define DIALOGS_H

#include <qdialog.h>
#include <qwidget.h>
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qlabel.h>
#include <qevent.h>
#include <qslider.h>
#include <qlcdnumber.h>
#include <qcheckbox.h>
#include <fstream.h>

#include "prog_defs.h"

#define CONNECT_SIZE 40
#if CONNECT_SIZE < hisCall_SIZE || CONNECT_SIZE < selCall_SIZE
#error 
#endif

class Tnc;

class ConnectDialog;

class ConnectEditor: public QLineEdit {
    
    Q_OBJECT

    int count;
    int max_size;
    Tnc* tnc_p;
    ConnectEditor(QWidget* widget_p, int size, Tnc* tnc): QLineEdit(widget_p),
                    max_size(size), tnc_p(tnc) {} // private class
                                                  //only ConnectDialog can create an object
protected:
    virtual void keyPressEvent(QKeyEvent*);
signals:
    void esc_pressed(void);
public:
    friend ConnectDialog;
};

class ConnectDialog: public QDialog {

    Q_OBJECT

    ConnectEditor* editbox_p;
    Tnc* tnc_p;
public:
    const char* get_call(void) const {return editbox_p->text();}
    ConnectDialog(Tnc*, int, QWidget* qwidget_p = 0);
    ~ConnectDialog(void) {}
};

class CallsignDialog;

class CallsignEditor: public QLineEdit {
    
    Q_OBJECT

    int count;
    Tnc* tnc_p;
    CallsignEditor(QWidget* widget_p, Tnc* tnc): QLineEdit(widget_p),
                    count(0), tnc_p(tnc) {} // private class
                                            // only CallsignDialog can create an object
protected:
    virtual void keyPressEvent(QKeyEvent*);
signals:
    void esc_pressed(void);
public:
    friend CallsignDialog;
};

class CallsignDialog: public QDialog {

    Q_OBJECT

    CallsignEditor* editbox_p;
public:
    const char* get_call(void) const {return editbox_p->text();}
    CallsignDialog(Tnc*, int, QWidget* qwidget_p = 0);
    ~CallsignDialog(void) {}
};

class CommandDialog;

class CommandEditor: public QLineEdit {
    
    Q_OBJECT

    int count;
    CommandEditor(QWidget* widget_p): QLineEdit(widget_p), count(0) {} // private class
                                           // only CommandDialog can create an object
protected:
    virtual void keyPressEvent(QKeyEvent*);
signals:
    void key_pressed(int);
public:
    friend CommandDialog;
};

class CommandDialog: public QDialog {

    Q_OBJECT

public:
    enum {rejected, accepted, script};
private:
    CommandEditor* editbox_p;
private slots:
    void command_accept(void) {done(accepted);}
    void command_reject(void) {done(rejected);}
    void command_script(void) {done(script);}
public:
    const char* get_command(void) const {return editbox_p->text();}
    CommandDialog(int, QWidget* qwidget_p = 0);
    ~CommandDialog(void) {}
};

class RstDialog;

class RstEditor: public QLineEdit {
    
    Q_OBJECT

    int count;
    RstEditor(QWidget* widget_p): QLineEdit(widget_p), count(0) {} // private class
                                       // only RstDialog can create an object
protected:
    virtual void keyPressEvent(QKeyEvent*);
signals:
    void esc_pressed(void);
public:
    friend RstDialog;
};

class RstDialog: public QDialog {

    Q_OBJECT

private:
    RstEditor* editbox_p;
public:
    const char* get_rst(void) const {return editbox_p->text();}
    RstDialog(int, QWidget* qwidget_p = 0);
    ~RstDialog(void) {}
};

class Autocq_modeDialog: public QDialog {

    Q_OBJECT

public slots:
    void mode_button_pressed(int);
public:
    Autocq_modeDialog(int standard_size, QWidget* qwidget_p = 0);
};

class GplDialog;

class GplEditor: public QMultiLineEdit {
    
    Q_OBJECT

    GplEditor(QWidget* widget_p): QMultiLineEdit(widget_p) {} // private class
                                                              // only GplDialog can create an object
protected:
    virtual void keyPressEvent(QKeyEvent*);
signals:
    void esc_pressed(void);
public:
    friend GplDialog;
};

class GplDialog: public QDialog {

    Q_OBJECT

    GplEditor* editbox_p;
    int standard_size;
    QSize button_size;
    QLabel* label_p;
    QPushButton* ok_button_p;
    QPushButton* cancel_button_p;
protected:
    virtual void resizeEvent(QResizeEvent*);
public:
    GplDialog(int size, QWidget* qwidget_p = 0);
    ~GplDialog(void) {}
};

class PromptDialog: public QDialog {

    Q_OBJECT

public:
    PromptDialog(const char* text, const char* caption, int standard_size, QWidget* qwidget_p = 0);
    ~PromptDialog(void) {}
};

class HelpDialog;

class HelpEditor: public QMultiLineEdit {
    
    Q_OBJECT

    HelpEditor(QWidget* widget_p): QMultiLineEdit(widget_p) {} // private class
                                                              // only HelpDialog can create an object
protected:
    virtual void keyPressEvent(QKeyEvent*);
signals:
    void esc_pressed(void);
public:
    friend HelpDialog;
};

class HelpDialog: public QDialog {

    Q_OBJECT

    HelpEditor* editbox_p;
    int standard_size;
    QSize button_size;
    QPushButton* cancel_button_p;
    int open_flag;
protected:
    virtual void resizeEvent(QResizeEvent*);
    virtual void closeEvent(QCloseEvent*) {kill_dialog();}
public slots:
    void kill_dialog(void) {hide(); delete this;}
public:
    int is_opened(void) const {return open_flag;}
    HelpDialog(int size);
    ~HelpDialog(void) {}
};

class CwSpeedDialog: public QDialog {

    Q_OBJECT

    QSlider* qslider_p;
    QLCDNumber* qlcdnumber_p;
private slots:
    void display(int num) {qlcdnumber_p->display(((num + 2)/5) * 5);}
    void set_sliderpos(void) {qslider_p->setValue(qlcdnumber_p->intValue());}
public:
    int get_speed(void) const {return qlcdnumber_p->intValue();}
    CwSpeedDialog(int, int, QWidget* qwidget_p = 0);
    ~CwSpeedDialog(void) {}
};

class MainScreen;
class ReceiveWin;

class DownloadDialog: public QDialog {

    Q_OBJECT

    Tnc* tnc_p;
    MainScreen* mainscreen_p;
    ReceiveWin* receivewin_p;
    int stream;
    int port;
    QLabel* bytes_label_p;
private slots:
    void end_download(void);
protected:
    virtual void closeEvent(QCloseEvent* e) {e->ignore();}
public:
    void show_bytes(long); 
    DownloadDialog(const char*, Tnc*, MainScreen*, ReceiveWin*, int);
    ~DownloadDialog(void) {}
};

class BufferList;

class UploadDialog: public QDialog {

    Q_OBJECT

    Tnc* tnc_p;
    BufferList& buffer_list;
    MainScreen* mainscreen_p;
    ReceiveWin* receivewin_p;
    int stream;
    int port;
    QLabel* bytes_label_p;
private slots:
    void end_upload(void);
protected:
    virtual void closeEvent(QCloseEvent* e) {e->ignore();}
public:
    void show_bytes(long); 
    UploadDialog(const char*, long, Tnc*, BufferList&, MainScreen*, ReceiveWin*, int);
    ~UploadDialog(void) {}
};

struct Settings {
    int rx_endstop_flag;
    int cw_rx_flag;
    int bell_flag;
};

class SettingsDialog: public QDialog {

    Q_OBJECT

    QCheckBox* rx_endstop_checkbox_p;
    QCheckBox* cw_rx_checkbox_p;
    QCheckBox* bell_checkbox_p;
public:
    Settings get_settings(void) const;
    SettingsDialog(int standard_size, Settings& settings, QWidget* qwidget_p = 0);
};

class PrintMarkDialog: public QDialog {

    Q_OBJECT

public:
    enum {accepted, rejected, cancel_job};
private slots:
    void command_accept(void) {done(accepted);}
    void command_reject(void) {done(rejected);}
    void command_cancel_job(void) {done(cancel_job);}
protected:
    virtual void keyPressEvent(QKeyEvent*);
public:
    PrintMarkDialog(int, QWidget* qwidget_p = 0);
    ~PrintMarkDialog(void) {}
};


#endif
