/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1996  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fr Amateurfunk Software).                                           */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* Aktivierung einzelner Elemente in TNN                                */
/************************************************************************/

#define IPROUTE                       /* DB7KG-IP-Router                */
#define PACSAT                        /* PACSAT-Server                  */
#define GRAPH                         /* Graphische Statistiken         */

/*#define PROFILER*/                  /* Spielzeug fuer DB7KG           */
/*#define EXPERT*/                    /* EXPERTEN-Modus, mehr Paras     */

/*#define FLEXHOST*/                  /* FlexNet durchmelden zu NET/ROM */

/************************************************************************/
/* Deaktivierung einzelner Elemente wenn fuer Zielsystem unmoeglich     */
/* (Diese Definitionen duerfen nicht editiert werden.                   */
/************************************************************************/

#if defined(MC68K)
#undef  PACSAT
#endif

/* Unser ganz privater Assert ******************************************/
#ifdef MC68302
  #define HALT(x) {dbg(x); reboot_system();}
#else
  #define HALT(x) {xprintf("Halted by " x); reboot_system();}
#endif

/* Unser ganz privater Debugger ****************************************/
#define dbg(x)
#ifdef ST
#undef dbg
#define dbg(x) wowarich=x
#endif
#ifdef MC68302
#undef dbg
#define dbg(x) *(char **)0x11CL=x
#endif

/************************************************************************/
/* Definition von Konstanten die in gesammten TNN genutzt werden.       */
/************************************************************************/

#define ERRORS      (-1)                /* Fehler                       */
#define LOOP        for( ; ; )          /* Endlosschleife               */

#if defined (__GNU32__) || defined(__LINUX__)
#define LINKNMBR    400
#else
#define LINKNMBR    250                 /* maximale Anzahl Links        */
#endif
#define NUMCIR      200                 /* maximale Anzahl Circuits     */
#define MAXHST      30+1                /* maximale Anzahl Hostkanaele  */
#define NUMPAT      (LINKNMBR+NUMCIR+MAXHST)
                                        /* Eintraege Patchcordliste     */

#define DEFL2L      1
#define TAILTIME    3                   /* Tailtime fuer die KISS-TNCs  */

#define L2PNUM      16                  /* Anzahl L2-Ports              */
#if (L2PNUM != 8) && (L2PNUM != 10) && (L2PNUM != 16)
#error "L2PNUM muss 8, 10 oder 16 sein!"
#endif

#ifndef MC68302
# define MAXCOMS 3                      /* Anzahl der seriellen Ports   */
#else
# define MAXCOMS 4
#endif
#define MAXKISS MAXCOMS                 /* Anzahl der KISSLINKS         */

#define MAXSUSPEND  50                  /* Maximalanzahl Sperrungen     */
#define MAXCVSHOST  10                  /* Maximaleintraege ConversHosts*/
#define MAXSTAT     16                  /* Anzahl der Statistik-Eintrge*/
#define MAXNMBSTN   16                  /* Quantisierung Stationen/Port */

#define MINBUFF     256

#define BELL        0x07                /* ASCII-Zeichen                */
#define BS          0x08
#define TAB         0x09
#define LF          0x0A
#define CR          0x0D
#define XON         0x11
#define XOFF        0x13
#define ESC         0x1B
#define DEL         0x7F

#define MONI        0x01                /* Monitor: I-Frames            */
#define MONU        0x02                /*          UI-Frames           */
#define MONS        0x04                /*          S-Frames            */
#define MONC        0x08                /* Anzeige, auch wenn connected */
#define MONF        0x10                /* Anzeige des Info-Feldes      */
#define MONT        0x20                /* Sende-/Empfangszeit          */
#define MONL        0x40                /* Info-Laengen-Anzeige         */

#define SECONDS_PER_DAY   86400L   /* the number of seconds in one day  */
#define SECONDS_PER_HOUR   3600L   /*  "    "    "    "      "  "  hour */
#define SECONDS_PER_MIN      60L   /*  "    "    "    "      "  "  min. */

#ifdef CRASHDEBUG
#define TRACE(x) wowarich2 = "x"
#else
#define TRACE(x)
#endif

/************************************************************************/
/*                Einiges fr TNC3                                      */
/************************************************************************/
#ifdef MC68302
#define __BOOLEAN
#include <apbind.h>

#undef stdout             /* stdout Simulation */
extern FILE *stdout;

#define MAXPATH   20

#define xchdir(a);

#endif

/************************************************************************/
/* hier noch einige Sachen fuer PP-conversd                             */
/************************************************************************/

#define MAXCHANNEL      32767          /* hoechster conversd Kanal      */

#if defined(__TURBOC__) || defined(__STDC__)
#define __ARGS(x)       x
#ifndef __DOTS
#define __DOTS          ,...
#endif
#else
#define __ARGS(x)       ()
#define const
#ifndef __DOTS
#define __DOTS
#endif
#endif

#if !defined (min)
#define min(a,b) ((a) >= (b) ? (b) : (a))
#define max(a,b) ((a) >= (b) ? (a) : (b))
#endif

/*#define uchar(x) ((x) & 0xff) wers braucht, solls anmachen, DL1XAO*/
#define uchar(x) (x)

#define REV "$Revision: 3.12b $"

#define INIT 0   /* Befehle fuer personalmanager und convers_config */
#define SAVE 1
#define SET  2
#define GET  3

/************************************************************************/
/* Dateitrennungszeichen usw fuer das Filesystem festlegen              */
/************************************************************************/
#define SEPARATORS "\\/"            /* die DOS- und die Unix-Konvention */

                                    /* File-Flags                       */
#define FF_LWR 1                    /* Dateinamen sind immer klein      */
#define FF_TXT 2                    /* Unterscheidung TEXT/BIN bei open */

#ifdef __LINUX__
#define FILE_SEP '/'                /* Linux und falcOS haben /         */
#define FILE_FLAGS FF_LWR
#define NO_DISKDRIVE                /* keine Laufwerksbuchstaben       */
#define TEXTPATH "/usr/local/tnn/"
#define TEXTCMDPATH TEXTPATH "textcmd/"
#define USEREXEPATH TEXTPATH "userexe/"
#define SYSEXEPATH TEXTPATH "sysexe/"
#ifdef PACSAT
#define PACSATPATH TEXTPATH "pacsat/"
#endif
#define MSGPATH TEXTPATH "msg/"
#define STRIPCHR CR
#define ENDCHR LF
#define PORTABLE
#else /* nicht __LINUX__ */
#define FILE_SEP '\\'               /* DOS und ST haben das alte \      */
#define STRIPCHR LF
#define ENDCHR CR
#ifndef MC68302
#define FILE_FLAGS FF_TXT
#define TEXTPATH "\\TNN\\"
#define TEXTCMDPATH TEXTPATH "TEXTCMD\\"
#define USEREXEPATH TEXTPATH "USEREXE\\"
#define SYSEXEPATH TEXTPATH "SYSEXE\\"
#ifdef PACSAT
#define PACSATPATH TEXTPATH "PACSAT\\"
#endif
#define MSGPATH TEXTPATH "MSG\\"
#else /* MC68302 */
#define FILE_FLAGS FF_LWR
#define TEXTPATH "r:\\"
#define TEXTCMDPATH TEXTPATH
#define USEREXEPATH TEXTPATH
#define SYSEXEPATH TEXTPATH
#define MSGPATH TEXTPATH
#endif
#endif

#if defined( __WIN32__ )
#define MAXPATH _MAX_FNAME
#define MAXDRIVE _MAX_FNAME
#define MAXDIR _MAX_FNAME
#define MAXFILE _MAX_FNAME
#define MAXEXT _MAX_FNAME
#define ffblk _finddata_t
#define ff_name name
#define ff_fdate time_write
#endif


#define GRAPH_THROUGHPUT 0
#define GRAPH_ROUNDSPSEC 1
#define GRAPH_FREEBUFFER 2
#define GRAPH_L2LINKS    3
#define GRAPH_CIRCUITS   4
#define GRAPH_NODES      5
#define GRAPH_MAXSELECT  6

#define GRAPH_LINES      15

#define GRAPH_INTERVAL   60   /* Alle 60 Sek. einen neuen Wert speicherm */
#define GRAPH_ELEMENTS   60   /* Wieviele Werte gespeichert werden sollen  */
                              /* Bei Veraenderung Ausgabe ccpgraph() anpassen*/


/* End of ALL.H */

