/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1996  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fr Amateurfunk Software).                                           */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

/* Variablen fuer Level 1 */

extern char huge *RAMBOT;       /* Zeiger auf Anfang des freien Speichers  */
extern char huge *RAMTOP;       /* Zeiger auf Ende des freien Speichers    */

extern LHEAD monfl;

extern WORD actch;              /* bearbeiteter Host-Kanal                 */
extern BOOLEAN tnb_ch;

extern WORD stamp;

extern WORD kick[];
extern WORD commandflag[];
extern WORD testflag[];
extern WORD show_recovery;
extern WORD watchdog;           /* Watchdog, Timer erhoeht                  */
extern UWORD DefDownport;

extern ULONG throughput;        /* Gesammtdurchsatz                         */
extern ULONG thbps;             /* Gesammtdurchsatz in bps                  */
extern ULONG thbps_max;         /* Gesammtdurchsatz in bps                  */

#define WATCHDOG_TIMEOUT 18000  /* Nach 3 Minuten ohne RX Port reset        */

extern char myid[];             /* Call (normal) + SSID (1 Bit linksgesch.) */
extern char myid_ssid[];        /* Call mit SSID -15 , fuer FlexNet         */
extern char hostid[];           /* Call fuer Host-Console                   */
extern char alias[];            /* Ident der Station                        */
extern char boxid[];            /* Rufzeichen der Mailbox                   */
extern char dxcid[];            /* Rufzeichen des Clusters                  */
extern UWORD convid;            /* SSID fr Convers                         */
extern UWORD testid;            /* SSID fr Linktest                        */

extern UWORD nmblks;            /* Anzahl aktiver Level-2-Links (1..127)    */
extern UWORD nmblks_max;        /* Maximalanzahl der Level-2-Links          */
                                /* empfangenes Frame :                      */
extern char rxfhdr[];           /*   Header (Ziel/Quell/via-Id's), 0-term.  */
extern UBYTE rxfctl;            /*   Kontrollbyte ohne P/F-Bit              */
extern UBYTE rxfPF;             /*   V2-Frame: 0x10 = P/F gesetzt, 0 sonst  */
extern UBYTE rxfCR;             /*   V2-Frame: 0x80 = Command-Frame         */
                                /*             0x00 = Response-Frame        */
extern int  rxfprt;             /*   Empfangs-Port                          */

                                /* zu sendendes Frame :                     */
extern char txfhdr[L2AFLEN+1];  /*   Header (Ziel/Quell/via-Id's), 0-term.  */
extern UBYTE txfctl;            /*   Kontrollbyte ohne P/F-Bit              */
extern UBYTE txfPF;             /*   V2-Frame: 0x10 = P/F gesetzt, 0 sonst  */
extern UBYTE txfCR;             /*   V2-Frame: 0x80 = Command-Frame         */
                                /*             0x00 = Response-Frame        */
extern int  txfprt;

extern UWORD DamaSpeedFactor;
extern UWORD paclen;
extern UWORD dama_init;         /* Anfangswert fuer DAMA Timer (10 ms)  */
extern UWORD dama_max;          /* Maximaler Aktivitaetszaehlerstand    */
extern UWORD MaxPollCnt;        /* Max. Anzahl von erlaubten Polls..    */

extern UWORD T3par;             /* T3         sec               @-T3-Befehl */
extern UWORD Rpar;              /* DIGION     0..1              R-Befehl    */
                                /* 1 = Digipeaten ein, 0 = aus              */
extern UWORD nmbfre;            /* "number free", Anzahl freier 32-Byte-    */
                                /* Buffer (36 Byte mit Kopf)                */
extern UWORD nmbfre_min;        /* min Buffer                               */
extern UWORD nmbfre_max;        /* max Buffer                               */

extern LHEAD freel;             /* "free list",                             */
                                /* Listenkopf Freibuffer                    */
extern LHEAD rxfl;              /* "rx frame list",                         */
                                /* Listenkopf empfangene Frames             */
extern LHEAD stfl;              /* "sent frame list",                       */
                                /* Listenkopf gesendete Frames              */
extern LHEAD trfl;              /* "trash frame list",                      */
                                /* Listenkopfe Frames fuer den Muelleimer   */
extern LHEAD damarl[L2PNUM];    /* "DAMA random list" - fuer Frames ausser- */
                                /* halb der DAMA-Steuerung (UI / UA / DM)   */
extern LHEAD txl2fl[L2PNUM];    /* "tx level 2 frame list",                 */
                                /* Listenkoepfe (je Port einer) zu sendende */
                                /* Frames                                   */
extern LNKBLK *lnktbl;          /* "link table", fuer jeden moeglichen      */
                                /* Level-2-Link ein Eintrag                 */
extern LNKBLK *lnkpoi;          /* "link pointer", globaler Zeiger auf den  */
                                /* gerade aktuellen Linkblock (in lnktbl)   */
extern LHEAD   l2frel;          /* Liste der freien Linkbloecke             */
extern LHEAD   l2actl[L2PNUM];  /* Aktive Linkbloecke je Port               */



/****************************************************************************/
/*** Variable fuer Level 3                                                ***/

extern NETWORK *netp;

extern UWORD broint_ui;        /* Broadcast-Interval                        */
extern UWORD broint_i;         /* Broadcast-Interval                        */
extern UWORD timliv;           /* Anfangswert Paketlebensdauer              */
extern UWORD worqua;           /* minimal Qualitaet fuer Autoupdate         */
extern UWORD autoqual;         /* Enable Link-Qualitaetsberechnung aus L3SRTT*/
extern UWORD l3rtt_time;       /* Uhr fuer L3-RTT berechnung                */
extern int   num_nodes_max;    /* bisher max. registrierte Nodes            */

extern LHEAD l3rxfl;           /* Level3 empfangene Frames                  */
extern LHEAD l3txl;            /* Level3 zu senddende Frames                */

extern MBHEAD *aliasbp;        /* Alias-Liste fuer Flexnet                  */

/****************************************************************************/
/*** Variable fuer Level 4                                            ***/
extern UWORD trawir;           /* Level4 vorgeschlagene Fenstergr.      */
extern LHEAD l4rxfl;           /* fuer Level4 eingegangene Frames       */
extern UBYTE l4hdr0;           /* Layer4 Header, Byte 1                 */
extern UBYTE l4hdr1;           /* Layer4 Header, Byte 2                 */
extern UBYTE l4hdr2;           /* Layer4 Header, Byte 3                 */
extern UBYTE l4hdr3;           /* Layer4 Header, Byte 4                 */
extern UBYTE l4hdr4;           /* Layer4 Header, Byte 5                 */
extern UBYTE l4opco;           /* Layer4 Opcode, Flags                  */
extern UBYTE l4pidx;           /* Layer4 Antwort, Partnerindex          */
extern UBYTE l4pcid;           /* Layer4 Antwort, Partner-ID            */
extern UBYTE l4ahd2;           /* Layer4 Antwort, Byte 2                */
extern UBYTE l4ahd3;           /* Layer4 Antwort, Byte 3                */
extern UBYTE l4aopc;           /* Layer4 Antwort, Opcode                */
extern LHEAD l4rxfl;           /* fuer Layer4 eingegangene Frames       */

extern UBYTE nmbcir;           /* Anzahl aktiver Level-4-Circuits       */
extern UBYTE nmbcir_max;       /* Maximalanzahl der Level-4-Circuits    */

extern char *typtbl;

/************************************************************************/
/*** Variable fuer Level 7                                              */

extern CIRBLK *cirtab;          /* Circuit Tabelle                      */
extern CIRBLK *cirpoi;          /* Pointer in Circuit Tabelle           */

extern char *clipoi;            /* Pointer in CLI Zeile                 */
extern char clilin[256];        /* Zeile fuer CLI                       */

extern char usrcal[7];          /* Call des aktuellen Users             */
extern char ncall[7];           /* Call des Nachbarn                    */
extern char ndigi[57];          /* Digiliste zum Nachbarn               */
extern UBYTE nport;             /* Port des Nachbarn                    */

extern WORD clicnt;             /* Zaehler fuer Zeichen in CLI Zeile    */
extern WORD paswle;             /* Laenge des Passworts                 */
extern char paswrd[];

extern UWORD ininat;           /* no activity timeout                   */
extern UWORD conctl;           /* congestion control                    */
extern UWORD VCpar;            /* Call ueberpruefen Flag                */
extern UWORD save_timer;       /* automatisches Speichern Configuration */
extern UWORD nquali;           /* Qualitaet des Knotens                 */
extern WORD  tic1s;            /* Zaehler fuer 100 x 10 ms = 1  s       */

extern PORTINFO portpar[L2PNUM];/* Konfiguration der KISS-TNC's         */

extern LHEAD usccpl;           /* Kopf der CCP-User Liste               */
extern LHEAD userhd;           /* Kopf der User Liste                   */
extern USRBLK *userpo;         /* Pointer in User Liste                 */

extern PTCENT *ptctab;         /* Patchcord Tabelle                     */

/************************************************************************/
/*** Variable fuer Host-Interface                                       */

extern LHEAD   smonfl;
extern LHEAD   statml;
extern int     monlin;
extern int     stalin;
extern int     numhsts;
extern BOOLEAN ishmod;
extern int     Ypar;
extern MBHEAD *mifmbp;

extern char bline[256];        /* Zeile vom Hostinterface       */
extern char *blipoi;           /* Pointer in bline              */
extern char blixfl;            /* X-on / X-off, Hostinterface   */
extern BOOLEAN hostco;         /* Flag Hostconnect erlaubt j/n  */
extern WORD blicnt;            /* zaehlt Zeichen in bline       */
extern HOSTUS *hstubl;         /* Kontrollblock fuer Host-User  */
extern HOSTUS *hstusr;         /* Pointer auf akt. Host User    */


extern STAT mh[MAXSTAT];
extern PORTSTAT portstat[L2PNUM];

extern char textpath[];
extern char confpath[];
extern char msgpath[];
extern char textcmdpath[];
extern char userexepath[];
extern char sysopexepath[];
extern char pacsatpath[];
extern char exename[];

extern FILE *loadfp;
extern char loadname[];
extern char loadtmp[];

extern char nullid[];
extern char cqdest[];          /* Call fuer CQ-Ruf              */
extern char cqdil[];           /* Digiliste fuer CQ-Ruf         */
extern char dmmsg[];           /* Disconnect Meldung            */
extern char conmsg[];          /* Connect Meldung               */
extern char recmsg[];          /* Reconnect Meldung             */
extern char failmsg[];         /* Failure with Meldung          */
extern char promptstr[];

extern char pass[];

extern char nulide[];          /* leerer Ident                  */

extern PARAM partab[];
extern int partablen;

/* Befehlstabelle */
extern COMAND cmdtab[];
extern COMAND syscmdtab[];
extern L1MODETAB l1modetab[];
extern HOSTCMD hostcmdtab[];
extern FILE  *consfile;
extern WORD startup_running;

extern MHTAB l2heard;
extern MHTAB l3heard;

extern LHEAD fdfl;              /* filedefblocks freelist */

extern time_t start_time;
extern time_t clear_time;

extern UWORD tkbaud;
extern int tkcom;

extern ULONG bytecnt;
extern ULONG checksum;
extern UWORD crc;
extern UWORD crctab[256];

extern UWORD syspro_flag;
extern char signon[];
extern char version[];
extern char cfgfile[];

extern ULONG lastic;
extern volatile ULONG tic10;
extern UBYTE port_status;

extern SUSPEND  sustab[];

extern UWORD dmagic;
#define MAGIC_L2PROFILE 2205        /* Par 1 = 2205 -> L2 Traffic       */

/* Definitionen for PP-Convers  */
extern WORD        cvs_pc;
extern time_t      currtime;
extern time_t      boottime;
extern char        *convtype;
extern char        *myfeatures;
extern char        *myhostname;
extern char        myrev[];
extern char        timestamp[];
extern PERMLINK    *permarray[MAXCVSHOST];
extern CONNECTION  *connections;
extern DESTINATION *destinations;
extern CHANNEL     *channels;

extern LONG rounds_pro_sec;             /* Anzahl Rounds/Sekunde        */
extern LONG rounds_max_sec;             /* Maximale Anzahl              */
extern LONG rounds_min_sec;             /* Minimale Anzahl              */
extern LONG rounds_count;               /* Zaehler fuer Rounds          */

extern BEACON beacon[L2PNUM];

extern time_t t;

#ifdef CRASHDEBUG
extern char *wowarich;
extern char *wowarich2;
#endif

#ifdef PACSAT
extern WORD  pacsat_enabled[];
extern UWORD pacsat_timer;
extern UWORD pacsat_frames;
extern UWORD pacsat_free;
extern LONG  first_fid;
extern LONG  last_fid;
extern char  pacsatid[];
#endif

extern unsigned int_level;              /* Interrupt-Vertiefungs-Level */

extern ULONG MEMORY_NEEDED;   /* fuer Message Buffer   */
extern UWORD maxlfz;
extern UWORD proto;
extern char loginstr[];
extern char infostr[];

extern BOOLEAN    tnnb_aktiv;

extern time_t sys_time;
extern struct tm *sys_localtime;

extern ULONG graph_values[GRAPH_MAXSELECT][GRAPH_ELEMENTS];/*StatistikGrahpen*/
extern ULONG graph_day[GRAPH_MAXSELECT][48]; /* fuer einen Tag, je halbe Std */
extern WORD  graph_day_aktpos;

/* End of $RCSfile$ */
