/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fr Amateurfunk Software).                                           */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

/*----------------------------------------------------------------------*/
/*                                                                      */
/* "level 2"                                                            */
/*                                                                      */
/* Der Level 2. Es werden alle Level-2-internen Aktionen ausgefuehrt    */
/* und Meldungen an hoehere Level weitergegeben (Informationstransfer   */
/* von/zum Level 2 und Kommandos an den Level 2 geschehen von ausser-   */
/* halb).                                                               */
/*                                                                      */
/* Der Level 2 laeuft wie folgt ab :                                    */
/*                                                                      */
/*  - Aufruf von l2init()                                               */
/*                                                                      */
/*  - zyklisches Aufrufen von l2()                                      */
/*                                                                      */
/*  Statusaenderungen im Level 2 (Connects, Disconnects, Failures, usw) */
/*  werden hoeheren Leveln vom Level 2 aus ueber                        */
/*                                                                      */
/*   l2tolx(<status>)  ->  l2tol3(<status>), l2tol7(<status>,lnkpoi,2)  */
/*                                                                      */
/*  mitgeteilt.                                                         */
/*                                                                      */
/*  Ein Connectwunsch wird dem Level 2 ueber das Besetzen eines leeren  */
/*  Linkblocks mit Quell- und Ziel- sowie Digicalls und Aufrufen von    */
/*  newlnk() mitgeteilt (lnkpoi zeigt auf Linkblock !).                 */
/*  Ein newlnk() auf einen bestehenden Link erzeugt einen Link Reset.   */
/*                                                                      */
/*  Ein Disconnectwunsch (oder bei mehrmaligem Aufruf der sofortige     */
/*  Disconnect) wird ueber das Setzen von lnkpoi auf den jeweiligen     */
/*  Linkblock und Aufruf von dsclnk() erreicht.                         */
/*                                                                      */
/*  Der Informationstransfer zum Level 2 geschieht von aussen durch     */
/*  Aufruf von itolnk(...), vom Level 2 durch itolx(..), welches dann   */
/*  fmlink() aus dem hoeheren Level aufruft.                            */
/*                                                                      */
/*  Ueber sdui(..) koennen unproto-Pakete (UI-Frames) gesendet werden.  */
/*                                                                      */
/*  Level-3-Pakete (Level-3-UI-Pakete oder Infopakete in Sequenz eines  */
/*  Level-2-3-Links) werden ausgefiltert und in die Level-3-Frameliste  */
/*  eingehaengt.                                                        */
/*                                                                      */
/*----------------------------------------------------------------------*/

/* Ist ein Port gerade aktiv ? (Blockierung des Senders und der Timer   */
BOOLEAN busy(int port) {
  if (fullduplex(port))
    return ((iscd(port) & (RXBFLAG|TXBFLAG)) != 0);
  else
    return ((iscd(port) & (DCDFLAG|PTTFLAG|RXBFLAG|TXBFLAG)) != 0);
}

/*----------------------------------------------------------------------*/
/*                                                                      */
/* "level 2 transmitter" (NEU)                                          */
/*                                                                      */
/* Falls auf dem Port keine Aktivitaet ist (PTT aus) und fuer eine      */
/* Verbindung das Sendefenster noch nicht gefuellt ist, senden wir      */
/* soviele Frames, wie in das Fenster passen. Auf Vollduplex-Ports      */
/* sendet sdi() grundsaetzlich immer nur EIN Frame, damit zwischen-     */
/* zeitliche Aenderungen am ->VR gleich bestaetigt werden koennen.      */
/* (Diese waere nicht moeglich, wenn die Frames bereits im L1 Sender    */
/* sitzen und auf Sendung warten).                                      */
/* Wenn l2tx() einen Port als frei erkennt, werden fuer alle Links      */
/* Informationen gesendet. Der Sender ist dann wieder gesperrt, bis     */
/* alles auf dem Port gesendet wurde.                                   */
/* Die Linkliste (pro Port) haelt die letzten Links (also die Ver-      */
/* bindungen, die zu letzt bedient und bestaetigt wurden) am Ende,      */
/* deshalb wird sie hier von vorn nach hinten gelesen. Damit wird       */
/* eine gleichmaessige Verteilung erreicht, es gibt kein "Festsaugen"   */
/* an einem Link.                                                       */
/*                                                                      */
/* Frames aus Gesendet-Liste holen und in die Monitorframeliste um-     */
/* haengen. Entsprechend dem Frameinhalt ggf. Timer 1 starten.          */
/*                                                                      */
/*----------------------------------------------------------------------*/
static void l2tx(void)
{
  WORD    port;                              /* Laufindex               */
  MBHEAD *sfbp;                              /* Sendeframebufferpointer */
  LHEAD  *llp;
  int     n;

  for (llp = &l2actl[port = 0];        /* alle Ports durchgehen         */
       port < L2PNUM;
       port++, llp++) {                /* nicht senden auf DAMA-Ports   */
    if (busy(port)) continue;          /* Port ist noch blockiert       */
    if (dama(port)) continue;
    for (lnkpoi  = (LNKBLK *)llp->head;
         lnkpoi != (LNKBLK *)llp;      /* alle Links des Ports pruefen  */
         lnkpoi  = lnkpoi->next) {
      if (lnkpoi->RStype != L2CREJ)    /* REJ nicht durch I ersetzen    */
        if ((n = itxwnd()) > 0)        /* darf ich ueberhaupt noch was? */
          sdi(outsdI(), n);            /* Frames generieren (mit clrT2) */
    }
  }

                                       /* Gesendetliste aufraeumen      */
  while ( ( sfbp = (MBHEAD *) stfl.head ) != (MBHEAD *) &stfl ) {
    ulink((LEHEAD *)sfbp);                      /* Frame holen          */
    if ((sfbp->l2fflg & L2FT1ST) != FALSE) {    /* ist T1 zu starten ?  */
      lnkpoi = sfbp->l2link;                    /* Zeiger auf Linkblock */
      setT1();                                  /* T1 starten           */
    }
    sfbp->tx = 1;
    if (takfhd(sfbp))
      monitor(sfbp);
    dealmb(sfbp);
  }
}

/*----------------------------------------------------------------------*/
/*                                                                      */
/* "level 2 receiver"                                                   */
/*                                                                      */
/* Alle Frames aus der RX-Frameliste holen und analysieren. Kopie an    */
/* Monitorliste, digipeaten oder in Level-3-Liste, falls erforderlich.  */
/* Auf UI-Frames antworten, falls erforderlich.                         */
/*                                                                      */
/* Reaktion entsprechend Protokoll, siehe unten.                        */
/*                                                                      */
/*----------------------------------------------------------------------*/

static void l2rx(void)
{
  char   *source;               /* Zeiger auf Quellrufzeichen/SSID      */
  WORD    l2state;              /* aktueller Level 2 Linkstatus         */
  MBHEAD *fbp;                  /* Framebufferpointer lokal             */
  int     i;

                                /* solange empfangene Frames vorhanden  */
  while ( ( fbp = (MBHEAD *) rxfl.head ) != (MBHEAD *) &rxfl )
  {
    ulink((LEHEAD *)fbp);       /* eins aus Liste holen                 */

    if (!takfhd(fbp)) {         /* Kopf analysieren                     */
      dealmb(fbp);              /* nicht ok, dann wegwerfen             */
      continue;                 /* naechstes Frame                      */
    }

    fbp->type = 2;              /* wir sind im Level 2                  */
    fbp->tx = 0;                /* es ist ein empfangenes Frame         */
    monitor(fbp);               /* an den Monitor                       */

    if (rxfctl == L2CUI) {              /* UI-Frame                     */
/*      if (istome(rxfhdr) == TRUE)      * wenn an mich ..              */
/*        if (rxfPF != FALSE             * .. und Antwort gewuenscht .. */
/*        && rxfCR != FALSE)                                            */
/*      xdm();                           * beantworten mit DM           */
/*                                                                      */
/* Dies ist ein Protokollverstoss! Nach AX.25-Protokoll soll auf ein    */
/* UI-Frame mit Poll nur dann mit DM geantwortet werden, wenn kein Link */
/* besteht. Wenn dagegen ein Link besteht, soll entsprechend Linkzu-    */
/* stand geantwortet werden. Dadurch kann ein bestehender, gut funktio- */
/* nierender Link vorzeitig beendet werden. Jetzt wird der Fehler so    */
/* geaendert, dass auf eine Reaktion hier vollkommen verzichtet wird.   */
/* Manche Spielkinder hatten ausserdem bemerkt, dass man einen Knoten   */
/* abschiessen kann, wenn man ihm in einer Aussendung beliebig viele    */
/* UI-Frames mit Poll schickt. Dadurch werden naemlich fuer die Ant-    */
/* wort-Frames beliebig viele Buffer belegt, bis der Knoten einen Reset */
/* ausloest. Auch deshalb ist es guenstiger, hier auf eine Reaktion zu  */
/* verzichten. Wenn es jemanden stoeren sollte, darf er natuerlich die  */
/* vom AX.25-Protokoll geforderte Reaktion einbauen.                    */

      lnkpoi = NULL;
      fbp->l2fflg = fbp->mbgc < fbp->mbpc ? getchr(fbp) : 0;
      if (!tol3sw(fbp))
        gateway_ui(rxfhdr+L2IDLEN, rxfhdr, rxfhdr+L2ILEN, fbp);
      continue;
    }

    /* Haben wir einen zum Frame passenden Linkblock ?                  */
    /*                                                                  */
    /* Die Linkliste dieses Ports durchgehen und nach einem passenden   */
    /* Linkblock ausschau halten. Wurde er gefunden, wird er an das     */
    /* Ende der Liste gehaengt, weil die Liste im naechsten Durchlauf   */
    /* wieder von hinten durchsucht wird.                               */
    /*                                                                  */
    /* Wenn wir keinen passenden Link haben, aber das Framezielcall     */
    /* an mich (Call + SSID oder Ident mit beliebiger SSID) ist, oder   */
    /* das Blockquellcall mit dem Framezielcall uebereinstimmt, dann    */
    /* einen neuen Link aus der Freiliste holen.                        */
    /* Wichtig: Es wird der Header, den wir senden wuerden, mit der     */
    /*          Linkliste verglichen (txf...)                           */

    lnkpoi = getlnk(rxfprt, txfhdr+L2IDLEN, txfhdr, txfhdr+L2ILEN);

    if (lnkpoi == NULL) {           /* keinen Linkblock gefunden?       */
      if (istome(rxfhdr)) {         /* Verbindung fuer mich?            */
        if (rxfctl == L2CSABM) {    /* SABM mit DM beantworten          */
          l2tolx(L2MBUSYT);         /* und hoeheren Leveln              */
          xdm();                    /* melden                           */
        } else                      /* sonst nur antworten,wenn         */
          if (   rxfPF != 0         /* Command mit Poll, dann           */
              && rxfCR != 0 )       /* mit DM antworten                 */
            xdm();
          else                      /* oder wenn kein Command           */
            if (rxfctl == L2CDISC)  /* Poll, aber ein DISC, mit         */
              xua();                /* UA antworten                     */
      }
      dealmb(fbp);                  /* empfangenes Frame wegwerfen      */
      continue;                     /* und zum naechsten                */
    }

    if (lnkpoi->state == L2SDSCED)  /* wir haben den Link noch nicht    */
      if (istomev() == 0) {
        dealmb(fbp);                /* nicht fuer uns? dann wegwerfen   */
        continue;
      }

/*------------------------*/
    /* Falls Timer 3 aktiv, diesen neu setzen, es ist wieder            */
    /* Aktivitaet auf dem Link                                          */

    if (lnkpoi->T3 != 0)
      setT3();

    l2state = lnkpoi->state;                 /* Linkstatus zur Abfrage  */

    if (!(rxfctl & L2CNOIM))                 /* I-Frame ?               */
    {
      /*----------------------------------------------------------------*/
      /* I-Frame :                                                      */
      /*                                                                */
      /* Nur annehmen, wenn empfangene N(R) des Frames ok,              */
      /* srxdNR(), und das I-Frame das naechste erwartete in der        */
      /* Sequenz ist, isntxi().                                         */
      /* Wenn alles ok, Laenge pruefen und ggf. auf falsche Laenge      */
      /* mit Frame-Reject reagieren, sonst Antwort entsprechend         */
      /* Statetable und I-Frame verarbeiten.                            */
      /*----------------------------------------------------------------*/
      if (   srxdNR()                            /* N(R) ok?            */
          && isnxti() )                          /* erwartet?           */
      {
        if (fbp->mbpc - fbp->mbgc <= L2MILEN+1)  /* Info-Laenge ok?     */
        {
          lnkpoi->tries = 0;
          /*------------------------------------------------------------*/
          /*    Bei DAMA-Betrieb auf lnkpoi->liport                     */
          /*    eventuell erstes neues I-Poll anmeckern                 */
          /*    DAMA-Ack-Poll verzoegern, bis alle Infos verarbeitet..  */
          /*    Aktivitaetszaehler und -merker loeschen                 */
          /*------------------------------------------------------------*/
          if (dama(lnkpoi->liport))          /* I-Frame auf DAMA-Port ? */
          {
            if (rxfPF & L2CPF)               /* Wenn I-Poll..           */
            {
              polDAMA();                     /* anmeckern..             */
              l2stma(stbl00dama);
            }
            else                             /* kein Poll               */
            {
              clrDAMA();                     /* DAMA clear !            */
#ifdef FEHLER
/* Hier folgt wohl ein Mehrfachfehler ...                               */
/* - Mit setT2 wird NICHT ein Wert fuer T2 berechnet, wie der Kommentar */
/*   vorschlaegt.                                                       */
/* - Bei setT2 wird der Antwort-Frametyp gesetzt .. 0 = L2CI, es soll   */
/*   also nach Ablauf von T2 mit einem I-Frame geantwortet werden. Was  */
/*   passiert, wenn keine Info vorliegt?                                */
/* - Bei (fast) allen Linkzustaenden wird mit l2stma(stbl01dama) der T2 */
/*   sowieso gesetzt, zum Glueck (oder leider?) auf einen sinnvollen    */
/*   Antworttyp. Daher ist dieser Befehl auch noch ueberfluessig.       */
              setT2(0);                      /* T2 berechnen            */
#endif
              lnkpoi->damapc = lnkpoi->T2;   /* und fr DAMA nehmen     */
              l2stma(stbl01dama);            /* DAMA braucht auch T2..  */
            }
          }
          else
          {
            if (rxfPF & L2CPF)               /* Poll                    */
              l2stma(stbl00);
            else                             /* kein Poll               */
              l2stma(stbl01);
          }

          /* Linkzustand I-Transfer moeglich und nicht busy ? */
          if (l2state >= L2SIXFER && !(lnkpoi->flag & L2FBUSY))
          {
            fbp->l2fflg = fbp->mbgc < fbp->mbpc ? getchr(fbp) : 0;
#if PID8
            if ((fbp = pid8frag(fbp)) == NULL)
              continue;
#endif PID8
            /*--------------------------------------------------*/
            /* wenn Level-3-I-Paket, dann in Level-3-RX-Liste   */
            /* einhaengen und Link als Level-3-Link markieren,  */
            /* No-Activity-Timeout neu starten                  */
            /*--------------------------------------------------*/
            if (tol3sw(fbp))
            {
              lnkpoi->noatou = ininat;
            }
            else
            {
              /*------------------------------------------------*/
              /* wenn normales Level-2-I-Paket, wenn nicht Busy */
              /* oder Level-3-Link, I annehmen und in           */
              /* Linkempfangsliste einhaengen                   */
              /*------------------------------------------------*/
              if (!(lnkpoi->flag & (L2FDSLE | L2FDIMM)))
              {
                relink((LEHEAD *)fbp,(LEHEAD *)lnkpoi->rcvdil.tail);
                ++lnkpoi->rcvd;
              }
              else                              /* sonst               */
                dealmb(fbp);                    /* Paket verwerfen     */
            }
            continue;                           /* naechstes Paket     */
          }
        }
        else                                    /* Frame zu lang       */
          sdfrmr(0x03);                         /* U/S-Frame invalid!  */
      }
    }                            /* durchfallen und Frame wegschmeien */
    else                                        /* kein I-Frame :      */
    if (!(rxfctl & L2CNOSM))              /* "no S mask", kein S-Frame */
    {
      /*---------------------------------------------------------------*/
      /* S-Frame :                                                     */
      /*                                                               */
      /* Nur annehmen, wenn empfangene N(R) des Frames ok,             */
      /* srxdNR(), und wenn das Frame kein Infofeld enthaelt.          */
      /*                                                               */
      /* Auf RR, RNR, REJ entsprechend Statetable antworten, auf       */
      /* andere mit Frame-Reject antworten.                            */
      /*---------------------------------------------------------------*/
      clrT3();                                  /* Timer 3 loeschen    */
      if (srxdNR())                             /* N(R) ok?            */
      {
        if (fbp->mbgc == fbp->mbpc)             /* kein I-Feld?        */
        {
          lnkpoi->tries = 0;
          /*-----------------------------------------------------------*/
          /*  Bei DAMA-Betrieb auf lnkpoi->liport                      */
          /*  Aktivitaetsmerker erhoehen                               */
          /*-----------------------------------------------------------*/
          if (dama(lnkpoi->liport))              /* Auf DAMA-Links:    */
            incDAMA();                           /* Prioritt runter   */
          switch ((rxfctl >> 2) & 0x03)
          {
            case 0 :                            /* L2CRR >> 2     RR   */
              l2stma(   !rxfCR
                      ? (!rxfPF ? stbl11 : stbl10)
                      : (!rxfPF ? stbl03 : stbl02)
                    );
              if (dama(lnkpoi->liport))         /* wenn DAMA-Port      */
              {
                if (rxfCR && rxfPF)             /* und gepollt wird    */
                  polDAMA();                    /* DAMA-Warnung        */
              }
              break;
            case 1 :
              l2stma(   !rxfCR                  /* L2CRNR >> 2         */
                     ? (!rxfPF ? stbl15 : stbl14)
                     : (!rxfPF ? stbl07 : stbl06)
                    );
              lnkpoi->VS = lnkpoi->lrxdNR;
              break;

            case 2 :                            /* L2REJ >> 2      REJ */
              l2stma(   !rxfCR
                     ? (!rxfPF ? stbl13 : stbl12)
                     : (!rxfPF ? stbl05 : stbl04)
                    );
              if (    (l2state >= L2SIXFER)
                  && (!dama(lnkpoi->liport)) )  /* nicht bei DAMA!    */
                sdoi();                /* ausstehende I-Frames senden */
              break;

            default :                           /* Kontrollfeld falsch */
              sdfrmr(0x01);                     /* oder nicht implemen-*/
              break;                            /* tiert!              */
          } /* switch */
        }
        else                                    /* U/S-Frame mit       */
          sdfrmr(0x03);                         /* unerlaubtem I-Feld  */
      }
    }                                          /* END S-Frame         */
    else                     /* Kein S-Frame, dann Frame der U-Gruppe */
    if ((rxfctl & 0xFF) != L2CFRMR)
    {
      /*-------------------------------------------------------------*/
      /* Kein FRMR-Frame, Frame nur annehmen, wenn kein Infofeld     */
      /* vorhanden.                                                  */
      /*                                                             */
      /* Frame auswerten, reagieren, nach Statetable antworten.      */
      /*-------------------------------------------------------------*/
      clrT3();                                /* Timer 3 loeschen    */
      if (fbp->mbgc == fbp->mbpc)
      {
        switch (rxfctl)
        {
          case L2CSABM :                      /* neuer Link/-reset   */
            if (fvalca(VCpar,rxfhdr + L2IDLEN) != TRUE) {
              l2tolx(L2MBUSYT);               /* nein, melden        */
              xdm();                          /* mit DM antworten    */
              dealmb(fbp);                    /* Frame vergessen     */
              continue;                       /* naechstes Paket     */
            }
            l2stma(lnkpoi->state == L2SDSCED && istomev() == 2
                   ? stbl08a
                   : stbl08);
            break;

          case L2CDISC :
            if (!l2state)                    /* Link aktiv ?         */
            {
              if (   rxfPF != 0              /* nein, wenn Command   */
                  && rxfCR != 0 )            /* mit Poll, dann mit   */
                xdm();                       /* DM antworten         */
              else
                xua();                       /* sonst mit UA         */
              dealmb(fbp);                   /* Frame wegwerfen      */
              continue;                      /* naechstes Paket      */
            }
            l2stma(stbl09);                  /* DISC EITHER COMMAND  */
            break;

          case L2CUA :
            l2stma(stbl16);                  /* UA EITHER RESPONSE   */
            break;

          case L2CDM :
            l2stma(stbl17);                  /* DM EITHER RESPONSE   */
            break;

          default :                /* unbekanntes Kontrollfeld :     */
            sdfrmr(0x01);          /* "Kontrollfeld falsch oder      */
            break;                 /* nicht implementiert"           */
        }                          /* end switch (rxfctl)            */
      } /* if */
      else {
        sdfrmr(0x03);                        /* Frametyp unbekannt   */
                                             /* "U/S-Frame mit un-   */
                                             /* erlaubtem Infofeld"  */
      }
    }
    else
    {
      /* FRMR-Frame :                                          */
      /*                                                       */
      /* Wird nur im Frame-Reject-Zustand oder bei moeglichem  */
      /* Informationstransfer angenommen.                      */
      /* Es werden die FRMR-Infobytes gelesen, FRMR an die     */
      /* hoeheren Level gemeldet, nach Statetable geantwortet. */
      if (l2state >= L2SIXFER || l2state == L2SFRREJ)
      {
        for (source = lnkpoi->frmr, i = 0; i < 3; ++i)
             *source++ = (fbp->mbgc < fbp->mbpc) ? getchr(fbp) : 0;
      }
      l2stma(stbl18);                  /* FRMR EITHER RESPONSE */
    }
    dealmb(fbp);   /* aktuelles Frame verarbeitet, wegwerfen   */
  }                /* end while ((fbp = rxfl.head) != &rxfl)   */
}

void l2profiler(void) {
#ifdef PROFILER
  MBHEAD *mbp;

  if (dmagic == MAGIC_L2PROFILE) {  /* im Level 2 ordentlich Krach  */
    while (lnkpoi->tosend < 10       /* machen                       */
           && !(lnkpoi->flag & (L2FDSLE | L2FDIMM))) {
      mbp = (MBHEAD*)allocb();
      while (mbp->mbpc < 256) putchr(' ', mbp);
      rwndmb(mbp);
      i3tolnk(0x12, lnkpoi, mbp);
    }
  }
#endif
}

/**************************************************************************\
*                                                                          *
* "level 2 rest"                                                           *
*                                                                          *
* Muellbufferliste frei machen (aus Interruptroutinen entstandener Muell,  *
* der besser ausserhalb der Interrupts deallokiert wird aus Zeitgruenden). *
*                                                                          *
\**************************************************************************/
static void l2rest(void)
{
  dealml((LEHEAD *)&trfl);            /* Muellbufferliste frei machen   */
}

/**************************************************************************\
*                                                                          *
* "level 2 timer"                                                          *
*                                                                          *
* Ausfuehren der Level-2-Millisekundentimer 1, 2, 3 in allen aktiven       *
* Links (herunterzaehlen und bei Ablauf reagieren).                        *
* In ticks wird die Anzahl der vergangenen 10ms-Intervalle (Ticks) seit    *
* dem letzten Aufruf dieser Routine angegeben.                             *
* Die Reaktion auf den T2 wird in l2tx() durchgefuehrt.                    *
*                                                                          *
* Hinweis zum Datendurchsatz:                                              *
* Da i2tolx() maximal alle 10ms ausgefuehrt wird (bei DOS16 alle 50ms),    *
* ist der Durchsatz AUF EINEM LINK auf etwa                                *
*                                                                          *
* (NoAckBuf * Framelaenge * 1s/10ms * 8) 10*256*100*8 = 2048000 Bits/s     *
*                                                                          *
* beschraenkt, das ist erstmal keine echte Huerde, sollte aber im Auge     *
* behalten werden.                                                         *
*                                                                          *
\**************************************************************************/
static void l2timr(void)
{
  int     port;
  LHEAD  *llp;
  LNKBLK *nextlp;
  static  ULONG lastic = 0L;
  UWORD   ticks;

  if ((ticks = (UWORD) (tic10-lastic)) != 0) {
    lastic = tic10;

    for (llp = &l2actl[port = 0];       /* alle Ports durchgehen        */
         port < L2PNUM;
         port++, llp++)
      for (lnkpoi  = (LNKBLK *)llp->head;
           lnkpoi != (LNKBLK *)llp;     /* alle Links des Ports pruefen   */
           lnkpoi  = nextlp) {
        nextlp = lnkpoi->next;          /* Nachfolger schonmal merken     */

        if (lnkpoi->flag & L2FACK) {    /* Bestaetigung von HTH           */
          if (lnkpoi->state == L2SHTH) {
            stxfad();                   /* Sendepfad setzen               */
            xua();                      /* UA- als Bestaetigung           */
            l2newstate(L2SIXFER);       /* neuer State: Connected         */
          }
          lnkpoi->flag &= ~L2FACK;      /* Flag loeschen                  */
        }
        if (lnkpoi->flag & L2FREJ) {    /* Ablehnung von HTH              */
          if (lnkpoi->state == L2SHTH) {
            stxfad();                   /* Sendepfad setzen               */
            txfCR = 0;
            txfPF = L2CPF;              /* Final                          */
            xdm();                      /* DM- als Bestaetigung           */
          }
          lnkpoi->flag &= ~L2FREJ;      /* Flag loeschen                  */
        }
        /* Wenn RTT-Messung freigegeben ist, dann RTT um ticks erhoehen   */
        if (lnkpoi->RTT != 0)
          lnkpoi->RTT += ticks;

        if (lnkpoi->T3 != 0)            /* wenn Timer 3 aktiv ...         */
          if (lnkpoi->T3 <= ticks) {    /*   wenn Timer 3 abgelaufen ...  */
            clrT3();                    /*   ... Timer 3 stoppen und      */
            l2stma(stbl24);             /*       Statetable T3 EXPIRES    */
          } else                        /*       ausfuehren               */
            lnkpoi->T3 -= ticks;        /*   sonst herunterzaehlen        */

        l2profiler();                   /* Spielzeug DB7KG                */

        if (   (lnkpoi->tosend > 150)       /* Der Link laeuft ueber..    */
            && (lnkpoi->state >= L2SIXFER))
          lnkpoi->flag |= L2FDIMM;          /* dann abwerfen              */

        if (lnkpoi->flag & L2FDIMM) {   /* Link sofort kappen             */
          l2stma(stbl20);               /* LOCAL STOP COMMAND             */
          lnkpoi->flag &= ~L2FDIMM;
          continue;
        }

        if (   (lnkpoi->flag & L2FDSLE) /* Disconnect wenn alles raus?    */
            && (!lnkpoi->tosend) ) {    /* und nix mehr anstehend?        */
          reslnk();                     /* Sequenzvars/Timer zurueck      */
          l2stma(stbl20);               /* LOCAL STOP COMMAND             */
          continue;
        }

        /*--------------------------------------------------------------*/
        /* sonst empfangene I-Pakete an hoeheren Level uebertragen und  */
        /* Busy-Condition pruefen / setzen / aufheben                   */
        /*                                                              */
        /* "Busy werden"      -   weniger als 80 Freibuffer             */
        /*                        oder so viele I-Pakete empfangen und  */
        /*                        nicht abgeholt, wie                   */
        /*                        "Erstickungszaehler" conctl angibt    */
        /*                                                              */
        /* "Busy aufloesen"   -   wieder mehr als 112 Freibuffer        */
        /*                        und weniger als halb so viele         */
        /*                        empfangen und nicht abgeholt wie      */
        /*                        conctl angibt                         */
        /*--------------------------------------------------------------*/
        i2tolx(FALSE);
        if (!(lnkpoi->flag & L2FBUSY)) {       /* nicht busy            */
          if (nmbfre < 30 || lnkpoi->rcvd >= conctl) {
            lnkpoi->flag |= L2FBUSY;           /* busy werden           */
            l2stma(stbl21);                    /* STATION BECOMES BUSY  */
          }
        } else
          if (nmbfre > 62 && lnkpoi->rcvd < conctl/2) {
            lnkpoi->flag &= ~L2FBUSY;          /* "busy" aufloesen      */
            l2stma(stbl22);                    /* BUSY CONDITION CLEARS */
          }

        if (   busy(lnkpoi->liport)   /* T1 und T2 nur wenn DCD aus ist */
            || dama(lnkpoi->liport))
          continue;

        if (lnkpoi->T1 != 0) {          /* wenn Timer 1 aktiv ...         */
          if (lnkpoi->T1 <= ticks) {    /* wenn Timer 1 abgelaufen ...    */
            lnkpoi->T1 = 0;             /* ... Timer 1 stoppen            */
            lnkpoi->RTT = 0;            /* RTT-Messung stoppen            */
            setT3();

            ++lnkpoi->tries;
            if (lnkpoi->tries <         /* zu viele Retries ?             */
                portpar[lnkpoi->liport].retry)
              l2stma(stbl23);           /* Statet. T1 EXPIRES             */
            else {                      /* zu viele Retries :             */
              lnkpoi->tries = 0;        /* Retryzaehler leer              */
              l2stma(stbl25);           /* N2 IS EXCEEDED                 */
            }
          }
          else
            lnkpoi->T1 -= ticks;          /* sonst herunterzaehlen        */
        }

        if (lnkpoi->T2 != 0) {          /* wenn Timer 2 aktiv ...         */
          if (lnkpoi->T2 <= ticks)      /*   wenn Timer 2 abgelaufen ...  */
            lnkpoi->T2 = 0;             /*   ... Timer 2 stoppen          */
          else
            lnkpoi->T2 -= ticks;        /*   sonst herunterzaehlen        */
        }

        if (lnkpoi->T2 == 0) {          /* Timer 2 nicht aktiv?           */
          if (lnkpoi->RStype != 0) {
            stxfad();                   /* ... dann Responseframe bauen   */
            txfCR = txfPF = 0;
            txfctl = setNR(  !(lnkpoi->flag & L2FBUSY)
                           ? lnkpoi->RStype
                           : L2CRNR);

            sdl2fr(makfhd(L2FUS),TRUE); /* und senden                     */
            clrT2();                    /* Responsemodus loeschen         */
          }
        }

    } /* fuer alle nicht disconnecteten Links */
    timDAMA(ticks);
  }
}

/* Die Reihenfolge der Bearbeitung ist hier entscheidend. Zuerst werden   */
/* die empfangenen Frames verarbeitet, dann werden I-Frames erzeugt und   */
/* erst dann wird ueber T1/T2 entschieden.                                */

void l2(void) {
  l2rx();
  l2tx();
  l2timr();
  l2rest();
}

/* End of L2A.C */
