/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fr Amateurfunk Software).                                           */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

UWORD   tracnt = 0;                 /* Anzahl der laufenden TRACEes     */
MONBUF  consmon = {0,255,0,""};     /* default: Console Monitor aus     */
extern MBHEAD    *hstmbp;

void dump_ip(MBHEAD *, MBHEAD *);
void dump_nrr(MBHEAD *, MBHEAD *);
BOOLEAN match(MBHEAD *, char *);

static void nethmon(MBHEAD *, MBHEAD *);

void putmb(MBHEAD *mbp, MBHEAD *mbp2)
{
  UBYTE c;

  rwndmb(mbp2);
  while (mbp2->mbgc < mbp2->mbpc) {
    c = getchr(mbp2);
    if (   c != TAB
        && c != LF
       ) {
      if (c != CR && c < ' ') {
        putchr('^', mbp);
        c += '@';
      }
      putchr(c, mbp);
    }
  }
}

/* Info-Daten umkopieren */
void frimon(MBHEAD *mbp, MBHEAD *fbp)
{
  BOOLEAN cr = (fbp->mbgc < fbp->mbpc);
  UBYTE   ch;

  while (fbp->mbgc < fbp->mbpc) {   /* verfuegbare Info holen           */
    ch = getchr(fbp);               /* ein Byte holen                   */
    if (cr) {                       /* wenn ein CR aussteht             */
      if (ch == CR) cr = FALSE;     /* es ist schon gekommen            */
    } else {                        /* kein CR ausstehen                */
      if (ch != CR && ch != LF)     /* CR,LF sind ok, sonst CR          */
        cr = TRUE;                  /* anfordern                        */
    }
    if (ch!=LF)                     /* Line-Feed filtern                */
    putchr(ch, mbp);                /* Info umkopieren                  */
  }
  if (cr) putchr(CR, mbp);          /* neue Zeile am Schluss            */
}

/*----------------------------------------------------------------------*/
/* Frames fuer Monitor bearbeiten                                       */
/*----------------------------------------------------------------------*/
void monitor(MBHEAD *fbp)
{
  MBHEAD    *l2mbp;
  MBHEAD    *netmbp;
  MBHEAD    *imbp;
  MBHEAD    *tmpmbp;
  char huge *mbbp;
  UWORD      mbgc;
  char       inflen[20];

  mbbp = fbp->mbbp;
  mbgc = fbp->mbgc;

  statsv(fbp->mbpc, fbp->mbgc, fbp->tx);

  if (consmon.Mpar || tracnt)           /* nur wenn Monitor oder Trace  */
   {
    l2mbp = (MBHEAD *)allocb();         /* Buffer fuer L2-Header        */
    netmbp = (MBHEAD *)allocb();        /* Buffer fuer L3/4-Header      */
    imbp = (MBHEAD *)allocb();          /* und einen fuer die Info      */
    frhmon(l2mbp, fbp);                 /* L2-Header auswerten          */
    netmbp->type = l2mbp->type;         /* PID kopieren                 */
    nethmon(netmbp, fbp);               /* L3/4-Header auch             */
    if (!(rxfctl & L2CNOIM))
     {
      sprintf(inflen, "[Info %d Bytes]",
              fbp->mbpc - fbp->mbgc);
     }
    else
     {
      inflen[0] = '\0';
     }
    frimon(imbp, fbp);                  /* Infofeld auswerten           */
    if (tracnt)                         /* min. ein User will lauschen  */
     {
      for (userpo =  (USRBLK *) usccpl.head;
           userpo != (USRBLK *) &usccpl;
           userpo =  (USRBLK *) userpo->unext)
       {
        if (userpo->status == US_CCP && userpo->monitor)
         {
          if (ismonf(fbp, userpo->monitor))
           {
            tmpmbp = getmbp();          /* ein Buffer fuer den User     */
            putmb(tmpmbp, l2mbp);       /* L2-Header ausgeben           */
            if (userpo->monitor->Mpar & MONT)
             {
              putstr(" - ", tmpmbp);
              puttim(&sys_time, tmpmbp);
             }
            putmb(tmpmbp, netmbp);             /* L3/4_Header hinterher */
            if (   (userpo->monitor->Mpar & MONL)
                && !(rxfctl & L2CNOIM))
              putprintf(tmpmbp, "%s\r", inflen);/* Infolaenge anzeigen  */
            if (userpo->monitor->Mpar & MONF)  /* wenn gewuenscht, auch */
              putmb(tmpmbp, imbp);             /* die Infos ausgeben    */

/* Damit der User nicht mehr Info bekommt, als er abnimmt, wird die     */
/* Ausgabe verworfen, wenn sein Link abgefuellt ist.                    */

            if (!send_msg(FALSE,tmpmbp))
              dealmb((MBHEAD *)ulink((LEHEAD *)tmpmbp));
          }
        }
      }
    }
    if (ismonf(fbp, &consmon))          /* Ausgabe gewuenscht           */
     {
      if (consmon.Mpar & MONT)
       {
        putstr(" - ", l2mbp);
        puttim(&sys_time, l2mbp);
       }
      l2mbp->type = HMRMONH;
      if (!ishmod)
       {
        putmb(netmbp, l2mbp);
        if (   (consmon.Mpar & MONL)
            && !(rxfctl & L2CNOIM))
            putprintf(l2mbp, "\r%s", inflen);
       }
      dealmb(netmbp);
      rwndmb(l2mbp);
      relink((LEHEAD *)l2mbp, (LEHEAD *)smonfl.tail);
      monlin++;
      if ((imbp->mbpc != 0) && (consmon.Mpar & MONF))
       {
        l2mbp->type = HMRMONIH;
        if (ishmod)             /* im Hostmode direkt das Infofeld      */
         {                      /* ausgeben, nicht die ^A gewandelte    */
          dealmb(imbp);
          imbp = (MBHEAD *)allocb();
          fbp->mbbp = mbbp;
          fbp->mbgc = mbgc;
          getchr(fbp);              /* PID ueberlesen                   */
          while (fbp->mbgc < fbp->mbpc)
            putchr(getchr(fbp), imbp);
         }
        rwndmb(imbp);                           /* zurueckspulen        */
        imbp->type = HMRMONI;
        relink((LEHEAD *)imbp, (LEHEAD *)smonfl.tail);
        monlin++;
       }
      else
        dealmb(imbp);   /* Info-Buffer freigeben                        */
     }
    else                /* Host ohne Monitor                            */
     {
      dealmb(l2mbp);    /* noch belegte Buffer freigeben                */
      dealmb(netmbp);
      dealmb(imbp);
     }
    fbp->mbbp = mbbp;
    fbp->mbgc = mbgc;
  }
}

/*----------------------------------------------------------------------*/
/* Statistik Arbeiten                                                   */
/*----------------------------------------------------------------------*/
void statsv(int count, int over_count, BOOLEAN tx)
{
  WORD     i;                           /* zum Zaehlen diverser Sachen  */
  STAT    *statp;                       /* Zeiger auf Statistiktabelle  */
  PORTSTAT *pstatp = portstat + (int)rxfprt;
  char     *viap;
  MHEARD   *mhp;

  throughput += count;                  /* fuer den Gesammtdurchsatz    */

  if (tx == 0)                          /* gesendete und empfangene     */
    pstatp->rx_bytes += (ULONG) count;
  else                                  /* Bytes zaehlen                */
    pstatp->tx_bytes += (ULONG) count;

 /*
  *  MH-Liste bearbeiten
  */
  if (updmheard((int)rxfprt))
  {
    if (tx == 0) { /* RX-Frame */
      if ((mhp = mh_lookup(&l2heard, rxfhdr+L2IDLEN)) == NULL)
        mhp = mh_add(&l2heard);
      if (mhp) {
        mh_update(&l2heard, mhp, rxfhdr+L2IDLEN, rxfprt);
        mhp->rx_bytes += count;
        if ((rxfctl&0xf) == L2CREJ)
          mhp->rx_rej++;
      }
    } else {
      if ((mhp = mh_lookup(&l2heard, rxfhdr)) != NULL) {
        mhp->tx_bytes += count;
        if ((rxfctl&0xf) == L2CREJ)
          mhp->tx_rej++;
      }
    }
  }

  /*------------------------------------ Statistik-Liste durchsuchen ----*/
  for(statp = mh, i=0; i < MAXSTAT; statp++, i++) {
    if (!*statp->call) continue;
    if (tx == 0)                         /* ein empfangene Frame?        */
    {
      if (cmpid(rxfhdr+L2IDLEN, statp->call))    /* Quellcall stimmt?    */
        break;                           /* Tabellenplatz gefunden       */
      else {
        if (*(viap = rxfhdr + L2ILEN) != '\0')   /* Zeiger auf Via-Liste */
          if (invial(viap, statp->call))         /* Wenn Call in Liste   */
            if (*(viap+L2IDLEN-1) & L2CH)        /* und schon digipeatet?*/
              break;                             /* dann gefunden        */
      }
    }
    else                                         /* gesendetes Frame     */
    {
      if (cmpid(rxfhdr, statp->call))            /* Zielcall stimmt?     */
        break;
      else
      {
        if (*(viap = rxfhdr + L2ILEN) != '\0')   /* Zeiger auf Via-Liste */
          if (invial(viap, statp->call))         /* Wenn Call in Liste   */
            break;                               /* dann gefunden        */
      }
    }
  }

  if (rxfctl & L2CNOIM)                          /* kein Info-Frame ?    */
  {
    if (tx == 0)
      pstatp->rx_overhead += over_count;
    else
      pstatp->tx_overhead += over_count;
  }

  if (i < MAXSTAT)
  {
    if( statp->hfirst == 0L)                     /* zum ersten Mal gehoert */
      statp->hfirst = sys_time;

    if (tx == 0)                                 /* empfangene Zeichen */
    {
      statp->hlast = sys_time;                   /* last heard updaten */
      statp->rxByte += (ULONG) count;
      if (!(rxfctl & L2CNOIM))
        statp->rxIno++;
      else
        if (!(rxfctl & L2CNOSM))
          switch ((rxfctl >> 2) & 0x3)
          {
            case 0  :   statp->rxRRno++;
                        break;
            case 1  :   statp->rxRNRno++;
                        break;
            case 2  :   statp->rxREJno++;
                        break;
          }
    } else {
      statp->txByte += (ULONG) count;            /* gesendete Zeichen  */
      if (!(rxfctl & L2CNOIM))
        statp->txIno++;
      else
        if (!(rxfctl & L2CNOSM))
          switch ((rxfctl >> 2) & 0x3)
          {
            case 0  :   statp->txRRno++;
                        break;
            case 1  :   statp->txRNRno++;
                        break;
            case 2  :   statp->txREJno++;
                        break;
          }
    }
  }
}

void dump_nodes(MBHEAD *mbp, MBHEAD *fbp)
{
  char id[7];
  int  i;

  putstr("\rNODES-Broadcast:", mbp);
  while (fbp->mbpc - fbp->mbgc >= 21) {
    if (getfid(id,fbp) == TRUE) {
        putchr('\r', mbp);
        for (i = 0; i < L2CALEN; ++i)
          putchr(getchr(fbp), mbp);
        putchr(':', mbp);
        putid(id, mbp);
        if (getfid(id,fbp) == TRUE) {
          putstr(" v ", mbp);
          putid(id, mbp);
          putchr(' ', mbp);
          putnum(getchr(fbp), mbp);
          continue;
        }
    }
    return;
  }
}

void dump_inp_nodes(MBHEAD *mbp, MBHEAD *fbp)
{
  char  desnod[7];
  char  beaide[7], *bp;
  int   qual;
  int   ttl;
  int   tag;
  int   len;
  int   ch, i;

  getchr(fbp);                           /* Kennung uebergehen  */

  putstr("\rRouting Information:", mbp);

  while (fbp->mbpc - fbp->mbgc > 10) {
    if (!getfid(desnod, fbp)) break;
    putchr('\r', mbp);
    putid(desnod, mbp);
    ttl = getchr(fbp);
    qual = get16(fbp);
    putprintf(mbp, " %u / %u", qual, ttl);

    while (fbp->mbgc < fbp->mbpc) {

      if ((len = getchr(fbp)) > 0)
        len--; /* Lngenbyte selbst abziehen */

      if (fbp->mbpc - fbp->mbgc < len) { /* noch genug vorhanden? */
        putprintf(mbp, "\rINP: frame error, len = %u, left = %u\r",
                       len, (int) (fbp->mbpc - fbp->mbgc));
        break;
      }

      if (len-- < 1) /* TAG abziehen, wenn nicht zu kurz */
        break;

      switch (tag = getchr(fbp)) {
        case 0 : /* ALIAS */
          if (len > L2CALEN)
           {
            putstr(" (INVALID ALIAS!)\r", mbp);
            return;
           }
          for (i = 0, bp = beaide; i < len; i++) {
            ch = getchr(fbp);
            if ((ch < ' ') || (ch > 127))
              ch = '?';
            *bp++ = ch;
          }
          for (; i < L2CALEN; i++)
            *bp++ = ' ';
          putprintf(mbp, " (ALIAS=%6.6s)", beaide);
          break;
        default :
          putprintf(mbp, " (LEN=%u TAG=%u", len, tag);
          while (len-- > 0)
            putprintf(mbp, " %02X", getchr(fbp));
          putchr(')', mbp);
          break;
      }
    }
  }
  putchr('\r', mbp);
}

void dump_netrom(MBHEAD *mbp, MBHEAD *fbp)
{
  char id[7];
  UBYTE l4opco;
  UBYTE l4idx[4];
  WORD i;
  char *l4opctab = "ESCAPECONREQCONACKDISREQDISACKINFTRAINFACKSTATRA";

  if (rxfctl != L2CUI) {          /* I-Frames                       */
    if (*fbp->mbbp == 0xFF)
      dump_inp_nodes(mbp, fbp);
    else
    if (getfid(id,fbp) == TRUE) { /* L3-Teil beginnt mit Call       */
      putstr("\r(L3 ", mbp);      /* L3-Teil in neue Zeile          */
      putid(id, mbp);             /* L3-Absendercall                */
      if (getfid(id,fbp) == TRUE) { /* L3-Empfaenger vorhanden?     */
        putchr('>', mbp);
        putid(id, mbp);              /* L3-Empfaenger anzeigen      */
        if (fbp->mbgc < fbp->mbpc) { /* L3-Lifetime vorhanden?      */
          putstr(" TTL=", mbp);
          putnum(getchr(fbp), mbp);  /* dann anzeigen               */
        }
        if (fbp->mbpc - fbp->mbgc >= 5) { /* gueltiger L4-Teil?     */
          putstr(")\r(L4 ", mbp);         /* L4-Teil in neue Zeile  */
          for (i = 0; i < 4; ++i)         /* 4 L4-Header Bytes      */
            l4idx[i] = getchr(fbp);
          l4opco = getchr(fbp);
          if (l4opco & 0x18)
            putnum(l4opco, mbp);
          else
            putprintf(mbp, "%6.6s", l4opctab + (l4opco & L4OPMASK) * 6);
          if (l4opco & L4CMORE)
            putstr("+MORE", mbp);
          if (l4opco & L4CNAK)
            putstr("+NAK", mbp);
          if (l4opco & L4CCHOKE)
            putstr("+CHOKE", mbp);
          for (i = 0; i < 4; ++i) {       /* Opcodes anzeigen       */
            putchr(' ', mbp);
            putnum(l4idx[i], mbp);
          }
          if (l4opco == 5 &&
              cmpid(id, "L3RTT \140") &&
              match(fbp, "BROAD")         /* BROAD Kennung ?        */
              ) {
            putchr(')', mbp);
            dump_nodes(mbp, fbp);         /* Nodes zeigen           */
            return;
          }
          if (l4opco == 1 || l4opco == 2) /* ConnReq o. ConnAck     */
            if (fbp->mbgc < fbp->mbpc) {  /* es sollte noch mehr    */
              putchr(' ', mbp);           /* kommen                 */
              putnum(getchr(fbp), mbp);   /* L4 Window Size         */
              if (l4opco == 1)            /* Connect Request        */
                if (getfid(id,fbp) == TRUE) {
                  putchr(' ', mbp);
                  putid(id, mbp);         /* User Call              */
                  if (getfid(id,fbp) == TRUE)
                  {
                    putchr(' ', mbp);
                    putid(id, mbp);               /* Absenderknoten */
                    if (fbp->mbpc - fbp->mbgc >= 7) /* neue Soft-   */
                    {                               /* ware?        */
                      if (getfid(id,fbp) == TRUE)   /* Uplinkknoten */
                      {
                        putstr(" v ",mbp); /*wie normale Digiliste*/
                        putid(id, mbp);      /* aber max. 9 Calls  */
                        while (*fbp->mbbp != '\0') /* Ende erreicht?*/
                        {
                          if (fbp->mbpc - fbp->mbgc < 7) break;
                          if (!getfid(id,fbp)) break;
                          putchr(' ', mbp);
                          putid(id, mbp);
                        }
                        if (fbp->mbgc < fbp->mbpc) getchr(fbp);
                        /* Nullterminierung Digiliste abholen   */
                      }
                    }
                  }
                }
            }
        }
      }
      putchr(')', mbp);          /* Ende L3/4-Teil                */
      if (l4opco == L4TCPUDP) {
        if (l4idx[0] == 0 && l4idx[1] == 1) {
          dump_nrr(mbp, fbp);
        }
#ifdef IPROUTE
        else
          dump_ip(mbp, fbp);
#endif
      }
    }
  }
  else                                    /* L3-UI Frame          */
  if (fbp->mbpc - fbp->mbgc >= 7) {
    putprintf(mbp, "\r%02X ", getchr(fbp));
    for (i = 0; i < L2CALEN; ++i)
      putchr(getchr(fbp), mbp);
    dump_nodes(mbp, fbp);           /* Node-Informationen zeigen  */
  }
}

#ifdef IPROUTE
UWORD get16( MBHEAD * );
ULONG get32( MBHEAD * );
void show_ip_addr(ULONG, MBHEAD *);

void dump_arp(MBHEAD *mbp, MBHEAD *fbp)
{
  ARP arp;

  arp.hardware = get16(fbp);
  arp.protocol = get16(fbp);
  arp.hwalen = getchr(fbp);
  arp.pralen = getchr(fbp);
  arp.opcode = get16(fbp);
  getfid(arp.shwaddr, fbp);
  arp.sprotaddr = get32(fbp);
  getfid(arp.thwaddr, fbp);
  arp.tprotaddr = get32(fbp);

  putstr("\r(", mbp);
  switch (arp.opcode) {
    case ARP_REQUEST    : putstr("ARP-REQ ", mbp); break;
    case ARP_REPLY      : putstr("ARP-REPLY ", mbp); break;
    case REVARP_REQUEST : putstr("REVARP-REQ ", mbp); break;
    case REVARP_REPLY   : putstr("REVRARP-REPLY ", mbp); break;
    default             : putprintf(mbp, "ARP%04X ", arp.opcode); break;
  }
  switch (arp.hardware) {
    case ARP_NETROM : putstr("NET/ROM ", mbp); break;
    case ARP_AX25   : putstr("AX25 ", mbp); break;
    default         : putprintf(mbp, "hardware=%04X ", arp.hardware);
  }
  switch (arp.protocol) {
    case L2CIP      : putstr("IP-Proto", mbp); break;
    default         : putprintf(mbp, "Proto=%04X"); break;
  }
  if (arp.hwalen != 7 || arp.pralen != 4)
    putprintf(mbp, " hwalen=%u pralen=%u", arp.hwalen, arp.pralen);
  putstr(")\rSource=", mbp);
  putid(arp.shwaddr, mbp);
  putchr(':', mbp);
  show_ip_addr(arp.sprotaddr, mbp);
  putstr(" Dest=", mbp);
  if (arp.opcode == ARP_REQUEST)
    putstr("unknown", mbp);
  else
    putid(arp.thwaddr, mbp);
  putchr(':', mbp);
  if (arp.opcode == REVARP_REQUEST)
    putstr("unknown", mbp);
  else
    show_ip_addr(arp.tprotaddr, mbp);
}

void dump_nrr(MBHEAD *mbp, MBHEAD *fbp)
{
  char id[L2IDLEN];
  int  lt;
  #define LT_MASK   0x7F
  #define ECHO_FLAG 0x80

  putstr(" NET/ROM Route Record\r", mbp);
  while (fbp->mbpc - fbp->mbgc >= L2IDLEN+1) { /* Eintrag da?       */
    if (getfid(id, fbp) == TRUE) {
      lt = getchr(fbp);
      if (lt & ECHO_FLAG) putchr('*', mbp);
      putid(id, mbp);
      putprintf(mbp, "(%u) ", lt & LT_MASK);
    }
  }

  while (fbp->mbgc < fbp->mbpc) getchr(fbp);
  /* kein Schrott auf den Schirm */
}

void dump_ip(MBHEAD *mbp, MBHEAD *fbp)
{
  IP ip;
  int ip_len;

  ip_len = getchr(fbp);            /* Laenge und Version lesen         */
  ip.version = ( ip_len >> 4 ) & 0x0f;     /* Versionsnummer           */
  ip_len = ( ip_len & 0x0f ) << 2;        /* und Laenge in Bytes      */
  ip.tos = getchr(fbp);
  ip.length = get16(fbp);
  ip.id = get16(fbp);
  ip.offset = get16(fbp);
  ip.flags.mf = (ip.offset & 0x2000) ? 1 : 0;
  ip.flags.df = (ip.offset & 0x4000) ? 1 : 0;
  ip.offset = (ip.offset & 0x1fff) << 3;
  ip.ttl = getchr(fbp);
  ip.protocol = getchr(fbp);
  ip.checksum = get16(fbp);
  ip.source = get32(fbp);
  ip.dest = get32(fbp);

  putprintf(mbp, " TCP/IP\r(IPV%u ", ip.version);
  if (ip.version == 4) {
    putstr("fm ", mbp);
    show_ip_addr(ip.source, mbp);
    putstr(" to ", mbp);
    show_ip_addr(ip.dest, mbp);
    putprintf(mbp, " TTL=%u ", ip.ttl);
    switch (ip.protocol) {
      case ICMP_PTCL : putstr("ICMP", mbp); break;
      case TCP_PTCL  : putstr("TCP", mbp); break;
      case UDP_PTCL  : putstr("UDP", mbp); break;
      default        : putprintf(mbp, "Proto=%02X", ip.protocol);
    }
    putchr(')', mbp);
  } else
    putstr("unknown)", mbp);

#if 0
/* ----- Dump tcp protocol header of a packet ----------------------- */

Void tcp_DumpHeader( ip, tp, mesg )
    struct in_Header *ip;
    struct tcp_Header *tp;
    char *mesg;
{
    static char *flags[] = { "FIN", "SYN", "RST", "PUSH", "ACK", "URG" };
    S8  int     len;
    S8  Word        f;

    len = rev_word( ip -> length )
        - (( TCP_DATAOFFSET( tp ) + IP_HLEN( ip )) << 2 );
    printf( "TCP: %s packet:\nSrcP: %x; DstP: %x; SeqN=%lx AckN=%lx Wind=%d DLen=%d\n",
        mesg,
        rev_word( tp -> srcPort ),
        rev_word( tp -> dstPort ),
        rev_longword( tp -> seqnum ),
        rev_longword( tp -> acknum ),
        rev_word( tp -> window ),
        len );
    printf( "DO=%d, C=%x U=%d",
        TCP_DATAOFFSET( tp ),
        rev_word( tp -> checksum ),
        rev_word( tp -> urgentPointer ));

    /* output flags */

    f = rev_word( tp -> flags );
    for( len = 0; len < 6; len++ )
        if( f & ( 1 << len )) printf( " %s", flags[ len ] );
    printf( "\n" );
}
#endif

  while (fbp->mbgc < fbp->mbpc) getchr(fbp);
  /* kein Schrott auf den Schirm */
}
#endif

/*----------------------------------------------------------------------*/
/* Fragmentierte AX25 Frames bearbeiten                                 */
/*----------------------------------------------------------------------*/
void dump_frag (MBHEAD *mbp, MBHEAD *fbp)
{
 BYTE anz_frames;
 BYTE pid;
 
   anz_frames = getchr(fbp); /* erstes Byte lesen */

   if (anz_frames & 0x80) {  /* erstes Frame ? */
      pid = getchr(fbp);
      putprintf (mbp,"\r[AX25 Fragment %u Frame follow PID %x]\r",
                     (anz_frames & 0x7F),(pid & 0xFF));
   }
   else {/* folge Frame */
     putprintf (mbp,"\r[AX25 Fragment %u Frame follows]\r",(anz_frames & 0x7F));
   }
}

/*----------------------------------------------------------------------*/
/* Frame Header im Monitor zeigen                                       */
/*----------------------------------------------------------------------*/
void frhmon(MBHEAD *mbp, MBHEAD *fbp)
{
  putprintf(mbp,"%c%d: fm ", fbp->tx ? 'T' : 'R', fbp->l2port);
  putid(rxfhdr + L2IDLEN, mbp);     /* Absender-Rufzeichen              */
  putstr(" to ", mbp);
  putid(rxfhdr, mbp);               /* Zielrufzeichen                   */
  putdil(rxfhdr + L2ILEN, mbp);
  putchr(' ', mbp);
  if (!(rxfctl & L2CNOIM))
    putchr('I', mbp);
  else
    if (!(rxfctl & L2CNOSM))
      switch ((rxfctl >> 2) & 0x3)
       {
        case 0  :   putstr("RR", mbp);
                    break;
        case 1  :   putstr("RNR", mbp);
                    break;
        case 2  :   putstr("REJ", mbp);
                    break;
        default :   putprintf(mbp, "?%02XH", (char)(rxfctl | rxfPF));
                    break;
       }
    else
      switch (rxfctl & 0xFF)
       {
        case L2CUI   :   putstr("UI", mbp);
                         break;
        case L2CDM   :   putstr("DM", mbp);
                         break;
        case L2CSABM :   putstr("SABM", mbp);
                         break;
        case L2CDISC :   putstr("DISC", mbp);
                         break;
        case L2CUA   :   putstr("UA", mbp);
                         break;
        case L2CFRMR :   putstr("FRMR", mbp);
                         while (fbp->mbgc < fbp->mbpc)
                           putprintf(mbp, "%02X", getchr(fbp));
                         break;
        default      :   putprintf(mbp, "?%02XH", (char)(rxfctl | rxfPF));
                         break;
       }

  if ((rxfctl & 0x3) != 3)
   {
    putnum((rxfctl >> 5) & 0x7, mbp);
    if (!(rxfctl & L2CNOIM))
      putnum((rxfctl >> 1) & 0x7, mbp);
   }
  if (rxfPF != 0)
    putchr(rxfCR != 0 ? '+' : '-', mbp);
  else
    putchr(rxfCR != 0 ? '^' : 'v', mbp);

  if (!(rxfctl & L2CNOIM) || rxfctl == L2CUI)
    putprintf(mbp, " pid %02X", 
                     mbp->type = (fbp->mbgc < fbp->mbpc) ? getchr(fbp) : 0);

  if (!(rxfhdr[L2ILEN-1] & 0x20))
    putstr(" [DAMA]", mbp);
}

/*----------------------------------------------------------------------*/
/* Network Header im Monitor zeigen                                     */
/*----------------------------------------------------------------------*/
static void
nethmon(MBHEAD *netmbp, MBHEAD *fbp)
{
  if (!(rxfctl & L2CNOIM) || rxfctl == L2CUI)
   {
    switch (netmbp->type)                       /* PID                  */
     {
      case L2CTEXNET:
      case L2CNETROM: dump_netrom(netmbp, fbp);
                      break;
      case L2CFRAG  : dump_frag(netmbp, fbp);
                      break;
#ifdef IPROUTE
      case L2CARP   : dump_arp(netmbp, fbp);
                      break;
      case L2CIP    : dump_ip(netmbp, fbp);
                      break;
#endif
     }
   }
    putchr('\r', netmbp);
}

/*----------------------------------------------------------------------*/
/* is monitor frame?                                                    */
/*----------------------------------------------------------------------*/
BOOLEAN ismonf(MBHEAD *fbp, MONBUF *m)
{
  if ((m->Mpar & MONC) != FALSE) {
    if ((fbp->l2port == m->Mport) || (m->Mport > L2PNUM)) {
      if (    (
                  (!(rxfctl & L2CNOIM))
               && (((m->Mpar & MONI) != 0))
              )
           || (
                  ((rxfctl & 3) == 1)
               && ((m->Mpar & MONS) != 0)
              )
           || (
                  ((rxfctl & 3) == 3)
               && (rxfctl != L2CUI)
               && ((m->Mpar & MONS) != 0)
              )
           || (   (rxfctl == L2CUI)
               && ((m->Mpar & MONU) != 0)
              )
         )
      {
        if (m->mftsel != 0) {
          if (    invial(m->mftidl,rxfhdr + L2IDLEN) == TRUE
               || invial(m->mftidl,rxfhdr) == TRUE
             )
          {
            if (m->mftsel == 2)
              return (FALSE);
          }
          else
            if (m->mftsel == 1)
              return (FALSE);
        }
        return (TRUE);
      }
    }
  }
  return (FALSE);
}

/*----------------------------------------------------------------------*/
/* in via list?                                                         */
/*----------------------------------------------------------------------*/
BOOLEAN invial(char *vial, char *id)
{
  while (*vial != '\0')
    if (cmpid(vial,id) == TRUE)
      return (TRUE);
    else
      vial += L2IDLEN;
  return (FALSE);
}

void moncmd(MBHEAD  *mbp, MONBUF *m, char *blipoi, WORD blicnt)
{
  WORD     arg;
  BOOLEAN  host = (m == &consmon);
  char    *c;
  char     str[128];
  char     call[15];
  char    *s;

  if (blicnt == 0)
  {
    if (host)
      rspini(HMRSMSG);
    else
      putstr(", Monitor=", mbp);

    if (m->Mpar == 0)
      strcpy(str, "N");
    else {
      s = str;
      if ((m->Mpar & MONI) || (m->Mpar & MONU))
       {
        if (m->Mpar & MONF)
          *s++ = 'F';
        if (m->Mpar & MONL)
          *s++ = 'L';
       }
      if (m->Mpar & MONU)
        *s++ = 'U';
      if (m->Mpar & MONS)
        *s++ = 'S';
      if (m->Mpar & MONT)
        *s++ = 'T';
      if (m->Mpar & MONI)
        *s++ = 'I';
      if (m->Mpar & MONC)
        *s++ = 'C';
      if ((m->Mpar & MONI) || (m->Mpar & MONU))
        if (!(m->Mpar & MONF))
          *s++ = 'H';

      if (m->Mport < L2PNUM)               /* Welcher Port selektiert? */
        s += sprintf(s, " Port%d", m->Mport);

      *s = 0;

      if (m->mftsel) {
        if (m->mftsel == 1)
          strcat(s, " +");
        if (m->mftsel == 2)
          strcat(s, " -");
        if (*(c = m->mftidl )) {
          while (*c) {
           strcat(s, " ");
           call2str(call, c);
           strcat(s, call);
           c += L2IDLEN;
          }
        }
      }
    }

    if (host) {
      putstr(str, hstmbp);
    } else {
      putstr(str, mbp);
      putstr("\r", mbp);
    }
  } else {
    m->Mport = 255;
    m->Mpar = 0;
    m->mftsel = 0;
    arg = 0;
    while (blicnt)
    {
      skipsp(&blicnt, &blipoi);
      if (toupper(*blipoi) == 'N')
      {
        blicnt--;
        blipoi++;
        m->Mport = 255;                        /* Alle Ports freigeben */
        if (skipsp(&blicnt,&blipoi) == FALSE)
          arg = 0;
        else
        {
          if(*blipoi == '+' || *blipoi == '-')
            arg = 0;
          else
          {
            if (host) {
              rsperr(HMEIPA);
              return;
            }
            blicnt = 1;
            arg = m->Mpar;
          }
        }
      }
      else
      {
        switch(toupper(*blipoi))
        {
           case 'M': if (host)          /* An der Konsole ist M falsch  */
                      {
                       rsperr(HMEIPA);
                       return;
                      }
                     break;             /* Bei TRACE ist M erlaubt      */
           case 'T': arg |= MONT;
                     break;
           case 'L': arg |= MONL;
                     break;
           case 'A': arg |= (  MONI | MONU | MONS | MONC
                             | MONF | MONT | MONL);
                     break;
           case 'U': arg |= MONU;
                     break;
           case 'S': arg |= MONS;
                     break;
           case 'I': arg |= MONI;
                     break;
           case 'C': arg |= MONC;
                     break;
           case 'F': arg |= MONF;    /* Full-Monitor: Infos anzeigen */
                     break;
           case 'H': arg &= ~MONF;   /* Header-Monitor: nur Header   */
                     break;
           case '+': --blicnt;
                     ++blipoi;
                     if(getdig(&blicnt, &blipoi, FALSE, m->mftidl) != TRUE) {
                       if (host) {
                         rsperr(HMEIPA);
                         return;
                       }
                     } else {
                       if(m->mftidl[0] == '\0')
                         m->mftsel = 0;
                       else
                         m->mftsel = 1;
                     }
                     blicnt = 1;
                     break;
           case '-': --blicnt;
                     ++blipoi;
                     if(getdig(&blicnt, &blipoi, FALSE, m->mftidl) != TRUE) {
                       if (host) {
                         rsperr(HMEIPA);
                         return;
                       }
                     } else {
                       if(m->mftidl[0] == '\0')
                         m->mftsel = 0;
                       else
                         m->mftsel = 2;
                     }
                     blicnt = 1;
                     break;
           default:  if (isdigit(*blipoi))
                     {
                       m->Mport = nxtnum(&blicnt, &blipoi);
                       while (isdigit(*blipoi)) {
                         blicnt--;
                         blipoi++;
                       }
                       continue;
                     }
                     else
                     {
                       if (host) {
                         rsperr(HMEIPA);
                         return;
                       }
                       blicnt = 1;
                       arg = 0;
                     }
        }
        blicnt--;
        blipoi++;
      }
    }
    if (   (arg & MONL)               /* Laenge nur sinnvoll wenn I-    */
        && !(arg & (MONI | MONU)))    /* oder UI-Frames ausgewaehlt     */
      arg &= ~MONL;
    if (!host) {                      /* nicht fuer die Console...      */
      if ( m->Mpar && !arg) tracnt--; /* der Monitor wurde abgeschaltet */
      if (!m->Mpar &&  arg) tracnt++; /* ... oder angeschaltet          */
      if (arg)
        arg |= MONC;    /* Parameter C nur von Bedeutung an der Konsole */
    } else
      rspsuc();
    m->Mpar = arg;
  }
}

/* End of L7MONI.C */
