/* AX25 mailbox interface
 * Copyright 1991 Phil Karn, KA9Q
 *
 *	May '91	Bill Simpson
 *		move to separate file for compilation & linking
 */
#include "global.h"
#include "commands.h"
#include "proc.h"
#include "iface.h"
#include "usock.h"
#include "mailbox.h"
#include "ax25mail.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: ax25mail.c,v 1.18 1997/07/31 00:44:20 root Exp $";
#endif

extern int Mbjumpstart;


/* Axi_sock is kept in Socket.c, so that this module won't be called */
int
ax25start (argc, argv, p)
int argc OPTIONAL;
char *argv[] OPTIONAL;
void *p OPTIONAL;
{
int s, whatcall;
struct usock *up;

	if (Axi_sock != -1)
		return 0;

	ksignal (Curproc, 0);	/* Don't keep the parser waiting */
	server_disconnect_io ();
	chname (Curproc, "AX25 listener");
	Axi_sock = socket (AF_AX25, SOCK_STREAM, 0);
	/* bind() is done automatically */
	if (listen (Axi_sock, 1) == -1) {
		close_s (Axi_sock);
		return -1;
	}
	for (;;) {
		if ((s = accept (Axi_sock, NULLCHAR, NULLINT)) == -1)
			break;	/* Service is shutting down */

		/* Spawn a server */
		up = itop (s);
		if (up == NULLUSOCK || !up->cb.ax25) {	/* shouldn't happen */
			close_s (s);
			continue;
		}
		whatcall = up->cb.ax25->jumpstarted;
		if (whatcall & IP_LINK) {	/* don't start PBBS for IP VC connect */
			continue;
		}
		/* If jumpstart is off, then
		 * eat the line that triggered the connection
		 * and start the mailbox
		 */
		if (!Mbjumpstart) {
			(void) sockmode (s, SOCK_ASCII);	/* To make recvline work */
			(void) recvline (s, (unsigned char *)0, 80);
		} else {
			/* Check to see if jumpstart was actually used for
			 * this connection.
			 * If not, then again eat the line triggering this all
			 */
			if (!(whatcall & JUMPSTARTED)) {
				(void) sockmode (s, SOCK_ASCII);	/* To make recvline work */
				(void) recvline (s, (unsigned char *)0, 80);
			}
		}
		if (newproc ("pbbs", 2048, pbbs_incom, s, (void *) whatcall, NULL, 0) == NULLPROC)
			close_s (s);
	}
	return (deleteserver (&Axi_sock));
}


int
ax250 (argc, argv, p)
int argc OPTIONAL;
char *argv[] OPTIONAL;
void *p OPTIONAL;
{
	return (deleteserver (&Axi_sock));
}
