#ifndef _CONFIG_H
#define _CONFIG_H

/*
 * Automatically generated C config file: don't edit
 */

/*
 * TNOS configuration for release 2.40
 */
#define ISUNIX		1	/* Compiling on a Unix-based machine */

/*
 * Options related to assorted servers
 */
#define SERVERS		1	/* Include TCP Servers */
#define DSERVER		1	/* Include Domain Name Server */
#define TUTOR		1	/* Include Tutorial Server */
#define RDATE		1	/* Include Time Protocol Server */
#define XSERVER		1	/* Include X-windows Server */
#define TERMSERVER	1	/* Include Term Server */
#define HTTP		1	/* Include HTTP Server */
#define HTTPPBBS	1	/* Include HTTP PBBS Server */
#define HTTPCGI		1	/* Include HTTP CGI Support */
#define STRICT_HTTPCALL	1	/* Enforce valid calls for HTTP PBBS access */
#define CRONTAB		1	/* Include Cron Server */
#define TCPGATE		1	/* Include TCP gateway server */
#undef  SQL			/* Include SQL server support */
#define FIFOSERVER	1	/* Include FIFO server support */
#define TRACESERVER	1	/* Include trace server */
#define GPS		1	/* Include GPS position support */
#define CONVERS		1	/* Include enhanced Conference Server */
#define NNTPS		1	/* Include NNTP Server and client */
#define NNTPFILTER	1	/* Include NNTP Bad word filtering support */
#define RLOGINSERV	1	/* Include Rlogin server */
#define BOOTPSERVER	1	/* Include BOOTP server */
#define BOOTPCLIENT	1	/* Include BOOTP client */
#define MESSAGESERVER	1	/* Include the generic MESSAGE server */
#define TSCRIPTSERVER	1	/* Include the generic TSCRIPT message server */
#define APRSD		1	/* Include the APRS server */

/*
 * Do you wish these assorted Servers?
 * daytime, discard, echo, quote, time, and ttylink
 * Undefining this also removes ttylink client code
 */
#define ALLSERV		1	/* Include these assorted servers */

/*
 * BBS Specific options
 */
#define MAILBOX		1	/* Include BBS server */
#define FILECMDS	1	/* Include file commands (D,U,W,Z etc) */
#define GATECMDS	1	/* Include gateway cmds (C,E,N,NR,P,PI,T etc) */
#define PING_SECURE	1	/* Allow only those who can telnet to ping */
#define FOQ_CMDS	1	/* Include Finger, Operator, Query commands */
#define MAILCMDS	1	/* Include mail commands (S, R, V etc) */
#define USERLOG		1	/* Include last-message-read user tracking */
#define MAILFOR		1	/* Include Mailbox 'Mail for' beacon support */
#define DELEGATE	1	/* Include mail forwarding delegation server */
#define MBFWD		1	/* Include PBBS forwarding support */
#define ASKHOME		1	/* Include code to ask new user for home BBS */
#define WPAGES		1	/* Include White Pages support */
#define RLINE		1	/* Include BBS R:-line interpretation support */
#define ALTERBID	1	/* Include code to check for altered BIDs */
#define FBBFWD		1	/* Include FBB forwarding support */
#define FBBCMP		1	/* Include FBB Compressed forwarding support */
#define XFWD		1	/* Include X-Forwarding support */
#define UKIP		1	/* UKIP enhancements */
#define BBSIMPORT	1	/* Include PBBS import file support */
#define BBSEXPORT	1	/* Include PBBS export file support */
#define MBXTDISC	1	/* Include BBS timeout-disconnect support */
#define EXPIRY		1	/* Include message and bid expiry support */
#define REJECT		1	/* Include message rejection support */
#define EDITHEADERS	1	/* Allow the sysop to edit message headers */
#define TIPMAIL		1	/* Include TIP mailbox server */
#define XMODEM		1	/* Xmodem file transfer support */

/*
 * Mail Specific options - SMTP, POP, POP2, POP3 or BBS
 */
#define POP		1	/* Include POP client or server */
#define USEPOP3		1	/* Use POP3 versions */
#define POP3SERVER	1	/* Include POP3 Server */
#define POP3CLIENT	1	/* Include POP3 Client */
#define RMAIL		1	/* Include RMAIL support */
#define REQSVR		1	/* Include REQSVR support */
#define TRANSLATE	1	/* Incoming 'from' translation support */
#define MAILFILTER	1	/* Include mail filtering support */
#define HOLDMODS	1	/* Include word/address scanning support */
#define HOPPER		1	/* Include SMTP hopper support */
#define HOLDMONITOR	1	/* Include held mail monitoring support */
#define ALERTMONITOR	1	/* Include incoming mail monitoring support */

/*
 * Protocol Specific options
 */
#define PPP		1	/* Include Point-to-Point Protocol support */
#define SLIP		1	/* Include Serial line IP support */
#define VJCOMPRESS	1	/* Include Van Jacobson compression support */
#define DIALER		1	/* Include dialer support */
#define RIP		1	/* Include RIP routing support */
#define RSPF		1	/* Include Radio Shortest Path First support */
#define RARP		1	/* Include Reverse ARP support */

/*
 * AX.25 Options
 */
#define TTYCALL		1	/* Include AX.25 ttylink call support */
#define NODECALL	1	/* Include AX.25 dumb node support */
#define AXBCSTR		1	/* Include "ax bc <if> <str>" support */
#define AXUI		1	/* Include AX UI client */

/*
 * NETROM specific options
 */
#define NRS		1	/* Include NET/ROM async interface */
#define NETROM		1	/* Include NET/ROM network support */
#define NR4TDISC	1	/* Include Netrom L4 timeout-disc support */

/*
 * Routing, tracing and security options
 */
#define AXIP		1	/* Include AX25 links via IP support */
#define AXUDP		1	/* Include AX25 links via UDP support */
#define TRACE		1	/* Include packet tracing support */
#define MONITOR		1	/* Include user-port monitor trace support */
#define IPACCESS	1	/* Include IP access control support */
#define TCPACCESS	1	/* Include TCP access control support */
#define UDPACCESS	1	/* Include UDP access control support */
#define ENCAP		1	/* Include IP encapsulation within IP support */
#define ROUTESERVER	1	/* Include Dynamic ENCAP route server */
#define AUTOROUTE	1	/* Include AX.25 IP auto-route support */
#define HOPCHECK	1	/* Include IP path tracing support */
#define LOOKSESSION	1	/* Include sysop LOOK session support */
#define RXECHO		1	/* Include Echo pkt to other iface support */

/*
 * Statistics options
 */
#define STATS		1	/* Include statistics support */
#define STATS_USE	1	/* Include usage statistics support */
#define STATS_MSG	1	/* Include message statistics support */
#define STATS_AREA	1	/* Include area statistics support */
#define STATS_FWD	1	/* Include forwarding statistics support */
#define STATS_TFC	1	/* Include traffic statistics support */
#define STATS_HTTP	1	/* Include http statistics support */

/*
 * Callbook Support
 */
#define CALLCLI		1	/* An improved, generic IP callbook client */
#define QRZCALLB	1	/* Include QRZ callbook support */

/*
 * Generic Hardware driver options
 */
#define KISS		1	/* Include KISS TNC support */
#define POLLEDKISS	1	/* Include G8BPQ Polled Multidrop support */
#define ASY		1	/* Include Asynch driver support */
#define KERNEL_IF	1	/* Include Linux kernel interface support */

/*
 * Operating System Specific Options
 * Unix Specific options - do not use with MSDOS!
 */
#define SM_DUMB		1	/* Include dumb session manager */
#undef  SM_RAW			/* Include raw terminfo session manager */
#define SM_CURSES	1	/* Include curses session manager */
#undef  PATCURSES		/* Include curses and trace patches */
#define UNIX_SOCKETS	1	/* Allow using remote TCP port as async dev */
#undef  PIPECMD			/* Enable PIPE command support (incomplete!) */
#define SOUNDS		1	/* Include Unix sound support */
#define SETPSINFO	1	/* Update 'ps' info with uptime */

/*
 * Assorted Software options
 */
#define SCREENSAVER	1	/* Include local screen saver support */
#define BROWSER		1	/* Include HTTP Browser client */
#define FORTH		1	/* Include FORTH interpreter */
#define SCRIPTING	1	/* Include Command Session scripting commands */
#define CATALOG		1	/* Include cataloged strings on disk support */
#define VERSION_ON_FILE	1	/* Include version string on disk support */
#define LZW		1	/* Include LZW-compressed sockets support */
#define ATCMD		1	/* Include timed 'at' execution support */
#define LOCK		1	/* Include keyboard locking support */
#define ESCAPE		1	/* Include Unix style escape support */
#define SHELL		1	/* Include shell command support */
#undef  LOG_GMT_TZ		/* Use GMT time for logfiles, not localtime */
#define USE_TZOFFSET	1	/* Use a timezone offset timezone name */
#define STRICT_CALL	1	/* Enforce valid calls for login & PBBS fwd */
#undef  STRICT_AX25CALL		/* and AX25 calls connecting to the BBS ? */
#define POOLED		1	/* Use POOLED memory allocs where possible */

/*
 * Do you wish all sessions?
 * If undefined, this deletes the following sessions commands:
 * abort, connect, conference, disconnect, ftp, split, & telnet
 */
#define ALLSESSIONS	1	/* Include all session types */
#define FTPTDISC	1	/* Include ftp-server timeout-disc support */

/*
 * Do you wish all Command Session commands?
 * If this is undefined, deletes the following commands:
 * cd, copy, delete, dir, dump, finger, fkey, ls, mail, md,
 * mkdir, more, motd, pwd, rd, record, rename, rm, rmdir,
 * tail, upload, version, watch
 */
#define ALLCMD		1	/* Include these commands */

/*
 * Software tuning parameters
 * These should be left alone, unless you know what you're doing
 */
#define MTHRESH		16384	/* Default memory threshold */
#define NROWS		25	/* Number of rows on screen */
#define NIBUFS		10	/* Number of interrupt buffers */
#define IBUFSIZE	1024	/* Size of interrupt buffers */
#define NSESSIONS	20	/* Number of interactive clients */
#define DEFNSOCK	40	/* Default number of sockets */


#include "config.chk"

#endif	/* _CONFIG_H */
