#ifndef _FORWARD_H
#define _FORWARD_H

#ifndef _MAILBOX_H
#include "mailbox.h"
#endif

#ifndef _FWDPARSE_H
#include "fwdparse.h"
#endif

/* Defines for the ax.25 forwarding code           */
/* This was moved from the mailbox.h include file. */

/* In forward.c: */
int dorevfwd (int argc,char *argv[],void *p);
int dombtimer (int argc,char *argv[],void *p);
int dombkick (int argc,char *argv[],void *p);
char *fwd_bbsname (struct mbx *m);
int fwdinit (struct mbx *m, int try);
void mark_forwarded (FILE *fp,long ind, char thetype);
int makecl (struct mbx *m,int msgn,char const *dest,char *line,char *subj,char *bid,int *bul);
void sendmbmsg (struct mbx *m,int msgn,char *thebid);
int checksubchannel (struct mbx *m, int assignit);
void releasesubchannel (struct mbx *m);
int cutofffwding (struct mbx *m);

/* In fbbfwd.c: */
int dofbbfwd (int argc,char *argv[],void *p);

/* In xfwd.c: */
int doxfwd (int argc,char *argv[],void *p);

/* In smtpserv.c: */
void statusCtl (const char *who, const char *extension,struct let *info,int entry, int readit);


#ifdef FBBFWD

#define fbbUNKNOWN 0
#define fbbNO      1
#define fbbYES     2
#define fbbDEFER   3

#define FBBMAXMSGS 5             /* Maximum number of messages to process for FBB. */
#define XMAXMSGS   25            /* Maximum number of messages to process for X-fwding. */


/* FBB Packet   */
struct fbbpacket {
     int    number;          /* Message number in mail area.                   */
     int    accept;          /* NotActive = 0 / Reject(-) = 1                  */
                             /* Accept(+) = 2 / Defer(=)  = 3                  */
     int    reject;	     /* value returned from reject()		       */
     char   fbbcmd[3];       /* FB ( FA when compression is added )            */
     char   type;            /* (B)ulletin, (P)ersonal, (T)raffic/NTS          */
     char   bid[15];         /* Hold makecl() modified bid.                    */
     char   *sline;          /* bufptr that holds the bbs send command         */
                             /* used to enter a message onto the system.       */
     char   *rewrite_to;     /* Place to keep the new, ( via rewrite() to info */
     char   *to;
     char   *from;
     char   *messageid;
     char   *area;
     char   *subject;
     int    size;
     FILE   *fwdfile;
     long   fwdfileindex;
};


#define FWDFILELEN 132

/* A forward entry */
struct fwd {
    struct mbx *m;
    FILE *fwdfile;
    int	sentThisArea;
#ifdef FBBFWD
    char                *tmpBuffer;
    struct fbbpacket    *msglst;
    char                savefsline[MBXLINE+1];
    char                line[MBXLINE+1];
    char                iFile[FWDFILELEN];
    char                oFile[FWDFILELEN];
    struct lzhufstruct  *lzhuf;
#endif
#ifdef XFWD
    char		numtrans;
#endif
};

#endif


/* A Forwarding BBS */
struct bbs      {
        char	name[FWDBBSLEN];
        char	processed;
        char	subchannel;
        time_t	laston;
        time_t	lastactivity;
};


/* A subchannel structure */
struct subchan {
	int	limit;
	int	used;
	char	*description;
};

extern struct subchan *subchannels;

#ifdef FBBCMP
#include "lzhuf.h"
#else
#include "hardware.h"
#endif

#ifdef MBFWD
extern int FWDareatrace;
#endif

#ifdef ALTERBID
extern int chkBidAltered, holdBidAltered;
#endif

#endif  /* FORWARD_H */
