#ifndef _LZHUF_H
#define _LZHUF_H

#ifndef _HARDWARE_H
#include "hardware.h"
#endif

#ifndef _MAILBOX_H
#include "mailbox.h"
#endif
/* Defines for the ax.25 mailbox facility */

#ifndef _GLOBAL_H
#include "global.h"
#endif

#if defined(FBBCMP) || defined(XFWD)
extern void FBBerror (int x, int y, struct mbx *m);

#define SOH    1
#ifndef STX
#define STX    2
#endif
#define EOT    4

/* LZHUF variables. */
#define N               2048    /* buffer size was 4096, */
#define F                 60    /* lookahead buffer size */
#define THRESHOLD          2
#define NIL                N    /* leaf of tree */

#define N_CHAR          (256 - THRESHOLD + F)   /* kinds of characters (character code = 0..N_CHAR-1) */
#define T               (N_CHAR * 2 - 1)        /* size of table */
#define R               (T - 1)                 /* position of root */
#define MAX_FREQ        0x8000                  /* updates tree when the */

struct lzhufdata {
   int           dad[N + 1];
   int           lson[N + 1];
   int           rson[N + 257];
   unsigned char text_buf[N + F - 1];
   unsigned int  freq[T + 1];
   int           prnt[T + N_CHAR];
   int           son[T];
};
#define NULLLZHUFDATA (struct lzhufdata *)NULL

struct lzhufstruct {
   FILE *iFile;
   FILE *oFile;
   struct lzhufdata    *data;
   int                 data_type;

   int                 *dad;
   int                 *lson;
   int                 *rson;
   unsigned char       *text_buf;
   unsigned int        *freq;
   int                 *prnt;
   int                 *son;

   long codesize;
   int  match_position;
   int  match_length;

   unsigned getbuf;
   unsigned char    getlen;
   unsigned putbuf;
   unsigned char    putlen;
   unsigned code;
   unsigned len;
   unsigned long    iFileSize;
};

#define NULLLZHUFSTRUCT (struct lzhufstruct *)NULL

int send_yapp(struct fwd *, char *, char *);
int recv_yapp(struct fwd *);
int recv_lzhuf (struct fwd *f, int msgsize, int16 *newchecksum);
int send_lzhuf (struct fwd *f, char *txtFileName);
#endif
#endif
