/* Mods by G1EMM */
#ifndef	_NETUSER_H
#define	_NETUSER_H

/* Global structures and constants needed by an Internet user process */

#ifndef	_GLOBAL_H
#include "global.h"
#endif

#define	NCONN	20		/* Maximum number of open network connections */

extern uint32 Ip_addr;	/* Our IP address */
extern int Net_error;	/* Error return code */
#define	NONE		0	/* No error */
#define	CON_EXISTS	1	/* Connection already exists */
#define	NO_CONN		2	/* Connection does not exist */
#define	CON_CLOS	3	/* Connection closing */
#define	NO_MEM		4	/* No memory for TCB creation */
#define	WOULDBLK	5	/* Would block */
#define	NOPROTO		6	/* Protocol or mode not supported */
#define	INVALID		7	/* Invalid arguments */
#define NOROUTE         8       /* No route exists */

#ifndef TNOS_68K
#define	INET_EOL	"\r\n"	/* Standard Internet end-of-line sequence */
#else
#define	INET_EOL	"\r\l"	/* Standard Internet end-of-line sequence */
#endif

/* Codes for the tcp_open call */
#define	TCP_PASSIVE	0
#define	TCP_ACTIVE	1
#define	TCP_SERVER	2	/* Passive, clone on opening */

/* Local IP wildcard address */
#ifdef INADDR_ANY
#undef INADDR_ANY
#endif
#define	INADDR_ANY	0x0L

#if 1		/* was def UNIX */
#ifndef socket
#include "socket.h"
#endif
#endif
/* Socket structure */
struct socket {
	uint32 address;		/* IP address */
	int16 port;		/* port number */
};
#define	NULLSOCK	(struct socket *)0

/* Connection structure (two sockets) */
struct connection {
	struct socket local;
	struct socket remote;
};
/* In domain.c: */
uint32 resolve (const char *name);
uint32 resolve_mx (const char *name);
int   resolve_amx (char *name,uint32 not_thisone,uint32 Altmx[]);

/* In netuser.c: */
uint32 aton (const char *s);
char *inet_ntoa (uint32 a);
char *pinet (struct socket *s);
char *inet_ntobos (uint32 a);

#endif	/* _NETUSER_H */

