/* the structures used for minimal http statistics */

struct http_stats	{
	long	days;			/* days that stats are valid for */

	/* these are each 2 element arrays, [0] is requests, [1] is PBBS-specific requests */
	long	connects[2];		/* total cumulative connects */
	long	dailyconnects[2];	/* total connects today */

	/* these are for daily and weekly stats - 2 element arrays, as before */
	long	hourly[24][2];		/* hourly usage in 1/10 minute */
	long	daily[7][2];		/* daily usage in 1/10 minute */
	long	monthly[31][2];		/* day/month usage in 1/10 minute */
	long	yearly[12][2];		/* month/year usage in 1/10 minute */

	/* these are the current hour and day - not updated till period is complete */
	long	hour[2];		/* current hour's usage in 1/10 minute */
	long	day[2];			/* current day's usage in 1/10 minute */
	long	month[2];		/* current month's usage in 1/10 minute */

	/* last stats start time */
	time_t	start;

	/* last update time */
	time_t	last;
};

