/* version control information */
#include "global.h"
#include "ctype.h"
#ifndef VERSION_FILE_BUILD
#include "commands.h"
#include "mbuf.h"
#include "usock.h"
#include "files.h"
#else
/* redo this in case config.h undoes it */
#undef  VERSION_ON_FILE
#define VERSION_ON_FILE 1
#endif


#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: version.c,v 1.27 2000/05/09 16:48:29 brian Exp $";
#endif

#ifdef __ELF__
#define ELF "/ELF"
#else
#define ELF ""
#endif

#ifdef UNIX
char Version[] = "KO4KS-TNOS/Unix v"VERSION""ELF;
char shortversion[] = "TNOS"VERSION"/U";
char statversion[] = " TNOS/U v"VERSION" [%2d] ";
char statversion_flow[] = " TNOS/U v"VERSION" >%2d< ";
#else
#ifndef OPTIONAL
#define OPTIONAL
#endif
char Version[] = "KO4KS-TNOS v"VERSION;
char shortversion[] = "TNOS"VERSION;
char statversion[] = " TNOS v"VERSION" [%2d] ";
char statversion_flow[] = " TNOS v"VERSION" >%2d< ";
#endif

#if !defined(VERSION_ON_FILE) || defined(VERSION_FILE_BUILD)
#ifdef TNOS_68K
static char VIA[] = "standard serial I/O devices";
#else
#ifndef UNIX
static char VIA[] = "8250/16450/16550";
#endif
#endif
#endif

char Version2[] = "This version by Brian A. Lantz, KO4KS\n";

#ifdef BETA
#define STATE "beta-test"
#define TRAILER "                             distribute and DIE!!\n"
#else
#define STATE "  release"
#define TRAILER ""
#endif
char Tnosversion[] = "               T  N  O  S    -  Tampa Network Operating System\n                           "STATE" version "VERSION""ELF"\n"TRAILER"\n";

#if defined(ALLCMD) || defined(VERSION_ON_FILE)
extern void tdisplay_map (void);

int
doversion(int argc, char *argv[], void *p OPTIONAL)
{
#if defined(VERSION_ON_FILE) && !defined(VERSION_FILE_BUILD)
	if (argc > 1 && tolower (argv[1][0]) == 's')	/* short version */
		tprintf ("TNOS %s\n", Version);
	else	{
		(void) DisplayFile (VersionFile,Curproc->output);
		tdisplay_map ();
	}
#else
int k;

/* this is to quiet warnings when compiling as mkvers.c */
    if (argc || argv || p)
    	k = 0;


#ifdef VERSION_ON_FILE
/*lint -esym(652,tprintf) */
#define tprintf printf
#ifdef UNIX
#undef tputs
#endif
#define tputs(str) fputs(str, stdout)
#endif

#ifndef TNOS_68K
    tprintf("TNOS %s, compiled %s %s, containing:\n" ,Version,__DATE__,__TIME__);
#else
    tprintf("TNOS %s, containing:\n" ,Version);
#endif
	tputs("TCP Servers:");

#ifndef SERVERS
	tputs("  None !\n");
#endif /* ! SERVERS */

#ifdef SERVERS
	tputs("  SMTP  FINGER  FTP");

#ifdef MAILBOX
	tputs("  TELNET");
#endif /* MAILBOX */

#ifdef ALLSERV
	tputs("  TTYLINK  QUOTE  DISCARD  ECHO");
#ifdef RLOGINSERV
	tputs("  RLOGIN");
#endif /* RLOGINSERV */
#endif /* ALLSERV */

	tputs("\n            ");
#ifdef ALLSERV
	tputs("  TIME  DAYTIME");
#endif /* ALLSERV */

#ifdef CALLSERVER
	tputs("  CALLBOOK (CD-ROM)");
#endif /* CALLSERVER */

#ifdef SAMCALLB
	tputs("  CALLBOOK (SAM)");
#endif /* SAMCALLB */

#ifdef CONVERS
	tputs("  CONVERS");
#endif /* CONVERS */

#ifdef NNTPS
	tputs("  NNTP");
#endif /* NNTPS */

#ifdef POP2SERVER
	tputs("  POP2");
#endif /* POP2SERVER */

#ifdef POP3SERVER
	tputs("  POP3");
#endif /* POP3SERVER */

#ifdef RDATE
	tputs ("  RDATE");
#endif /* RDATE */

#ifdef TERMSERVER
	tputs ("  TERM");
#endif
 
	tputs("\n");

#endif /* SERVERS */


    tputs("TCP Clients:  SMTP");

#ifdef ALLCMD
    tputs("  FINGER");
#endif

#ifdef ALLSESSIONS
	tputs("  FTP  TELNET");
#endif /* ALLSESSIONS */

#ifdef ALLSERV
	tputs("  TTYLINK");
#endif /* ALLSERV */

	tputs("  QUOTE  TIME  DAYTIME\n");

#if (defined(SAMCALLB) || defined(CALLCLI) || defined(CONVERS) || defined(NNTP) || defined(NNTPS) || defined(POP2CLIENT) || defined(POP3CLIENT) || defined(RLOGINCLI) || defined(RDATE)) || defined(LOOKSESSION)
	tputs("            ");

#if defined(CALLCLI) || defined(SAMCALLB)
	tputs("  CALLBOOK");
#endif /* CALLCLI || SAMCALLB */

#ifdef CONVERS
	tputs("  CONVERS");
#endif /* CONVERS */

#if (defined(NNTP) || defined(NNTPS))
	tputs("  NNTP");
#endif /* NNTP || NNTPS */

#ifdef POP2CLIENT
	tputs("  POP2");
#endif /* POP2CLIENT */

#ifdef POP3CLIENT
	tputs("  POP3");
#endif /* POP3CLIENT */

#ifdef RLOGINCLI
	tputs("  RLOGIN");
#endif /* RLOGINCLI */

#ifdef LOOKSESSION
    	tputs("  LOOK");
#endif
#ifdef AXUI
	tputs("  AXUI");
#endif
	tputs("\n");
#endif /* LOOKSESSION || CALLCLI || CONVERS || NNTP || NNTPS || POP2CLIENT || POP3CLIENT || RLOGINCLI || RDATE */


#ifdef LZW
    tputs("    with LZW compression for TCP sockets\n");
#endif /* LZW */

#if (defined(TCPACCESS) || defined(IPACCESS))
	tputs("    with ");

#ifdef TCPACCESS
	tputs("TCP");
#endif /* TCPACCESS */

#if (defined(TCPACCESS) && defined(IPACCESS))
	tputs("/");
#endif /* TCPACCESS && IPACCESS */

#ifdef IPACCESS
    tputs("IP");
#endif /* IPACCESS */

	tputs(" access controls\n");
#endif /* TCPACCESS || IPACCESS */


	tputs("UDP Servers:");

#if (!defined(DSERVER) && !defined(SERVERS) && !defined(BOOTP))
	tputs("  None !");
#endif /* ! DSERVER && ! SERVERS */

#ifdef DSERVER
	tputs("  DOMAIN NAMESERVER");
#endif /* DSERVER */

#ifdef SERVERS
	tputs("  REMOTE");
#endif /* SERVERS */
#ifdef	BOOTP
	tputs("  BOOTP");
#endif
	tputs("\n");


#ifdef TIPMAIL
	tputs("TIP Mailbox Server");
#ifdef XMODEM
	tputs(" with Xmodem file transfer");
#endif /* XMODEM */
	tputs("\n");
#endif /* TIPMAIL */


#ifdef MAILBOX
	tputs("Full Service BBS");

#if (defined(RMAIL) || defined(EXPIRY) || defined(MAILFOR) || defined(MBFWD) || defined(RLINE) || defined(WPAGES))
	tputs(" with:\n ");
#endif /* RMAIL || EXPIRY || MAILFOR || MBFWD || RLINE || WPAGES */

	k = 0;
#ifdef RMAIL
	tputs("   Remote Mailer (RMAIL)  ");
	++k;
#endif
#ifdef EXPIRY
	tputs("   Message and BID expiry ");
	++k;
#endif /* EXPIRY */

#ifdef MAILFOR
	tputs("   'Mail For' beaconing   ");
	++k;
#endif /* MAILFOR */

/*lint -e774 */
#ifdef MBFWD
	if (!(k % 3))
		tputs("\n ");
	tputs("   AX.25 mail forwarding  ");
	++k;
#endif /* MBFWD */

#ifdef RLINE
	if (!(k % 3))
		tputs("\n ");
	tputs("   'R:-line' compatibility");
	++k;
#endif /* RLINE */

#ifdef WPAGES
	if (!(k % 3))
		tputs("\n ");
	tputs("   'Pseudo-White Pages'   ");
	++k;
#endif
#ifdef FBBFWD
	if (!(k % 3))
		tputs("\n ");
	tputs("   'FBB-style' forwarding ");
#ifdef FBBCMP
	tputs("with compression");
#else
	tputs("without compression");
#endif
#endif
#ifdef UKIP
	tputs("   'UKIP' enhancements ");
	++k;
#endif
	tputs("\n");

#endif /* MAILBOX */

#if (defined(CALLBOOK) || defined(AXIP) || defined(ENCAP))
	tputs("Internet Services:");

#if defined(CALLBOOK)
	tputs("  BBS Callbook Client");
#endif /* CALLBOOK */

#ifdef AXIP
	tputs("  AX.25 Digipeating (AXIP)");
#endif /* AXIP */

#ifdef ENCAP
	tputs("  IP Encapsulation");
#endif /* ENCAP */

	tputs("\n");
#endif /* CALLBOOK || AXIP || ENCAP */

	tputs("Assorted TNOS Features:\n");
	k = 0;
#ifdef CONVERS
	tputs("     Expanded Conference bridge        ");
	k++;
#endif
#ifdef REQSVR
	tputs("     Remote Request Server             ");
	k++;
#endif
	if (!(k % 2))
		tputs("\n");
	tputs("     ANSI Color Graphics               ");
	k++;
#ifdef SCREENSAVER
	if (!(k % 2))
		tputs("\n");
	tputs("     Local screen saver                ");
	k++;
#endif
#ifdef  MSDOS
	if (!(k % 2))
		tputs("\n");
	tputs("     Virtual Memory storage routines   ");
	k++;
#endif
#ifdef TUTOR
	if (!(k % 2))
		tputs("\n");
	tputs("     Information/News/Tutorial Services");
	k++;
#endif
#ifdef SCRIPTING
	if (!(k % 2))
		tputs("\n");
	tputs("     Command Session Scripting Commands");
	k++;
#endif
#ifdef CRONTAB
	if (!(k % 2))
		tputs("\n");
	tputs("     Crontab daemon                    ");
	k++;
#endif
#ifdef SQL
	if (!(k % 2))
		tputs("\n");
	tputs("     SQL server support                ");
	k++;
#endif
#ifdef NODECALL
	if (!(k % 2))
		tputs("\n");
	tputs("     TNODE application                 ");
	k++;
#endif
/*lint +e774 */
	tputs("\n");


#ifdef HOPCHECK
	tputs("Hopcheck IP path tracing\n");
#endif /* HOPCHECK */

#ifdef RIP
	tputs("RIP Routing Protocol\n");
#endif /* RIP */

#ifdef RSPF
	tputs("Radio Shortest Path First Protocol (RSPF)\n");
#endif /* RSPF */

#ifdef RARP
	tputs("Reverse Address Resolution Protocol (RARP)\n");
#endif /* RARP */

#ifdef ASY
#ifdef UNIX
    tputs("Generic termios interface driver\n");
#else
    tprintf("Generic async (%s) interface driver\n", VIA);
#endif

#if (defined(KISS) || defined(AX25) || defined(NRS))
	tputs("Async interface drivers:");

#ifdef KISS
	tputs("  KISS TNC");
#endif /* KISS */

#ifdef POLLEDKISS
	tputs ("  POLLED-KISS");
#endif /* POLLEDKISS */


#ifdef AX25
	tputs("  AX.25");
#endif /* AX25 */

#ifdef NRS
	tputs("  NET/ROM TNC");
#endif /* NRS */

	tputs("\n");
#endif /* KISS || AX25 || NRS */

#endif /* ASY */

#ifdef NETROM
	tputs("NET/ROM network interface\n");
#endif /* NETROM */

#if (defined(PPP) || defined(SLIP))
	tputs("Async IP drivers:");

#ifdef PPP
	tputs("  Point-to-Point (PPP)");
#endif /* PPP */

#ifdef SLIP
	tputs("  Serial Line (SLIP)");
#endif /* SLIP */

#ifdef DIALER
    tputs(" - with dialer code");
#endif /* DIALER */
	tputs("\n");

#ifdef VJCOMPRESS
    tputs("      with Van Jacobson compression\n");
#endif /* VJCOMPRESS */

#endif /* PPP || SLIP */

#ifdef PACKET
	tputs("FTP Software's PACKET driver interface\n");
#endif /* PACKET */

#ifdef ARCNET
	tputs("ARCnet via PACKET driver\n");
#endif /* ARCNET */

#ifdef DRSI
	tputs("DRSI PCPA low-speed driver\n");
#endif /* DRSI */

#ifdef EAGLE
    tputs("Eagle card 8530 driver\n");
#endif /* EAGLE */

#ifdef ETHER
#ifndef linux
    tputs("Generic ethernet driver\n");
#else
    tputs("Linux Kernel ethernet driver\n");
#endif
#endif /* ETHER */

#ifdef HAPN
	tputs("Hamilton Area Packet Network driver\n");
#endif /* HAPN */

#ifdef HS
	tputs("High speed (56 kbps) modem driver\n");
#endif /* HS */

#ifdef PACKETWIN
	tputs("Gracilis PackeTwin driver\n");
#endif /* PACKETWIN */

#ifdef PC_EC
	tputs("3-Com 3C501 Ethernet controller driver\n");
#endif /* PC_EC */

#ifdef PC100
	tputs("PAC-COM PC-100 driver\n");
#endif /* PC100 */

#ifdef PI
	tputs("PI SCC card with DMA driver (VE3IFB)\n");
#endif /* PI */

#ifdef SCC
    tputs("Generic SCC (8530) driver (PE1CHL)\n");
#endif /* SCC */

#ifdef SLFP
	tputs("SLFP via PACKET driver\n");
#endif /* SLFP */
    
#ifdef TRACE
	tputs("Hardware interface packet tracing code");
#ifdef MONITOR
	tputs(" - with user monitor mode");
#endif
	tputs("\n");
#endif /* TRACE */

#ifdef UNIX
    tputs("Linux/Unix/POSIX modifications by Brandon S. Allbery & Brian A. Lantz\n");
#endif
#ifdef __bsdi__
    tputs("Initial BSD/OS modifications by Dave VK2KFU and Kirk VE6KIK\n");
#endif

#ifdef MONITOR
    tputs("User port monitor trace mode\n");
#endif

#ifdef TTYCALL
    tputs("AX.25 ttylink mode\n");
#endif

#ifdef AXBCSTR
    tputs("AX.25 broadcast strings\n");
#endif

#ifdef FORTH
    tputs("SM0RGV Forth\n");
#endif

#ifdef PATCURSES
	tputs("Thomas Lucaw's color patches\n");
#endif

#endif

	return 0;
}
#endif /*ALLCMD*/
