/* Output from p2c, the Pascal-to-C translator */
/* From input file "box.p" */


/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1996 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/


#include "defs.h"

#define BOX_G
#include "box.h"


#ifndef TOOLS_H
#include "tools.h"
#endif

#ifndef SORT_H
#include "sort.h"
#endif

#ifndef MISC_OS_H
#include "misc_os.h"
#endif

#ifndef CRC_H
#include "crc.h"
#endif

#ifndef BOX_INOU_H
#include "box_inou.h"
#endif

#ifndef BOX_FILE_H
#include "box_file.h"
#endif

#ifndef BOX_MEM_H
#include "box_mem.h"
#endif

#ifndef BOX_SEND_H
#include "box_send.h"
#endif

#ifndef BOX_TIM_H
#include "box_tim.h"
#endif

#ifndef BOX_SYS_H
#include "box_sys.h"
#endif

#ifndef BOX_SF_H
#include "box_sf.h"
#endif

#ifndef BOX_SUB_H
#include "box_sub.h"
#endif

#ifndef BOX_SERV_H
#include "box_serv.h"
#endif

#ifndef BOXFSERV_H
#include "boxfserv.h"
#endif


Static void run_batch(short unr, Char *cmd);


/* ************************************************************************* */


void box_board(short unr, Char *board)
{
  if (boxrange(unr))
    strcpy(board, user[unr]->brett);
  else
    board[0] = '\0';
}


/* wird in PACKETL1 gebraucht, procedure pr_wprg3                        */

short box_s_chan(short unr)
{
  if (boxrange(unr))
    return (user[unr]->sendchan);
  else
    return nohandle;
}


/* wird in PACKETL1 gebraucht, procedure pr_wprg3 und pr_wprg2           */
/* der tempbinname wird hier als Zwischenspeicher fuer den #BIN#-Header  */
/* verwendet...                                                          */

void box_rtitle(boolean set_it, short unr, Char *rtitle)
{
  Char hs[256];

  if (!boxrange(unr))
    return;
  if (!set_it) {
    strcpy(rtitle, user[unr]->tempbinname);
    return;
  }
  if (strlen(rtitle) <= 80) {
    strcpy(user[unr]->tempbinname, rtitle);
    return;
  }
  strcpy(hs, rtitle);
  del_path(hs);
  strcpy(user[unr]->tempbinname, hs);
}


void box_ttouch(short unr)
{
  if (boxrange(unr)) {
    user[unr]->lastatime = clock_.ixtime;
    user[unr]->lastcmdtime = clock_.ixtime;
  }
}


/* ----------------------------------------------------------------- */

Static short in_readby(Char *call, Char *readby)
{
  Char w2[256];

  strcpy(w2, call);
  rspacing(w2, 6);
  cut(w2, 6);
  return strpos2(readby, w2, 1);
}


void add_eraseby(Char *call, indexstruct *header)
{
  Char w2[256];
  short x;
  Char STR1[256];

  if (*call == '\0')
    return;
  strcpy(w2, call);
  rspacing(w2, 6);
  cut(w2, 6);
  x = strpos2(header->readby, w2, 1);
  sprintf(w2, "-%s", strcpy(STR1, w2));
  if (x > 0)
    strdelete((void *)header->readby, x - 1, 7);
  if (strlen(header->readby) < 134) {
    strcat(header->readby, w2);
    return;
  }
  x = strpos2(header->readby, "!", 1);
  if (x > 0) {
    strdelete((void *)header->readby, x, 7);
    strcat(header->readby, w2);
  }
}


Static void add_readby(short unr, indexstruct *header, boolean add_lt)
{
  Char w2[256];
  short x;
  Char STR1[256];

  if (!boxrange(unr))
    return;
  strcpy(w2, user[unr]->call);
  rspacing(w2, 6);
  cut(w2, 6);
  x = strpos2(header->readby, w2, 1);
  if (x == 0) {
    if (user[unr]->in_reply)
      sprintf(w2, ",%s", strcpy(STR1, w2));
    else if (user[unr]->f_bbs)
      sprintf(w2, "$%s", strcpy(STR1, w2));
    else if (user[unr]->supervisor)
      sprintf(w2, "&%s", strcpy(STR1, w2));
    else if (!strcmp(user[unr]->call, header->dest))
      sprintf(w2, ".%s", strcpy(STR1, w2));
    else
      sprintf(w2, "!%s", strcpy(STR1, w2));
    if (strlen(header->readby) < 134)
      strcat(header->readby, w2);
    else {
      x = strpos2(header->readby, "!", 1);
      if (x > 0) {
	strdelete((void *)header->readby, x, 7);
	strcat(header->readby, w2);
      }
    }
  }

  if (user[unr]->in_reply)
    return;

  if (user[unr]->f_bbs || user[unr]->supervisor || user[unr]->rsysop)
    return;

  header->readcount++;
  header->lastread = clock_.ixtime;

  if (add_lt) {
    if (header->lifetime > 0 && header->lifetime < max_lt_inc)
      header->lifetime++;
  }

}


Static boolean check_search(boolean bidsearch, boolean fwdlist,
			    boolean wildcardsearch, Char *search,
			    indexstruct header)
{
  Char hs[256], w[256];

  strcpy(hs, header.betreff);
  upper(hs);
  w[0] = '\0';
  if (wildcardsearch)
    return (wildcardcompare(SHORT_MAX, search, header.absender, w) ||
	    wildcardcompare(SHORT_MAX, search, hs, w) ||
	    bidsearch && wildcardcompare(SHORT_MAX, search, header.id, w) ||
	    (fwdlist &&
	     (wildcardcompare(SHORT_MAX, search, header.dest, w) ||
	      wildcardcompare(SHORT_MAX, search, header.verbreitung, w))));
  else
    return (strpos2(header.absender, search, 1) > 0 ||
	    strpos2(hs, search, 1) > 0 ||
	    bidsearch && strpos2(header.id, search, 1) > 0 ||
	    (fwdlist && (strpos2(header.dest, search, 1) > 0 ||
			 strpos2(header.verbreitung, search, 1) > 0)));
}


void signalise_readlimit(short unr, boolean today, long MaxReadBuf,
			 Char *name, short von, short bis)
{
  Char hs[256], w1[256], w2[256];
  Char STR1[256];

  if (!user[unr]->smode) {
    wlnuser0(unr);
    show_prompt(unr);
    wlnuser0(unr);
  }
  if (today) {
    w_btext(unr, 74);
    sprintf(hs, "%ld", user[unr]->maxread_day >> 10);
    sprintf(hs, " %s \007", strcpy(STR1, hs));
    wlnuser(unr, hs);
    /*   end
         else begin
             lint2str(MaxReadBuf div 1024,hs);
             if is_g then
                 wlnuser(unr,concat('*** Auslesebeschraenkung von ',hs,' kBytes pro Kommando ueberschritten! ',#7))
             else
                 wlnuser(unr,concat('*** readout buffer limitation (',hs,' kBytes) exceeded! ',#7));
    */
  }
  if (user[unr]->smode)
    return;
  sprintf(w1, "%ld", von);
  sprintf(hs, "%s %s", name, w1);
  if (von < bis) {
    sprintf(w2, "%ld", bis);
    sprintf(hs + strlen(hs), "-%s", w2);
  }
  w_btext(unr, 75);
  sprintf(hs, " R %s \007", strcpy(STR1, hs));
  wlnuser(unr, hs);
  debug(2, unr, 41, hs);
  wlnuser(unr, hs);
}


Static long calc_readers_size(boolean is_call, indexstruct header)
{
  if (is_call) {
    if (*header.readby != '\0')
      return (strlen(header.readby) + 9);
    else
      return 0;
  } else
    return 0;
}


Static void show_readers(short unr, boolean is_call, unsigned short rc,
			 Char *r, boolean all)
{
  Char w[11];
  Char hs[256];
  boolean sv;
  short x;

  if (!boxrange(unr))
    return;
  sv = user[unr]->supervisor;
  if (is_call || all && sv) {
    if (rc > 0) {
      sprintf(hs, "Read: %ld ", rc);
    } else
      strcpy(hs, "Read: ");
    x = 1;
    while (x < strlen(r)) {
      strsub(w, r, x, 7);
      x += 7;
      if (sv || w[0] == '!' || w[0] == '.' || w[0] == ',') {
	strdelete((void *)w, 1, 1);
	sprintf(hs + strlen(hs), "%s ", w);
      }
      if (strlen(hs) > 72) {
	wlnuser(unr, hs);
	strcpy(hs, "Read: ");
      }
    }
    if (strlen(hs) > 6)
      wlnuser(unr, hs);
    return;
  }


  if (rc <= 0)
    return;
  sprintf(hs, "Read: %ld", rc);
  wlnuser(unr, hs);
}


void add_readday(short unr, long count)
{
  short x;

  if (count <= 0)
    return;
  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL) {
      if (!strcmp(user[x]->call, user[unr]->call))
	user[x]->read_today += count;
    }
  }
}


Static unsigned short ttl_lifetime(short unr, unsigned short lt, long rx)
{
  short ttl;

  if (boxrange(unr)) {
    if (user[unr]->ttl) {
      if (lt == 0) {
	ttl = 0;
	return ((unsigned short)ttl);
      }
      ttl = (short)lt - (short)((clock_.ixtime - rx) / 86400L);
      if (ttl < 1)
	ttl = 1;
      return ((unsigned short)ttl);
    } else
      return lt;
  } else
    return lt;
}


Static void true_lifetime(short unr, unsigned short lt, long rx, Char *s)
{
  sprintf(s, "%ld", ttl_lifetime(unr, lt, rx));
}


/* ---------------------------------------------------------------------------------------- */

#define rbsize 150*sizeof(indexstruct)

short search_by_bid(Char *brett, Char *bid, boolean hidden)
{
  indexstruct header, *hpointer;
  long isize, hsize, psize, asize;
  short k, mct;
  boolean hit;
  long WantedOffs, CurBufOffs;
  uchar *puffer;
  Char STR1[256];

  debug(3, 0, 36, bid);
  hsize = 0;
  puffer = NULL;
  if (strlen(bid) >= 13)
    return 0;
  hit = false;
  sprintf(STR1, "%s%s%c%s", indexdir, brett, extsep, idx_e);
  isize = sfsize(STR1);
  if (isize <= 0)
    return 0;
  mct = isize / sizeof(indexstruct);
  psize = isize;
  if (psize > rbsize)
    psize = rbsize;
  puffer = mymalloc(psize);
  sprintf(STR1, "%s%s%c%s", indexdir, brett, extsep, idx_e);
  k = sfopen(STR1, FO_READ);
  if (k < minhandle)
    return 0;
  
  if (puffer != NULL) {
    CurBufOffs = LONG_MAX;
    asize = 0;
    while (mct > 0 && hit == false) {

      WantedOffs = (mct - 1) * sizeof(indexstruct);
      if (WantedOffs < CurBufOffs || WantedOffs >= CurBufOffs + asize) {
	asize = 0;
	CurBufOffs = (WantedOffs - psize) + sizeof(indexstruct);
	if (CurBufOffs < 0)
	  CurBufOffs = 0;
	if (k >= minhandle) {
	  if (sfseek(CurBufOffs, k, SFSEEKSET) == CurBufOffs)
	    asize = sfread(k, psize, puffer);
	  else
	    asize = 0;
	}
      }
      hpointer = (indexstruct *)(&puffer[WantedOffs - CurBufOffs]);

      if (!check_hcs(*hpointer) || strcmp(hpointer->id, bid) ||
	  hpointer->deleted != hidden)
	mct--;
      else
	hit = true;
    }
    
    mymfreep(&puffer);
    
  } else {
    while (mct > 0 && hit == false && k >= minhandle) {
      read_index(k, mct, &header);
      if (!check_hcs(header) || strcmp(header.id, bid) ||
	  header.deleted != hidden)
	mct--;
      else
	hit = true;
    }
  }
  sfclose(&k);
  if (hit)
    return mct;
  return 0;
}

#undef rbsize

#define cpentries       checkblocksize

#define cpsize          (cpentries * sizeof(boxlogstruct))


boolean erase_by_bid(boolean reread, Char *sbid_, Char *eraseabsender_)
{
  boolean Result;
  Char sbid[256];
  Char eraseabsender[7];

  long cpstart;
  Char bid[13];
  boolean hit, double_;
  long seekpos, lognr, lastlog;
  short log, x, list;
  uchar *ipuffer;
  boxlogstruct logheader, *logptr;
  indexstruct header;
  Char hs[256], w[256];

  strcpy(sbid, sbid_);
  strcpy(eraseabsender, eraseabsender_);
  debug(3, 0, 37, sbid);
  Result = false;
  double_ = false;

  x = strlen(sbid);
  if ((unsigned)x >= 32 || ((1L << x) & 0x3ff8) == 0)
    return Result;

  if (sbid[0] == '$') {
    if (x <= 1)
      return Result;
    strsub(bid, sbid, 2, x - 1);
  } else if (x <= 12)
    strcpy(bid, sbid);
  else
    return Result;

  /* (not(reread)) ist ein flag fuer remote erase */

  if (bull_mem(bid, false) < 0)
    return (!double_);

  boxprotokoll("erase by bid");
  hit = false;
  lastlog = sfsize(boxlog) / sizeof(boxlogstruct);
  lognr = lastlog;
  log = sfopen(boxlog, FO_RW);
  cpstart = 0;

  ipuffer = Malloc(cpsize);

  if (log >= minhandle && lastlog > 0) {
    do {
      if ((lastlog & 127) == 0)   /*Watchdog resetten*/
	dp_watchdog(2, 4711);

      if (ipuffer == NULL) {
	read_log(log, lognr, &logheader);
	logptr = &logheader;
      } else {
	if (lognr < cpstart || cpstart == 0) {
	  if (cpstart == 0)
	    cpstart = lastlog - cpentries + 1;
	  else
	    cpstart -= cpentries;
	  if (cpstart <= 1)
	    cpstart = 1;
	  seekpos = (cpstart - 1) * sizeof(boxlogstruct);
	  if (sfseek(seekpos, log, SFSEEKSET) != seekpos)
	    goto _L1;
	  if (sfread(log, cpsize, ipuffer) <= 0)
	    goto _L1;
	  if (lognr < cpstart)
	    goto _L1;
	}
	logptr = (boxlogstruct *)
		 (&ipuffer[(lognr - cpstart) * sizeof(boxlogstruct)]);
      }


      if (!logptr->deleted) {
	if (!strcmp(logptr->bid, bid)) {
	  sprintf(hs, "%s%s%c%s", indexdir, logptr->brett, extsep, idx_e);
	  list = sfopen(hs, FO_RW);
	  if (list >= minhandle) {
	    read_index(list, logptr->idxnr, &header);
	    if (!strcmp(header.id, bid) && check_hcs(header)) {
	      if (reread && (header.msgflags & MSG_CUT) != 0 || !reread) {
		hit = true;
		header.deleted = true;
		header.erasetime = clock_.ixtime;
		if (!reread) {
		  if (!exist(r_erase_box)) {
		    strcpy(hs,
		      "Date  BID          Board      Nr. Subject                  By     Erase-BID");
		    append(r_erase_box, hs, true);
		    *hs = '\0';
		    append(r_erase_box, hs, true);
		  }
		  ix2string(clock_.ixtime, hs);
		  cut(hs, 5);
		  rspacing(bid, 12);
		  sprintf(hs + strlen(hs), " %s ", bid);
		  strcpy(w, logptr->brett);
		  rspacing(w, 8);
		  sprintf(hs + strlen(hs), "%s ", w);
		  sprintf(w, "%ld", logptr->idxnr);
		  lspacing(w, 5);
		  sprintf(hs + strlen(hs), "%s %s", w, header.betreff);
		  cut(hs, 58);
		  rspacing(hs, 59);
		  append(r_erase_box, hs, false);
		  header.eraseby = EB_REMOTE;
		  add_eraseby(eraseabsender, &header);
		} else {
		  bull_mem(bid, true);
		  header.eraseby = EB_DOUBLESYSOP;
		}
		write_index(list, logptr->idxnr, &header);
		logptr->deleted = true;
		write_log(log, lognr, logptr);
	      }
	      if (reread && (header.msgflags & MSG_CUT) == 0 || !reread)
		double_ = true;
	    }

	    sfclose(&list);
	  }
	}
      }
      lognr--;
    } while (!(lognr <= 0 || hit));
    sfclose(&log);
  }

_L1:
  if (ipuffer != NULL)
    mymfreep(&ipuffer);
  sfclose(&log);

  return (!double_);
}

#undef cpentries
#undef cpsize


void check_remote_erase(long *seekp)
{
  short k;
  long tc;
  Char hs[256], fn[256];
  Char absender[256], id1[256], rxfrom[256], id2[256];

  tc = statclock();
  sprintf(fn, "%srerase%ctmp", boxstatdir, extsep);
  k = sfopen(fn, FO_READ);
  if (k >= minhandle) {
    if (sfseek(*seekp, k, SFSEEKSET) == *seekp) {
      do {
	if (file_to_string(k, hs)) {
	  *seekp += strlen(hs) + 1;
	  get_word(hs, absender);
	  cut(absender, 6);
	  get_word(hs, id1);
	  get_word(hs, rxfrom);
	  get_word(hs, id2);
	  if (!erase_by_bid(false, id2, absender)) {
	    rspacing(id1, 12);
	    rspacing(absender, 6);
	    sprintf(hs, "%s %s", absender, id1);
	    append(r_erase_box, hs, true);
	  }
	} else
	  *seekp = 0;
      } while (*seekp != 0 && statclock() - tc < ttask);
    } else
      *seekp = 0;
    sfclose(&k);
  } else
    *seekp = 0;

  if (*seekp == 0) {
    sfdelfile(fn);
    new_remote_erases = false;
  }
}


void add_remote_erase(Char *absender, Char *id1, Char *rxfrom, Char *id2)
{
  Char hs[256];
  Char STR7[256];

  sprintf(hs, "%s %s %s %s", absender, id1, rxfrom, id2);
  sprintf(STR7, "%srerase%ctmp", boxstatdir, extsep);
  append(STR7, hs, true);
  new_remote_erases = true;
}


void set_sys_fwd(Char b, Char *rxfrom1, Char *absender1, Char *id0, Char *id1,
		 Char *verbr)
{
  indexstruct header;
  Char w[256];

  debug(5, 0, 38, id1);
  strcpy(header.verbreitung, verbr);
  strcpy(header.absender, absender1);
  if (*id0 == '\0')
    new_bid(header.id);
  else
    strcpy(header.id, id0);
  strcpy(header.betreff, id1);
  header.fwdct = 0;
  header.pmode = 0;
  header.start = 0;
  header.size = 0;
  header.packsize = 0;
  header.lifetime = 0;
  header.txlifetime = 0;
  header.deleted = false;
  header.rxdate = clock_.ixtime;
  header.txdate = 0;
  strcpy(header.rxfrom, rxfrom1);
  header.rxqrg = boxaktqrg();
  header.level = 1;
  header.fwdct = 0;
  header.msgtype = 'B';
  header.erasetime = 0;
  header.lastread = 0;
  header.readcount = 0;
  *header.readby = '\0';
  header.eraseby = 0;
  header.infochecksum = 0;
  header.bcastchecksum = 0;
  header.firstbyte = 0;
  header.hver = headervn;
  if (strcmp(header.rxfrom, Console_call))
    header.msgflags = MSG_SFRX;
  else
    header.msgflags = MSG_MINE;
  write_msgid(-1, header.id);
  create_hcs(&header);
  sprintf(w, "%c", b);
  vermerke_sf(-1, false, w, rxfrom1, "*", header, "");
}


/* wird nur fuer X und T verwendet: */

#define LookAheadBufSize 150*sizeof(indexstruct)

void delete_brett_by_bid(Char *brett, Char *sfcall, Char *bid,
			 boolean release, boolean hidden)
{
  indexstruct header, *rpointer;
  short list, k, lv;
  uchar *ipuffer;
  long CurBufOffs, WantedOffs, TotalSize;
  long isize;
  Char whatc;
  boolean i_changed;
  Char fname[256];

  debug(4, 0, 39, bid);
  
  if (!strcmp(brett, "X")) {
    if (release)
      whatc = 'R';
    else if (hidden)
      whatc = 'E';
    else
      whatc = 'U';
    alter_fwd(whatc, bid, 0, "", sfcall);
    return;
  }
  
  sprintf(fname, "%s%s%c%s", indexdir, brett, extsep, idx_e);
  if (!exist(fname))
    return;
    
  isize = 0;
  i_changed = false;
  TotalSize = sfsize(fname);
  lv = TotalSize / sizeof(indexstruct);
  CurBufOffs = 0;
  list = nohandle;
  ipuffer = NULL;
  ipuffer = mymalloc(LookAheadBufSize);
  if (ipuffer != NULL) {
    CurBufOffs = LONG_MAX;
    isize = 1;
  }
   
  rpointer = &header;   /*bleibt ggf. gleich*/

  list = sfopen(fname, FO_RW);

  if (list < minhandle && ipuffer == NULL) {
    sfclosedel(&list);
    return;
  }
  
  k = 1;
  while (k <= lv) {
    if (ipuffer == NULL)
      read_index(list, k, &header);
    else {
      WantedOffs = (k - 1) * sizeof(indexstruct);
      if (WantedOffs < CurBufOffs || WantedOffs >= CurBufOffs + isize) {
	if (i_changed && isize >= sizeof(indexstruct)) {
	  if (list >= minhandle) {
	    if (sfseek(CurBufOffs, list, SFSEEKSET) == CurBufOffs)
	      sfwrite(list, isize, ipuffer);
	  }
	}
	i_changed = false;
	isize = 0;
	if (list >= minhandle) {
	  CurBufOffs = sfseek(WantedOffs, list, SFSEEKSET);
	  if (CurBufOffs == WantedOffs)
	    isize = sfread(list, LookAheadBufSize, ipuffer);
	  else
	    isize = 0;
	}
      }
      rpointer = (indexstruct *)(&ipuffer[WantedOffs - CurBufOffs]);
    }

    if (!strcmp(rpointer->id, bid) && check_hcs(*rpointer)) {
      if (release) {
	rpointer->msgflags &= ~(MSG_SFHOLD | MSG_LOCALHOLD);
	alter_log(true, rpointer->msgnum, rpointer->msgflags, '!', "");
      } else {
	rpointer->deleted = hidden;
	if (rpointer->deleted)
	  whatc = 'E';
	else
	  whatc = 'U';
	alter_log(true, rpointer->msgnum, rpointer->msgflags, whatc, "");
      }

      if (ipuffer == NULL)
	write_index(list, k, rpointer);
      else {
	create_hcs(rpointer);
	i_changed = true;
      }
    }

    k++;
  }

  if (ipuffer == NULL) {
    sfclose(&list);
    return;
  }
  if (i_changed && isize >= sizeof(indexstruct)) {
    if (list >= minhandle) {
      if (sfseek(CurBufOffs, list, SFSEEKSET) == CurBufOffs)
	sfwrite(list, isize, ipuffer);
    }
  }
  sfclose(&list);
  mymfreep(&ipuffer);
}

#undef LookAheadBufSize

Static void erase_brett(short unr, Char *name_, short von, short bis,
			Char *option_, Char *search_, boolean release,
			boolean kill)
{
  Char name[9];
  Char option[256];
  Char search[256];
  Char index[256], w[256];
  indexstruct header;
  short lv, k, x, list;
  uchar *dptr;
  long dummy;
  long ect;
  Char whatc;
  boolean valid, e_mode, bidsearch, inrboards, loginsearch, noperm,
	  wcsearch;

  strcpy(name, name_);
  strcpy(option, option_);
  strcpy(search, search_);
  debug(2, unr, 40, name);
  if (!boxrange(unr))
    return;
  
  if (!strcmp(name, "X"))
    recompile_fwd();

  noperm = false;

  loginsearch = (strpos2(option, "!", 1) > 0);
  if (loginsearch) {
    if (release || callsign(name)) {  /*loginsearch nur bei usermails*/
      von = 1;
      bis = SHORT_MAX;
    } else {
      loginsearch = false;
      von = 0;
      bis = 0;
    }
  }

  if (von == 0 || bis == 0) {
    wln_btext(unr, 37);
    return;
  }

  if (user[unr]->lastprocnumber > 0) {
    von = user[unr]->lastprocnumber;
    ect = user[unr]->lastprocnumber3;
    user[unr]->lastprocnumber = 0;
  } else
    ect = 0;

  lv = user[unr]->lastprocnumber2;
  user[unr]->lastprocnumber2 = 0;
  if (lv == 0)
    lv = last_valid(unr, name, false, &dptr, &dummy);

  sprintf(index, "%s%s%c%s", indexdir, name, extsep, idx_e);
  list = sfopen(index, FO_RW);
  if (list >= minhandle && lv > 0) {
    bidsearch = (strpos2(option, "$", 1) > 0);
    inrboards = may_sysaccess(unr, name);
    e_mode = (strpos2(option, "+", 1) > 0 && user[unr]->supervisor);
	/* rem-sys's duerfens nicht */

    copy_eralog(true);
    if (bis > lv)
      bis = lv;

    if (create_syslog && ect == 0 && inrboards &&
	strcmp(name, user[unr]->call))
      append_syslog(unr);

    wcsearch = (*search != '\0' && strpos2(search, "*", 1) > 0);

    for (k = von; k <= bis; k++) {
      if (k != von && ect > 0 && statclock() - user[unr]->cputime >= ttask) {
	user[unr]->lastprocnumber = k;
	user[unr]->lastprocnumber2 = lv;
	user[unr]->lastprocnumber3 = ect;
	goto _L1;
      }

      if (k % 10 == 0)
	dp_watchdog(2, 4711);
      read_index(list, k, &header);
      if ((!strcmp(header.absender, user[unr]->call) ||
	   !strcmp(name, user[unr]->call) ||
	   inrboards) && (check_hcs(header) || kill)) {
	if (header.deleted == user[unr]->hidden) {
	  if (loginsearch)
	    valid = (header.rxdate > user[unr]->lastdate);
	  else if (*search != '\0')
	    valid = check_search(bidsearch, false, wcsearch, search, header);
	  else
	    valid = true;

	  if (valid) {
	    if (release) {
	      header.msgflags &= ~(MSG_SFHOLD | MSG_LOCALHOLD);
	      alter_log(true, header.msgnum, header.msgflags, '!', "");
	      strcpy(w, "X");
	      delete_brett_by_bid(w, "", header.id, true, false);

	    } else {
	      header.deleted = !user[unr]->hidden;

	      if (header.deleted) {
		header.erasetime = clock_.ixtime;
		if (!strcmp(name, user[unr]->call))
		  header.eraseby = EB_RECEIVER;
		else if (!strcmp(header.absender, user[unr]->call))
		  header.eraseby = EB_SENDER;
		else if (user[unr]->supervisor)
		  header.eraseby = EB_SYSOP;
		else if (inrboards)
		  header.eraseby = EB_RSYSOP;
		else
		  header.eraseby = EB_NONE;
		add_eraseby(user[unr]->call, &header);

		if (!strcmp(name, "M"))
		  clear_uf_cache(header.absender);

	      } else {  /* unerase */
		header.erasetime = 0;
		header.eraseby = EB_NONE;
		x = 1;
		while (x > 0) {
		  x = strpos2(header.readby, "-", 1);
		  if (x > 0)
		    strdelete((void *)header.readby, x, 7);
		}
	      }
	    }



	    write_index(list, k, &header);

	    if (!release && strcmp(name, "M") && strcmp(name, "X")) {
	      /*   unhpath(header.verbreitung,hmbx); */
	      if (header.deleted)
		whatc = 'E';
	      else
		whatc = 'U';
	      alter_log(true, header.msgnum, header.msgflags, whatc, "");

	      if (kill)
		bull_mem(header.id, true);

	      if (header.deleted && *e_m_verteiler != '\0' &&
		  (!strcmp(header.absender, user[unr]->call) || e_mode) &&
		  !callsign(header.dest) &&
		  (header.fwdct > 0 || *header.rxfrom != '\0' || e_mode) &&
		  (user[unr]->is_authentic || holddelay == 0) &&
		  !user[unr]->hidden)
	      {   /* remote-erase by sysop */
		/* and (hmbx <> console_call) */
		set_sys_fwd('E', Console_call, Console_call, "", header.id,
			    e_m_verteiler);
		if (e_mode && ect == 0)
		  wln_btext(unr, 76);
	      }
	      /* remote-erase by sysop */

	      if (header.deleted && *pacsrv_verteiler != '\0')
		set_sys_fwd('E', Console_call, Console_call, "", header.id,
			    pacsrv_verteiler);

	      strcpy(w, "X");
	      if (header.fwdct == 0 || header.deleted)
		delete_brett_by_bid(w, "", header.id, false, header.deleted);

	    }
	    ect++;
	  }
	}

      } else
	noperm = true;

    }


_L1:
    sfclose(&list);
    copy_eralog(false);

    if (user[unr]->lastprocnumber != 0)
      return;

    if (ect > 0) {
      if (release) {
	w_btext(unr, 77);
      } else {
        if (user[unr]->hidden)
	  w_btext(unr, 78);
        else
	  w_btext(unr, 18);
      }
      if (ect == 1)
        sprintf(w, " (%ld message)", ect);
      else
        sprintf(w, " (%ld messages)", ect);
      wlnuser(unr, w);
      return;
    }
    if (noperm)
      wln_btext(unr, 7);
    else
      wln_btext(unr, 37);
    return;
  }

  sfclose(&list);
  if (lv == 0)
    no_files(unr, name);
  else if (lv == -1)
    wln_btext(unr, 147);


}


Static void release_hold(short unr, Char *brett, short s, short e,
			 Char *option, Char *search)
{
  erase_brett(unr, brett, s, e, option, search, true, false);
}


Static void unerase_users_mails(short unr)
{
  boolean hstat;
  Char ds[256];

  if (!boxrange(unr))
    return;
  *ds = '\0';
  hstat = user[unr]->hidden;
  user[unr]->hidden = true;
  erase_brett(unr, user[unr]->call, 1, SHORT_MAX, ds, ds, false, false);
  user[unr]->hidden = hstat;
}


/* Die Blocksize sollte mindestens so gross sein  */
/* wie die zu erwartende Headerlaenge der Mails   */
/* Mit 16K nur fuer die Header sollte man gut     */
/* geruestet sein hi.                             */

#define blocksize       16384
#define maxrcount       5


unsigned short read_brett(short unr, short outch, Char *board, short von,
			  short bis, Char *option, Char *search,
			  long sfoffset, indexstruct *header)
{

  /* gibt bodychecksumme zurueck */

  short outchan, ct, bbsmode, ki, kx, ka, ko;
  long hl;
  boolean ok;
  long bstart, err;
  uchar *copybuf, *nmem;
  long nsize;
  uchar *rp;
  short lv;
  boolean sf, sf_pack, valid;
  long sf_psize;
  boolean sf_ishuff, rheader, loginsearch;
  short unpackerr;
  uchar *dptr;
  long dummy;
  boolean is_binary, bcast, is_call, export;
  long bct, rs, hsize, fsize;
  boolean hidflag;
  unsigned short bodychecksum;
  short i, rcount;
  uchar fbyte;
  boolean add_lt, inc_read, fill_readlog, fill_readlog1, bidsearch,
	  with_readers, only_headers, ack_msg, none_displayed, check_readday,
	  check_rcount, readday_ok, wcsearch, ownboard, tpksf;
  unsigned short ics;
  userstruct uf;
  Char indexname[256];
  Char temp5[256];
  Char temp3[256], temp4[256];
  Char temp2[256], temp1[256];
  Char status[256];
  Char infoname[256];
  Char hs[256], hs1[256];
  Char srline[256];
  Char STR1[34];
  Char STR7[256];
  short FORLIM;
  userstruct *WITH;
  Char STR14[30];


  debug(2, unr, 42, board);
  export = false;
  sf = false;
  sf_pack = false;
  loginsearch = false;
  hidflag = false;
  add_lt = false;
  inc_read = false;
  none_displayed = true;
  bbsmode = 0;
  rheader = (strchr(option,'+') != NULL);
  bcast = (strchr(option, 'B') != NULL);
  bidsearch = (strchr(option, '$') != NULL);
  with_readers = (strchr(option, ':') != NULL);
  only_headers = (strchr(option, '=') != NULL);
  tpksf = (strchr(option, 'T') != NULL);
  outchan = outch;
  rcount = 0;
  bodychecksum = 0;
  is_call = callsign(board);
  wcsearch = (strchr(search, '*') != NULL);

  if (!bcast) {
    hidflag = user[unr]->hidden;
    export = (user[unr]->action == 76);
    sf = (!export && user[unr]->f_bbs);

    if (sf) {
      bbsmode = user[unr]->fwdmode;
      sf_pack = (bbsmode > 0);
    }

    if (tpksf) {
      if (user[unr]->fwdmode == 0)
        user[unr]->fwdmode = 1;
      bbsmode = user[unr]->fwdmode;
      sf_pack = true;
    }

    /* zur Unterdrueckung der zu sendenden Daten im Verbindungsfenster: */
    if (sf || tpksf)
      boxsetboxbin(user[unr]->pchan, true);


    loginsearch = (!sf && !tpksf && strchr(option, '!') != NULL);
    if (loginsearch) {
      von = 1;
      bis = SHORT_MAX;
    }

  }


  check_rcount = (boxrange(unr) && !bcast && !export && outch < minhandle &&
		  (!sf || tpksf));

  fill_readlog1 = (check_rcount && !user[unr]->console && !only_headers);

  fill_readlog = (create_readlog && fill_readlog1);

  check_readday = (fill_readlog1 && !user[unr]->supervisor &&
		   !(user[unr]->rsysop &&
		     in_rsysops_boards(user[unr]->call, board)));

  ownboard = (export || is_call && unr > 0 && !strcmp(board, user[unr]->call));

  if (unr > 0 && !bcast && !export && !only_headers &&
      (!user[unr]->console || !strcmp(user[unr]->call, board)))
    inc_read = true;

  if (inc_read && max_lt_inc > 0 && (!sf || tpksf) && !is_call)
    add_lt = true;

  uf.readlock = 0;
  if (unr > 0 && !bcast && !export && (!sf || tpksf) && is_call) {
    load_userfile(true, false, board, &uf);
    if (*uf.call == '\0')
      uf.readlock = 2;
  }

  if (check_rcount) {
    if (user[unr]->lastprocnumber > 0) {
      von = user[unr]->lastprocnumber;
      user[unr]->lastprocnumber = 0;
      none_displayed = false;
    }
  }

  if (*board == '\0' || von <= 0 || bis <= 0)
    return bodychecksum;
  if (strlen(board) <= 1 &&
      (strlen(board) != 1 || board[0] == 'M' || board[0] == 'X'))
    return bodychecksum;

  sprintf(indexname, "%s%s%c%s", indexdir, board, extsep, idx_e);
  sprintf(infoname, "%s%s%c%s", infodir, board, extsep, inf_e);

  if (sf && !tpksf || bcast || export)
    lv = sfsize(indexname) / sizeof(indexstruct);
  else if (check_rcount) {
    lv = user[unr]->lastprocnumber2;
    user[unr]->lastprocnumber2 = 0;
    if (lv == 0)
      lv = last_valid(unr, board, false, &dptr, &dummy);
  } else
    lv = last_valid(unr, board, false, &dptr, &dummy);

  rp = NULL;

  if (lv > 0) {
    sprintf(temp1, "%sINFO%cR", tempdir, extsep);
    sprintf(temp2, "%s2", temp1);
    sprintf(temp4, "%s4", temp1);
    sprintf(temp5, "%s5", temp1);
    strcat(temp1, "1");

    if (inc_read)
      kx = sfopen(indexname, FO_RW);
    else
      kx = sfopen(indexname, FO_READ);
  } else
    kx = nohandle;

  if (kx >= minhandle && lv > 0) {
    ki = sfopen(infoname, FO_READ);
    if (ki >= minhandle) {
      if (bis > lv)
	bis = lv;
      FORLIM = bis;
      for (ct = von; ct <= FORLIM; ct++) {
	fbyte = 0;

	if (check_rcount) {
	  if (!none_displayed &&
	      (rcount >= maxrcount ||
	       boxspoolstatus(user[unr]->tcon, user[unr]->pchan, -1) >= 30000 ||
	       statclock() - user[unr]->cputime >= ttask * 4)) {
	    user[unr]->lastprocnumber = ct;

	    user[unr]->lastprocnumber2 = lv;
	    goto _L1;
	  }
	}

	if (check_readday)
	  readday_ok = ((user[unr]->maxread_day == 0 &&
			 all_maxread_day > user[unr]->read_today) ||
			user[unr]->maxread_day > user[unr]->read_today);
	else
	  readday_ok = true;

	if (unr > 0 && !bcast && !export && (!user[unr]->f_bbs || tpksf) &&
	    !user[unr]->console && !user[unr]->supervisor && !readday_ok) {
		signalise_readlimit(unr, !readday_ok, MaxReadBuf, board, ct,
				    bis);
	  goto _L1;
	}
	dp_watchdog(2, 4711);   /* Watchdog resetten */
	read_index(kx, ct, header);

	if ((header->deleted == hidflag || sf && !tpksf || bcast) &&
	    check_hcs(*header)) {
	  if (bcast || sf)
	    valid = true;
	  else if (loginsearch) {
	    valid = (header->rxdate > user[unr]->lastdate);
	    if (*search != '\0') {
	      if (valid)
		valid = check_search(bidsearch, false, wcsearch, search,
				     *header);
	    }
	  } else if (*search != '\0')
	    valid = check_search(bidsearch, false, wcsearch, search, *header);
	  else
	    valid = true;

	  /* ------------------------------------------------------------ */

	  if (valid && (is_call || header->msgtype != 'B') && unr > 0 &&
	      !user[unr]->supervisor && (!sf || tpksf) && !bcast && !export) {
	    unhpath(header->verbreitung, hs);

	    if (ufilhide || uf.readlock == 2 || strcmp(hs, Console_call))
	      valid = (ownboard ||
		       !strcmp(header->absender, user[unr]->call) ||
		       !strcmp(header->dest, user[unr]->call));
	    else if (uf.readlock == 1)
	      valid = (ownboard ||
		       !strcmp(header->absender, user[unr]->call) ||
		       !strcmp(header->dest, user[unr]->call) ||
		       in_readby(board, header->readby) > 0);
	  }

	  if (valid) {
	    if (check_rcount)
	      rcount++;

	    none_displayed = false;

	    if (check_readday)
	      add_readday(unr, header->size);

	    if (fill_readlog) {
	      sprintf(hs, "%s %ld <%s $%s",
		      board, ct, header->absender, header->id);
	      append_readlog(unr, hs);
	    }

	    if (inc_read) {
	      add_readby(unr, header, add_lt);

	      write_index(kx, ct, header);

	    }


	    is_binary = ((header->pmode & TBIN) != 0);
	    ack_msg = (header->msgtype == 'A');

	    if (!bcast) {
	      if (!sf && !(export && is_binary)) {
		if (boxrange(unr)) {
		  WITH = user[unr];
		  strcpy(WITH->reply_brett, board);
		  WITH->reply_nr = ct;

		  header->lifetime = ttl_lifetime(unr, header->lifetime,
						  header->rxdate);

		  create_status(calc_readers_size(is_call, *header), false,
				header->dest, *header, status);
		  if (only_headers)
		    sprintf(status, "|%s", strcpy(STR7, status));
		  if (outchan >= minhandle)
		    string_to_file(&outchan, status, true);
		  else
		    wlnuser(unr, status);
		}
	      }


	      if (outchan >= minhandle)
		string_to_file(&outchan, header->betreff, true);
	      else if (!(export && is_binary)) {
		if (!sf_pack)
		  wlnuser(unr, header->betreff);
	      }

	    }


	    if (sf) {
	      if (user[unr]->sf_level < 3)
		boxspoolfend(user[unr]->pchan);
	    }

	    srline[0] = '\0';

	    if (sf || bcast) {
	      if (with_rline
	          &&
		  (!no_rline_if_exterior ||
		   !strcmp(header->rxfrom, Console_call) ||
		   *header->rxfrom == '\0')
		  &&
		  (!ack_msg
		   || ((header->msgflags & MSG_MINE) != 0)
		   || (sf && (strchr(user[unr]->SID, 'A') == NULL))
		   || (sf && (strchr(user[unr]->SID, 'M') == NULL))
		  )
		 ) {
		/* nur die erste Box setzt bei ACK-Files ihren Header ein */
		ixdatum2string(header->rxdate, hs);
		sprintf(hs1, "%c%c%c%c%c%c/",
			hs[6], hs[7], hs[3], hs[4], hs[0], hs[1]);
		ixzeit2string(header->rxdate, hs);
		sprintf(hs1 + strlen(hs1), "%c%c%c%cz",
			hs[0], hs[1], hs[3], hs[4]);
		sprintf(hs, "R:%s @:%s", hs1, ownhiername);
		sprintf(hs + strlen(hs), " [%s", ownfheader);
		cut(hs, 56);
		sprintf(hs + strlen(hs), "] DP%s $:%s", dp_vnr, header->id);
		cut(hs, 79);

		if (sf_pack) {
		  strcpy(srline, hs);

		} else if (bcast) {
		  for (i = 0; hs[i] != '\0'; i++)
		    checksum16(hs[i], &bodychecksum);
		  checksum16(13, &bodychecksum);
		  checksum16(10, &bodychecksum);

		  if (outchan >= minhandle)
		    string_to_file(&outchan, hs, true);
		} else {
		  wlnuser(unr, hs);
		  if (user[unr]->sf_level < 3)
		    boxspoolfend(user[unr]->pchan);
		}

	      }
	    } else if (*header->id != '\0' && !(export && is_binary)) {
	      if (outchan >= minhandle) {
		if (header->msgtype == 'B') {
		  sprintf(STR1, "*** Bulletin-ID: %s ***", header->id);
		  string_to_file(&outchan, STR1, true);
		} else {
		  sprintf(STR1, "*** Message-ID: %s ***", header->id);
		  string_to_file(&outchan, STR1, true);
		}
		if (rheader) {
		  if (*header->rxfrom != '\0') {
		    sprintf(STR14, "*** Received from %s ***", header->rxfrom);
		    string_to_file(&outchan, STR14, true);
		  }
		}
		string_to_file(&outchan, "", true);
	      } else {
		if (header->msgtype == 'B') {
		  sprintf(STR1, "*** Bulletin-ID: %s ***", header->id);
		  wlnuser(unr, STR1);
		} else {
		  sprintf(STR1, "*** Message-ID: %s ***", header->id);
		  wlnuser(unr, STR1);
		}
		if (rheader) {
		  if (*header->rxfrom != '\0') {
		    sprintf(STR14, "*** Received from %s ***", header->rxfrom);
		    wlnuser(unr, STR14);
		  }
		}
		wlnuser0(unr);
		if (!rheader)
		  show_readers(unr, is_call, header->readcount,
			       header->readby, with_readers);
	      }
	    }


	    /* --------------------------------------------------------------------- */

	    unpackerr = 0;
	    sf_ishuff = false;
	    err = sfseek(header->start, ki, SFSEEKSET);
	    if (export)
	      user[unr]->tempbinname[0] = '\0';

	    /* ----------------- Wollen wir lieber auf Disk entpacken ? ------------ */

	    if (header->size > maxram() - 500 ||
		header->size > 100000L && header->size > maxavail__() - 500) {
	      /* -------------------- Verarbeitung auf Disk -------------------------- */

	      debug(3, unr, 42, "on disk");
	      dpgetmem(&copybuf, blocksize);
	      if (copybuf != NULL) {
		ka = sfcreate(temp1, FC_FILE);
		if (ka >= minhandle) {
		  if (header->pmode == 0 && *srline != '\0' && sf_pack) {
		    string_to_file(&ka, srline, true);
		    sf_ishuff = true;
			/* das flag wird hier anders verwendet*/
		  }  /* als der name vermuten laesst        */
		  else
		    sf_ishuff = false;

		  ok = true;
		  hsize = 0;
		  ics = 0;
		  rs = header->packsize;
		  while (rs > 0 && ok) {
		    if (rs > blocksize)
		      rs = blocksize;
		    bct = sfread(ki, rs, copybuf);
		    if (header->infochecksum != 0)
		      checksum16_buf(copybuf, bct, &ics);
		    if (hsize == 0)
		      fbyte = copybuf[0];
		    if (fbyte == header->firstbyte &&
			sfwrite(ka, bct, copybuf) == bct)
		      hsize += bct;
		    else
		      ok = false;
		    rs = header->packsize - hsize;
		  }

		  sfclose(&ka);

		  if (hsize != header->packsize) {
		    sprintf(hs, "%s %ld : read error (2)",
			    board, ct);
		    debug(0, unr, 42, hs);
		    bodychecksum = 0xffffL;
		  } else if (header->infochecksum != ics) {
		    sprintf(hs, "%s %ld : info checksum error (2)",
			    board, ct);
		    debug(0, unr, 42, hs);
		    bodychecksum = 0xffffL;
		  } else {
		    if ((header->pmode & PM_HUFF2) != 0) {
		      huffpacker(false, temp1, temp2, false);
		      sfdelfile(temp1);
		      strcpy(temp3, temp2);
		    } else
		      strcpy(temp3, temp1);

		    if (sf_pack) {
		      hsize = fsize;   /* ist ein Flag ... */
		      if (!sf_ishuff) {
			if (*srline != '\0') {
			  fsize = sfsize(temp3);
			  ka = sfopen(temp3, FO_READ);
			  if (ka >= minhandle) {   /* flag ... */
			    ko = sfcreate(temp4, FC_FILE);
			    if (ko >= minhandle) {
			      string_to_file(&ko, srline, true);
			      hsize = 0;
			      ok = true;
			      rs = fsize;
			      while (rs > 0 && ok) {
				if (rs > blocksize)
				  rs = blocksize;
				bct = sfread(ka, rs, copybuf);
				if (sfwrite(ko, bct, copybuf) == bct)
				  hsize += bct;
				else
				  ok = false;
				rs = fsize - hsize;
			      }
			      sfclose(&ko);
			      if (hsize != fsize)
				debug(0, unr, 42, "file error 2");
			    } else
			      hsize = fsize + 1;
			    sfclose(&ka);
			    sfdelfile(temp3);
			    strcpy(temp3, temp4);
			  } else
			    hsize = fsize + 1;

			}

		      }

		      if (hsize == fsize) {
			huffpacker(true, temp3, temp5, true);
			sfdelfile(temp3);
			send_pfbbdisk(bbsmode, unr, sfoffset, temp5,
				      header->betreff);
			boxspoolread();
		      } else
			bodychecksum = 0xffffL;

		      sfdelfile(temp5);
		    } else {
		      fsize = sfsize(temp3);
		      ka = sfopen(temp3, FO_READ);
		      if (ka >= minhandle) {
			hsize = 0;
			ok = true;
			rs = fsize;
			while (rs > 0 && ok) {
			  if (rs > blocksize)
			    rs = blocksize;
			  bct = sfread(ka, rs, copybuf);
			  if (bct > 0) {
			    if (bcast)
			      checksum16_buf(copybuf, bct, &bodychecksum);
			    if (outchan >= minhandle) {
			      bct = sfwrite(outchan, bct, copybuf);

			    } else if (!(export && is_binary)) {
			      if (hsize == 0)
				show_rfile(unr, copybuf, bct, rheader, sf,
					   only_headers);
			      else
				show_puffer(unr, copybuf, bct);
			    } else {
			      if (hsize == 0)
			      {  /* nur im ersten Block suchen ... */
				bstart = get_binstart(copybuf, bct,
						      user[unr]->tempbinname);
				if (bstart > 0)
				  show_puffer(unr,
					      (uchar *)(&copybuf[bstart]),
					      bct - bstart);
				else
				  show_puffer(unr, copybuf, bct);
			      } else
				show_puffer(unr, copybuf, bct);
			    }

			    hsize += bct;
			  } else {
			    debug(0, unr, 42, "file error 3");
			    bodychecksum = 0xffffL;
			    ok = false;
			  }


			  rs = fsize - hsize;
			}

			if (bcast && ok) {
			  if (bodychecksum == 0xffffL)
			    bodychecksum = 0;
			}


			sfclose(&ka);

			if (!bcast) {
			  if (sf) {
			    if (!is_binary) {
			      chwuser(unr, 0x1a);
			      wlnuser0(unr);
			    }
			  }

			  if (!sf && is_binary)
			    user[unr]->errors -= 5;
			  boxspoolread();
			}


			sfdelfile(temp3);

		      }
		    }


		  }

		}

		dpfreemem(&copybuf, blocksize);
	      } else {
		debug(2, unr, 42, "NO MEMORY");
		if (sf)
		  abort_sf(unr, false, "no mem");
		bodychecksum = 0xffffL;
	      }

	    } else {

	    /* ------------------------ Verarbeitung komplett im RAM --------------  */

	      rp = Malloc(header->packsize);
	      if (rp != NULL) {
		err = sfread(ki, header->packsize, rp);
		ics = 0;
		if (header->infochecksum != 0)
		  checksum16_buf(rp, err, &ics);
		if (err != header->packsize || rp[0] != header->firstbyte) {
		  sprintf(hs, "%s %ld : read error (4)",
			  board, ct);
		  debug(0, unr, 42, hs);
		  if (!sf)
		    wlnuser(unr, "read error");
		  bodychecksum = 0xffffL;
		} else if (ics != header->infochecksum) {
		  sprintf(hs, "%s %ld : info checksum error (4)",
			  board, ct);
		  debug(0, unr, 42, hs);
		  if (!sf)
		    wlnuser(unr, "read error");
		  bodychecksum = 0xffffL;
		} else {
		  if ((header->pmode & PM_HUFF2) != 0) {
		    /* Muessen wir eventuell die msg nicht auspacken und neu packen?  */
		    if (false) {   /* geht nicht wegen CRLF-Wandlung */
		      sf_ishuff = true;

		      /* Doch, leider. Entpacker aufrufen.                             */

		    } else {
		      unpackerr = huffmempacker(false, rp, err, &nmem, &nsize,
						temp2, false);
		      mymfreep(&rp);
		      if (nsize != 0) {
			rp = nmem;
			err = nsize;
		      }
		    }

		    /* Alles ausgepackt ?                                            */

		    if (unpackerr != 0) {
		      debug(2, unr, 42, memfailtxt);
		      wlnuser(unr, memfailtxt);
		      bodychecksum = 0xffffL;
		    } else {
		      if (rp == NULL) {
			/* in RAM zuruecklesen, Entpacker hat auf Disk geschrieben       */

			err = 0;
			hl = sfsize(temp2);
			if (hl < maxram() && hl < maxavail__()) {
			  ka = sfopen(temp2, FO_READ);
			  if (ka < minhandle)
			    wlnuser(unr, txt203);
			  else {
			    rp = Malloc(hl);
			    if (rp != NULL)
			      err = sfread(ka, hl, rp);
			    else if (sf) {
			      bodychecksum = 0xffffL;

			    }

			    sfclose(&ka);
			  }

			} else {
			  debug(2, unr, 42, "no mem (22)");
			  wlnuser(unr, "no mem (22)");
			  bodychecksum = 0xffffL;
			}
		      }


		    }

		  }


		  if (rp != NULL) {
		    /* --------------------------------------------------------------------- */

		    if (sf_pack) {
		      if (sf_ishuff == false) {
			if (*srline != '\0')
			  add_line_to_buff(&rp, &err, 0, srline);
			nsize = 0;
			nmem = NULL;
			unpackerr = huffmempacker(true, rp, err, &nmem,
						  &nsize, temp2, true);
			mymfreep(&rp);

			if (unpackerr == 0) {
			  if (nsize != 0) {
			    rp = nmem;
			    err = nsize;
			  } else {
			    err = 0;
			    hl = sfsize(temp2);
			    ka = sfopen(temp2, FO_READ);
			    if (ka >= minhandle) {
			      rp = Malloc(hl);
			      if (rp != NULL)
				err = sfread(ka, hl, rp);
			      sfclose(&ka);
			    }
			  }
			} else
			  bodychecksum = 0xffffL;
		      }
		      if (rp != NULL && err > 0 && unpackerr == 0) {
			sf_psize = err;
			send_pfbbram(bbsmode, unr, rp, sf_psize, sfoffset,
				     header->betreff);
			boxspoolread();
		      }
		    } else {
		      if (outchan >= minhandle) {
			if (bcast) {
			  checksum16_buf(rp, err, &bodychecksum);
			  if (bodychecksum == 0xffffL)
			    bodychecksum = 0;
			}
			err = sfwrite(outchan, err, rp);
		      } else {
			if (!(export && is_binary)) {
			  show_rfile(unr, rp, err, rheader, sf, only_headers);
			  if (sf) {
			    if (!is_binary) {
			      chwuser(unr, 0x1a);
			      wlnuser0(unr);
			    }
			  }
			  if (!sf && is_binary)
			    user[unr]->errors -= 5;
			} else {
			  bstart = get_binstart(rp, err,
						user[unr]->tempbinname);
			  if (bstart > 0)
			    show_puffer(unr, (uchar *)(&rp[bstart]),
					err - bstart);
			  else
			    show_puffer(unr, rp, err);
			}
		      }
		      if (!bcast)
			boxspoolread();
		    }

		  }

		}

		if (rp != NULL)
		  mymfreep(&rp);
		  
	      } else {
		debug(2, unr, 42, "no mem (23)");
		wlnuser(unr, memfailtxt);
		if (sf)
		  abort_sf(unr, false, "no mem");
		bodychecksum = 0xffffL;
	      }


	    }


	    /* --------------------------------------------------------------- */

	    if (!sf && !(export && is_binary) && outchan < minhandle) {
	      if (unr > 0 && user[unr]->tell < minhandle && add_ex)
		wlnuser(unr, "/EX");
	      wlnuser0(unr);
	    }
	  }

	} else if (check_hcs(*header) == false) {
	  sprintf(hs, "%s %ld : index checksum error",
		  board, ct);
	  debug(0, unr, 42, hs);
	  bodychecksum = 0xffffL;
	}

      }

      if (none_displayed) {
	if (!(bcast || sf))
	  wln_btext(unr, 37);
      }

_L1:
      sfclose(&ki);
    }
    sfclose(&kx);
  } else {
    sfclose(&kx);
    if (sf)
      bodychecksum = 0xffffL;
    else if (lv == 0)
      no_files(unr, board);
    else if (lv == -1)
      wln_btext(unr, 147);
  }

  if (rp != NULL)
    mymfreep(&rp);
  return bodychecksum;
}

#undef blocksize
#undef maxrcount


void list_brett(short unr, Char *name, short von, short bis, Char *option,
		Char *search)
{
  Char index[256];
  indexstruct header, *hptr;
  userstruct uf;
  long asz;
  short k, ct, x, y, list;
  Char zs[256], ds[256], w[256];
  Char hs[256];
  Char w1[256];

  boolean bidsearch, loginsearch, valid, xlist, flist, header_displayed;
  short lv, proz;
  boolean fwdlist;
  uchar *ipuffer;
  long isize;
  boolean no_betreff;
  Char binins[9], flagins[9];
  boolean ownboard, pw_show, mlist;
  short pwm;
  boolean rset, wcsearch, iscall, lastflag, ufloaded;
  short pwh;
  Char pwn[256];
  Char STR1[256];
  Char STR7[10];
  short FORLIM;
  Char STR13[52];
  Char STR14[86];
  Char STR16[256];
  short FORLIM1;

  if (!boxrange(unr))
    return;

  debug(2, unr, 43, name);
  lv = last_valid(unr, name, true, &ipuffer, &isize);
  if (lv > 0) {
    pwh = nohandle;
    header_displayed = false;
    fwdlist = (strcmp(name, "X") == 0);
    if (fwdlist)
      recompile_fwd();
    pw_show = (strchr(option, '/') != NULL);
    if (pw_show) {
      sprintf(pwn, "%supwshow%c%ld", tempdir, extsep, unr);
      pwh = sfcreate(pwn, FC_FILE);
      if (pwh < minhandle) {
	if (isize > 0)
	  mymfreep(&ipuffer);
	return;
      }
    }
    mlist = (!strcmp(name, "M") && !pw_show);
    if (!mlist) {
      iscall = callsign(name);
      xlist = (strchr(option, '+') != NULL);
      flist = (strchr(option, ':') != NULL);
      bidsearch = (strchr(option, '$') != NULL);
    } else {
      iscall = false;
      xlist = false;
      flist = false;
      bidsearch = false;
    }
    no_betreff = (mlist && !user[unr]->console);
    loginsearch = (strchr(option, '!') != NULL);
    if (loginsearch) {
      von = 1;
      bis = SHORT_MAX;
    }

    ufloaded = false;
    uf.readlock = 2;
    *uf.name = '\0';
    *uf.mybbs = '\0';
    ownboard = (iscall && strcmp(user[unr]->call, name) == 0);

    wcsearch = (strchr(search, '*') != NULL);
    sprintf(index, "%s%s%c%s", indexdir, name, extsep, idx_e);
    if (isize <= 0)
      list = sfopen(index, FO_READ);
    else
      list = nohandle;
    if (list >= minhandle || isize > 0) {
      if (bis > lv)
	bis = lv;
      x = strpos2(option, "&", 1);
      if (x > 0) {
	*w1 = '\0';
	for (y = x; y <= x + 2; y++)
	  sprintf(w1 + strlen(w1), "%c", option[y]);
	von = bis - Str2int(w1) + 1;
	loginsearch = false;
      }
      if (von < 1)
	von = 1;
      if (von > bis) {
	von = bis;
	wln_btext(unr, 25);
	wlnuser0(unr);
      }

      FORLIM = bis;
      for (k = von; k <= FORLIM; k++) {
	lastflag = false;
	if (isize <= 0)
	  read_index(list, k, &header);
	else {
	  hptr = (indexstruct *)(&ipuffer[(k - 1) * sizeof(indexstruct)]);
	  header = *hptr;
	}

	if (header.deleted == user[unr]->hidden) {
	  if (loginsearch) {
	    valid = (header.rxdate > user[unr]->lastdate);
	    if (*search != '\0') {
	      if (valid)
		valid = check_search(bidsearch, fwdlist, wcsearch, search,
				     header);
	    } else {
	      if (k == bis && header_displayed == false && valid == false) {
		valid = true;
		lastflag = true;
	      }
	    }
	  } else if (*search != '\0')
	    valid = check_search(bidsearch, fwdlist, wcsearch, search, header);
	  else
	    valid = true;

	  if (valid && !(fwdlist || pw_show)) {
	    valid = (user[unr]->msgselection == 0 ||
		     (header.msgflags & user[unr]->msgselection) != 0);

	    if (valid && (user[unr]->msgselection == (MSG_SFHOLD | MSG_LOCALHOLD))) {
	      valid = clock_.ixtime - header.rxdate < holddelay;
	    }

	    if (valid && (iscall || header.msgtype != 'B') &&
		!user[unr]->supervisor) {
	      if (iscall && !ufilhide && !ufloaded) {
		load_userfile(false, false, name, &uf);
		if (*uf.call == '\0')
		  uf.readlock = 2;
		ufloaded = true;
	      }

	      unhpath(header.verbreitung, hs);

	      if (ufilhide || uf.readlock == 2 || strcmp(hs, Console_call))
		valid = (ownboard ||
			 !strcmp(header.absender, user[unr]->call) ||
			 !strcmp(header.dest, user[unr]->call));
	      else if (uf.readlock == 1)
		valid = (ownboard ||
			 !strcmp(header.absender, user[unr]->call) ||
			 !strcmp(header.dest, user[unr]->call) ||
			 in_readby(name, header.readby) > 0);


	    }

	  } else if (valid && fwdlist) {
	    if (xlist)
	      valid = header.msgtype == 'P' || header.msgtype == 'A';
	    else if (flist) {
	      strcpy(w, header.betreff);
	      get_word(w, w1);
	      valid = header.msgtype == 'B' && strcmp(w1, "M")
	              && strcmp(w1, "E");
	    }
	  }

	  if (valid) {
	    if (!header_displayed) {
	      if (fwdlist) {
		wlnuser(unr, "FORWARD-LIST:");
		wln_btext(unr, 29);
		wlnuser0(unr);
	      } else if (pw_show) {
		wlnuser(unr, "Users with password: (call-pwlen-pwmode)");
		wlnuser0(unr);
	      } else {
		if (lastflag) {
		  wln_btext(unr, 25);
		  wlnuser0(unr);
		}

		if (iscall) {
		  if (!ufloaded) {
		    load_userfile(false, false, name, &uf);
		    ufloaded = true;
		  }

		  wuser(unr, "User-File: ");
		  if (*uf.mybbs != '\0') {
		    sprintf(STR13, "%s @ %s", name, uf.mybbs);
		    wuser(unr, STR13);
		    if (!uf.lock_here && ring_bbs) {
		      unhpath(uf.mybbs, hs);
		      if (!strcmp(hs, Console_call))
			wuser(unr, " (swap)");
		    }
		  } else
		    wuser(unr, name);
		  if (*uf.name != '\0') {
		    sprintf(STR14, " (%s)", uf.name);
		    wlnuser(unr, STR14);
		  } else
		    wlnuser0(unr);
		    
	/*	  if (uf.lastatime > 0 && !strcmp(uf.mybbs, Console_call)) {
	            ix2string(uf.lastatime, hs);
	            w_btext(unr, 54);
	            sprintf(hs, " %s", strcpy(STR7, hs));
	            wlnuser(unr, hs);
                  } else if (uf.mybbsupd > 0 && *uf.mybbs != '\0') {
	            w_btext(unr, 188);
	            sprintf(hs, " %s ", uf.mybbs);
	            wuser(unr, hs);
	            w_btext(unr, 189);
	            ix2string(uf.mybbsupd, hs);
	            sprintf(hs, " %s", strcpy(STR7, hs));
	            wlnuser(unr, hs);       
                  }
        */          
		} else {
		  w_btext(unr, 15);
		  sprintf(STR7, " %s", name);
		  wlnuser(unr, STR7);
		}


		if (mlist)
		  wln_btext(unr, 79);
		if (flist)
		  wln_btext(unr, 27);
		else if (xlist)
		  wln_btext(unr, 26);
		else
		  wln_btext(unr, 16);
		wlnuser0(unr);
	      }
	      header_displayed = true;
	    }
	    if (!check_hcs(header)) {
	      if (!may_sysaccess(unr, name))
		goto _L1;
	      wln_btext(unr, 80);
	    }
	    if (pw_show) {
	      if (header.size == 0)
		pwm = header.msgflags;
	      else
		pwm = header.fwdct;
	      if (pwm > maxpwmode)
		pwm = 0;
	      if (*header.betreff != '\0' || pwm > 1) {
		sprintf(hs, "%s-%ld-%ld", header.absender, 
				strlen(header.betreff), pwm);
		string_to_file(&pwh, hs, true);
	      }
	    } else {
	      flagins[0] = '\0';
	      binins[0] = '\0';
	      if (!mlist) {
		if ((header.pmode & TBIN) != 0)
		  strcpy(binins, "(BIN) ");
		else if ((header.pmode & T7PLUS) != 0)
		  strcpy(binins, "(7PL) ");
		else if ((header.pmode & THTML) != 0)
		  strcpy(binins, "(WWW) ");
	      }

	      if (bidsearch) {
		strcpy(ds, header.id);
		rspacing(ds, 12);
	      } else
		ixdatum2string(header.rxdate, ds);

	      ixzeit2string(header.rxdate, zs);   /*Keine Sekunden zeigen*/
	      cut(zs, 5);

	      rspacing(header.rxfrom, 6);
	      rspacing(header.absender, 6);
	      rspacing(header.verbreitung, 6);
	      cut(header.verbreitung, 6);
	      if (mlist)
		asz = 0;
	      else
		asz = truesize(header);

	      if (fwdlist) {
		cut(header.betreff, 8);
		get_word(header.betreff, w);
		rspacing(w, 8);
		rspacing(header.dest, 6);
		rspacing(header.id, 12);
		sprintf(w1, "%ld", k);
		lspacing(w1, 4);
		sprintf(hs, "%s %s %s ", w1, header.dest, header.rxfrom);
		sprintf(w1, "%ld", header.rxqrg);
		lspacing(w1, 7);
		sprintf(hs + strlen(hs), "%s %s %s %s %s ",
			w1, header.absender, w, header.verbreitung,
			header.id);
		true_lifetime(unr, header.txlifetime, header.rxdate, w1);
		lspacing(w1, 3);
		sprintf(hs + strlen(hs), "%s ", w1);
		sprintf(w1, "%ld", asz);
		lspacing(w1, 6);
		sprintf(hs + strlen(hs), "%s %c", w1, header.msgtype);
	      } else {
		if (ownboard ||
		    (iscall && (user[unr]->supervisor ||
				!strcmp(user[unr]->call, header.absender)))) {
		  x = in_readby(name, header.readby);
		  if (x <= 0)
		    strcpy(flagins, "*");
		  else if (header.readby[x - 2] == ',')
		    strcpy(flagins, "+");
		  else
		    strcpy(flagins, ".");
		} else if (user[unr]->supervisor) {
		  if (strchr(header.readby, '&') != NULL)
		    strcpy(flagins, ".");
		}
		rspacing(header.dest, 8);
		if (flist) {
		  if (!bidsearch)
		    cut(ds, 5);

		  proz = calc_prozent(header.packsize, header.size);
		  sprintf(w1, "%ld", k);
		  lspacing(w1, 4);
		  sprintf(hs, "%ld", header.lifetime);
		  lspacing(hs, 4);
		  sprintf(hs, "%s %s %s %s",
			  w1, header.absender, header.dest,
			  header.verbreitung);
		  true_lifetime(unr, header.lifetime, header.rxdate, w1);
		  lspacing(w1, 4);
		  strcat(hs, w1);
		  true_lifetime(unr, header.txlifetime, header.rxdate, w1);
		  lspacing(w1, 4);
		  sprintf(hs + strlen(hs), "%s %s", w1, header.rxfrom);
		  sprintf(w1, "%ld", header.level);
		  lspacing(w1, 4);
		  sprintf(hs + strlen(hs), "%s %s ", w1, ds);
		  sprintf(w1, "%ld", asz);
		  lspacing(w1, 6);
		  sprintf(hs + strlen(hs), "%s ", w1);
		  sprintf(w1, "%ld", proz);
		  lspacing(w1, 3);
		  sprintf(hs + strlen(hs), "%s%%", w1);
		  sprintf(w1, "%ld", header.fwdct);
		  lspacing(w1, 4);
		  strcat(hs, w1);
		  sprintf(w1, "%ld", header.msgflags);
		  lspacing(w1, 4);
		  sprintf(hs + strlen(hs), "%s %c", w1, header.msgtype);
		  wlnuser(unr, hs);

		  if (!no_betreff) {
		    sprintf(hs, "     %s%s%s",
			    flagins, binins, header.betreff);
		    wlnuser(unr, hs);
		  }

		  if (user[unr]->supervisor) {
		    rset = false;
		    if (header.readcount > 0) {
		      sprintf(STR16, "     Read: %ld ", header.readcount);
		      wuser(unr, STR16);
		      rset = true;
		    }
		    if (*header.readby != '\0') {
		      if (!rset)
			wuser(unr, "     Read: ");
		      strcpy(hs, header.readby);
		      x = 1;
		      while (x > 0) {
			x = strpos2(hs, "-", 1);
			if (x > 0)
			  strdelete((void *)hs, x, 7);
		      }
		      FORLIM1 = strlen(hs);
		      for (x = 0; x < FORLIM1; x++) {
			if (!(isupper(hs[x]) || isdigit(hs[x])))
			  hs[x] = ' ';
		      }
		      wlnuser(unr, hs);
		      rset = false;
		    }
		    if (rset)
		      wlnuser0(unr);

		    if (header.readcount > 0) {
		      ix2string(header.lastread, hs);
		      sprintf(hs, "     Last Read: %s", strcpy(STR16, hs));
		      wlnuser(unr, hs);
		    }

		    if (header.eraseby != EB_NONE) {
		      switch (header.eraseby) {

		      case EB_SENDER:
			strcpy(w1, "sender");
			break;

		      case EB_RECEIVER:
			strcpy(w1, "recipient");
			break;

		      case EB_SYSOP:
			strcpy(w1, "sysop");
			break;

		      case EB_RSYSOP:
			strcpy(w1, "board-sysop");
			break;

		      case EB_DOUBLESYSOP:
			strcpy(w1, "reread of sysop");
			break;

		      case EB_LIFETIME:
			strcpy(w1, "lifetime");
			break;

		      case EB_SF:
			strcpy(w1, "s&f with");
			break;

		      case EB_REMOTE:
			strcpy(w1, "remote erase of");
			break;

		      case EB_SFERR:
			strcpy(w1, "s&f error with");
			break;

		      case EB_RETMAIL:
			strcpy(w1, "return mailer");
			break;

		      case EB_TRANSFER:
			strcpy(w1, "transfer of");
			break;

		      case EB_BIN27PLUS:
			strcpy(w1, "bin>7plus conversion");
			break;

		      default:
			strcpy(w1, "unknown");
			break;
		      }
		      ix2string(header.erasetime, hs);
		      sprintf(hs, "     Erased at: %s by %s",
			      strcpy(STR16, hs), w1);
		      x = strpos2(header.readby, "-", 1);
		      if (x > 0) {
			strsub(w1, header.readby, x + 1, 6);
			del_lastblanks(w1);
			sprintf(hs + strlen(hs), " %s", w1);
		      }
		      wlnuser(unr, hs);
		    }

		  } else {
		    if (header.readcount > 0) {
		      sprintf(STR1, "     Read: %ld", header.readcount);
		      wlnuser(unr, STR1);
		    }
		  }

		  *hs = '\0';
		} else if (xlist) {
		  proz = calc_prozent(header.packsize, header.size);
		  sprintf(w1, "%ld", k);
		  lspacing(w1, 4);
		  sprintf(hs, "%s %s %s",
			  w1, header.absender, header.verbreitung);
		  true_lifetime(unr, header.lifetime, header.rxdate, w1);
		  lspacing(w1, 4);
		  sprintf(hs + strlen(hs), "%s %s ", w1, ds);
		  sprintf(w1, "%ld", asz);
		  lspacing(w1, 6);
		  sprintf(hs + strlen(hs), "%s ", w1);
		  sprintf(w1, "%ld", proz);
		  lspacing(w1, 3);
		  sprintf(hs + strlen(hs), "%s%%", w1);
		  if (!no_betreff)
		    sprintf(hs + strlen(hs), "  %s%s%s",
			    flagins, binins, header.betreff);
		} else {
		  sprintf(w1, "%ld", k);
		  lspacing(w1, 4);
		  sprintf(hs, "%s %s %s %s ", w1, header.absender, ds, zs);
		  sprintf(w1, "%ld", asz);
		  lspacing(w1, 6);
		  strcat(hs, w1);
		  if (!no_betreff)
		    sprintf(hs + strlen(hs), "  %s%s%s",
			    flagins, binins, header.betreff);

		  if (user[unr]->in_begruessung && hs[strlen(hs) - 1] == '>')
		    hs[strlen(hs) - 1] = ']';
		}


	      }


	      if (user[unr]->console)
		cut(hs, 118);
	      else
		cut(hs, 79);

	      wlnuser(unr, hs);
	    }
_L1: ;
	  }
	}
      }
      sfclose(&list);
      if (isize > 0)
	mymfreep(&ipuffer);

      if (pw_show) {
	sfclose(&pwh);
	sort_file(pwn);
	ct = 0;
	pwh = sfopen(pwn, FO_READ);
	if (pwh >= minhandle) {
	  while (file_to_string(pwh, hs)) {
	    if (ct % 5 == 0)
	      wlnuser0(unr);
	    rspacing(hs, 15);
	    wuser(unr, hs);
	    ct++;
	  }
	  if (ct > 0)
	    wlnuser0(unr);
	  sfclosedel(&pwh);
	}
      }

      if (!header_displayed)
	wln_btext(unr, 37);

    } else {
      sfclose(&list);
      no_files(unr, name);
    }
    sfclosedel(&pwh);
    return;
  }
  if (lv == -1)
    wln_btext(unr, 147);
  else
    no_files(unr, name);

}


Static void show_pwuser(short unr)
{
  Char s[1];

  *s = '\0';
  list_brett(unr, "M", 1, SHORT_MAX, "/", s);
}


Static void change_mbx(short unr, Char *brett, short von, short bis,
		       Char *newmbx_, Char *option)
{
  Char newmbx[41];

  long isize;
  short k, list;
  boolean valid;
  short lv;
  boolean forwarding, only_show, disp;
  uchar *ipuffer;
  boolean userfile;
  Char mbx1[41];
  Char index[256];
  indexstruct header;
  Char w[256];
  Char STR1[42];

  strcpy(newmbx, newmbx_);
  debug(2, unr, 44, brett);
  if (!boxrange(unr))
    return;

  only_show = (strchr(option, '+') != NULL);
  unhpath(newmbx, mbx1);
  userfile = callsign(brett);
  if (userfile && !callsign(mbx1) && !only_show) {
    wln_btext(unr, 34);
    return;
  }
  if (callsign(mbx1)) {
    if (strchr(newmbx, '.') == NULL) {
      complete_hierarchical_adress(newmbx);
      unhpath(newmbx, mbx1);
    }
  }
  valid = false;

  lv = user[unr]->lastprocnumber2;
  user[unr]->lastprocnumber2 = 0;
  if (lv == 0)
    lv = last_valid(unr, brett, false, &ipuffer, &isize);

  if (lv > 0) {
    if (user[unr]->lastprocnumber > 0) {
      von = user[unr]->lastprocnumber;
      user[unr]->lastprocnumber = 0;
      disp = true;
      valid = true;
    } else
      disp = false;

    sprintf(index, "%s%s%c%s", indexdir, brett, extsep, idx_e);
    list = sfopen(index, FO_RW);

    if (list < minhandle || lv <= 0) {
      sfclose(&list);
      no_files(unr, brett);
      return;
    }
    copy_eralog(true);
    if (bis > lv)
      bis = lv;

    for (k = von; k <= bis; k++) {
      if (disp && k != von && statclock() - user[unr]->cputime >= ttask) {
	user[unr]->lastprocnumber = k;
	user[unr]->lastprocnumber2 = lv;
	goto _L1;
      }

      if (list >= minhandle) {
	read_index(list, k, &header);
	if (header.deleted == user[unr]->hidden && check_hcs(header)) {
	  valid = true;
	  if (!only_show) {
	    if (strcmp(header.verbreitung, newmbx)) {
	      strcpy(header.verbreitung, newmbx);
	      header.msgflags &= ~(MSG_SFWAIT | MSG_SFERR | MSG_SFNOFOUND
	      				| MSG_REJECTED | MSG_DOUBLE);
	      write_index(list, k, &header);
	      alter_log(true, header.msgnum, header.msgflags, '@', newmbx);
	    } else
	      unhpath(header.verbreitung, mbx1);

	    if (header.deleted == false) {
	      if (userfile)
		forwarding = (strcmp(mbx1, Console_call) != 0);
	      else
		forwarding = ((strpos2(header.id, Console_call, 1) > 0 ||
			       (header.msgflags & MSG_SFRX) != 0) &&
			      strcmp(mbx1, Console_call));
	    } else
	      forwarding = false;

	    if (forwarding) {
	      sfclose(&list);
	      *w = '\0';
	      set_forward(-1, -1, brett, w, k, k, "FORWARD", w, w);
	      list = sfopen(index, FO_RW);
	    }
	  } else {
	    w_btext(unr, 35);
	    sprintf(STR1, " %s", header.verbreitung);
	    wlnuser(unr, STR1);
	  }

	}
      }
    }


_L1:
    sfclose(&list);
    copy_eralog(false);

    if (valid && !disp) {
      w_btext(unr, 36);
      sprintf(STR1, " %s", newmbx);
      wlnuser(unr, STR1);
    } else if (!valid)
      wln_btext(unr, 37);

    return;
  }

  if (lv == -1)
    wln_btext(unr, 147);
  else
    no_files(unr, brett);
}


Static void change_lifetime(short unr, Char *brett, short von, short bis,
			    Char *newlt_)
{
  Char newlt[256];
  long isize;
  short k, list;
  boolean valid, disp;
  short lv, lt, xlt;
  uchar *ipuffer;
  indexstruct header;
  Char index[256];

  strcpy(newlt, newlt_);
  debug(2, unr, 45, brett);
  if (!boxrange(unr))
    return;

  if (!may_sysaccess(unr, brett)) {
    wln_btext(unr, 1);
    return;
  }

  if ((unsigned long)strlen(newlt) >= 32 ||
      ((1L << strlen(newlt)) & 0x1e) == 0) {
    wln_btext(unr, 39);
    return;
  }
  if (newlt[0] == '#')
    strdelete((void *)newlt, 1, 1);
  lt = Str2int(newlt);
  if ((unsigned)lt > 999) {
    wln_btext(unr, 39);
    return;
  }
  valid = false;
  lv = user[unr]->lastprocnumber2;
  user[unr]->lastprocnumber2 = 0;
  if (lv == 0)
    lv = last_valid(unr, brett, false, &ipuffer, &isize);

  if (lv > 0) {
    if (user[unr]->lastprocnumber > 0) {
      von = user[unr]->lastprocnumber;
      user[unr]->lastprocnumber = 0;
      disp = true;
      valid = true;
    } else
      disp = false;


    sprintf(index, "%s%s%c%s", indexdir, brett, extsep, idx_e);
    list = sfopen(index, FO_RW);
    if (list < minhandle || lv <= 0) {
      sfclose(&list);
      no_files(unr, brett);
      return;
    }
    copy_eralog(true);
    if (bis > lv)
      bis = lv;
    for (k = von; k <= bis; k++) {
      if (disp && k != von && statclock() - user[unr]->cputime >= ttask) {
	user[unr]->lastprocnumber = k;
	user[unr]->lastprocnumber2 = lv;
	goto _L1;
      }

      if (k % 10 == 0)
	dp_watchdog(2, 4711);
      read_index(list, k, &header);
      if (header.deleted == user[unr]->hidden && check_hcs(header)) {
	xlt = lt;
	if (user[unr]->ttl) {
	  if (lt > 0)
	    xlt = (clock_.ixtime - header.rxdate) / 86400L + lt;
	}

	if (header.lifetime != xlt) {
	  header.lifetime = xlt;
	  write_index(list, k, &header);
	  sprintf(newlt, "%ld", xlt);
	  alter_log(true, header.msgnum, header.msgflags, '#', newlt);
	}
	valid = true;
      }

    }


_L1:
    sfclose(&list);
    copy_eralog(false);
    if (!valid || disp) {
      if (!valid)
	wln_btext(unr, 37);
      return;
    }
    w_btext(unr, 38);
    sprintf(newlt, " %ld", lt);
    wlnuser(unr, newlt);
    return;
  }

  if (lv == -1)
    wln_btext(unr, 147);
  else
    no_files(unr, brett);
}





#define maxcheckc       30000
#define maxchecks       30000


Static long maxcheck, lastcheck;



void disp_logptr(short unr, long checkct, boolean bidsearch,
		 boxlogstruct *logptr, Char *hs)
{
  Char lts[256], lns[256], ns[256];
  Char bname[256], tname[256];
  Char datum[256], binins[256];
  Char STR1[256];

  if (logptr == NULL)
    return;

  if ((logptr->pmode & TBIN) != 0)
    strcpy(binins, "(BIN) ");
  else if ((logptr->pmode & T7PLUS) != 0)
    strcpy(binins, "(7PL) ");
  else if ((logptr->pmode & THTML) != 0)
    strcpy(binins, "(WWW) ");
  else
    binins[0] = '\0';

  if (unr > 0 && user[unr]->fbbmode) {
    sprintf(hs, "%ld", logptr->msgnum + msgnumoffset);
    rspacing(hs, 7);
    sprintf(hs + strlen(hs), "%c", logptr->msgtype);
    sprintf(ns, "%ld", logptr->size);
    lspacing(ns, 6);
    sprintf(hs + strlen(hs), "%s ", ns);
    strcpy(ns, logptr->obrett);
    cut(ns, 8);
    rspacing(ns, 8);
    sprintf(hs + strlen(hs), "%s@", ns);
    unhpath(logptr->verbreitung, ns);
    cut(ns, 6);
    rspacing(ns, 7);
    strcat(hs, ns);
    strcpy(ns, logptr->absender);
    cut(ns, 6);
    rspacing(ns, 7);
    strcat(hs, ns);
    ix2string(logptr->date, ns);

    if (bidsearch) {
      strcpy(ns, logptr->bid);
      rspacing(ns, 12);
      strcat(hs, ns);
    } else {
      sprintf(hs + strlen(hs), "%c%c%c%c/%c%c%c%c",
	      ns[3], ns[4], ns[0], ns[1], ns[9], ns[10], ns[12], ns[13]);
    }


    sprintf(hs + strlen(hs), " %s%s", binins, logptr->betreff);
  } else {
    strcpy(tname, logptr->brett);
    if (!defined_board(tname))
      lower(tname);
    strcpy(bname, tname);
    sprintf(ns, "%ld", logptr->idxnr);
    while (strlen(bname) + strlen(ns) < 12)
      strcat(bname, ".");
    if (bidsearch) {
      strcpy(datum, logptr->bid);
      rspacing(datum, 12);
    } else
      ixdatum2string(logptr->date, datum);
    rspacing(logptr->absender, 6);
    rspacing(logptr->verbreitung, 6);
    if (bidsearch)
      cut(logptr->verbreitung, 2);
    else
      cut(logptr->verbreitung, 6);
    true_lifetime(unr, logptr->lifetime, logptr->date, lts);
    lspacing(lts, 3);
    sprintf(lns, "%ld", checkct);
    lspacing(lns, 5);
    sprintf(hs, "%ld", logptr->size);
    lspacing(hs, 6);
    sprintf(hs, "%s %s > %s%s %s %s%s %s %s%s",
	    lns, logptr->absender, bname, ns, datum, logptr->verbreitung,
	    strcpy(STR1, hs), lts, binins, logptr->betreff);
  }

  cut(hs, 79);
}


Static void show_logptr(short unr, long checkct, boolean bidsearch,
			boxlogstruct *logptr, long *gefunden,
			short *sorthandle)
{
  Char hs[256], ns[256], tname[256];
  Char STR1[256];

  if (*gefunden < maxcheck) {
    disp_logptr(unr, checkct, bidsearch, logptr, hs);

    if (*sorthandle >= minhandle) {
      if (unr > 0 && user[unr]->fbbmode)
	strcpy(ns, logptr->obrett);
      else {
	strcpy(tname, logptr->brett);
	if (!defined_board(tname))
	  lower(tname);
	strcpy(ns, tname);
      }
      rspacing(ns, 9);
      sprintf(hs, "%s%s", ns, strcpy(STR1, hs));
      string_to_file(sorthandle, hs, true);
    } else
      wlnuser(unr, hs);

    lastcheck = *gefunden + 1;
    if (*sorthandle < minhandle && *gefunden % 30 == 0)
      boxspoolread();

  }

  (*gefunden)++;
}


Static boolean access_ok(short unr, boolean userfiles, boolean nochb,
			 boolean wantchb, boxlogstruct *log)
{
  short acc;
  Char STR7[12];

  if (log->msgtype == 'B') {
    if (userfiles)
      return false;
  } else {
    if (!userfiles)
      return false;
  }

  if (nochb) {
    sprintf(STR7, ",%s,", log->brett);
    if (strpos2(user[unr]->nocheckboards, STR7, 1) > 0)
      return false;
  } else if (wantchb) {
    sprintf(STR7, ",%s,", log->brett);
    if (strpos2(user[unr]->wantcheckboards, STR7, 1) == 0)
      return false;
  }

  if (user[unr]->console) {
    acc = 1;

  } else if (strlen(log->brett) == 1) {
    if (may_sysaccess(unr, log->brett))
      acc = log->level;
    else
      acc = SHORT_MAX;
  } else
    acc = log->level;

  if (user[unr]->level < acc)
    return false;

  if (log->deleted == user[unr]->hidden) {
    if (user[unr]->supervisor || log->msgtype == 'B' ||
	!strcmp(log->absender, user[unr]->call) || !strcmp(log->brett, user[unr]->call)) {
      return true;
    }
  }
  
  return false;
}


void show_sortcheck(short unr)
{
  short sorthandle;
  Char w[256], w1[256], hs[256];

  if (!boxrange(unr))
    return;
  if (*user[unr]->wait_file == '\0')
    return;
  sorthandle = sfopen(user[unr]->wait_file, FO_READ);
  if (sorthandle >= minhandle) {
    *w1 = '\0';
    while (file_to_string(sorthandle, hs)) {
      sprintf(w, "%.9s", hs);
  /*    strdelete((void *)hs, 1, 9); */
      if (*w1 != '\0' && strcmp(w1, w))
	wlnuser0(unr);
      strcpy(w1, w);
      wlnuser(unr, (Char *) (&hs[9]));
    }
    sfclose(&sorthandle);
  }
  sfdelfile(user[unr]->wait_file);
  *user[unr]->wait_file = '\0';
}


#define cpentries       checkblocksize

#define cpsize          (cpentries * sizeof(boxlogstruct))


Static void check(short unr, Char *suche, short von, short bis,
		  boolean userfiles, Char *option, Char *board,
		  boolean sorted)
{

  long cpstart, seekpos, err;
  boolean check_end, bidsearch, nochb, wantchb;

  boolean resumed, wcsearch, first;
  short sorthandle, log;
  boxlogstruct *logptr, logheader;
  long lognr, loganz, checkct, gefunden;
  uchar *ipuffer;
  short cmode;
  Char hs[256], w[256], fn[256];
  Char logname[256];
  Char STR7[256];

  debug0(2, unr, 46);

  if (!boxrange(unr))
    return;

  strcpy(logname, boxlog);

  resumed = (user[unr]->lastprocnumber > 0);
      /* diesmal ist es nur ein Flag (0/1(/2)) */

  if (resumed)
    err = user[unr]->lastprocnumber7;
  else
    err = sfsize(logname);


  if (err % sizeof(boxlogstruct) != 0 || err == 0) {
    create_new_boxlog(unr, false);
    err = sfsize(logname);
  }

  if (!resumed) {
    recompile_log(unr);

    checkct = 0;
    gefunden = 0;
    lastcheck = 0;
  } else {
    checkct = user[unr]->lastprocnumber4;
    gefunden = user[unr]->lastprocnumber5;
    lastcheck = user[unr]->lastprocnumber6;
  }



  cpstart = 0;
  check_end = false;
  cmode = 2;

  if (sorted)
    maxcheck = maxchecks;
  else
    maxcheck = maxcheckc;

  w[0] = '\0';   /* muss null bleiben! */

  wcsearch = (strchr(suche, '*') != NULL);
  if (*suche != '\0')   /* CHECK 1-10 */
    cmode = 1;   /* Search */
  else if (strpos2(option, "!", 1) > 0)
    cmode = 2;   /* loginsearch */
  else if (bis > 0)
    cmode = 3;
  if (*board != '\0')   /* + DIR */
    cmode += 10;

  bidsearch = (strchr(option, '$') != NULL);

  nochb = (!userfiles && cmode < 10 && *suche == '\0' &&
	   user[unr]->msgselection == 0 && *user[unr]->nocheckboards != '\0');

  wantchb = (!userfiles && cmode < 10 && !nochb && *suche == '\0' &&
	     user[unr]->msgselection == 0 &&
	     *user[unr]->wantcheckboards != '\0');

  if (!resumed) {
    wuser(unr, "Check: ");
    if (*suche != '\0') {
      sprintf(STR7, "(%s)", suche);
      wlnuser(unr, STR7);
    } else
      wlnuser0(unr);

    wlnuser0(unr);
    if (user[unr]->fbbmode)
      wln_btext(unr, 183);
    else
      wln_btext(unr, 17);
    wlnuser0(unr);

  }


  ipuffer = Malloc(cpsize);

  if (ipuffer == NULL)
    debug(2, unr, 46, "from disk");

  if (resumed) {
    lognr = user[unr]->lastprocnumber3;
    bis = user[unr]->lastprocnumber2;
    user[unr]->lastprocnumber3 = 0;
    user[unr]->lastprocnumber = 0;
    user[unr]->lastprocnumber7 = err;
  } else {
    lognr = err / sizeof(boxlogstruct);
    if (bis > lognr)
      bis = lognr;
    user[unr]->lastprocnumber7 = err;
  }

  log = sfopen(logname, FO_READ);

  loganz = lognr;


  if (log >= minhandle && lognr > 0) {   /* wenn das log ganz leer ist ... */
    sorthandle = nohandle;
    if (sorted) {
      sprintf(fn, "%sCS1823%c%ld", tempdir, extsep, unr);
      if (!resumed) {
	sorthandle = sfcreate(fn, FC_FILE);
	user[unr]->prochandle = sorthandle;
      } else
	sorthandle = user[unr]->prochandle;
    }

    first = true;

    do {
      dp_watchdog(2, 4711);   /*Watchdog resetten*/
      if (ipuffer == NULL) {
	if (!first && statclock() - user[unr]->cputime >= ttask) {
	  user[unr]->lastprocnumber = 1;
	  user[unr]->lastprocnumber2 = bis;
	  user[unr]->lastprocnumber3 = lognr;
	  user[unr]->lastprocnumber4 = checkct;
	  user[unr]->lastprocnumber5 = gefunden;
	  user[unr]->lastprocnumber6 = lastcheck;
	  goto _L1;
	}

	read_log(log, lognr, &logheader);
	logptr = &logheader;
      } else {
	if (lognr < cpstart || cpstart == 0) {
	  if (!first && statclock() - user[unr]->cputime >= ttask) {
	    user[unr]->lastprocnumber = 1;
	    user[unr]->lastprocnumber2 = bis;
	    user[unr]->lastprocnumber3 = lognr;
	    user[unr]->lastprocnumber4 = checkct;
	    user[unr]->lastprocnumber5 = gefunden;
	    user[unr]->lastprocnumber6 = lastcheck;
	    goto _L1;
	  }

	  if (cpstart == 0)
	    cpstart = loganz - cpentries + 1;
	  else
	    cpstart -= cpentries;
	  if (cpstart <= 1)
	    cpstart = 1;
	  seekpos = (cpstart - 1) * sizeof(boxlogstruct);
	  if (sfseek(seekpos, log, SFSEEKSET) != seekpos)
	    goto _L1;
	  if (sfread(log, cpsize, ipuffer) <= 0)
	    goto _L1;
	  if (lognr < cpstart)
	    goto _L1;
	}

	logptr = (boxlogstruct *)
		 (&ipuffer[(lognr - cpstart) * sizeof(boxlogstruct)]);
      }


      first = false;

      if ((user[unr]->msgselection == 0 ||
	   ((logptr->msgflags & user[unr]->msgselection) != 0) &&
	    (user[unr]->msgselection != (MSG_SFHOLD | MSG_LOCALHOLD) 
	        || clock_.ixtime - logptr->date < holddelay)
	  ) && access_ok(unr, userfiles, nochb, wantchb, logptr)) {

	if (!user[unr]->undef || !defined_board(logptr->brett)) {
	  checkct++;

	  switch (cmode) {

	  case 1:  /* Search */
	    if (checkct > bis)
	      check_end = true;
	    else if (checkct >= von) {
	      strcpy(hs, logptr->betreff);
	      upper(hs);
	      if (wcsearch) {
		if (wildcardcompare(SHORT_MAX, suche, logptr->absender, w) ||
		    wildcardcompare(SHORT_MAX, suche, hs, w) ||
		    (bidsearch &&
		     wildcardcompare(SHORT_MAX, suche, logptr->bid, w)))
		  show_logptr(unr, checkct, bidsearch, logptr, &gefunden,
			      &sorthandle);
	      } else {
		if (strpos2(logptr->absender, suche, 1) > 0 ||
		    strpos2(hs, suche, 1) > 0 ||
		    bidsearch && strpos2(logptr->bid, suche, 1) > 0)
		  show_logptr(unr, checkct, bidsearch, logptr, &gefunden,
			      &sorthandle);
	      }
	    }
	    break;

	  case 2:  /* loginsearch */
	    if (user[unr]->lastdate > logptr->date) {
	      if (checkct == 1)
		show_logptr(unr, checkct, bidsearch, logptr, &gefunden,
			    &sorthandle);
	      check_end = true;
	    } else
	      show_logptr(unr, checkct, bidsearch, logptr, &gefunden,
			  &sorthandle);
	    break;

	  case 3:  /* C 1-10 */
	    if (checkct > bis)
	      check_end = true;
	    else if (checkct >= von)
	      show_logptr(unr, checkct, bidsearch, logptr, &gefunden,
			  &sorthandle);
	    break;

	  case 11:  /* Search + board */
	    if (checkct > bis)
	      check_end = true;
	    else if (checkct >= von) {
	      if (!strcmp(board, logptr->brett)) {
		strcpy(hs, logptr->betreff);
		upper(hs);
		if (wcsearch) {
		  if (wildcardcompare(SHORT_MAX, suche, logptr->absender, w) ||
		      wildcardcompare(SHORT_MAX, suche, hs, w) ||
		      (bidsearch &&
		       wildcardcompare(SHORT_MAX, suche, logptr->bid, w)))
		    show_logptr(unr, checkct, bidsearch, logptr, &gefunden,
				&sorthandle);
		} else {
		  if (strpos2(logptr->absender, suche, 1) > 0 ||
		      strpos2(hs, suche, 1) > 0 ||
		      bidsearch && strpos2(logptr->bid, suche, 1) > 0)
		    show_logptr(unr, checkct, bidsearch, logptr, &gefunden,
				&sorthandle);
		}
	      }
	    }
	    break;

	  case 12:  /* loginsearch + board */
	    if (user[unr]->lastdate > logptr->date)
	      check_end = true;
	    else if (!strcmp(board, logptr->brett))
	      show_logptr(unr, checkct, bidsearch, logptr, &gefunden,
			  &sorthandle);
	    break;

	  case 13:  /* C 1-10 + board */
	    if (checkct > bis)
	      check_end = true;
	    else if (checkct >= von) {
	      if (!strcmp(board, logptr->brett))
		show_logptr(unr, checkct, bidsearch, logptr, &gefunden,
			    &sorthandle);
	    }
	    break;
	  }
	}

      }


      lognr--;

    } while (!(check_end || lognr < 1));

    /* das ist doppelt, aber mit absicht */
    if (ipuffer != NULL)
      mymfreep(&ipuffer);
    sfclose(&log);

    if (sorthandle >= minhandle) {
      sfclose(&sorthandle);
      user[unr]->prochandle = nohandle;
      strcpy(user[unr]->wait_file, fn);
      user[unr]->action = 71;
      user[unr]->wait_pid = fork();
      if (user[unr]->wait_pid <= 0) {
	if (user[unr]->wait_pid == 0)
	  setsid();
	sort_file(fn);
	if (user[unr]->wait_pid == 0)
	  exit(0);
	show_sortcheck(unr);
	user[unr]->action = 0;
      }
    }

  } else
    wln_btext(unr, 8);


_L1:
  if (ipuffer != NULL)
    mymfreep(&ipuffer);
  sfclose(&log);

  if (user[unr]->lastprocnumber != 0 || gefunden < maxcheck)
    return;

  wlnuser0(unr);
  wln_btext(unr, 41);
  if (cmode != 2)
    return;
  w_btext(unr, 42);
  sprintf(hs, ": %ld ", checkct);
  wuser(unr, hs);
  w_btext(unr, 81);
  sprintf(hs, " %ld", lastcheck);
  wlnuser(unr, hs);

}

#undef cpentries
#undef cpsize


Static void form_out(short unr, Char *rub, Char *lts, short *k)
{
  short x;

  x = strlen(rub) + strlen(lts);
  while (x < 13) {
    strcat(rub, ".");
    x++;
  }
  sprintf(rub + strlen(rub), "%s ", lts);
  wuser(unr, rub);
  if (*k % 5 == 0)
    wlnuser0(unr);
  (*k)++;
}


Static void show_dir(short unr, boolean with_user, boolean msgcount,
		     boolean lost)
{
  short k, result, ofi, msgct;
  unsigned short lt, acc;
  uchar *dptr;

  long dummy;
  boolean eofil, ok, first;
  DTA dirinfo;
  Char ofiname[256];
  Char hs[256], hs2[256];
  Char rubrik[256];
  Char rubrik1[256];
  Char STR1[256];

  debug0(2, unr, 47);
  if (!boxrange(unr))
    return;
  if (user[unr]->lastprocnumber == 0) {
    user[unr]->lastprocnumber2 = 1;
    sprintf(ofiname, "%sSHOWDIR%c%ld", tempdir, extsep, unr);
    ofi = sfcreate(ofiname, FC_FILE);
    if (ofi >= minhandle) {
      wlnuser(unr, "Files:");
      wlnuser0(unr);

      sprintf(STR1, "%s%c%c%s", indexdir, allquant, extsep, idx_e);
      result = sffirst(STR1, 0, &dirinfo);
      while (result == 0) {
	strcpy(hs, dirinfo.d_fname);
	del_ext(hs);
	if (callsign(hs) == with_user) {
	  if (!with_user) {
	    if (!defined_board(hs))
	      lower(hs);
	  }
	  sprintf(hs2, "%s %ld", hs, dirinfo.d_length);
	  string_to_file(&ofi, hs2, true);
	}
	result = sfnext(&dirinfo);
      }
      sfclose(&ofi);
      sort_file(ofiname);
      user[unr]->prochandle = sfopen(ofiname, FO_READ);
    }

  }

  ofi = user[unr]->prochandle;
  if (ofi < minhandle) {
    wlnuser(unr, memfailtxt);
    user[unr]->lastprocnumber = 0;
    return;
  }


  k = user[unr]->lastprocnumber2;

  eofil = false;
  first = true;
  while (!eofil && (first || statclock() - user[unr]->cputime < ttask)) {
    first = false;

    if (!file_to_string(ofi, hs)) {
      eofil = true;
      break;
    }


    user[unr]->lastprocnumber++;

    dp_watchdog(2, 4711);   /*Watchdog resetten*/
    get_word(hs, rubrik);
    strcpy(rubrik1, rubrik);
    upper(rubrik1);
    get_word(hs, hs2);

    if (with_user) {  /*Userfiles*/
      if (lost) {  /* nur Userfiles mit MyBBS <> eigenem anzeigen */
	user_mybbs(rubrik1, hs2);
	unhpath(hs2, hs2);
	ok = (strcmp(hs2, Console_call) != 0);
      } else
	ok = true;

      if (!ok)
	continue;

      msgct = last_valid(unr, rubrik1, false, &dptr, &dummy);
      if (msgct <= 0)
	continue;
      if (msgcount) {
	sprintf(hs2, "%ld", msgct);
	form_out(unr, rubrik, hs2, &k);
	continue;
      }
      rspacing(rubrik, 9);
      wuser(unr, rubrik);
      if ((k & 7) == 0)
	wlnuser0(unr);
      k++;
      continue;
    }


    msgct = last_valid(unr, rubrik1, false, &dptr, &dummy);
    if (msgct <= 0)
      continue;

    lt = 0;
    if (msgcount)
      sprintf(hs2, "%ld", msgct);
    else {
      check_lt_acc(rubrik, &lt, &acc);
      sprintf(hs2, "%ld", lt);
    }
    form_out(unr, rubrik, hs2, &k);
  }

  if (!eofil) {
    user[unr]->lastprocnumber2 = k;
    return;
  }

  sfclosedel(&user[unr]->prochandle);
  user[unr]->lastprocnumber = 0;
  user[unr]->lastprocnumber2 = 0;
  wlnuser0(unr);

  /*Infofiles*/
}


Static void show_statistik(short unr, Char *option)
{
  short k, ct;
  unsigned short lt, acc;
  short result, ofi, anz;
  long size1, size2, gsize1, gsize2, hsize;
  short prozent, msgs, dmsgs;
  long gmsgs, gdmsgs;
  boolean short_stat, short_user, short_bulls, single_file, first, eofil,
	  take_it;
  DTA dirinfo;
  Char datei[256];
  Char ofiname[256];
  Char hs[256], w[256], hs2[256];
  Char hname[256];
  indexstruct header;
  Char STR1[256], STR7[256];

  debug(2, unr, 48, option);
  if (!boxrange(unr))
    return;

  datei[0] = '\0';
  single_file = false;

  if (!strcmp(option, "-S")) {
    short_stat = true;
    short_user = true;
    short_bulls = true;
  } else if (!strcmp(option, "-U") || !strcmp(option, "-P")) {
    short_stat = true;
    short_user = true;
    short_bulls = false;
  } else if (!strcmp(option, "-B")) {
    short_stat = true;
    short_user = false;
    short_bulls = true;
  } else {
    short_stat = false;
    short_user = false;
    short_bulls = false;
    if ((unsigned long)strlen(option) < 32 &&
	((1L << strlen(option)) & 0x1fe) != 0) {
      strcpy(datei, option);
      single_file = (*datei != '\0' &&
		     exist((sprintf(STR1, "%s%s%c%s",
				    indexdir, datei, extsep, idx_e), STR1)));
    }
  }

  if (user[unr]->lastprocnumber == 0) {
    wln_btext(unr, 19);
    wlnuser0(unr);
    wln_btext(unr, 20);
    wlnuser0(unr);

    gsize1 = 0;
    gsize2 = 0;
    gmsgs = 0;
    gdmsgs = 0;

    sprintf(ofiname, "%sSHOWDIR%c%ld", tempdir, extsep, unr);
    ofi = sfcreate(ofiname, FC_FILE);
    if (ofi >= minhandle) {
      if (single_file) {
	sprintf(STR1, "%s%s%c%s", indexdir, datei, extsep, idx_e);
	result = sffirst(STR1, 0, &dirinfo);
      } else {
	sprintf(STR1, "%s%c%c%s", indexdir, allquant, extsep, idx_e);
	result = sffirst(STR1, 0, &dirinfo);
      }

      while (result == 0) {
	strcpy(hs, dirinfo.d_fname);
	del_ext(hs);
	sprintf(hs2, "%s %ld", hs, dirinfo.d_length);
	string_to_file(&ofi, hs2, true);
	result = sfnext(&dirinfo);
      }
      sfclose(&ofi);
      sort_file(ofiname);
      user[unr]->prochandle = sfopen(ofiname, FO_READ);
    }

  } else {
    gmsgs = user[unr]->lastprocnumber3;
    gdmsgs = user[unr]->lastprocnumber4;
    gsize1 = user[unr]->lastprocnumber5;
    gsize2 = user[unr]->lastprocnumber6;
  }

  ofi = user[unr]->prochandle;
  if (ofi < minhandle) {
    wlnuser(unr, memfailtxt);
    user[unr]->lastprocnumber = 0;
    return;
  }

  eofil = false;
  first = true;
  while (!eofil && (first || statclock() - user[unr]->cputime < ttask)) {
    first = false;

    if (!file_to_string(ofi, hs)) {
      eofil = true;
      break;
    }


    user[unr]->lastprocnumber++;

    dp_watchdog(2, 4711);   /* Watchdog resetten */

    get_word(hs, hname);
    get_word(hs, hs2);
    hsize = str2lint(hs2);

    if (!strcmp(hname, "M") || !strcmp(hname, "X"))
      take_it = false;
    else if (short_stat) {
      if (callsign(hname))
	take_it = short_user;
      else
	take_it = short_bulls;
    } else
      take_it = true;

    msgs = 0;
    dmsgs = 0;
    size1 = 0;
    size2 = 0;

    if (!take_it)
      continue;
    anz = hsize / sizeof(indexstruct);
    sprintf(STR7, "%s%s%c%s", indexdir, hname, extsep, idx_e);
    k = sfopen(STR7, FO_READ);
    if (k >= minhandle) {
      for (ct = 1; ct <= anz; ct++) {
	read_index(k, ct, &header);
	if (check_hcs(header)) {
	  size1 += header.size;
	  size2 += header.packsize;
	  if (header.deleted)
	    dmsgs++;
	  else
	    msgs++;
	}
      }
      sfclose(&k);

    }

    gmsgs += msgs;
    gdmsgs += dmsgs;
    gsize1 += size1;
    gsize2 += size2;

    if (short_stat)
      continue;


    prozent = calc_prozent(size2, size1);
    lt = 0;
    check_lt_acc(hname, &lt, &acc);
    if (!(acc <= user[unr]->level || user[unr]->console))
      continue;

    rspacing(hname, 9);
    sprintf(hs, "%ld", msgs);
    lspacing(hs, 5);
    sprintf(w, "%ld", dmsgs);
    lspacing(w, 5);
    sprintf(hs, "%s%s %s ", hname, strcpy(STR1, hs), w);
    sprintf(w, "%ld", size1);

    lspacing(w, 9);
    sprintf(hs + strlen(hs), "%s ", w);
    sprintf(w, "%ld", size2);
    lspacing(w, 9);
    sprintf(hs + strlen(hs), "%s   ", w);
    sprintf(w, "%ld", prozent);
    lspacing(w, 3);
    sprintf(hs + strlen(hs), "%s ", w);
    sprintf(w, "%ld", lt);
    lspacing(w, 3);
    strcat(hs, w);
    sprintf(w, "%ld", acc);
    lspacing(w, 3);
    sprintf(hs + strlen(hs), " %s", w);
    wlnuser(unr, hs);
  }

  if (eofil) {
    if (!single_file) {
      if (!short_stat)
	wlnuser0(unr);
      get_btext(unr, 42, hs);
      rspacing(hs, 9);
      cut(hs, 9);
      wuser(unr, hs);
      prozent = calc_prozent(gsize2, gsize1);
      sprintf(hs, "%ld", gmsgs);
      lspacing(hs, 5);
      sprintf(w, "%ld", gdmsgs);
      lspacing(w, 5);
      sprintf(hs + strlen(hs), " %s ", w);
      sprintf(w, "%ld", gsize1);
      lspacing(w, 9);
      sprintf(hs + strlen(hs), "%s ", w);
      sprintf(w, "%ld", gsize2);
      lspacing(w, 9);
      sprintf(hs + strlen(hs), "%s   ", w);
      sprintf(w, "%ld", prozent);
      lspacing(w, 3);


      strcat(hs, w);
      wlnuser(unr, hs);
      wlnuser0(unr);
    }

    sfclosedel(&user[unr]->prochandle);
    user[unr]->lastprocnumber = 0;
    return;
  }


  user[unr]->lastprocnumber3 = gmsgs;
  user[unr]->lastprocnumber4 = gdmsgs;
  user[unr]->lastprocnumber5 = gsize1;
  user[unr]->lastprocnumber6 = gsize2;
}


void set_forward(short unr, short unr_msg, Char *quelle, Char *option,
		 short nr, short bis, Char *to_box, Char *from_box,
		 Char *lastvias)
{
  Char index[256];
  indexstruct header;
  short list, lv;

  debug(2, unr, 49, quelle);
  if (strchr(option, '(') != NULL || strchr(option, ')') != NULL) {
    wln_btext(unr, 2);
    return;
  }
  if ((unsigned long)strlen(quelle) >= 32 ||
      ((1L << strlen(quelle)) & 0x1fe) == 0) {
    wln_btext(unr, 2);
    return;
  }
  sprintf(index, "%s%s%c%s", indexdir, quelle, extsep, idx_e);
  if (!exist(index)) {
    wln_btext(unr, 2);
    return;
  }
  lv = sfsize(index) / sizeof(indexstruct);
  if (bis > lv)
    bis = lv;
  list = sfopen(index, FO_RW);

  if (create_syslog) {
    if (boxrange(unr)) {
      if (user[unr]->supervisor)
	append_syslog(unr);
    }
  }

  while (nr <= bis && list >= minhandle) {
    if (nr % 20 == 0)   /*Watchdog resetten*/
      dp_watchdog(2, 4711);
    read_index(list, nr, &header);
    if (check_hcs(header)) {
      if (unr < 0) {  /*das System*/
	if (!header.deleted)
	  header.msgflags |= vermerke_sf(unr_msg, false, quelle, from_box,
					 "*", header, lastvias);
      } else if (boxrange(unr)) {
	if (header.deleted == user[unr]->hidden) {
	  if (!strcmp(header.absender, user[unr]->call) ||
	      !strcmp(header.dest, user[unr]->call) ||
	      !strcmp(quelle, user[unr]->call) || user[unr]->supervisor)
	    header.msgflags |= vermerke_sf(unr_msg, false, quelle, from_box,
					   to_box, header, lastvias);
	  else
	    wln_btext(unr, 7);
	} else
	  wln_btext(unr, 2);
      }
      write_index(list, nr, &header);
      alter_log(false, header.msgnum, header.msgflags, '!', "");
    }
    nr++;
  }
  sfclose(&list);
}


#define blocksize       16384


Static void transfer(short unr, Char *quelle, short nr, short bis,
		     Char *com_)
{
  Char com[256];

  indexstruct header;
  short list, nlist;
  long start, rs, hsize;
  uchar *copybuf;
  long psize, ct;
  short lv, k, x, l, fidx;
  unsigned short new_lt, lt, acc1, acc2;
  boolean hit, first_disp;
  uchar fbyte;
  boolean first, cerr, ok;
  unsigned short ics;
  Char in_index[256];
  Char in_info[256];
  Char out_index[256];
  Char out_info[256];
  Char nach[256], hs[256];
  Char w[256], w1[256];
  Char new_mbx[41];
  userstruct *WITH;
  Char STR1[42];
  Char STR7[256];

  strcpy(com, com_);
  debug(2, unr, 50, quelle);
  first_disp = true;
  hit = false;
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  new_mbx[0] = '\0';
  new_lt = 60000L;

  k = strpos2(com, "#", 1);
  if (k > 0) {
    *hs = '\0';
    x = k + 1;
    l = strlen(com);
    while (x <= l && com[x - 1] == ' ')
      x++;
    while (x <= l && isdigit(com[x - 1])) {
      sprintf(hs + strlen(hs), "%c", com[x - 1]);
      x++;
    }
    if (*hs != '\0')
      new_lt = (unsigned short)Str2int(hs);
    strdelete((void *)com, k, x - k);
  }

  k = strpos2(com, "@", 1);
  if (k > 0) {
    if (strlen(com) - k <= 40) {
      strsub(new_mbx, com, k + 1, strlen(com) - k);
      cut(com, k - 1);
      del_lastblanks(com);
      del_blanks(new_mbx);

    if (!callsign(com) && !callsign(quelle))
      new_mbx[0] = '\0';
    }
  }
  get_word(com, nach);
  if (*nach != '\0')
    switch_to_default_board(nach);
  check_lt_acc(quelle, &lt, &acc1);
  check_lt_acc(nach, &lt, &acc2);
  if (*new_mbx == '\0' && callsign(nach)) {
    user_mybbs(nach, new_mbx);
    if (*new_mbx == '\0')
      strcpy(new_mbx, Console_call);
  }
  if (strpos2(new_mbx, ".", 1) == 0)
    complete_hierarchical_adress(new_mbx);

  if (!((unsigned long)strlen(quelle) < 32 &&
	((1L << strlen(quelle)) & 0x1fe) != 0 &&
	(unsigned long)strlen(nach) < 32 &&
	((1L << strlen(nach)) & 0x1fe) != 0 && strcmp(quelle, nach) &&
	(quelle[0] != 'T' && quelle[0] != 'M' && quelle[0] != 'X' ||
	 strlen(quelle) != 1) && ((nach[0] != 'E' && nach[0] != 'T' &&
				   nach[0] != 'M' &&
				   nach[0] != 'X') || strlen(nach) != 1) &&
	(strlen(nach) != 1 || may_sysaccess(unr, nach)) &&
	valid_boardname(nach) && acc1 <= WITH->level &&
	acc2 <= WITH->level)) {
    wln_btext(unr, 2);
    return;
  }


  if (WITH->lastprocnumber > 0) {
    nr = WITH->lastprocnumber;
    WITH->lastprocnumber = 0;
    first_disp = false;

  }

  if (create_syslog && first_disp && may_sysaccess(unr, quelle))
    append_syslog(unr);
  sprintf(in_index, "%s%s%c%s", indexdir, quelle, extsep, idx_e);
  sprintf(in_info, "%s%s%c%s", infodir, quelle, extsep, inf_e);
  if (!(exist(in_index) && exist(in_info))) {
    wln_btext(unr, 2);
    return;
  }
  if (!callsign(quelle))
    copy_eralog(true);
  lv = sfsize(in_index) / sizeof(indexstruct);
  if (bis > lv)
    bis = lv;
  first = true;
  while (nr <= bis) {
    if (!first && statclock() - WITH->cputime >= ttask) {
      WITH->lastprocnumber = nr;
      goto _L1;
    }

    cerr = false;
    fbyte = 0;
    list = sfopen(in_index, FO_RW);
    if (list >= minhandle) {
      read_index(list, nr, &header);
      ics = 0;
      if (header.deleted == WITH->hidden && header.level <= WITH->level &&
	  check_hcs(header)) {
	if (!strcmp(header.absender, WITH->call) ||
	    !strcmp(header.dest, WITH->call) ||
	    !strcmp(quelle, WITH->call) || may_sysaccess(unr, quelle)) {
	  first = false;

	  if (!callsign(quelle)) {
	    if (!callsign(nach) || !strcmp(quelle, "D")) {
	      header.deleted = true;
	      header.erasetime = clock_.ixtime;
	      header.eraseby = EB_TRANSFER;
	      add_eraseby(user[unr]->call, &header);
	      write_index(list, nr, &header);
	    }
	  } else
	    add_readby(unr, &header, false);

	  sfclose(&list);
	  header.deleted = false;
	  header.eraseby = EB_NONE;
	  *header.rxfrom = '\0';
	  x = 1;
	  while (x > 0) {
	    x = strpos2(header.readby, "-", 1);
	    if (x > 0)
	      strdelete((void *)header.readby, x, 7);
	  }

	  psize = blocksize;
	  if (psize > header.packsize)
	    psize = header.packsize;

	  dpgetmem(&copybuf, psize);
	  if (copybuf != NULL) {
	    list = sfopen(in_info, FO_READ);
	    if (list >= minhandle) {
	      sfseek(header.start, list, SFSEEKSET);

	      sprintf(out_info, "%s%s%c%s", infodir, nach, extsep, inf_e);
	      if (exist(out_info))
		nlist = sfopen(out_info, FO_RW);
	      else
		nlist = sfcreate(out_info, FC_FILE);

	      if (nlist >= minhandle) {
		start = sfseek(0, nlist, SFSEEKEND);

		hsize = 0;
		ok = true;
		rs = header.packsize;
		while (rs > 0 && ok) {
		  if (rs > psize)
		    rs = psize;
		  ct = sfread(list, rs, copybuf);

		  if (hsize == 0)
		    fbyte = copybuf[0];
		  if (ct == rs && fbyte == header.firstbyte) {
		    checksum16_buf(copybuf, rs, &ics);
		    ct = sfwrite(nlist, rs, copybuf);
		    if (ct == rs)
		      hsize += ct;
		    else {
		      debug(0, unr, 50, "write error");
		      cerr = true;
		      ok = false;
		    }
		  } else {
		    debug(0, unr, 50, "read error");
		    cerr = true;
		    ok = false;


		  }
		  rs = header.packsize - hsize;
		}

		if (!cerr && header.infochecksum != 0) {
		  cerr = (header.infochecksum != ics);
		  if (cerr)
		    debug(0, unr, 50, "checksum error in mail");
		}

		if (!cerr && strcmp(quelle, "D") &&
		    (header.pmode & (PM_HUFF2 | TBIN)) == 0) {
		  /* Transfervermerk geht nur bei ungepackten nicht-BIN - mails */
		  if (!may_sysaccess(unr, nach) || header.msgtype != 'B' ||
		      callsign(nach)) {
		    sprintf(hs, "TRANSFER by %s@%s at %s %s UTC",
			    WITH->call, Console_call, clock_.datum,
			    clock_.zeit);
		    checksum16(10, &ics);
		    checksum16_buf(hs, strlen(hs), &ics);
		    checksum16(10, &ics);
		    string_to_file(&nlist, "", true);
		    string_to_file(&nlist, hs, true);
		    hsize += strlen(hs) + 2;
		    header.packsize = hsize;
		    header.size = hsize;
		    header.infochecksum = ics;
		  }
		}

		sfclose(&list);
		sfclose(&nlist);
		dpfreemem(&copybuf, psize);

		if (!cerr) {
		  sprintf(out_index, "%s%s%c%s",
			  indexdir, nach, extsep, idx_e);

		  header.rxdate = clock_.ixtime;
		  header.start = start;
		  header.level = acc2;
		  if (new_lt > 1000)
		    new_lt = header.txlifetime;
		  check_lt_acc(nach, &new_lt, &acc2);
		  header.lifetime = new_lt;

		  if (callsign(nach) && header.msgtype == 'B')
		    header.msgtype = 'P';
		  else if (!callsign(nach) && header.msgtype == 'P')
		    header.msgtype = 'B';

		  if (callsign(nach) && strcmp(header.absender, WITH->call) &&
		      strcmp(quelle, "D")) {
		    sprintf(hs, "CP %s: %s", WITH->call, header.betreff);
		    cut(hs, 79);
		    strcpy(header.betreff, hs);
		  }

		  if (callsign(quelle) || callsign(nach)) {
		    *w = '\0';
		    if (!strcmp(quelle, "D")) {
		      if (header.msgflags & (MSG_MINE | MSG_SFRX) != 0){
		        if (*new_mbx == '\0' || !strcmp(nach, header.dest))
		          strcpy(new_mbx, header.verbreitung);
		      }
		      alter_log(true, header.msgnum, header.msgflags, 'E', "");
		    } else
		      new_bid(w);
		    if (*new_mbx != '\0') {
		      strcpy(header.dest, nach);
		      strcpy(header.verbreitung, new_mbx);
		      header.fwdct = 0;
		      *header.readby = '\0';
		    }
		    if (*w != '\0') {
		      unhpath(header.verbreitung, w1);
		      if (callsign(w1))
			strcpy(header.id, w);
		    }
		    header.msgflags &= ~(MSG_SFWAIT | MSG_PROPOSED
		  	| MSG_SFTX | MSG_SFERR | MSG_SFNOFOUND
		  	| MSG_REJECTED | MSG_DOUBLE);
		    header.msgnum = new_msgnum();
		  } else {
		    if (!strcmp(quelle, "D"))
		      if (header.msgflags & (MSG_MINE | MSG_SFRX) != 0){
		        if (*new_mbx == '\0' || !strcmp(nach, header.dest))
		          strcpy(new_mbx, header.verbreitung);
		      }
		    alter_log(true, header.msgnum, header.msgflags, 'E', "");
		    header.msgnum = new_msgnum();
		    alter_fwd('T', header.id, header.msgnum, nach, "");
		  }
		  
		  write_log_and_bid(nach,
		    sfsize(out_index) / sizeof(indexstruct) + 1, header);

		  if (exist(out_index))
		    list = sfopen(out_index, FO_RW);
		  else
		    list = sfcreate(out_index, FC_FILE);

		  if (list >= minhandle) {
		    write_index(list, -1, &header);
		    sfclose(&list);
		    if (first_disp) {
		      hit = true;
		      w_btext(unr, 82);
		      sprintf(STR7, " %s -> %s", quelle, nach);
		      wuser(unr, STR7);
		    }
		    if (*new_mbx != '\0') {
		      *w = '\0';
		      fidx = sfsize(out_index) / sizeof(indexstruct);
		      if (first_disp) {
			sprintf(STR1, "@%s", new_mbx);
			wlnuser(unr, STR1);
			set_forward(-1, unr, nach, w, fidx, fidx, "FORWARD",
				    w, w);
		      } else
			set_forward(-1, -1, nach, w, fidx, fidx, "FORWARD", w,
				    w);
		    }
		  } else
		    wlnuser(unr, "file error (14)");

		} else
		  wlnuser(unr, "file error (12)");

		if (first_disp) {
		  wlnuser0(unr);
		  first_disp = false;
		}

	      } else
		sfclose(&list);
	    } else
	      wlnuser(unr, "file error (17)");
	  } else
	    boxprotokoll("Error #1026");


	} else {
	  sfclose(&list);
	  wln_btext(unr, 7);
	}

      } else {
	sfclose(&list);
      }
    } else
      wlnuser(unr, "file error (18)");
    nr++;
  }

_L1:
  if (!callsign(quelle))
    copy_eralog(false);
  if (!hit && first_disp)
    wln_btext(unr, 2);

}

#undef blocksize


boolean select_file(short unr, Char *pfad, Char *name, Char *titel)
{

  if (user[unr]->console)
    return (boxgetfilename(pfad, name, titel));
  else
    return false;
}


void export_brett(short unr, Char *brett, short s, short e, Char *option1,
		  Char *search, Char *fname)
{
  boolean ok, sf;
  short olda, handle;
  indexstruct lheader;
  Char exname[256];
  Char option[256], pfad[256], name[256];
  Char STR1[256];

  debug(2, unr, 51, brett);
  strcpy(name, fname);
  ok = true;
  sf = user[unr]->f_bbs;
  strcpy(option, option1);

  if (*name == '\0')
    sprintf(name, "%sexport%c001", savedir, extsep);
  validate(name);

  if (!ok)
    return;

  if (!sf) {
    sprintf(STR1, "export: %s", name);
    wlnuser(unr, STR1);
  }

  handle = sfcreate(name, FC_FILE);

  if (handle < minhandle) {
    if (!sf)
      wln_btext(unr, 46);
    return;
  }
  sprintf(user[unr]->input2, "%ld", handle);
  olda = user[unr]->action;
  user[unr]->action = 76;
  user[unr]->tempbinname[0] = '\0';
  strcat(option, "+");
  read_brett(unr, nohandle, brett, s, e, option, search, 0, &lheader);
  sfclose(&handle);
  if (user[unr] == NULL)
    return;
  user[unr]->action = olda;

  /* Wenn es sich um ein Binaerfile gehandelt hat, so bekommen   */
  /* wir den Filenamen im tempbinname zurueck und koennen so die */
  /* Datei nachtraeglich umbenennen                              */

  strcpy(pfad, user[unr]->tempbinname);
  del_path(pfad);

  if (*pfad == '\0')
    return;
  if (sfsize(name) == 0)
    sfdelfile(name);
  strcpy(exname, name);
  get_path(exname);
  strcat(exname, pfad);
  if (!strcmp(exname, name))
    return;
  validate(exname);   /* sicherstellen, dass nicht bereits eine    */
  /* Datei gleichen Namens existiert           */
  sfrename(name, exname);
  strcpy(fname, exname);
  if (!sf) {
    sprintf(STR1, "export renamed to: %s", fname);
    wlnuser(unr, STR1);
  }
}


void read_for_view(short unr, Char *cmd_)
{
  Char cmd[256];
  Char rubrik[256];
  Char w1[256];
  Char vname[256];
  short nr, handle;
  indexstruct lheader;

  strcpy(cmd, cmd_);
  debug(2, unr, 52, cmd);
  get_word(cmd, rubrik);
  get_word(cmd, w1);
  if (*w1 == '\0')
    return;
  sprintf(vname, "%s%s%c%s", tempdir, rubrik, extsep, w1);
  nr = Str2int(w1);
  handle = sfcreate(vname, FC_FILE);
  if (handle < minhandle)
    return;
  read_brett(unr, handle, rubrik, nr, nr, "+ ", "", 0, &lheader);
  sfclose(&handle);
  boxstartedit(vname, NULL, 0, 0, false, false, true);
  if (!hold_view)
    sfdelfile(vname);
}


unsigned short read_for_bcast(Char *rubrik, short nr, Char *vname,
			      indexstruct *header)
{
  unsigned short Result;
  short handle;

  debug(2, 0, 53, rubrik);
  handle = sfcreate(vname, FC_FILE);
  if (handle < minhandle)
    return 0xffffL;
  Result = read_brett(-1, handle, rubrik, nr, nr, "+B", "", 0, header);
  sfclose(&handle);
  return Result;
}


Static void name_ok(short unr)
{
  userstruct *WITH;
  Char STR1[10];

  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (!WITH->se_ok)
    return;
  if (*WITH->name == '\0')
    wln_btext(unr, 21);
  if (*WITH->mybbs == '\0' || WITH->mybbsmode == 'G'
      || clock_.ixtime - WITH->mybbsupd >= 7776000) {
    sprintf(STR1, "%s: ", WITH->call);
    wuser(unr, STR1);
    wln_btext(unr, 22);
  }
}


void begruessung(short unr)
{
  Char hs[256];
  uchar d, m, y, h, min, s;
  short dubarr[5];
  boolean dub;
  Char fname[256];
  Char pwd[256];
  short x, y1, z, d1;
  userstruct *WITH;
  Char STR1[256], STR7[256], STR13[256], STR14[256];
  Char STR17[84];
  Char STR19[24];

  debug0(1, unr, 54);
  if (!boxrange(unr))
    return;

  WITH = user[unr];
  *pwd = '\0';
  strcpy(hs, WITH->call);
  lower(hs);
  sprintf(STR1, "%s%s%cpwd", boxsfdir, hs, extsep);
  if (exist(STR1)) {
    utc_clock();
    strcpy(pwd, clock_.datum);
    strdelete((void *)pwd, 6, 1);
    strdelete((void *)pwd, 3, 1);
    strcpy(hs, clock_.zeit);
    strdelete((void *)hs, 6, 3);
    strdelete((void *)hs, 3, 1);
    sprintf(STR7, "%s%s", pwd, hs);
    *WITH->sfpwtn = '\0';
    calc_pwdb(WITH->call, STR7, WITH->sfpwdb);
    sprintf(pwd, " %s%s", strcpy(STR14, pwd), hs);
  } else if (!WITH->se_ok && *WITH->password != '\0') {
    if (WITH->sfmd2pw) {  /* soll im sf mit MD2 einloggen */
      *WITH->sfpwdb = '\0';
      calc_MD2_prompt(pwd);
      calc_MD2_pw(pwd, WITH->password, WITH->sfpwtn);
      sprintf(pwd, " [%s]", strcpy(STR13, pwd));
    } else {
      for (x = 0; x <= 4; x++) dubarr[x] = 0;
      y1 = strlen(WITH->password);
      for (x = 1; x <= 5; x++) {
	do {
          dub = false;
	  z = dp_randomize(1, y1);
	  for (d1 = 0; d1 < x - 1; d1 ++) {
	    if (dubarr[d1] == z) dub = true;
	  }
	} while ((dub) || (WITH->password[z - 1] == ' '));
	dubarr[x - 1] = z;
	sprintf(pwd + strlen(pwd), " %ld", z);
      }
      strcpy(hs, pwd);
      strdelete((void *)hs, 1, 1);
      calc_pwtn(WITH->call, hs, WITH->sfpwtn);
    }
  }

  if (WITH->sf_level > 0 && !(WITH->console || WITH->supervisor)) {
/*  if (WITH->sf_level == 2) {
      if (packed_sf) {
	sprintf(STR1, "[THEBOX-1.9-AB1D1FHMR$]%s", pwd);
	wlnuser(unr, STR1);
      } else {
	sprintf(STR1, "[THEBOX-1.9-ADFHMR$]%s", pwd);
	wlnuser(unr, STR1);
      }
    } else { */
      if (packed_sf) {
	sprintf(STR1, "[DP-%s-AB1D1FHMR$]%s", dp_vnr, pwd);
	wlnuser(unr, STR1);
      } else {
	sprintf(STR1, "[DP-%s-ADFHMR$]%s", dp_vnr, pwd);
	wlnuser(unr, STR1);
/*    } */
      w_btext(unr, 52);
      sprintf(STR17, " %s!", WITH->name);
      wlnuser(unr, STR17);
    }
    if (WITH->sf_level < 3)
      boxspoolfend(WITH->pchan);
    if (WITH->console) {
      WITH->supervisor = true;
      WITH->se_ok = true;
      WITH->level = 127;
      WITH->is_authentic = true;
      wlnuser0(unr);
      wln_btext(unr, 12);
    }
    chwuser(unr, '>');
    wlnuser0(unr);
    return;
  }

  if (packed_sf) {
    sprintf(STR1, "[DP-%s-AB1D1FHMR$]%s", dp_vnr, pwd);
    wlnuser(unr, STR1);
  } else {
    sprintf(STR1, "[DP-%s-ADFHMR$]%s", dp_vnr, pwd);
    wlnuser(unr, STR1);
  }

  /*DB0BRB Mailbox Brandenburg - Login: 13.04.93 13:44 UTC   Logins: 5*/

  wuser(unr, connecttext);
  wuser(unr, " - Login: ");
  ixdatum2string(WITH->logindate, hs);
  wuser(unr, hs);
  chwuser(unr, 32);
  ixzeit2string(WITH->logindate, hs);
  strdelete((void *)hs, 6, 3);   /* Keine Sekunden zeigen */
  wuser(unr, hs);
  wuser(unr, " UTC   Logins: ");
  sprintf(hs, "%ld", actual_connects());

  wlnuser(unr, hs);

  sprintf(STR19, "dpbox (Linux) v%s%s", dp_vnr, dp_vnr_sub);
  wlnuser(unr, STR19);

  w_btext(unr, 53);
  sprintf(STR17, " %s!", WITH->name);
  wlnuser(unr, STR17);
  if (WITH->lastdate != WITH->logindate) {
    w_btext(unr, 54);
    decode_ixtime(WITH->lastdate, &d, &m, &y, &h, &min, &s);
    wochentag(WITH->language, d, m, y, hs);

    sprintf(STR7, " %s, ", hs);
    wuser(unr, STR7);
    ixdatum2string(WITH->lastdate, hs);
    wuser(unr, hs);
    chwuser(unr, 32);
    ixzeit2string(WITH->lastdate, hs);
    strdelete((void *)hs, 6, 3);   /* Keine Sekunden zeigen*/
    wlnuser(unr, hs);
  } else
    WITH->lastdate = WITH->logindate - 86400L;

  WITH->in_begruessung = true;
  if (exist(ctext_box))
    show_textfile(unr, ctext_box);

  sprintf(fname, "%sNEWS%c%s", boxlanguagedir, extsep, user[unr]->language);
  if (!exist(fname))
    new_ext(fname, "G");
  if (exist(fname)) {
    wlnuser0(unr);
    show_textfile(unr, fname);
  }
  WITH->in_begruessung = false;

  if (WITH->console) {
    WITH->supervisor = true;
    WITH->se_ok = true;
    WITH->level = 127;
    WITH->is_authentic = true;
    wlnuser0(unr);
    wln_btext(unr, 12);
  }

  name_ok(unr);

  wlnuser0(unr);

  if (*WITH->logincommands != '\0')
    strcpy(hs, WITH->logincommands);
  else
    strcpy(hs, "L");
  box_input(unr, false, true, hs, true);

}


/* Nur bei Anwahl von Modem-Port: erstmal das Password eingeben. Das   */
/* PW wird, anders als ueberall sonst, KOMPLETT abgefordert. Ueber     */
/* Draht hoert ja nur der Verfassungsschutz zu...                      */

Static void enter_password(short unr, Char *eingabe, boolean last)
{
  userstruct *WITH;

  debug(2, unr, 55, eingabe);
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (!strcmp(eingabe, WITH->password)) {
    WITH->se_ok = false;
    WITH->level = WITH->plevel;
    WITH->is_authentic = (WITH->pwsetat + holddelay < clock_.ixtime);

    switch (WITH->pwmode) {

    case PWM_SEND_ERASE:
    case PWM_MUST_PRIV:
      WITH->se_ok = true;
      break;

    case PWM_RSYSOP:
    case PWM_RSYSOPPRIV:
      WITH->se_ok = true;
      WITH->rsysop = true;
      break;

    case PWM_SYSOPPRIV:
    case PWM_SYSOP:
      WITH->se_ok = true;
      WITH->supervisor = true;
      break;
    }
    begruessung(unr);
    if (user[unr] != NULL)
	  /* zur Unterdrueckung des doppelten Logon-Prompts */
	    WITH->action = 86;
    return;
  }
  if (last)
    melde_user_ab(unr, false);
  else {
    wuser(unr, "Password: ");
    WITH->action++;
  }
}


Static void switch_bbsbcast(short unr, Char *w)
{
  wuser(unr, "BROADCAST was ");
  if (send_bbsbcast)
    wlnuser(unr, "ON");
  else
    wlnuser(unr, "OFF");
  if (*w != '\0')
    send_bbsbcast = (strcmp(w, "ON") == 0);
  wuser(unr, "BROADCAST now ");
  if (send_bbsbcast)
    wlnuser(unr, "ON");
  else
    wlnuser(unr, "OFF");
}


Static void set_debuglevel(short unr, Char *w)
{
  Char hs[256];
  short k;

  if (*w != '\0') {
    k = Str2int(w);
    if (k < 0)
      k = 0;
    else if (k > 6)
      k = 6;
    debug_level = k;
  }
  sprintf(hs, "DEBUG %ld", debug_level);
  wlnuser(unr, hs);
}


boolean set_reply_flag(short unr, Char *brett, short nr)
{
  boolean Result;
  short k, x;
  indexstruct header;
  Char STR1[256];

  Result = false;
  if (!boxrange(unr))
    return Result;
  if (strcmp(user[unr]->call, brett))
    return Result;
  user[unr]->in_reply = true;
  sprintf(STR1, "%s%s%c%s", indexdir, brett, extsep, idx_e);
  k = sfopen(STR1, FO_RW);
  if (k >= minhandle) {
    read_index(k, nr, &header);
    if (check_hcs(header)) {
      x = in_readby(brett, header.readby);
      if (x > 0)
	header.readby[x - 2] = ',';
      else
	add_readby(unr, &header, false);
      write_index(k, nr, &header);
      Result = true;
    }
    sfclose(&k);
  }
  user[unr]->in_reply = false;
  return Result;
}


Static boolean get_reply_info(short unr, Char *eingabe,
			      indexstruct *rep_header)
{
  boolean direct_reply;
  Char w[256], w1[256];
  short rep_handle;
  uchar *pc;
  long l;
  userstruct *WITH;
  Char STR1[256];

  if (!boxrange(unr))
    return false;
  WITH = user[unr];
  if (*eingabe != '\0') {
    direct_reply = false;
    get_word(eingabe, w);
    get_word(eingabe, w1);
    if (zahl(w) && Str2int(w) > 0) {
      strcpy(WITH->reply_brett, WITH->brett);
      WITH->reply_nr = Str2int(w);


    } else if ((unsigned long)strlen(w) < 32 &&
	       ((1L << strlen(w)) & 0x1fe) != 0 && Str2int(w1) > 0) {
      strcpy(WITH->reply_brett, w);
      WITH->reply_nr = Str2int(w1);
    }
  } else {
    direct_reply = true;
  }
  
  upper(WITH->reply_brett);

  sprintf(STR1, "%s%s%c%s", indexdir, WITH->reply_brett, extsep, idx_e);

  if (WITH->reply_nr <= 0)
    return false;
  if (direct_reply || WITH->supervisor) {
    if (sfsize(STR1) / sizeof(indexstruct) < WITH->reply_nr)
      return false;
  } else {
    if (last_valid(unr, WITH->reply_brett, false, &pc, &l) < WITH->reply_nr)
      return false;
  }
  
  rep_handle = sfopen(STR1, FO_READ);
  if (rep_handle < minhandle)
    return false;
  read_index(rep_handle, WITH->reply_nr, rep_header);
  sfclose(&rep_handle);
  if (!rep_header->deleted || direct_reply || WITH->supervisor)
    return true;
  return false;
}


Static void set_reply_flag_directly(short unr, Char *eingabe)
{
  indexstruct header;

  if (!get_reply_info(unr, eingabe, &header))
    return;
  if (set_reply_flag(unr, user[unr]->reply_brett, user[unr]->reply_nr))
    wlnuser(unr, "OK");
  else
    wlnuser(unr, "NO");
}


Static boolean set_reply_address(boolean for_comment, short unr,
				 Char *eingabe, Char *hs, Char *msgtype)
{
  boolean Result;
  indexstruct rep_header;
  Char rep_call[7];
  Char rep_brett[9];
  Char rep_title[81];
  Char rep_mbx[7], rep_box[7];
  Char w2[256];
  userstruct *WITH;
  Char STR1[84];
  Char STR13[256];

  Result = false;
  if (!get_reply_info(unr, eingabe, &rep_header))
    return Result;

  WITH = user[unr];
  strcpy(rep_call, rep_header.absender);
  strcpy(rep_brett, rep_header.dest);
  strcpy(rep_title, rep_header.betreff);
  unhpath(rep_header.verbreitung, rep_mbx);
  strcpy(rep_box, rep_header.sendbbs);
  cut(rep_title, 77);
  sprintf(rep_title, "RE:%s", strcpy(STR1, rep_title));
  check_replytitle(rep_title);
  strcpy(eingabe, rep_title);

  if (!for_comment) {
    user_mybbs(rep_call, w2);
    if (*w2 == '\0')
      strcpy(w2, rep_box);
    if (*w2 != '\0')
      sprintf(hs, "%s @ %s", rep_call, w2);
    else
      strcpy(hs, rep_call);

    sprintf(STR13, "REPLY: %s", hs);
    wlnuser(unr, STR13);
    sprintf(hs + strlen(hs), " %s", eingabe);
    sprintf(STR13, "       %s", eingabe);
    wlnuser(unr, STR13);
    wlnuser0(unr);
    *msgtype = 'P';
    return true;
  }

  if (callsign(rep_brett)) {
    user_mybbs(rep_brett, w2);
    if (*w2 == '\0')
      strcpy(w2, rep_mbx);
  } else
    strcpy(w2, rep_mbx);
  if (*w2 != '\0')
    sprintf(hs, "%s @ %s", rep_brett, w2);
  else
    strcpy(hs, rep_brett);
  sprintf(STR13, "COMMENT: %s", hs);
  wlnuser(unr, STR13);
  sprintf(hs + strlen(hs), " %s", eingabe);
  sprintf(STR13, "         %s", eingabe);
  wlnuser(unr, STR13);
  wlnuser0(unr);
  *msgtype = '\0';   /* sucht send_check() sich dann raus */
  return true;
}


Static void read_next(short unr)
{
  Char board[256];
  Char search[256];
  short number;
  indexstruct lheader;
  userstruct *WITH;

  if (!boxrange(unr))
    return;
  WITH = user[unr];
  strcpy(board, WITH->reply_brett);
  number = WITH->reply_nr;
  number++;
  *search = '\0';
  read_brett(unr, nohandle, board, number, number, WITH->lastroption, search,
	     0, &lheader);
}


Static void mkf_cmd(short unr, Char *eingabe)
{
  indexstruct header;
  Char hs[256], w[256];
  Char STR1[256], STR7[256];

  if (!boxrange(unr))
    return;
  if (!get_reply_info(unr, eingabe, &header)) {
    wln_btext(unr, 65);
    return;
  }
  sprintf(hs, "%s/%s/$%s", header.absender, header.dest, header.id);
      /*,' / ',header.betreff*/
  cut(hs, 79);
  wlnuser(unr, hs);
  wlnuser0(unr);
  sprintf(hs, "F@%s #14 %s", e_m_verteiler, strcpy(STR7, hs));
  send_check(unr, hs, true, 'B');
  if (user[unr]->action != 74) {
    wln_btext(unr, 11);
    return;
  }
  strcpy(hs, "FMAIL / dpbox (Linux)");
  sprintf(hs + strlen(hs), " v%s%s", dp_vnr, dp_vnr_sub);
  wlnuser(unr, hs);
  send_text3(unr, true, hs, true);
  if (user[unr]->action == 74)
    user[unr]->action = 75;
  strcpy(hs, "-----------------------------------");
  wlnuser(unr, hs);
  send_text3(unr, false, hs, true);
  sprintf(hs, "Sender     : %s", header.absender);
  wlnuser(unr, hs);
  send_text3(unr, false, hs, true);
  sprintf(hs, "Board      : %s @ %s", header.dest, header.verbreitung);
  wlnuser(unr, hs);
  send_text3(unr, false, hs, true);
  sprintf(hs, "BID        : $%s", header.id);
  wlnuser(unr, hs);
  send_text3(unr, false, hs, true);
  sprintf(hs, "%ld", header.txlifetime);
  sprintf(hs, "Lifetime   : %s", strcpy(STR7, hs));
  wlnuser(unr, hs);
  send_text3(unr, false, hs, true);
  sprintf(hs, "Subject    : %s", header.betreff);
  cut(hs, 79);
  wlnuser(unr, hs);
  send_text3(unr, false, hs, true);
  strcpy(hs, header.sendbbs);
  if (*hs != '\0') {
    complete_hierarchical_adress(hs);
    sprintf(hs, "Created in : %s", strcpy(STR7, hs));
    wlnuser(unr, hs);
    send_text3(unr, false, hs, true);
  }
  if (header.txdate != 0) {
    ixdatum2string(header.txdate, w);
    ixzeit2string(header.txdate, hs);
    sprintf(hs, "%s %s", w, strcpy(STR1, hs));
    sprintf(hs, "Created at : %s UTC", strcpy(STR7, hs));
    wlnuser(unr, hs);
    send_text3(unr, false, hs, true);
  }
  strcpy(hs, "-----------------------------------");
  wlnuser(unr, hs);
  send_text3(unr, false, hs, true);
  *hs = '\0';
  wlnuser(unr, hs);
  send_text3(unr, false, hs, true);
  wln_btext(unr, 83);
}


Static void set_selection(short unr, Char *hs)
{
  Char w[256];
  short x;
  userstruct *WITH;

  if (!boxrange(unr))
    return;
  WITH = user[unr];
  WITH->msgselection = 0;
  WITH->hidden = false;
  WITH->undef = false;

  for (x = 0; hs[x] != '\0'; x++) {
    if (hs[x] == ',')
      hs[x] = ' ';
  }

  get_word(hs, w);
  while (*w != '\0') {
    upper(w);
    if (compare(w, "SFWAIT"))
      WITH->msgselection |= MSG_SFWAIT;
    if (compare(w, "PROPOSED"))
      WITH->msgselection |= MSG_PROPOSED;
    if (compare(w, "SFRX"))
      WITH->msgselection |= MSG_SFRX;
    if (compare(w, "SFTX"))
      WITH->msgselection |= MSG_SFTX;
    if (compare(w, "SFERR"))
      WITH->msgselection |= MSG_SFERR;
    if (compare(w, "SFNOFOUND"))
      WITH->msgselection |= MSG_SFNOFOUND;
    if (compare(w, "CUT"))
      WITH->msgselection |= MSG_CUT;
    if (compare(w, "MINE"))
      WITH->msgselection |= MSG_MINE;
    if (compare(w, "BROADCAST"))
      WITH->msgselection |= MSG_BROADCAST;
    if (compare(w, "BROADCAST_RX"))
      WITH->msgselection |= MSG_BROADCAST_RX;
    if (compare(w, "OWNHOLD"))
      WITH->msgselection |= MSG_OWNHOLD;
    if (compare(w, "LOCALHOLD"))
      WITH->msgselection |= MSG_LOCALHOLD;
    if (compare(w, "SFHOLD"))
      WITH->msgselection |= MSG_SFHOLD;
    if (compare(w, "REJECTED"))
      WITH->msgselection |= MSG_REJECTED;
    if (compare(w, "DOUBLE"))
      WITH->msgselection |= MSG_DOUBLE;
    if (compare(w, "OUTDATED"))
      WITH->msgselection |= MSG_OUTDATED;
    if (compare(w, "UNDEF"))
      WITH->undef = true;
    if (compare(w, "HIDDEN") && WITH->supervisor)
      WITH->hidden = true;
    get_word(hs, w);
  }
}


Static boolean find_env(Char *w)
{
  Char res[256];

  sprintf(res, "%s%s", boxsysdir, w);
  if (exist(res)) {
    strcpy(w, res);
    return true;
  }
  sprintf(res, "%s%s", boxsfdir, w);
  if (exist(res)) {
    strcpy(w, res);
    return true;
  }
  sprintf(res, "%s%s", boxdir, w);
  if (exist(res)) {
    strcpy(w, res);
    return true;
  }
  sprintf(res, "%s%s%cbox", boxsysdir, w, extsep);
  if (exist(res)) {
    strcpy(w, res);
    return true;
  }
  return false;
}


Static void do_checkboards(short unr, boolean want, Char *w)
{
  Char cb[256];
  userstruct *WITH;
  Char STR1[256];

  if (!boxrange(unr))
    return;

  WITH = user[unr];
  if (*w != '\0') {
    if (w[0] != ',')
      sprintf(w, ",%s", strcpy(STR1, w));
    if (w[strlen(w) - 1] != ',')
      strcat(w, ",");

    if (want)
      strcpy(cb, WITH->wantcheckboards);
    else
      strcpy(cb, WITH->nocheckboards);

    if (*cb != '\0') {
      strdelete((void *)w, 1, 1);
      if (strlen(cb) + strlen(w) <= 255)
	strcat(cb, w);
      else
	wln_btext(unr, 84);
    } else
      strcpy(cb, w);

    if (want) {
      strcpy(WITH->wantcheckboards, cb);
      *WITH->nocheckboards = '\0';
      wuser(unr, "WantBoard : ");
    } else {
      strcpy(WITH->nocheckboards, cb);
      *WITH->wantcheckboards = '\0';
      wuser(unr, "NotBoard : ");
    }

    strdelete((void *)cb, 1, 1);
    strdelete((void *)cb, strlen(cb), 1);
    wlnuser(unr, cb);

  } else {
    *WITH->nocheckboards = '\0';
    *WITH->wantcheckboards = '\0';

    wln_btext(unr, 85);
  }

  save_userfile(user[unr]);

}


boolean analyse_boxcommand(short unr, Char *eingabe, Char *voll,
			   boolean return_)
{
  boolean Result;
  short s, e, x;
  unsigned short lt, a;
  boolean plus;
  unsigned short oldsel;
  boolean valid_command, valid_command2, resumed;
  short cnr;
  indexstruct lheader;
  Char msgtype;
  boolean onlysys, rep_ok;
  Char w[256], w1[256], w2[256], cmd[256];
  Char search[256];
  Char hs[256];
  Char option[256];
  userstruct *WITH;
  Char STR1[256], STR7[256];
  Char STR14[34];
  short TEMP;
  void (*TEMP1)(short unr, Char *s);
  void (*TEMP2)(short unr, Char *s);

  debug(6, unr, 56, eingabe);
  Result = false;

  if (!boxrange(unr)) {
    *eingabe = '\0';
    return Result;
  }

  WITH = user[unr];
  valid_command = true;
  valid_command2 = false;
  option[0] = '\0';
  plus = false;
  resumed = (WITH->lastprocnumber != 0);

  if (WITH->action == 0) {
    WITH->in_reply = false;

    if (*eingabe != '\0')
      strcpy(WITH->lastcmd, eingabe);

    if (debug_level > 0 && debug_level < 6) {
      if (resumed) {
	sprintf(STR1, "%s (resumed)", eingabe);
	debug(1, unr, 56, STR1);
      } else
	debug(1, unr, 56, eingabe);
    }

    *w = '\0';
    get_word(eingabe, w2);
    strcpy(cmd, w2);
    upper(cmd);
    cut(cmd, 20);
    cnr = find_command(unr, cmd, &onlysys);
    if (cnr == 71)
      onlysys = false;

    if (cnr >= 6 && cnr <= 10 || cnr == 15 || cnr == 16 || cnr == 18 ||
	cnr >= 21 && cnr <= 26 || cnr == 31 || cnr == 122 || cnr == 121 ||
	cnr == 104 || cnr == 101 || cnr == 100 || cnr == 97 || cnr == 96 ||
	cnr == 93 || cnr == 92 || cnr == 89 || cnr == 84 ||
	cnr >= 66 && cnr <= 86 || cnr >= 54 && cnr <= 64 ||
	cnr >= 50 && cnr <= 51 || cnr >= 42 && cnr <= 47 || cnr == 40 ||
	cnr == 39 || cnr == 37 || cnr >= 33 && cnr <= 35)
      WITH->brett[0] = '\0';

    if (cnr == 1 || cnr == 2 || cnr == 5 || cnr == 7 || cnr == 19 ||
	cnr == 27 || cnr == 104 || cnr == 95 || cnr == 47 || cnr == 38 ||
	cnr == 36 || cnr >= 30 && cnr <= 32)
      get_numbers(unr, eingabe, &s, &e, option, search);

    if (cnr >= 8 && cnr <= 13 || cnr >= 15 && cnr <= 17 || cnr == 20 ||
	cnr >= 22 && cnr <= 25 || cnr == 28 || cnr == 29 || cnr == 117 ||
	cnr == 111 || cnr == 102 || cnr == 94 || cnr == 93 || cnr == 92 ||
	cnr == 89 || cnr == 88 || cnr == 80 || cnr == 78 || cnr == 73 ||
	cnr == 72 || cnr == 70 || cnr >= 64 && cnr <= 66 || cnr == 55 ||
	cnr >= 51 && cnr <= 52 || cnr >= 37 && cnr <= 38 || cnr == 33) {
      get_word(eingabe, w);
      upper(w);
    } else if (cnr == 3 || cnr == 27 || cnr == 101 || cnr == 100 ||
	       cnr == 91 || cnr >= 81 && cnr <= 83 || cnr == 76 ||
	       cnr == 57 || cnr == 54)
      get_word(eingabe, w);   /*Linux will gerne auch kleine Filenamen*/


    if (cnr != 2 && cnr != 108 && cnr != 95)
      *WITH->lastroption = '\0';

    if (cnr == 43)
      strcpy(WITH->lastcmd, "*** PASSWORD");

    if (!resumed) {
      if (create_syslog && onlysys && unr != 11)
	append_syslog(unr);
      else if (create_sflog && WITH->f_bbs)
	append_sflog(unr);
      else if (create_userlog && !onlysys && !WITH->f_bbs && cnr != 45)
	append_userlog(unr);
      if (in_protocalls(user[unr]->call))
	append_protolog(unr);
    }

    if (cnr == 9) {  /* Fuer die lieben Baycom-Benutzer */
      if (compare(w, "NEWS") || compare(w, "MESSAGES")) {
	cnr = 104;   /* DIR NEWS -> CS / DIR MESSAGES -> CS < search */
	get_numbers(unr, eingabe, &s, &e, option, search);
      } else if (compare(w, "SENT")) {
	cnr = 104;   /* DIR SENT -> CS < call */
	s = 1;
	e = SHORT_MAX;
	strcpy(search, WITH->call);
      } else if (compare(w, "USERS")) {
	if (*eingabe != '\0') {
	  cnr = 104;   /* DIR USERS search -> CS + < search */
	  get_numbers(unr, eingabe, &s, &e, option, search);
	  strcat(option, "+");
	}
      }
    }


    /* ============================================================================= */
    /* Kommandointerpreter der Box. Im Pseudo-Multitasking ausgefuehrte Befehle sind */
    /* mit einem fuehrenden * markiert                                               */
    /* ============================================================================= */


    switch (cnr) {

    case 0:
      valid_command = false;
      if (WITH->errors < maxerrors && WITH->errors >= 0)
	wln_btext(unr, 1);
      break;

    /*LIST*/
    case 1:
      list_brett(unr, WITH->brett, s, e, option, search);
      break;

    /**READ/*HEADER*/
    case 2:
    case 95:
      if (cnr == 95)   /*HEADER*/
	strcat(option, "=");
      strcpy(WITH->lastroption, option);
      read_brett(unr, nohandle, WITH->brett, s, e, option, search, 0,
		 &lheader);
      break;

    /*IMPORT*/
    case 3:
      if (disk_full)
	wln_btext(unr, 86);
      else {
	strcpy(w1, w);
	upper(w1);
	if (!strcmp(w1, "DIEBOX"))
	  conv_diebox(unr, eingabe);
	else {
	  if (!WITH->console) {
	    if (insecure(w))
	      *w = '\0';
	    else
	      sprintf(w, "%s%s", boxdir, strcpy(STR1, w));
	  }
	  if (exist(w))
	    send_file0(unr, false, w);
	  else
	    wln_btext(unr, 4);
	}
      }
      break;

    /*SEND/REPLY/COMMENT*/
    /*SB/SP/SR*/
    case 4:
    case 48:
    case 49:
      msgtype = '\0';
      if (WITH->tell == nohandle && !WITH->in_begruessung) {

	/* se_ok wird jetzt in SEND_CHECK geprueft, msg an   	*/
	/* CONSOLE_CALL und Sysops ist erlaubt  		*/

	if (disk_full)
	  wln_btext(unr, 86);
	else {
	  if (in_sfp(WITH->call) && !WITH->supervisor) {
	    get_btext(unr, 87, w2);
	    sprintf(hs, "%ld %s", unr, w2);
	    debug(0, unr, 56, "attempt to send without SID");
	    disc_user(-1, hs);
	  } else {
	    WITH->input2[0] = '\0';
	    if (cnr == 49 || cnr == 48) {
	      rep_ok = set_reply_address(cnr == 49, unr, eingabe, hs,
					 &msgtype);
	      WITH->in_reply = (rep_ok &&
				!strcmp(WITH->reply_brett, WITH->call));
	    } else {
	      rep_ok = false;
	      strcpy(hs, eingabe);
	      if (strlen(cmd) == 2) {
		if (cmd[1] == 'P' || cmd[1] == 'B')
		  msgtype = cmd[1];
	      }
	    }


	    if (cnr != 4 && !rep_ok)
	      wln_btext(unr, 37);
	    else
	      send_check(unr, hs, true, msgtype);
	  }

	}
      } else
	wln_btext(unr, 65);

      break;

    /**ERASE/*KILL*/
    case 5:
    case 47:
      if (WITH->se_ok)
	erase_brett(unr, WITH->brett, s, e, option, search, false, cnr == 47);
      else
	wln_btext(unr, 65);
      break;

    /*TELL*/
    case 6:
      if (WITH->se_ok && !WITH->in_begruessung) {
	upper(eingabe);
	get_word(eingabe, w);   /*Zielcall*/
	get_word(eingabe, w1);   /*Kommando*/
	if (callsign(w)) {
	  unhpath(w, hs);
	  if (strcmp(hs, Console_call) && strchr(eingabe, ';') == NULL && strlen(eingabe) <= 80) {
	    sprintf(w2, "%s %s @ %s", w1, eingabe, ownhiername);
	    sprintf(STR1, "%s%s%cTEL", boxstatdir, WITH->call, extsep);
	    append(STR1, "        ", true);
	    sprintf(user[unr]->input2, "%s%s%cTEL",
		    boxstatdir, WITH->call, extsep);
	    sprintf(hs, "T @ %s < %s %s", w, WITH->call, w2);
	    user[unr]->tell = -99;
	    send_check(unr, hs, false, 'B');
	    user[unr]->tell = nohandle;
	    sprintf(STR1, "%s%s%cTEL", boxstatdir, WITH->call, extsep);
	    sfdelfile(STR1);
	    WITH->brett[0] = '\0';
	  } else
	    wln_btext(unr, 2);
	} else
	  wln_btext(unr, 2);
      } else
	wln_btext(unr, 65);
      break;

    /**CHECK/*HOLD/*CS*/
    case 7:
    case 31:
    case 104:
      if (s == e)
	s = 1;
      plus = (strchr(option, '+') != NULL);
      oldsel = WITH->msgselection;
      if (cnr == 31) {
	WITH->msgselection = MSG_SFHOLD | MSG_LOCALHOLD;
	if (e == 1)
	  e = SHORT_MAX;
	if (strchr(option, '!') != NULL) {
	  while (strchr(option, '!') != NULL)
	    strdelete((void *)option, strpos2(option, "!", 1), 1);
	  if (!plus && *WITH->brett == '\0') {
	    if (WITH->lastprocnumber == 0) {
	      wlnuser(unr, "Userfiles:");
	      wlnuser0(unr);
	    }
	    if ((unsigned)WITH->lastprocnumber < 32 &&
		((1L << WITH->lastprocnumber) & 0x5) != 0) {
	      check(unr, search, s, e, true, option, WITH->brett, false);
	      if (WITH->lastprocnumber != 0)
		WITH->lastprocnumber = 2;
	    }

	    if (WITH->lastprocnumber == 0) {
	      wlnuser0(unr);
	      wlnuser(unr, "Bulletins:");
	      wlnuser0(unr);
	    }
	  }
	}
      }
      if (WITH->lastprocnumber != 2)
	check(unr, search, s, e, plus, option, WITH->brett, cnr == 104);
      WITH->msgselection = oldsel;
      break;

    /*USAGE*/
    case 8:
      if (WITH->supervisor && !strcmp(w, "PW"))
	show_pwuser(unr);
      else if (WITH->supervisor && (!strcmp(w, "OFF") || !strcmp(w, "KILL"))) {
	gesperrt = true;
	if (!strcmp(w, "KILL"))
	  disc_user(unr, "USER maintenance works, sri. try later.");
	if (create_syslog)
	  append_syslog(unr);
      } else if (WITH->supervisor && !strcmp(w, "ON")) {
	gesperrt = false;
	if (create_syslog)
	  append_syslog(unr);
      } else if (WITH->supervisor &&
		 (!strcmp(w, "HISCORE") || !strcmp(w, "HIGHSCORE"))) {
	sprintf(hs, " %ld", hiscore_connects);
	wln_btext(unr, 88);
	wlnuser(unr, hs);
	if (!strcmp(eingabe, "-")) {
	  hiscore_connects = 0;
	  update_bidseek();
	  flush_bidseek();
	  wln_btext(unr, 89);
	}
      } else {
	if (callsign(w))
	  strcpy(option, "+");
	else if (w[0] == '@') {
	  strcpy(option, "@");
	  strdelete((void *)w, 1, 1);
	  if (WITH->supervisor && strpos2(eingabe, "-a", 1) > 0)
	    strcpy(option, "!");
	  else if (strpos2(eingabe, "-c", 1) > 0)
	    strcat(option, "/");
	}
	get_word(eingabe, w1);
	if (WITH->supervisor && !strcmp(w1, "-d") &&
	    strchr(option, '!') == NULL) {
	  strcat(option, "-");
	  if (create_syslog)
	    append_syslog(unr);
	}
	show_user(unr, w, option);
      }
      break;

    /**DIR*/
    case 9:
      if (compare(w, "USERS"))
	show_dir(unr, true, true, false);
      else if (compare(w, "INFO"))
	show_dir(unr, false, true, false);
      else if (compare(w, "ALL")) {
	if (WITH->lastprocnumber == 0)
	  WITH->lastprocnumber3 = 0;
	if (WITH->lastprocnumber3 == 0)
	  show_dir(unr, false, false, false);
	if (WITH->lastprocnumber == 0) {
	  WITH->lastprocnumber3 = 1;
	  wlnuser0(unr);
	}
	if (WITH->lastprocnumber3 == 1)
	  show_dir(unr, true, false, false);
      } else if (compare(w, "LOST") /* && WITH->supervisor */ )
	show_dir(unr, true, true, true);
      else
	show_dir(unr, false, false, false);
      break;

    /*HELP*/
    case 10:
      show_help(unr, w);
      break;

    /*HIDDEN*/
    case 11:
      WITH->hidden = positive_arg(w);
      break;

    /*LOGINTIME*/
    case 12:
      new_login(unr, w);
      break;

    /* Achtung: wegen der bloeden Protokollhuddelei von //COMP wird  */
    /* nun gewartet, bis nach QUIT alles im SPOOLER stehende ausge-  */
    /* geben worden ist, bevor der User auch wirklich aus der Box    */
    /* geworfen wird. Dann klappt auch das Zurueckschalten in den    */
    /* unkomprimierten Modus wieder...                               */

    /*QUIT/ABORT*/
    case 13:
    case 14:
      if (WITH->tell == nohandle && !WITH->in_begruessung) {
	if (!WITH->se_ok && WITH->pwmode >= 8)
	  cnr = 14;

	if (cnr == 13 && !strcmp(w, "R"))
	{  /* reset der loginzeit, nichts weiter */
	  WITH->lastdate = WITH->logindate;
	  save_userfile(user[unr]);
	  WITH->logindate = clock_.ixtime;
	  for (x = 1; x <= maxuser; x++) {
	    if (user[x] != NULL) {
	      if (!strcmp(user[x]->call, WITH->call)) {
		user[x]->lastdate = WITH->lastdate;
		user[x]->logindate = WITH->logindate;
	      }
	    }
	  }
	  wlnuser(unr, "OK");
	} else
	  do_quit(unr, cnr == 14);

      }
      break;


    /**STATISTIK*/
    case 15:
      show_statistik(unr, w);
      break;

    /*VERSION*/
    case 16:
      show_version(unr, !strcmp(w, "X") || !strcmp(w, "+"));
      break;


    /*TIME*/
    case 18:
      show_systemtime(unr);
      break;

    /**TRANSFER*/
    case 19:
      if (WITH->se_ok) {
	upper(eingabe);
	transfer(unr, WITH->brett, s, e, eingabe);
      } else
	wln_btext(unr, 65);
      break;

    /*NAME*/
    case 20:
      if (WITH->se_ok) {
	if (callsign(w) && WITH->supervisor && *eingabe != '\0') {
	  if (create_syslog)
	    append_syslog(unr);
	  strcpy(w2, w);
	} else {
	  strcpy(w2, WITH->call);
	  sprintf(eingabe, "%s %s", w, strcpy(STR7, eingabe));
	}
	del_mulblanks(eingabe);
	del_lastblanks(eingabe);
	if (*eingabe != '\0' || WITH->tell == nohandle)
	  change_name(unr, w2, eingabe);
      } else
	wln_btext(unr, 65);
      break;

    /*BBS*/
    case 21:
      del_leadblanks(eingabe);
      upper(eingabe);
      if (WITH->supervisor && !strcmp(eingabe, "HASH"))
	disp_hboxhash(unr);
      else if (*eingabe != '\0' || WITH->console)
	show_bbs_info(unr, eingabe);
      else
	wln_btext(unr, 2);
      break;

    /*SPEAK*/
    case 22:
      if (WITH->se_ok) {
	if (callsign(w) && WITH->supervisor && *eingabe != '\0') {
	  if (create_syslog)
	    append_syslog(unr);
	  strcpy(w2, w);
	  get_word(eingabe, w);
	  upper(w);
	} else
	  strcpy(w2, user[unr]->call);

	change_language(unr, w2, w);
      } else
	wln_btext(unr, 65);
      break;

    /*SF*/
    case 23:
      if (callsign(w))
	start_sf(unr, w, eingabe);
      else {
	if (!strcmp(w, "ON"))
	  sf_allowed = true;
	else if (!strcmp(w, "OFF") || !strcmp(w, "KILL")) {
	  sf_allowed = false;
	  if (!strcmp(w, "KILL"))
	    disc_user(unr, "SF");
	  kill_all_routing_flags();
	}
      }
      break;


    /*SFLEVEL/LEVEL/PWMODE*/
    case 25:
    case 29:
    case 66:
      if (WITH->tell == nohandle && WITH->supervisor) {
	if (callsign(w) && *eingabe != '\0') {
	  get_word(eingabe, w1);
	  s = Str2int(w1);
	  change_levels(unr, cnr, w, s);
	} else
	  wln_btext(unr, 3);
      }
      break;


    /*EXPORT*/
    case 27:
      if (WITH->se_ok) {
	if (disk_full)
	  wln_btext(unr, 86);
	else {
	  if (!WITH->console) {
	    if (insecure(w))
	      *w = '\0';
	    else if (*w != '\0')
	      sprintf(w, "%s%s", boxdir, strcpy(STR7, w));
	  }
	  export_brett(unr, WITH->brett, s, e, option, search, w);
	}
      } else
	wln_btext(unr, 65);
      break;

    /*MYBBS/SETUSR*/
    case 28:
      if (WITH->se_ok) {
	unhpath(w, w1);
	if (callsign(w1)) {
	  get_word(eingabe, w1);
	  upper(w1);
	  unhpath(w1, w2);
	  if ((*w2 != '\0') && WITH->supervisor) {
	    if (callsign(w2)) {
	      if (create_syslog)
	        append_syslog(unr);
	      cut(eingabe, 8);
	      change_mybbs(unr, w, w1, 0, eingabe, 'U', false,
			   strpos2(eingabe, "+", 1) > 0);
	    } else
	      wln_btext(unr, 3);
	  } else
	    change_mybbs(unr, WITH->call, w, 0, "", 'U', false,
			 strcmp(w1, "-") != 0);
	} else
	  wln_btext(unr, 3);
      } else
	wln_btext(unr, 65);

      break;

    /**MBX*/
    case 30:
      if (WITH->se_ok) {
	upper(eingabe);
	if (strlen(eingabe) >= 1 && strlen(eingabe) <= 40)
	  change_mbx(unr, WITH->brett, s, e, eingabe, option);
	else
	  wln_btext(unr, 2);
      } else
	wln_btext(unr, 65);
      break;

    /**LIFETIME*/
    case 32:
      if (WITH->se_ok)
	change_lifetime(unr, WITH->brett, s, e, eingabe);
      else
	wln_btext(unr, 65);
      break;

    /*GARBAGE*/
    case 33:
      garbage_collection(strcmp(w, "+") == 0, strcmp(w, "-F") == 0,
			 strcmp(w, "-A") == 0, strcmp(w, "-I") == 0, unr);
      break;

    /*FHEADER*/
    case 34:
      sprintf(STR14, "[%s]", ownfheader);
      wlnuser(unr, STR14);
      if (strlen(eingabe) > 1) {
	if (strlen(eingabe) + strlen(ownhiername) < 52) {
	  strcpy(ownfheader, eingabe);
	  wlnuser(unr, "changed to:");
	  sprintf(STR14, "[%s]", ownfheader);
	  wlnuser(unr, STR14);
	} else
	  wlnuser(unr, "*** too long");
      }
      break;

    /*HNAME*/
    case 35:
      wlnuser(unr, ownhiername);
      upper(eingabe);
      if (*eingabe != '\0') {
	if (strpos2(eingabe, Console_call, 1) == 0)
	  sprintf(ownhiername, "%s.%s", Console_call, eingabe);
	else
	  strcpy(ownhiername, eingabe);
	wlnuser(unr, "changed to:");
	wlnuser(unr, ownhiername);
      } else
	wlnuser(unr, "not changed");
      break;

    /**RELEASE*/
    case 36:
      release_hold(unr, WITH->brett, s, e, option, search);
      break;

    /*SFPARMS*/
    case 37:
      if (callsign(w)) {
	show_sfparms(unr, w);
	TEMP = count_words(eingabe);
	if ((unsigned)TEMP < 32 && ((1L << TEMP) & 0x44) != 0) {
	  set_sfparms(w, eingabe);
	  show_sfparms(unr, w);
	}
      } else {
	*w = '\0';
	show_sfparms(unr, w);
      }
      break;

    /*FORWARD*/
    case 38:
      if (WITH->se_ok) {
	check_lt_acc(WITH->brett, &lt, &a);
	if (!strcmp(w, "@")) {
	  get_word(eingabe, w);
	  upper(w);
	}
	if (a <= WITH->level && callsign(w)) {
	  if (strchr(option, '+') != NULL)
	    sprintf(w, "!%s", strcpy(STR7, w));
	  set_forward(unr, -1, WITH->brett, option, s, e, w, "", "");
	} else
	  wln_btext(unr, 3);
      } else
	wln_btext(unr, 65);
      break;

    /*RELOAD*/
    case 39:
      load_all_parms();
      wlnuser(unr, "OK, reloaded complete configuration");
      break;

    /*BOXLOG/REBUILD*/
    case 40:
    case 50:
      create_new_boxlog(unr, cnr == 50);
      break;

    /*SYSTEM*/
    case 41:
      if (WITH->tell == nohandle)
	answer_sysrequest(unr, false);
      break;

    /*SYSCHK*/
    case 42:
      if (WITH->supervisor)
	wlnuser(unr, "OK");
      break;

    /*PASSWORD*/
    case 43:
      if (WITH->se_ok) {
	get_word(voll, w);   /* erstes Wort loeschen (PASSWORD) */
	Result = true;
	set_password(unr, WITH->supervisor, voll);
      } else
	wln_btext(unr, 65);
      break;

    /*DISCONNECT*/
    case 44:
      disc_user(unr, eingabe);
      break;

    /*BOX-SID*/
    case 45:
      if (WITH->tell == nohandle) {
	Result = true;
	sprintf(hs, "%ld", unr);
	if (sf_allowed) {
	  get_word(voll, w2);   /* die SID */
	  get_word(voll, w);   /* das Password */
	  if (*WITH->sfpwdb != '\0') {
	    get_btext(unr, 90, w1);
	    sprintf(hs + strlen(hs), " %s", w1);
	    if (strcmp(w, WITH->sfpwdb))
	      disc_user(-1, hs);
	    else {
	      WITH->is_authentic = true;
	      analyse_sid(true, unr, w2);
	    }
	  } else if (*WITH->sfpwtn != '\0') {
	    get_btext(unr, 90, w1);
	    sprintf(hs + strlen(hs), " %s", w1);
	    if (strpos2(w, WITH->sfpwtn, 1) == 0)
	      disc_user(-1, hs);
	    else {
	      WITH->is_authentic = (WITH->pwsetat + holddelay < clock_.ixtime);
	      analyse_sid(true, unr, w2);
	    }
	  } else if (WITH->se_ok)
	    analyse_sid(true, unr, w2);
	  else {
	    get_btext(unr, 91, w1);
	    sprintf(hs + strlen(hs), " %s", w1);
	    disc_user(-1, hs);
	  }
	} else {
	  get_btext(unr, 92, w1);
	  sprintf(hs + strlen(hs), " %s", w1);
	  disc_user(-1, hs);
	}
      }
      break;

    /*LANGUAGES*/
    case 46:
      show_languages(unr);
      break;

    /*BULLID*/
    case 51:
      if (!strcmp(w, "HASH"))
	disp_bidhash(unr);
      else
	search_bull(unr, w, strchr(eingabe, '-') != NULL,
		    strchr(eingabe, '+') != NULL);
      break;

    /*MSG*/
    case 52:
      if (WITH->tell == nohandle && WITH->se_ok) {
	Result = true;
	get_word(voll, w1);   /* MSG */
	get_word(voll, w1);   /* CALL */
	send_msg(unr, w, voll);
      } else if (!WITH->se_ok)
	wln_btext(unr, 65);
      break;

    /*SELECTION*/
    case 53:
      set_selection(unr, eingabe);
      break;

    /*BATCH*/
    case 54:
      run_batch(unr, w);
      break;

    /*SETSF*/
    case 55:
      if (callsign(w)) {
	get_word(eingabe, w1);
	get_word(eingabe, w2);
	upper(w1);
	upper(w2);
	if ((callsign(w2) || !strcmp(w2, "NIL")) &&
	    (w1[0] == 'S' || w1[0] == 'P' || w1[0] == 'B' || w1[0] == 'A'))
	  change_sfentries(1, SHORT_MAX, w, w1[0], w2);
	else
	  wln_btext(unr, 3);
      } else {
	if (strlen(w) == 1 &&
	    (w[0] == 'S' || w[0] == 'P' || w[0] == 'B' || w[0] == 'A'))
	  strcpy(w1, w);
	else {
	  strcpy(w1, "A");
	  sprintf(eingabe, "%s %s", w, strcpy(STR1, eingabe));
	}
	get_numbers(unr, eingabe, &s, &e, option, search);
	strcpy(WITH->brett, "X");
	get_word(eingabe, w);
	upper(w);
	if (callsign(w) || !strcmp(w, "NIL"))
	  change_sfentries(s, e, "", w1[0], w);
	else
	  wln_btext(unr, 3);
      }
      break;



    /*FDELETE*/
    case 57:
      if (WITH->supervisor) {
	TEMP1 = wlnuser;
	file_delete(unr, w, TEMP1);
      }
      break;

    /*SAT*/
    case 58:
      if (WITH->tell == nohandle && WITH->se_ok)
	reset_to_term(unr, true, false);
      break;


    /*CTEXT*/
    case 63:
      if (WITH->tell == nohandle) {
	if (WITH->supervisor)
	  enter_ctext(unr);
      }
      break;

    /*TALK*/
    case 64:
      if (WITH->tell == nohandle && WITH->se_ok)
	set_talk_mode(unr, w);
      else if (!WITH->se_ok)
	wln_btext(unr, 65);
      break;

    /*//COMP*/
    case 65:
      if (WITH->tell == nohandle)
	set_comp_mode(unr, w);
      break;


    /*SFTEST*/
    case 69:
      gen_sftest(unr, eingabe);
      break;

    /*CLEARBUF*/
    case 70:
      boxfreemostram(strcmp(w, "ALL") == 0);
      break;

    /*ACTIVITY*/
    case 71:
      show_boxactivity(unr);
      break;

    /*BROADCAST*/
    case 72:
      switch_bbsbcast(unr, w);
      break;

    case 73:
      set_debuglevel(unr, w);
      break;

    /*FREAD*/
    case 74:
      if (read_file(false, unr, eingabe)) {
	if (read_filepart(unr))
	  WITH->action = 96;
      }
      break;

    /*FWRITE*/
    case 75:
      write_file(unr, eingabe);
      break;

    /*FDIR*/
    case 76:
      show_file_dir(unr, w);
      break;

    /*#OK#/<GP>*/
    case 77:
    case 112:
      if (cnr == 112) {
	sprintf(w, "%ld", boxboxssid());
	if (!strcmp(w, "0"))
	  *w = '\0';
	else
	  sprintf(w, "-%s", strcpy(STR1, w));
	w_btext(unr, 93);
	sprintf(w, " %s%s ", Console_call, strcpy(STR7, w));
	wuser(unr, w);
	wln_btext(unr, 94);
      }

      valid_command = false;
      WITH->errors = -5;
      break;


    /*NOTBOARD/WANTBOARD*/
    case 78:
    case 111:
      if (WITH->se_ok)
	do_checkboards(unr, cnr == 111, w);
      else
	wln_btext(unr, 65);
      break;

    /*UPDATE*/
    case 79:
      update_dp(unr, w);
      break;

    /*PWGEN*/
    case 80:
      if (WITH->tell == nohandle && WITH->supervisor && *w != '\0')
	generate_dbpwfile(unr, w, eingabe);
      else
	wln_btext(unr, 2);
      break;

    /*FCOPY,FMOVE*/
    case 81:
    case 82:
      if (WITH->tell == nohandle && *w != '\0') {
	get_word(eingabe, w1);
	if (*w1 != '\0') {
	  if (!WITH->console) {
	    if (insecure(w))
	      *w = '\0';
	    else
	      sprintf(w, "%s%s", boxdir, strcpy(STR7, w));
	    if (insecure(w1))
	      *w = '\0';
	    else
	      sprintf(w1, "%s%s", boxdir, strcpy(STR7, w1));
	    strcpy(w2, boxdir);
	  } else
	    *w2 = '\0';

	  if (*w != '\0') {
	    TEMP2 = wlnuser;
	    filecp(w, w1, w2, cnr == 82, unr, TEMP2);
	  } else
	    wln_btext(unr, 4);
	} else
	  wln_btext(unr, 2);
      } else
	wln_btext(unr, 4);
      break;

    /*SERVER*/
    case 84:
      if (WITH->se_ok) {
	if (!config_server(unr, eingabe))
	  wln_btext(unr, 2);
      } else
	wln_btext(unr, 65);
      break;

    /*PROFILE*/
    case 85:
      if (*eingabe == '\0')
	show_textfile(unr, profile_box);
      else if (WITH->se_ok)
	append_profile(unr, eingabe);
      else
	wln_btext(unr, 65);
      break;

    /*SFSTAT*/
    case 86:
      create_sfstat(unr, eingabe);
      break;

    /**UNERASE*/
    case 87:
      if (WITH->se_ok) {
	unerase_users_mails(unr);

	strcpy(WITH->brett, WITH->call);
      } else
	wln_btext(unr, 65);
      break;

    /*PROTO*/
    case 88:
      get_word(eingabe, w1);
      upper(w1);
      proto_cmd(unr, w, w1);
      break;

    /*TRACE*/
    case 89:
      WITH->fulltrace = false;
      get_word(eingabe, w1);
      upper(w1);
      trace_cmd(unr, w, w1);
      break;

    /*MKF*/
    case 90:
      if (WITH->tell == nohandle)
	mkf_cmd(unr, eingabe);
      break;

    /*PRIV*/
    case 91:
      Result = true;
      if (*WITH->sfpwdb != '\0') {
	get_word(voll, w);   /* PRIV */
	get_word(voll, w);   /* das PW */
	strcpy(WITH->input2, WITH->sfpwdb);
	check_sysanswer(unr, w);
	name_ok(unr);
      } else
	append_syslog(unr);
      break;

    /*FULLTRACE*/
    case 92:
      WITH->fulltrace = true;
      get_word(eingabe, w1);
      upper(w1);
      trace_cmd(unr, w, w1);
      break;

    /*CONVERS*/
    case 93:
      if (WITH->tell == nohandle && WITH->se_ok)
	box_convers(unr, w);
      else if (!WITH->se_ok)
	wln_btext(unr, 65);
      break;

    /*CD*/
    case 94:
      cut(w, 8);
      if (valid_boardname(w))
	strcpy(WITH->brett, w);
      else
	wln_btext(unr, 2);
      break;

    /*PROMPT*/
    case 96:
      if (WITH->se_ok) {
	Result = true;
	get_word(voll, w);   /* PROMPT */
	change_prompt(unr, voll);
      } else
	wln_btext(unr, 65);
      break;

    /*STARTUP*/
    case 97:
      if (WITH->se_ok) {
	Result = true;
	get_word(voll, w);   /* STARTUP */
	for (x = 0; voll[x] != '\0'; x++) {
	  if (voll[x] == ';')
	    voll[x] = ',';
	}
	change_startup(unr, voll);
      } else
	wln_btext(unr, 65);
      break;

    /*(*)FEXECUTE*/
    case 83:
      if (WITH->tell == nohandle && *w != '\0')
	call_runprg(true, unr, w, eingabe, false);
      else
	wln_btext(unr, 2);
      break;

    /*(*)RUN*/
    case 98:
    case 99:
/*      expand_command(unr, w2);
      lower(w2); */
      call_runprg(false, unr, w2, eingabe, cnr == 99);
      break;

    /*CONFIG*/
    case 100:
      if (WITH->se_ok) {
	if (insecure(w)) {
	  *w = '\0';
	  do_config(unr, w, w);
	} else {
	  if (*w != '\0') {
	    if (!find_env(w)) {
	      *w = '\0';
	      *eingabe = '\0';
	    }
	    do_config(unr, w, eingabe);
	  } else
	    do_config(unr, w, w);
	}
      } else
	wln_btext(unr, 65);
      break;

    /*STRIPCR*/
    case 101:
      if (WITH->se_ok && WITH->supervisor) {
	if (insecure(w)) {
	  *w = '\0';
	  do_stripcr(unr, w);
	} else {
	  if (*w != '\0') {
	    if (!find_env(w))
	      *w = '\0';
	    do_stripcr(unr, w);
	  } else
	    do_stripcr(unr, w);
	}
      } else
	wln_btext(unr, 65);
      break;

    /*MAXREAD*/
    case 102:
      if (WITH->supervisor)
	set_maxread(unr, w, eingabe);
      else
	wln_btext(unr, 65);
      break;

    /*TTL*/
    case 103:
      if (WITH->se_ok)
	change_ttl(unr, eingabe);
      else
	wln_btext(unr, 65);
      break;

    /*IFUSAGE*/
    case 105:
      list_ifaceusage(unr);
      break;

    /*QRG*/
    case 106:
      list_qrgs(unr);
      break;

    /*CONNECT*/
    case 107:
      if (WITH->tell == nohandle)
	connect_from_box(unr, eingabe);
      break;

    /*TNTCOMM*/
    case 109:
      if (WITH->tell == nohandle)
	tnt_command(unr, eingabe);
      break;

    /*NEXT*/
    case 108:
      read_next(unr);
      break;

    /*BEACON*/
    case 110:
      start_mailbeacon_manually(unr);
      break;

    /*READLOCK*/
    case 113:
      if (WITH->se_ok && WITH->tell == nohandle)
	change_readlock(unr, eingabe);
      else
	wln_btext(unr, 65);

      break;

    /*SETREPLY*/
    case 114:
      if (WITH->se_ok && WITH->tell == nohandle)
	set_reply_flag_directly(unr, eingabe);
      else
	wln_btext(unr, 65);
      break;

    /*MAILBEACON*/
    case 115:
      if (WITH->se_ok && WITH->tell == nohandle)
	change_mailbeacon(unr, eingabe);
      else
	wln_btext(unr, 65);
      break;

    /*FILESERVER*/
    case 116:
      if (WITH->tell == nohandle) {
	wln_btext(unr, 95);
	WITH->smode = true;
	WITH->changed_dir = true;
      }
      break;

    /*MD2*/
    case 117:
      if (WITH->tell == nohandle)
	answer_sysrequest(unr, true);
      break;

    /*MD2SF*/
    case 118:
      if (WITH->se_ok && WITH->tell == nohandle)
	change_md2sf(unr, eingabe);
      else
	wln_btext(unr, 65);
      break;

    /*FBBMODE*/
    case 119:
      if (WITH->se_ok && WITH->tell == nohandle)
	change_fbbmode(unr, eingabe);
      else
	wln_btext(unr, 65);
      break;

    /*UNPROTO*/
    case 120:
      if (WITH->supervisor)
	change_unprotomode(unr, eingabe);
      else
	wln_btext(unr, 65);
      break;

    /*SHELL,TSHELL*/
    case 121:
    case 122:
      open_shell(unr, cnr == 122);
      break;


    default:
      wlnuser(unr, "unknown command number...");
      break;
    }
  } else {
    switch (WITH->action) {

    /*           71  :   ; Vergeben fuer sorted check */
    case 72:
      send_check(unr, eingabe, true, '\0');
      break;

    case 73:
      box_txt2(false, unr, eingabe);
      break;

    case 74:
    case 75:  /* 74 = erste Zeile */
      send_text3(unr, WITH->action == 74, eingabe, return_);
      if (WITH->action == 74)
	WITH->action = 75;
      plus = true;
      break;

    /*           76  Vergeben fuer EXPORT */
    case 77:
      check_sysanswer(unr, eingabe);
      name_ok(unr);
      break;

    case 78:
      change_name(unr, WITH->call, eingabe);
      break;

    case 79:
      write_ctext(unr, eingabe);
      break;

    case 80:
      talk_line(unr, eingabe);
      break;

    case 81:
    case 82:
    case 83:
      enter_password(unr, eingabe, WITH->action >= 83);
      break;

    case 14:
    case 15:
    case 86:   /* QUIT / ABORT : Daeumchen drehen, bis der Spooler alle ist */
      break;
      /* reserviert fuer Promptunterdrueckung bei PW-Eingabe */

    case 87:
    case 88:
      write_file2(unr, eingabe);
      valid_command2 = true;
      break;

    case 89:
      update_dp2(unr);
      break;

    case 90:
      send_conv(unr, eingabe);
      break;

    case 91:   /* zusaetzliche Lifetimeabfrage */
      enter_lifetime(unr, eingabe);
      break;

    /*   92  :   ;  reserviert fuer ascii-upload fileserver */
    case 96:
      if (WITH->bin == NULL)
	WITH->action = 0;
      else if (*eingabe == '\0' || strpos2(eingabe, "#ABORT#", 1) > 0) {
	abort_fileread(unr);
	abort_useroutput(unr);
	WITH->action = 0;
      }
      break;

    default:
      sprintf(hs, "invalid value of <action>: %ld", WITH->action);
      debug(0, unr, 56, hs);
      WITH->action = 15;   /* Abwurf */
      break;
    }
  }


  if (!boxrange(unr)) {
    *eingabe = '\0';
    return Result;
  }

  if (!valid_command)
    WITH->errors++;

  if (WITH->errors > maxerrors) {
    wlnuser0(unr);
    WITH->action = 15;   /* Warten auf Spooler, dann Abbruch    */
  } else if ((WITH->action < 72 || WITH->action > 91) && !plus &&
	     !valid_command2)
    WITH->errors = 0;

  /*           else if not(action in [74,75,87,88,89]) */

  if (WITH->lastprocnumber > 0)
    strcpy(eingabe, WITH->lastcmd);
  else
    *eingabe = '\0';

  return Result;

}


Static void run_batch(short unr, Char *cmd_)
{
  Char cmd[256];
  boolean ok;
  Char pfad[256], name[256];
  Char hs[256];
  short inf;
  Char STR7[256];

  strcpy(cmd, cmd_);
  ok = false;
  if (*cmd == '\0' || exist(cmd) == false) {
    if (user[unr]->console) {
      sprintf(pfad, "%s%c%c%c", boxsysdir, allquant, extsep, allquant);
      name[0] = '\0';
      if (boxgetfilename(pfad, name, "select batchfile")) {
	if (exist(name)) {
	  strcpy(cmd, name);
	  ok = true;
	}
      }
    } else {
      sprintf(STR7, "Batchfile <%s> not found", cmd);
      wlnuser(unr, STR7);
    }
  } else
    ok = true;
  if (!ok)
    return;
  inf = sfopen(cmd, FO_READ);
  if (inf < minhandle)
    return;
  debug(1, unr, 57, cmd);
  while (file_to_string(inf, hs))
    box_input(unr, false, false, hs, true);

  sfclose(&inf);
  debug(1, unr, 57, "closed. Batch will proceed in background.");
}


void run_sysbatch(Char *name)
{
  short unr;

  if (!exist(name))
    return;
  debug(1, 0, 58, name);
  unr = melde_user_an(Console_call, 0, 0, UM_SYSREQ, false);
  if (unr > 0) {
    run_batch(unr, name);
    box_input(unr, false, false, "ABORT", true);
  }
  debug(1, 0, 58, "closed. BATCH will proceed in background.");
}


void box_command_fract(short unr, Char *command, boolean return_)
{
  short x;
  boolean ret2, nop, v;
  Char teil[256], voll[256];
  userstruct *WITH;
  Char STR7[256];

  debug(5, unr, 59, command);
  boxsetbmouse();
  if (boxrange(unr)) {
    WITH = user[unr];

    if (WITH->action == 0)
      utc_clock();

    if (WITH->f_bbs) {
      analyse_sf_command(unr, command, return_);
      *command = '\0';
    } else if (WITH->smode) {
      analyse_smode_command(unr, command, return_);
      WITH->isfirstchar = return_;
      *command = '\0';
    } else {
      dp_watchdog(2, 4711);
      nop = false;
      strcpy(voll, command);
      ret2 = return_;
      if (WITH->action == 0) {
	del_blanks(command);
	x = strpos2(command, ";", 1);
	if (x > 0) {
	  ret2 = true;
	  sprintf(teil, "%.*s", x - 1, command);
	  strdelete((void *)command, 1, x);
	} else {
	  strcpy(teil, command);
	  command[0] = '\0';
	}
	del_blanks(teil);

	/* falls da jemand s&f einleiten will keine Leerzeile vorneweg senden */

	if (teil[0] != '[' && (WITH->errors >= 0 || WITH->errors == -5) &&
	    WITH->lastprocnumber == 0)
	  wlnuser0(unr);

      } else {
	strcpy(teil, command);
	command[0] = '\0';
      }

      v = analyse_boxcommand(unr, teil, voll, ret2);

      if (boxrange(unr)) {
	if (v)
	  command[0] = '\0';
	else if (*teil != '\0') {
	  nop = true;
	  if (*command != '\0')
	    sprintf(command, "%s;%s", teil, strcpy(STR7, command));
	  else
	    strcpy(command, teil);
	}

	if (*command != '\0' && WITH->lastprocnumber == 0) {
	  sfclosedel(&WITH->prochandle);
	  WITH->lastprocnumber2 = 0;
	}

	WITH->isfirstchar = ret2;

	if (WITH->action == 0 && (WITH->errors >= 0 || WITH->errors == -5) &&
	    !nop && WITH->wait_pid <= 0)
	  show_prompt(unr);
	else if (WITH->action == 86)
	  WITH->action = 0;
	/* Promptunterdrueckung PW */
      }
      
    }
    
  }
  
  boxsetamouse();
}


void _box_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
}

