/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1996 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/


#include "defs.h"

#define PASTRIX_G
#include "pastrix.h"

#ifndef DPGLOBAL_H
#include "dpglobal.h"
#endif

#ifndef MISC_OS_H
#include "misc_os.h"
#endif

#ifndef BOXGLOBL_H
#include "boxglobl.h"
#endif

#ifndef TOOLS_H
#include "tools.h"
#endif

#ifdef dplinux
#include <sys/time.h>
#else
#include <time.h>
#endif
#ifdef dpmacos
#include <timer.h>
#endif

#ifdef dpmacos
long memavail__(void)
{
  long total, cont;
  
  PurgeSpace(&total, &cont);
  return(total);
}
#endif

long maxavail__(void)
{
#ifdef dpmacos
  long total, cont;
  
  PurgeSpace(&total, &cont);
  return(cont);
  
#else
  short k;
  Char hs[256];
  Char w[256];
  long mem, lm;

  mem = 8000000L;
  k = sfopen("/proc/meminfo", FO_READ);
  if (k < minhandle)
    return mem;
  file_to_string(k, hs);
  file_to_string(k, hs);
  strsub(w, hs, 24, 9);
  del_leadblanks(w);
  mem = str2lint(w);
  strsub(w, hs, 42, 9);
  del_leadblanks(w);
  lm = str2lint(w);
  if (lm > 500000L)
    lm -= 500000L;
  else
    lm = 0;
  mem += lm;
  file_to_string(k, hs);
  sfclose(&k);
  strsub(w, hs, 24, 9);
  del_leadblanks(w);
  mem += str2lint(w);
  if (mem <= 0)
    mem = 8000000L;
  return mem;
#endif
}

uchar *mymalloc(long v)
{
  if (v <= 0)
    return NULL;
  return Malloc(v);
}


void mymfree(uchar **p)
{
  if (*p == NULL)
    return;
  free(*p);
  *p = NULL;
}


void mymfreep(uchar **p)
{
  if (*p == NULL)
    return;
  free(*p);
  *p = NULL;
}


void dpgetmem(uchar **p, long size)
{
  *p = NULL;
  if (size <= 0)
    return;
  *p = Malloc(size);
}


void dpfreemem(uchar **p, long size)
{
  if (*p != NULL) {
    Free(*p);
  }
  *p = NULL;
}




/* Fragt einen 200Hz-Systemzaehler ab. Der absolute Betrag ist unerheblich,  */
/* DP bildet immer die Differenz aus zwei Werten. Wird fuer die Box ge-      */
/* braucht um die CPU-Time des Benutzers zu ermitteln, sowie in ATARI.PAS    */
/* um einen TIMEOUT bei den BIOS-Input-Routinen erzeugen zu koennen.         */
/* Man kann also beliebige Zaehler verwenden, einen 50Hz-Zaehler sollte man  */
/* aber jeweils mit 4 multiplizieren, da sonst alle Timeoutwerte und alle    */
/* statistischen Angaben ueber die Boxauslastung falsch sind                 */

long statclock(void)
{
#ifdef dpmacos
  struct UnsignedWide microTickCount;
  
  Microseconds(&microTickCount);
  return((microTickCount.hi / 5000) + (microTickCount.lo / 5000));
  /* muss noch korrigiert werden, reicht aber erstmal zum testen */
  
#else
  struct timeval tv;
  struct timezone tz;

  gettimeofday(&tv,&tz);
  return(((tv.tv_sec % 10000000) * 200) + (tv.tv_usec / 5000));
#endif
}


void mtpause(void)
{
  /* hier koennte sich der prozess ein wenig schlafenlegen */
}


long searchbyte(uchar what, uchar *p, long size)
{
  long z;

  if (p == NULL)
    return 0;

  z = 0;
  while (z++ < size && *p++ != what);

  if (z >= size)
    return 0;
  return --z;
}


void ersetze(Char *oldstr, Char *newstr, Char *txt)
{
  short k, s, d;

  k = strpos2(txt, oldstr, 1);
  if (k <= 0)
    return;
  s = strlen(oldstr);
  d = strlen(newstr) - s;
  while (k > 0 && strlen(txt) + d <= 255) {
    strdelete((void *)txt, k, s);
    strinsert(newstr, (void *)txt, k);
    k = strpos2(txt, oldstr, 1);
  }
}


typedef Char es[2];
typedef Char ess[3];
typedef Char esss[4];

Static es e1 = "[", e2 = "]", e3 = "\\", e4 = "{", e5 = "|", e6 = "}",
	  e7 = "~", e10 = "\204", e11 = "\224", e12 = "\201", e13 = "\216",
	  e14 = "\231", e15 = "\232", e16 = "\341", e17 = "\236";
Static ess es1 = "ae", es2 = "oe", es3 = "ue", es4 = "Ae", es5 = "Oe",
	   es6 = "Ue", es7 = "ss";
Static esss ess1 = "sss";

void umlaut1(Char *txt)
{
  ersetze(e10, es1, txt);
  ersetze(e11, es2, txt);
  ersetze(e12, es3, txt);
  ersetze(e13, es4, txt);
  ersetze(e14, es5, txt);
  ersetze(e15, es6, txt);
  ersetze(e16, es7, txt);
  ersetze(e17, es7, txt);
  ersetze(ess1, es7, txt);
}


void umlaut2(Char *txt)
{
  ersetze(e1, e13, txt);
  ersetze(e2, e14, txt);
  ersetze(e3, e15, txt);
  ersetze(e4, e10, txt);
  ersetze(e5, e11, txt);
  ersetze(e6, e12, txt);
  ersetze(e7, e17, txt);
}

#ifdef dpmacos

int fork()
{
    return -1;
}

int kill(pid_tt pid, int signal)
{
    return 0;
}

void setsid()
{
}

int waitpid(pid_tt pid, int *res, int flag)
{
    return -1;
}

#endif

/* Wandelt einen String mit Namen in richtige Gross/Kleinschreibung */

void gkdeutsch(Char *name)
{
  short x, k;

  k = strlen(name);
  if (k == 0)
    return;
  lower(name);
  name[0] = upcase_(name[0]);
  for (x = 1; x < k; x++) {
    switch (name[x - 1]) {

    case ' ':
    case '-':
    case '_':
    case '(':
    case '[':
    case '.':
    case '/':
    case ':':
    case '|':
    case ',':
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
      name[x] = upcase_(name[x]);
      break;

    }
  }
}


/* Liest ein File in PUFFER und beachtet dabei die maximal moeglichen */
/* Memory Blocks                                                      */

void sfbread(boolean aslongaspossible, Char *name, uchar **puffer, long *size)
{
  bst fs, err;
  long hsz;
  uchar *fp;
  short k;

  *puffer = NULL;
  *size = 0;

  k = sfopen(name, FO_READ);
  if (k < minhandle)
    return;

  hsz = sfseek(0, k, SFSEEKEND);
  sfseek(0, k, SFSEEKSET);

  if (hsz > maxram()) {
    if (aslongaspossible)
      fs = maxram();
    else
      fs = 0;
  } else
    fs = hsz;
    
  if (fs > 0)
    fp = Malloc(fs);

  if (fs > 0 && fp == NULL) {
    if (aslongaspossible) {
      fs = maxavail__();
      fp = Malloc(fs);
    }
  }

  if (fp != NULL) {
    err = sfread(k, fs, fp);
    if (err == fs) {
      *puffer = fp;
      *size = fs;
    } else
      mymfreep(&fp);
  }

  sfclose(&k);
}


Static void fill2digits(Char *s)
{
  int k;
  Char STR1[256];

  k = strlen(s);
  while (k++ < 2)
    sprintf(s, "0%s", strcpy(STR1, s));
}


void Gettimestr(Char *ts)
{
  Char sep;
  Char w[256];

  if (*ts != '\0')
    sep = *ts;
  else
    sep = ':';
  sprintf(w, "%ld", clock_.hour);
  fill2digits(w);
  sprintf(ts, "%s%c", w, sep);
  sprintf(w, "%ld", clock_.min);
  fill2digits(w);
  sprintf(ts + strlen(ts), "%s%c", w, sep);
  sprintf(w, "%ld", clock_.sec);
  fill2digits(w);
  strcat(ts, w);
  cut(ts, 8);
}


void GetDatestr(Char *ds)
{
  short y;
  Char sep;
  Char w[256];

  if (*ds != '\0')
    sep = *ds;
  else
    sep = '.';
  sprintf(w, "%ld", clock_.day);
  fill2digits(w);
  sprintf(ds, "%s%c", w, sep);
  sprintf(w, "%ld", clock_.mon);
  fill2digits(w);
  sprintf(ds + strlen(ds), "%s%c", w, sep);
  y = clock_.year;
  if (y >= 100) y = y - 100;
  sprintf(w, "%ld", y);
  fill2digits(w);
  strcat(ds, w);
  cut(ds, 8);
}


short week_day(short d, short m, short y)
{
  /* Wochentags-Berechnung (1583-4139) */

  if (y < 1583)
    y += 1900;
  if (m < 3) {
    m += 12;
    y--;
  }
  return ((d + (m * 13 + 3) / 5 + (((unsigned)(y * 5)) >> 2) - y / 100 +
	   y / 400) % 7 + 1);
}

unsigned short Make_DTime(short Hour, short Min, short Sec)
{
  return ((Hour << 11) | (Min << 5) | (((unsigned)Sec) >> 1));
}


unsigned short Make_DDate(short Day, short Mon, short Yr)
{
  short yh;

  if (Yr >= 1980) {
    yh = Yr - 1980;
    return ((yh << 9) | (Mon << 5) | Day);
  }
  if (Yr < 80)
    yh = Yr + 20;   /* 2000 - 2079 */
  else
    yh = Yr - 80;
  return ((yh << 9) | (Mon << 5) | Day);
}


void Get_DDate(unsigned short ddate, short *Day, short *Mon, short *Yr)
{
  *Day = ddate & 31;
  *Mon = (ddate >> 5) & 15;
  *Yr = ((ddate >> 9) & 127) + 80;
}


void Get_DTime(unsigned short dtime, short *Hour, short *Min, short *Sec)
{
  *Sec = (dtime & 31) << 1;
  *Min = (dtime >> 5) & 63;
  *Hour = (dtime >> 11) & 31;
}




/* Common string functions, taken from p2c.c of David Gillespie: */

/* Store in "ret" the substring of length "len" starting from "pos" (1-based).
   Store a shorter or null string if out-of-range.  Return "ret". */

char *strsub(ret, s, pos, len)
register char *ret, *s;
register int pos, len;
{
    register char *s2;

    if (--pos < 0 || len <= 0) {
        *ret = 0;
        return ret;
    }
    while (pos > 0) {
        if (!*s++) {
            *ret = 0;
            return ret;
        }
        pos--;
    }
    s2 = ret;
    while (--len >= 0) {
        if (!(*s2++ = *s++))
            return ret;
    }
    *s2 = 0;
    return ret;
}


/* Return the index of the first occurrence of "pat" as a substring of "s",
   starting at index "pos" (1-based).  Result is 1-based, 0 if not found. */

int strpos2(s, pat, pos)
char *s;
register char *pat;
register int pos;
{
    register char *cp, ch;
    register int slen;

    if (--pos < 0)
        return 0;
    slen = strlen(s) - pos;
    cp = s + pos;
    if (!(ch = *pat++))
        return 0;
    pos = strlen(pat);
    slen -= pos;
    while (--slen >= 0) {
        if (*cp++ == ch && !strncmp(cp, pat, pos))
            return cp - s;
    }
    return 0;
}


/* Delete the substring of length "len" at index "pos" from "s".
   Delete less if out-of-range. */

void strdelete(s, pos, len)
register char *s;
register int pos, len;
{
    register int slen;

    if (--pos < 0)
        return;
    slen = strlen(s) - pos;
    if (slen <= 0)
        return;
    s += pos;
    if (slen <= len) {
        *s = 0;
        return;
    }
    while ((*s = s[len])) s++;
}


/* Insert string "src" at index "pos" of "dst". */

void strinsert(src, dst, pos)
register char *src, *dst;
register int pos;
{
    register int slen, dlen;

    if (--pos < 0)
        return;
    dlen = strlen(dst);
    dst += dlen;
    dlen -= pos;
    if (dlen <= 0) {
        strcpy(dst, src);
        return;
    }
    slen = strlen(src);
    do {
        dst[slen] = *dst;
        --dst;
    } while (--dlen >= 0);
    dst++;
    while (--slen >= 0)
        *dst++ = *src++;
}


/* end of p2c-subroutines */



Static void del_lead0(register Char *s)
{
  /*Loescht fuehrende '00' in "s"*/
  
  register Char c;
  register Char *p;

  p = s;
  c = '0';
  
  while (*s != '\0' && *s == c)
    s++;
    
  if (s == p) return;
  if (*s == '\0') {
    /* eine Null stehen lassen */
    p[1] = '\0';
    return;
  }

  while (*s != '\0')
    *p++ = *s++;

  *p = '\0';
}


void del_leadblanks(register Char *s)
{
  /*Loescht fuehrende Leerzeichen in "s"*/
  register Char c, v;
  register Char *p;

  p = s;
  c = ' ';
  v = tab;
  
  while (*s != '\0' && (*s == c || *s == v))
    s++;
    
  if (s == p) return;
  if (*s == '\0') {
    *p = '\0';
    return;
  }

  while (*s != '\0')
    *p++ = *s++;

  *p = '\0';
}


void del_lastblanks(register Char *s)
{
  /*Loescht letzte Leerzeichen*/
  register Char c, v;
  register Char *p;
  
  p = s;
  if (*s++ == '\0') return;
  while (*s++ != '\0');
  s--;
  s--;
  c = ' ';
  v = tab;
  while (s >= p && (*s == c || *s == v))
    s--;
  s++;
  *s = '\0';
}


/*Loescht Spaces an Anfang und Ende des Strings*/

void del_blanks(Char *s)
{
  del_lastblanks(s);
  del_leadblanks(s);
}


void lspacing(register Char *txt, register short l)
{
  register short i;
  register Char *p;
  register Char *s;
  register Char c;
  
  p = txt;
  i = 0;
  while (*txt++ != '\0')
    i++;
  i = l - i;  /* soviele Zeichen fehlen noch   */
  if (i <= 0) return;
  txt--;
  s = txt;
  txt = txt + i;
  while (s >= p)
    *txt-- = *s--;
  c = ' ';
  while (txt >= p)
    *txt-- = c;
}


void rspacing(register Char *txt, register short l)
{
  register short i;
  register Char c;
  
  i = 0;
  while (*txt++ != '\0')
    i++;
  i = l - i;   /* soviele Zeichen fehlen noch   */
  if (i <= 0)
    return;
  txt--;
  c = ' ';
  while (i-- > 0)
    *txt++ = c;
  *txt = '\0';
}


Char lowcase(Char ch)
{
  Char Result;

  switch (ch) {

  case 142:
    Result = 132;
    break;

  case 153:
    Result = 148;
    break;

  case 154:
    Result = 129;
    break;

  default:
    if (isupper(ch))
      Result = ch + 0x20;
    else {

      Result = ch;
    }
    break;
  }
  return Result;
}


Char upcase_(Char ch)
{
  Char Result;

  switch (ch) {

  case 132:
    Result = 142;
    break;

  case 148:
    Result = 153;
    break;

  case 129:
    Result = 154;
    break;

  default:
    if (islower(ch))
      Result = ch - 0x20;
    else
      Result = ch;
    break;
  }
  return Result;
}


void upper(Char *s)
{
  while (*s != '\0')
    *s++ = upcase_(*s); 
}


void lower(Char *s)
{
  while (*s != '\0')
    *s++ = lowcase(*s);
}


/* --------------------------------------------------------------------- */


boolean zahl(Char *s)
{
  /* nur dez               */
  boolean erg;
  short ct, start, FORLIM;

  erg = false;
  if (*s == '\0')
    return erg;
  if (s[0] == '-' || s[0] == '+')
    start = 2;
  else
    start = 1;
  if (strlen(s) >= start)
    erg = true;
  FORLIM = strlen(s);
  for (ct = start - 1; ct < FORLIM; ct++) {
    if (!isdigit(s[ct]))
      erg = false;
  }
  return erg;
}


boolean azahl(Char *s)
{
  /* auch bin und hex      */
  boolean erg;
  short ct, FORLIM;

  erg = false;
  if (*s == '\0')
    return erg;
  if (s[0] == '$') {
    if (strlen(s) < 2)
      return erg;
    erg = true;
    FORLIM = strlen(s);
    for (ct = 1; ct < FORLIM; ct++) {
      if (!(s[ct] >= 'a' && s[ct] <= 'f' || s[ct] >= 'A' && s[ct] <= 'F' ||
	    isdigit(s[ct])))
	erg = false;
    }
    return erg;
  }
  if (s[0] != '%') {
    erg = zahl(s);
    return erg;
  }
  if (strlen(s) < 2)
    return erg;
  erg = true;
  FORLIM = strlen(s);
  for (ct = 1; ct < FORLIM; ct++) {
    if (s[ct] < '0' || s[ct] > '1')
      erg = false;
  }
  return erg;
}


boolean rzahl(Char *s)
{
  boolean Result;
  short x, l;
  boolean digit;
  short FORLIM;

  l = strlen(s);
  if (l == 0)
    return false;
  if (l == 1)
    return (zahl(s) && s[0] != '+' && s[0] != '-');
  if (upcase_(s[0]) == 'E')
    return false;
  digit = false;
  Result = true;
  FORLIM = strlen(s);
  for (x = 0; x < FORLIM; x++) {
    if (!(s[x] == 'e' || s[x] == 'E' || s[x] == '+' || s[x] == '-' ||
	  s[x] == '.' || isdigit(s[x])))
      Result = false;
    else if (isdigit(s[x]))
      digit = true;
  }
  if (!digit)
    return false;
  return Result;
}


Static short makehexdigit(Char c)
{
  short Result;

  switch (c) {

  case 'A':
  case 'B':
  case 'C':
  case 'D':
  case 'E':
  case 'F':
    Result = c - 55;
    break;

  case 'a':
  case 'b':
  case 'c':
  case 'd':
  case 'e':
  case 'f':
    Result = c - 87;
    break;

  default:
    if (isdigit(c))
      Result = c - '0';
    else
      Result = 0;
    break;
  }
  return Result;
}


long hstr2int(Char *s)
{
  /* "Hex-String to Integer", String wird unbedingt als Hex-Zahl interpretiert */
  long erg;
  short ct, start, FORLIM;

  erg = 0;
  if (s[0] == '$')
    start = 2;
  else
    start = 1;
  FORLIM = strlen(s);
  for (ct = start - 1; ct < FORLIM; ct++)
    erg = (erg << 4) + makehexdigit(s[ct]);
  return erg;
}


long bstr2int(Char *s)
{
  /* "Bin-String to Integer", String wird unbedingt als Bin-Zahl interpretiert */
  long erg;
  short ct, start, FORLIM;

  erg = 0;
  if (s[0] == '%')
    start = 2;
  else
    start = 1;
  FORLIM = strlen(s);
  for (ct = start - 1; ct < FORLIM; ct++) {
    erg <<= 1;
    if (s[ct] != '0')
      erg++;
  }
  return erg;
}


typedef Char hexarr[16];

/* Der Weg ueber die Pointer ist so   */
/* kompliziert gewaehlt, weil TP erst */
/* dann einen Zeiger auf die Tabelle  */
/* in einem Register haelt. Sonst     */
/* wird bei jedem Schleifendurchlauf  */
/* die Tabelle neu geladen.           */

Static hexarr hextab = {
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E',
  'F'
};


#define digits          8


void int2hstr(long i, Char *s)
{
  /* "Integer to Hex-String", Zahl als Hex-Zahl dargestellt */
  short ct, c;
  long v;
  Char *p;

  p = hextab;
  c = 0xf;
  v = i;
  s[digits] = '\0';
  for (ct = 1; ct <= digits; ct++) {
    s[digits - ct] = p[v & c];
    v = ((unsigned long)v) >> 4;
  }
  del_lead0(s);
}

#undef digits


void int2hchar(short i, Char *c1, Char *c2)
{
  /* Bereich von $00..$FF  */
  short h;
  Char *p;

  p = hextab;
  h = (((unsigned)i) >> 4) & 0xf;
  *c1 = p[h];
  h = i & 0xf;
  *c2 = p[h];
}


void hstr2str(Char *h, Char *s)
{
  sprintf(s, "%ld", hstr2int(h));
}


void str2hstr(Char *s, Char *h)
{
  int2hstr(Str2int(s), h);
}



/* ---------------------------------------------------------------------- */




void str2mem(Char *s1, uchar *at, boolean lbyte)
{
  Char *p;
  uchar *p2;
  short ct, k;

  if (lbyte) {
    p = at;
    strcpy(p, s1);
    return;
  }
  k = strlen(s1);
  if (k == 0)
    return;
  p2 = at;
  for (ct = 0; ct < k; ct++)
    p2[ct] = s1[ct];
}


void mem2str(uchar *at, Char *s1)
{
  strcpy(s1, at);
}


void mem2str2(Char *s1, uchar *at, short size)
{
  uchar *p;
  short ct, sz;

  sz = size & 0xff;
  s1[sz] = '\0';
  p = at;
  for (ct = 0; ct < sz; ct++)
    s1[ct] = p[ct];
}


void del_mulblanks(Char *s)
{
  /* Laesst in einer Folge von Leerzeichen nur je eines stehen */
  static Char dspace[3] = "  ";

  short x;

  while (true) {
    x = strpos2(s, dspace, 1);
    if (x == 0)
      return;
    strdelete((void *)s, x, 1);
  }
}


short count_words(register Char *s)
{
  register short erg;
  register boolean space;
  register Char spc, spc2, val;

  erg = 0;
  space = true;
  spc = ' ';
  spc2 = tab;
  
  val = *s; 
  while (val != '\0') {
    if (val == spc || val == spc2)
      space = true;
    else {
      if (space)
        erg++;
      space = false;
    }
    val = *++s;
  }
  return erg;
}


/* Holt naechstes Wort aus "inp" und loescht   */
/* dieses dort, Leerzeichen werden ueberlesen  */

void get_word(Char *inp, Char *outp)
{
  short delct, start, len, outct;
  Char c, spc, tabu;

  outct = 0;
  len = strlen(inp);
  if (len > 0) {
    start = 1;
    spc = ' ';
    tabu = tab;

    while (start <= len && (inp[start - 1] == tabu || inp[start - 1] == spc))
      start++;

    if (start <= len) {
      c = inp[start - 1];
      while (start <= len && c != tabu && c != spc) {
	outct++;
	outp[outct - 1] = c;
	start++;
	c = inp[start - 1];
      }

      if (start <= len) {
	while (start <= len &&
	       (inp[start - 1] == tabu || inp[start - 1] == spc))
	  start++;
      }
    }

    delct = start - 1;
    if (delct > 0) {
      if (delct >= len)
	inp[0] = '\0';
      else
	strdelete((void *)inp, 1, delct);
    }

  }

  outp[outct] = '\0';
}


void del_comment(Char *z, Char c)
{
  /* Loescht String nach erstem Auftreten von "C" */
  Char *p;

  p = strchr(z, c);
  if (p == NULL) return;
  *p = '\0';
}


/* --------------------------------------------------------------------- */



/*
 get_line und put_line operieren in einem Pufferspeicher,
 die Zeilen sollten zum Lesen mit CR+LF oder LF abgeschlossen sein
 */

void get_line(uchar *buf, long *posi, long ende, Char *zeile)
{
  uchar *p;
  Char c, cr, lf;
  bst tende, tpos;
  short outct;

  outct = 0;
  tpos = *posi;
  tende = ende;
  if (tpos < tende) {
    if (tende - tpos > 255)
      tende = tpos + 255;

    p = buf;
    cr = '\015';
    lf = '\n';
    c = p[tpos];

    while (tpos < tende && c != cr && c != lf) {
      outct++;
      zeile[outct - 1] = c;
      tpos++;
      c = p[tpos];
    }

    if (tpos < tende)   /*hinter's CR oder LF stellen*/
      tpos++;

    if (tpos < maxram()) {
      if (p[tpos] == lf && c != lf)
	*posi = tpos + 1;
      else
	*posi = tpos;
    } else
      *posi = maxram();

  }

  zeile[outct] = '\0';
}


void next_line(uchar *buf, long *posi, long ende)
{
  uchar *p;
  Char cr, lf;
  bst tende, tpos;

  if (*posi >= ende)
    return;
  tpos = *posi;
  tende = ende;
  if (tende - tpos > 255)
    tende = tpos + 255;

  p = buf;
  cr = '\015';
  lf = '\n';

  while (tpos < tende && p[tpos] != cr && p[tpos] != lf)
    tpos++;
  if (tpos < tende && p[tpos] == cr)   /* Zeiger hinter das CR */
    tpos++;

  if (tpos >= maxram()) {
    *posi = maxram();
    return;
  }

  if (p[tpos] == lf)
    *posi = tpos + 1;
  else
    *posi = tpos;
}


void prev_line(uchar *buf, long *posi)
{
  uchar *p;
  Char cr, lf;
  bst tpos;

  if (*posi <= 2) {
    *posi = 0;
    return;
  }
  tpos = *posi - 3;
  p = buf;
  cr = '\015';
  lf = '\n';

  while (tpos > 0 && p[tpos] != cr && p[tpos] != lf)
    tpos--;
  if (p[tpos] == cr) {
    if (tpos >= maxram() - 2) {
      *posi = maxram();
      return;
    }
    tpos++;
    if (p[tpos] == lf)
      *posi = tpos + 1;
    else
      *posi = tpos;
    return;
  }
  if (p[tpos] != lf) {
    *posi = 0;
    return;
  }
  if (tpos < maxram() - 1)
    *posi = tpos + 1;
  else
    *posi = maxram();
}


void put_line(uchar *buf, long *posi, Char *zeile)
{
  uchar *p;
  short ct, l;
  bst tpos;

  p = buf;
  tpos = *posi;
  l = strlen(zeile);
  if (tpos + l + 2 > maxram())
    return;
  for (ct = 0; ct < l; ct++) {
    p[tpos] = zeile[ct];
    tpos++;
  }
  p[tpos] = 10;
  tpos++;
  *posi = tpos;
}

void _randomize()
{
  int t;
  
  t = (int)time(NULL);
  srand(t);
}

int _randint(short my_range)
{
  int i,j;
  
  i = RAND_MAX / my_range;
  i *= my_range;
  while ((j = rand()) >= i) continue;
  return (j % i) % my_range;
}

/* randomize erzeugt eine Zufallszahl in den Grenzen LO - HI */
/* wird fuer die Passwordberechnungen gebraucht              */

short dp_randomize(short low, short hiw)
{
  short erg;

  erg = _randint(hiw - low + 1);
  return (erg + low);
}

void _pastrix_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
  _randomize();
}

