#include "defs.h"

#ifdef dplinux
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <termios.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <ctype.h>
#include <sys/un.h>
#include "dpglobal.h"
#include "pastrix.h"
#include "filesys.h"
#include "boxglobl.h"
#include "boxlocal.h"
#include "ifacedef.h"
#include "dpbox.h"
#include "init.h"
#include "status.h"
#include "tools.h"
#include "box_inou.h"
#include "box_tim.h"
#endif

#ifdef dpmacos
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <stat.h>
#include <string.h>
#include <time.h>
#include <types.h>
#include <signal.h>
#include <ctype.h>
#include "dpglobal.h"
#include "pastrix.h"
#include "filesys.h"
#include "boxglobl.h"
#include "boxlocal.h"
#include "ifacedef.h"
#include "dpbox.h"
#include "init.h"
#include "status.h"
#include "tools.h"
#include "box_inou.h"
#include "box_tim.h"
#endif
/* ---- shell functs, stolen from TNT by Mark Wahl, DL4YBG ----- */


#define NUMPTY		256
#define MASTERPREFIX    "/dev/pty"
#define SLAVEPREFIX     "/dev/tty"
#define pty_timeout     1

#define pty_name(name, prefix, num) \
  sprintf(name, "%s%c%x", prefix, 'p' + (num >> 4), num & 0xf)


static void restore_pty(const char *id)
{
#ifndef dpmacos
  char filename[80];

  sprintf(filename, "%s%s", MASTERPREFIX, id);
  chown(filename, 0, 0);
  chmod(filename, 0666);
  sprintf(filename, "%s%s", SLAVEPREFIX, id);
  chown(filename, 0, 0);
  chmod(filename, 0666);
#endif
}

static short find_pty(short *numptr, char *slave)
{
#ifndef dpmacos
  char master[80];
  int fd;
  short num;

  for (num = 0; num < NUMPTY; num++) {
    pty_name(master, MASTERPREFIX, num);
    fd = dpsyscreate(master, O_RDWR, 0600);
    if (fd >= minhandle) {
      *numptr = num;
      pty_name(slave, SLAVEPREFIX, num);
      return (short) fd;
    }
  }
#endif
  return (-1);
}

static void dat_input_pty(short unr, char *buffer, int len)
{
  if (user[unr]->ptylfcrconv)
    show_puffer(unr,buffer,len);
  else
    trans_show_puffer(unr,buffer,len);
}

static void pty_send_data(short unr ,char *buffer, int len)
{
  int tmp_len;
  
  if (len > box_paclen) return; /* sanity check */
  if ((user[unr]->ptybuflen == 0) && (len == box_paclen)) {
    dat_input_pty(unr,buffer,len);
  }
  else if ((tmp_len = user[unr]->ptybuflen + len) > box_paclen) {
    if (user[unr]->ptybuflen) {
      dat_input_pty(unr,user[unr]->ptybuffer,user[unr]->ptybuflen);
    }
    memcpy(user[unr]->ptybuffer,buffer,len);
    user[unr]->ptybuflen = len;
    user[unr]->ptytouch = clock_.ixtime;
  }
  else {
    memcpy((user[unr]->ptybuffer + user[unr]->ptybuflen),
           buffer,len);
    user[unr]->ptybuflen = tmp_len;       
    user[unr]->ptytouch = clock_.ixtime;
  }
}

static void conv_crtolf(char *str, int len)
{
  int i;

  for (i = 0; i < len; i++) {
    if (str[i] == 13) str[i] = 10;
  }
}

static void conv_lftocr(char *str, int len)
{
  int i;

  for (i = 0; i < len; i++) {
    if (str[i] == 10) str[i] = 13;
  }
}


static void pty_check_timeout(short unr)
{
  if (!user[unr]->ptybuflen) return;
  if ((clock_.ixtime - user[unr]->ptytouch) >= pty_timeout) {
    dat_input_pty(unr,user[unr]->ptybuffer,user[unr]->ptybuflen);
    user[unr]->ptybuflen = 0;
  }
}

static int read_data_pty(unr, buffer)
short unr;
char buffer[];
{

#ifndef dpmacos

  int len;
  int fc;

  fcntl(user[unr]->pty,F_SETFL,O_NONBLOCK);
  len = read(user[unr]->pty,buffer,box_paclen);
  fc  = fcntl(user[unr]->pty,F_GETFL,NULL);
  fcntl(user[unr]->pty,F_SETFL,fc & ~O_NONBLOCK);

  if (len > 0) {
    if (user[unr]->ptylfcrconv) {
      conv_lftocr(buffer,len);
    }
    pty_send_data(unr,buffer,len);
    return(1);
  }
  else {
    return(0);
  }
#else
    return(0);
#endif
}

void shell_receive(struct fd_set *fdmask)
{
#ifndef dpmacos
  short unr;
  char buffer[256];

  for (unr=0;unr<=maxuser;unr++) {
    if ((user[unr] != NULL) && (user[unr]->pty >= minhandle)) {
      pty_check_timeout(unr);
      if (FD_ISSET(user[unr]->pty,fdmask)) {
        read_data_pty(unr,buffer);
      }
    }
  }
#endif
}

boolean close_shell(short unr)
{
  char buffer[256];
  int nodata;

  if (user[unr] == NULL) return false;

#ifndef dpmacos  
  if (user[unr]->pty >= minhandle) {
  
    /* read all remaining data from pty */
    fcntl(user[unr]->pty,F_SETFL,O_NONBLOCK);
    while (read_data_pty(unr,buffer) == 1);
    if (user[unr]->ptybuflen) {
      if (user[unr]->ptylfcrconv)
      	show_puffer(unr,user[unr]->ptybuffer,user[unr]->ptybuflen);
      else
      	trans_show_puffer(unr,user[unr]->ptybuffer,user[unr]->ptybuflen);
    }
    if (user[unr]->pty >= minhandle) {
      ioctl(user[unr]->pty, TCFLSH, 2);
      close(user[unr]->pty);
      user[unr]->pty = nohandle;
    
      restore_pty(user[unr]->ptyid);

    }
  }
#endif
  
  if (user[unr]->wait_pid > 0) {
    add_zombie(user[unr]->wait_pid);
    kill(-user[unr]->wait_pid, DP_SIGHUP);
   }
  user[unr]->wait_pid = -1;
  return true;
}

void set_dpbox_environment(short unr)
{
    userstruct *WITH;
    char w[256];
    
    WITH = user[unr];
    if (WITH == NULL) return;
    setenv("TERM", "dumb", true);
    setenv("LOGNAME", WITH->call, true);
    setenv("CALLSIGN", WITH->call, true);
    setenv("DPBOXUSERCALL", WITH->call, true);
    setenv("DPBOXUSERMYBBS", WITH->mybbs, true);
    setenv("DPBOXUSERNAME", WITH->name, true);
    setenv("DPBOXUSERLANGUAGE", WITH->language, true);
    setenv("DPBOXBOARD", WITH->brett, true);
    ix2string(WITH->lastdate, w);
    setenv("DPBOXLASTDATE", w, true);
    sprintf(w, "%ld", WITH->lastdate);
    setenv("DPBOXIXLASTDATE", w, true);
    if (WITH->se_ok)
      strcpy(w, "1");
    else
      strcpy(w, "0");
    setenv("DPBOXSENDERASEOK", w, true);
    if (WITH->hidden)
      strcpy(w, "1");
    else
      strcpy(w, "0");
    setenv("DPBOXHIDDEN", w, true);
    if (WITH->is_authentic)
      strcpy(w, "1");
    else
      strcpy(w, "0");
    setenv("DPBOXPWOK", w, true);
    if (WITH->rsysop)
      strcpy(w, "1");
    else
      strcpy(w, "0");
    setenv("DPBOXBOARDSYSOP", w, true);
    if (WITH->supervisor)
      strcpy(w, "1");
    else
      strcpy(w, "0");
    setenv("DPBOXSYSOP", w, true);
    sprintf(w, "%ld", WITH->level);
    setenv("DPBOXUSERLEVEL", w, true);
    setenv("DPBOXBOXCALL", Console_call, true);
    if (WITH->smode)
      strcpy(w, "1");
    else
      strcpy(w, "0");
    setenv("DPBOXSERVERMODE", w, true);
    strcpy(w, boxdir);
    strcat(w, fservdir);
    setenv("DPBOXSERVERROOT", w, true);
    if (*WITH->spath == '\0') *w = '\0';
    else strcpy(w, &WITH->spath[1]);
    setenv("DPBOXSERVERPATH", w, true);
    setenv("DPBOXCONNECTPATH", WITH->conpath, true);
    if (WITH->unproto_ok)
      strcpy(w, "1");
    else
      strcpy(w, "0");
    setenv("DPBOXUNPROTOOK", w, true);
    setenv("DPBOXNOCHECK", WITH->nocheckboards, true);
    setenv("DPBOXWANTCHECK", WITH->wantcheckboards, true);
    setenv("DPBOXLASTCMD", WITH->lastcmd, true);
    sprintf(w, "%ld", debug_level);
    setenv("DPBOXDEBUGLEVEL", w, true);
    sprintf(w, "%ld", usertimeout);
    setenv("DPBOXUSERTIMEOUT", w, true);
    strcpy(w, dp_vnr);
    strcat(w, dp_vnr_sub);
    setenv("DPBOXVERSION", w, true);
    sprintf(w, "%ld", unr);
    setenv("DPBOXUSERNUMBER", w, true);
    sprintf(w, "%ld", actual_connects());
    setenv("DPBOXUSERCOUNT", w, true);
}


/* open a shell */
boolean cmd_shell(short unr, boolean transparent)
{

#ifndef NO_SHELL

  char *env = 0;
  char slave[80];
  int i;
  struct termios termios;
  
  if (user[unr] == NULL) return false;

  if ((user[unr]->pty = find_pty(&user[unr]->ptynum, slave)) < 0) {
    wlnuser(unr,"Can't open pseudo terminal");
    return false;
  }
  
  user[unr]->ptybuflen = 0;
  user[unr]->ptylfcrconv = !transparent;
  strcpy(user[unr]->ptyid, slave + strlen(slave) - 2);
  if (!(user[unr]->wait_pid = fork())) {
/*
    pw = getpasswdentry(find_user_name(ch_stat[channel].call), unix_new_user);
    if (!pw || pw->pw_passwd[0]) {
      pw = getpasswdentry(remote_user, 0);
      if (!pw || pw->pw_passwd[0]) exit(1);
    }
*/
    for (i = minhandle; i <= maxhandle; i++) close(i);
    setsid();
    dpsyscreate(slave, O_RDWR, 0666);
    dup(0);
    dup(0);
    chmod(slave, 0622);
    if (user[unr]->ptylfcrconv) {
      memset((char *) &termios, 0, sizeof(termios));
      termios.c_iflag = ICRNL | IXOFF;
      termios.c_oflag = OPOST | TAB3 | ONLRET;
      termios.c_oflag &= ~(OCRNL | ONLCR | ONOCR);
      termios.c_cflag = CS8 | CREAD | CLOCAL;
      termios.c_lflag = ISIG | ICANON;
      termios.c_cc[VINTR]  = 127;
      termios.c_cc[VQUIT]  =  28;
      termios.c_cc[VERASE] =   8;
      termios.c_cc[VKILL]  =  24;
      termios.c_cc[VEOF]   =   3;
      cfsetispeed(&termios, B1200);
      cfsetospeed(&termios, B1200);
    }
    else {
      tcgetattr(0,&termios);
    }
    tcsetattr(0, TCSANOW, &termios);
    set_dpbox_environment(unr);
    execl("/bin/sh","-login",(char *) 0);
    exit(1);
  }
  return true;
#else
  return false;
#endif
}


/* run a program on the current channel */
#define maxrunargs 50
boolean cmd_run(short unr, boolean transparent, char *command, char *ofi)
{
#ifndef dpmacos
  char slave[80];
  char execfile[81];
  char fname[81];
  int i, ct;
  struct termios termios;
  char *args[maxrunargs];
  char *s;
  char w[256];

  if (user[unr] == NULL) return false;

  if ((user[unr]->pty = find_pty(&user[unr]->ptynum, slave)) < 0) {
    wlnuser(unr,"Can't open pseudo terminal");
    return false;
  }
  user[unr]->ptybuflen = 0;

  user[unr]->ptylfcrconv = !transparent;
  
  strcpy(user[unr]->ptyid, slave + strlen(slave) - 2);
  if (!(user[unr]->wait_pid = fork())) {
    for (i = minhandle; i <= maxhandle; i++) close(i);
    setsid();
    dpsyscreate(slave, O_RDWR, 0666);
    dup(0);
    dup(0);
    chmod(slave, 0622);
    if (user[unr]->ptylfcrconv) {
      memset((char *) &termios, 0, sizeof(termios));
      termios.c_iflag = ICRNL | IXOFF;
      termios.c_oflag = OPOST | TAB3 | ONLRET;
      termios.c_oflag &= ~(OCRNL | ONLCR | ONOCR);
      termios.c_cflag = CS8 | CREAD | CLOCAL;
      termios.c_lflag = ISIG | ICANON;
      termios.c_cc[VINTR]  = 127;
      termios.c_cc[VQUIT]  =  28;
      termios.c_cc[VERASE] =   8;
      termios.c_cc[VKILL]  =  24;
      termios.c_cc[VEOF]   =   3;
      cfsetispeed(&termios, B1200);
      cfsetospeed(&termios, B1200);
    }
    else {
      tcgetattr(0,&termios);
    }
    tcsetattr(0, TCSANOW, &termios);

    set_dpbox_environment(unr);

    setenv("DPBOXTEXTOUT", ofi, true);
    new_ext(ofi, "trn");
    setenv("DPBOXTRANSOUT", ofi, true);
    new_ext(ofi, "bin");
    setenv("DPBOXBINOUT", ofi, true);
    
    get_word(command, execfile);
    setenv("_", execfile, true);

    strcpy(fname, execfile);
    del_path(fname);
    
    for (ct = 0; ct < maxrunargs; ct++)
      args[ct] = NULL;
    
    s = (char *)Malloc(strlen(fname)+1);
    if (s != NULL) {
      strcpy(s, fname);
      args[0] = s;
    }
    
    ct = 1;
    do {
      if (*command != '\0') {
      	get_word(command, w);
        s = (char *)Malloc(strlen(w)+1);
        if (s != NULL) {
          strcpy(s, w);
          args[ct] = s;
        }
        ct++;
      } else {
        ct = maxrunargs;
      }
    }
    while (ct < maxrunargs-1);
    
    execv(execfile, args);
    exit(1);
  }
  return true;
#else
  return false;
#endif
}
#undef maxrunargs

boolean write_pty(short unr, int len, char *str)
{
  char buffer[300];

  if (user[unr] == NULL) return(false);
  if (user[unr]->pty < minhandle) return(false);

  memcpy(buffer,str,len);
  if (user[unr]->ptylfcrconv) {
    conv_crtolf(buffer,len);
  }
  if (write(user[unr]->pty,buffer,len) < len) {
    close_shell(unr);
    return(false);
  }
  return(true);
}

void shell_fdset(int *max_fd, struct fd_set *fdmask)
{
#ifndef dpmacos
  int unr;
  int fd;
  
  for (unr=1;unr<=maxuser;unr++) {
    if ((user[unr] != NULL) && (user[unr]->pty >= minhandle)) {
      fd = user[unr]->pty;
      FD_SET(fd,fdmask);
      if (fd > ((*max_fd) - 1)) {
        *max_fd = fd + 1;
      }
    }
  }
#endif
}
